/**
 * <h1>AWS CodeCommit Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * AWS CodeCommit is a version control service that enables you to privately store and manage Git repositories in the AWS cloud.
 * <p>
 * For further information on CodeCommit,
 * see the <a href="https://docs.aws.amazon.com/codecommit">AWS CodeCommit documentation</a>.
 * <p>
 * To add a CodeCommit Repository to your stack:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.aws_codecommit;
 * 
 * 
 * Repository repo = new Repository(this, "Repository", new RepositoryProps()
 *         .repositoryName("MyRepositoryName")
 *         .description("Some description."));
 * </pre></blockquote>
 * <p>
 * Use the <code>repositoryCloneUrlHttp</code>, <code>repositoryCloneUrlSsh</code> or <code>repositoryCloneUrlGrc</code>
 * property to clone your repository.
 * <p>
 * To add an Amazon SNS trigger to your repository:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // trigger is established for all repository actions on all branches by default.
 * repo.notify("arn:aws:sns:*:123456789012:my_topic");
 * </pre></blockquote>
 * <p>
 * <h2>Events</h2>
 * <p>
 * CodeCommit repositories emit Amazon CloudWatch events for certain activities.
 * Use the <code>repo.onXxx</code> methods to define rules that trigger on these events
 * and invoke targets as a result:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // starts a CodeBuild project when a commit is pushed to the "master" branch of the repo
 * repo.onCommit("CommitToMaster", Map.of(
 *         "target", new CodeBuildProject(project),
 *         "branches", asList("master")));
 * 
 * // publishes a message to an Amazon SNS topic when a comment is made on a pull request
 * Object rule = repo.onCommentOnPullRequest("CommentOnPullRequest", Map.of(
 *         "target", new SnsTopic(myTopic)));
 * </pre></blockquote>
 */
package software.amazon.awscdk.services.codecommit;
