package software.amazon.awscdk.services.codepipeline.actions;

/**
 * (experimental) Configuration for replacing a placeholder string in the ECS task definition template file with an image URI.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:06.500Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.CodeDeployEcsContainerImageInput")
@software.amazon.jsii.Jsii.Proxy(CodeDeployEcsContainerImageInput.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CodeDeployEcsContainerImageInput extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The artifact that contains an `imageDetails.json` file with the image URI.
     * <p>
     * The artifact's <code>imageDetails.json</code> file must be a JSON file containing an
     * <code>ImageURI</code> property.  For example:
     * <code>{ "ImageURI": "ACCOUNTID.dkr.ecr.us-west-2.amazonaws.com/dk-image-repo&#64;sha256:example3" }</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact getInput();

    /**
     * (experimental) The placeholder string in the ECS task definition template file that will be replaced with the image URI.
     * <p>
     * The placeholder string must be surrounded by angle brackets in the template file.
     * For example, if the task definition template file contains a placeholder like
     * <code>"image": "&lt;PLACEHOLDER&gt;"</code>, then the <code>taskDefinitionPlaceholder</code> value should
     * be <code>PLACEHOLDER</code>.
     * <p>
     * Default: IMAGE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getTaskDefinitionPlaceholder() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CodeDeployEcsContainerImageInput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeDeployEcsContainerImageInput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CodeDeployEcsContainerImageInput> {
        private software.amazon.awscdk.services.codepipeline.Artifact input;
        private java.lang.String taskDefinitionPlaceholder;

        /**
         * Sets the value of {@link CodeDeployEcsContainerImageInput#getInput}
         * @param input The artifact that contains an `imageDetails.json` file with the image URI. This parameter is required.
         *              The artifact's <code>imageDetails.json</code> file must be a JSON file containing an
         *              <code>ImageURI</code> property.  For example:
         *              <code>{ "ImageURI": "ACCOUNTID.dkr.ecr.us-west-2.amazonaws.com/dk-image-repo&#64;sha256:example3" }</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder input(software.amazon.awscdk.services.codepipeline.Artifact input) {
            this.input = input;
            return this;
        }

        /**
         * Sets the value of {@link CodeDeployEcsContainerImageInput#getTaskDefinitionPlaceholder}
         * @param taskDefinitionPlaceholder The placeholder string in the ECS task definition template file that will be replaced with the image URI.
         *                                  The placeholder string must be surrounded by angle brackets in the template file.
         *                                  For example, if the task definition template file contains a placeholder like
         *                                  <code>"image": "&lt;PLACEHOLDER&gt;"</code>, then the <code>taskDefinitionPlaceholder</code> value should
         *                                  be <code>PLACEHOLDER</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder taskDefinitionPlaceholder(java.lang.String taskDefinitionPlaceholder) {
            this.taskDefinitionPlaceholder = taskDefinitionPlaceholder;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeDeployEcsContainerImageInput}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CodeDeployEcsContainerImageInput build() {
            return new Jsii$Proxy(input, taskDefinitionPlaceholder);
        }
    }

    /**
     * An implementation for {@link CodeDeployEcsContainerImageInput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeDeployEcsContainerImageInput {
        private final software.amazon.awscdk.services.codepipeline.Artifact input;
        private final java.lang.String taskDefinitionPlaceholder;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.taskDefinitionPlaceholder = software.amazon.jsii.Kernel.get(this, "taskDefinitionPlaceholder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.codepipeline.Artifact input, final java.lang.String taskDefinitionPlaceholder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.input = java.util.Objects.requireNonNull(input, "input is required");
            this.taskDefinitionPlaceholder = taskDefinitionPlaceholder;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getInput() {
            return this.input;
        }

        @Override
        public final java.lang.String getTaskDefinitionPlaceholder() {
            return this.taskDefinitionPlaceholder;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("input", om.valueToTree(this.getInput()));
            if (this.getTaskDefinitionPlaceholder() != null) {
                data.set("taskDefinitionPlaceholder", om.valueToTree(this.getTaskDefinitionPlaceholder()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.CodeDeployEcsContainerImageInput"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeDeployEcsContainerImageInput.Jsii$Proxy that = (CodeDeployEcsContainerImageInput.Jsii$Proxy) o;

            if (!input.equals(that.input)) return false;
            return this.taskDefinitionPlaceholder != null ? this.taskDefinitionPlaceholder.equals(that.taskDefinitionPlaceholder) : that.taskDefinitionPlaceholder == null;
        }

        @Override
        public final int hashCode() {
            int result = this.input.hashCode();
            result = 31 * result + (this.taskDefinitionPlaceholder != null ? this.taskDefinitionPlaceholder.hashCode() : 0);
            return result;
        }
    }
}
