package software.amazon.awscdk.services.cognito;

/**
 * (experimental) How will a user be able to recover their account?
 * <p>
 * When a user forgets their password, they can have a code sent to their verified email or verified phone to recover their account.
 * You can choose the preferred way to send codes below.
 * We recommend not allowing phone to be used for both password resets and multi-factor authentication (MFA).
 * <p>
 * @see https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:16.341Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.AccountRecovery")
public enum AccountRecovery {
    /**
     * (experimental) Email if available, otherwise phone, but don’t allow a user to reset their password via phone if they are also using it for MFA.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    EMAIL_AND_PHONE_WITHOUT_MFA,
    /**
     * (experimental) Phone if available, otherwise email, but don’t allow a user to reset their password via phone if they are also using it for MFA.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    PHONE_WITHOUT_MFA_AND_EMAIL,
    /**
     * (experimental) Email only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    EMAIL_ONLY,
    /**
     * (experimental) Phone only, but don’t allow a user to reset their password via phone if they are also using it for MFA.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    PHONE_ONLY_WITHOUT_MFA,
    /**
     * (experimental) (Not Recommended) Phone if available, otherwise email, and do allow a user to reset their password via phone if they are also using it for MFA.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    PHONE_AND_EMAIL,
    /**
     * (experimental) None – users will have to contact an administrator to reset their passwords.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NONE,
}
