/**
 * <h1>Amazon DocumentDB Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * <h2>Starting a Clustered Database</h2>
 * <p>
 * To set up a clustered DocumentDB database, define a <code>DatabaseCluster</code>. You must
 * always launch a database in a VPC. Use the <code>vpcSubnets</code> attribute to control whether
 * your instances will be launched privately or publicly:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .masterUser(Map.of(
 *                 "username", "myuser"))
 *         .instanceType(ec2.InstanceType.of(ec2.InstanceClass.getR5(), ec2.InstanceSize.getLARGE()))
 *         .vpcSubnets(Map.of(
 *                 "subnetType", ec2.SubnetType.getPUBLIC()))
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 * <p>
 * By default, the master password will be generated and stored in AWS Secrets Manager with auto-generated description.
 * <p>
 * Your cluster will be empty by default.
 * <p>
 * <h2>Connecting</h2>
 * <p>
 * To control who can access the cluster, use the <code>.connections</code> attribute. DocumentDB databases have a default port, so
 * you don't need to specify the port:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * cluster.connections.allowDefaultPortFromAnyIpv4("Open to the world");
 * </pre></blockquote>
 * <p>
 * The endpoints to access your database cluster will be available as the <code>.clusterEndpoint</code> and <code>.clusterReadEndpoint</code>
 * attributes:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object writeAddress = cluster.clusterEndpoint.getSocketAddress();
 * </pre></blockquote>
 * <p>
 * If you have existing security groups you would like to add to the cluster, use the <code>addSecurityGroups</code> method. Security
 * groups added in this way will not be managed by the <code>Connections</code> object of the cluster.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object securityGroup = SecurityGroup.Builder.create(stack, "SecurityGroup")
 *         .vpc(vpc)
 *         .build();
 * cluster.addSecurityGroups(securityGroup);
 * </pre></blockquote>
 * <p>
 * <h2>Deletion protection</h2>
 * <p>
 * Deletion protection can be enabled on an Amazon DocumentDB cluster to prevent accidental deletion of the cluster:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .masterUser(Map.of(
 *                 "username", "myuser"))
 *         .instanceType(ec2.InstanceType.of(ec2.InstanceClass.getR5(), ec2.InstanceSize.getLARGE()))
 *         .vpcSubnets(Map.of(
 *                 "subnetType", ec2.SubnetType.getPUBLIC()))
 *         .vpc(vpc)
 *         .deletionProtection(true)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Rotating credentials</h2>
 * <p>
 * When the master password is generated and stored in AWS Secrets Manager, it can be rotated automatically:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * cluster.addRotationSingleUser();
 * </pre></blockquote>
 * <p>
 * <a href="test/integ.cluster-rotation.lit.ts">example of setting up master password rotation for a cluster</a>
 * <p>
 * The multi user rotation scheme is also available:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * cluster.addRotationMultiUser("MyUser", Map.of(
 *         "secret", myImportedSecret));
 * </pre></blockquote>
 * <p>
 * It's also possible to create user credentials together with the cluster and add rotation:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object myUserSecret = DatabaseSecret.Builder.create(this, "MyUserSecret")
 *         .username("myuser")
 *         .masterSecret(cluster.getSecret())
 *         .build();
 * Object myUserSecretAttached = myUserSecret.attach(cluster);// Adds DB connections information in the secret
 * 
 * cluster.addRotationMultiUser("MyUser", Map.of(// Add rotation using the multi user scheme
 *         "secret", myUserSecretAttached));
 * </pre></blockquote>
 * <p>
 * <strong>Note</strong>: This user must be created manually in the database using the master credentials.
 * The rotation will start as soon as this user exists.
 * <p>
 * See also <a href="https://github.com/aws/aws-cdk/blob/master/packages/%40aws-cdk/aws-secretsmanager/README.md">&#64;aws-cdk/aws-secretsmanager</a> for credentials rotation of existing clusters.
 */
package software.amazon.awscdk.services.docdb;
