package software.amazon.awscdk.services.ec2;

/**
 * (experimental) Additional options for creating an InitFile from an asset.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:16.719Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.InitFileAssetOptions")
@software.amazon.jsii.Jsii.Proxy(InitFileAssetOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface InitFileAssetOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.InitFileOptions, software.amazon.awscdk.services.s3.assets.AssetOptions {

    /**
     * @return a {@link Builder} of {@link InitFileAssetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InitFileAssetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<InitFileAssetOptions> {
        private java.lang.Boolean base64Encoded;
        private java.lang.String group;
        private java.lang.String mode;
        private java.lang.String owner;
        private java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles;
        private java.util.List<software.amazon.awscdk.services.iam.IGrantable> readers;
        private java.lang.String assetHash;
        private software.amazon.awscdk.AssetHashType assetHashType;
        private software.amazon.awscdk.BundlingOptions bundling;
        private java.util.List<java.lang.String> exclude;
        private software.amazon.awscdk.SymlinkFollowMode followSymlinks;
        private software.amazon.awscdk.IgnoreMode ignoreMode;

        /**
         * Sets the value of {@link InitFileAssetOptions#getBase64Encoded}
         * @param base64Encoded True if the inlined content (from a string or file) should be treated as base64 encoded.
         *                      Only applicable for inlined string and file content.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder base64Encoded(java.lang.Boolean base64Encoded) {
            this.base64Encoded = base64Encoded;
            return this;
        }

        /**
         * Sets the value of {@link InitFileAssetOptions#getGroup}
         * @param group The name of the owning group for this file.
         *              Not supported for Windows systems.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder group(java.lang.String group) {
            this.group = group;
            return this;
        }

        /**
         * Sets the value of {@link InitFileAssetOptions#getMode}
         * @param mode A six-digit octal value representing the mode for this file.
         *             Use the first three digits for symlinks and the last three digits for
         *             setting permissions. To create a symlink, specify 120xxx, where xxx
         *             defines the permissions of the target file. To specify permissions for a
         *             file, use the last three digits, such as 000644.
         *             <p>
         *             Not supported for Windows systems.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mode(java.lang.String mode) {
            this.mode = mode;
            return this;
        }

        /**
         * Sets the value of {@link InitFileAssetOptions#getOwner}
         * @param owner The name of the owning user for this file.
         *              Not supported for Windows systems.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder owner(java.lang.String owner) {
            this.owner = owner;
            return this;
        }

        /**
         * Sets the value of {@link InitFileAssetOptions#getServiceRestartHandles}
         * @param serviceRestartHandles Restart the given service after this file has been written.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder serviceRestartHandles(java.util.List<? extends software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles) {
            this.serviceRestartHandles = (java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle>)serviceRestartHandles;
            return this;
        }

        /**
         * Sets the value of {@link InitFileAssetOptions#getReaders}
         * @param readers A list of principals that should be able to read this asset from S3.
         *                You can use <code>asset.grantRead(principal)</code> to grant read permissions later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder readers(java.util.List<? extends software.amazon.awscdk.services.iam.IGrantable> readers) {
            this.readers = (java.util.List<software.amazon.awscdk.services.iam.IGrantable>)readers;
            return this;
        }

        /**
         * Sets the value of {@link InitFileAssetOptions#getAssetHash}
         * @param assetHash Specify a custom hash for this asset.
         *                  If <code>assetHashType</code> is set it must
         *                  be set to <code>AssetHashType.CUSTOM</code>. For consistency, this custom hash will
         *                  be SHA256 hashed and encoded as hex. The resulting hash will be the asset
         *                  hash.
         *                  <p>
         *                  NOTE: the hash is used in order to identify a specific revision of the asset, and
         *                  used for optimizing and caching deployment activities related to this asset such as
         *                  packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
         *                  need to make sure it is updated every time the asset changes, or otherwise it is
         *                  possible that some deployments will not be invalidated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetHash(java.lang.String assetHash) {
            this.assetHash = assetHash;
            return this;
        }

        /**
         * Sets the value of {@link InitFileAssetOptions#getAssetHashType}
         * @param assetHashType Specifies the type of hash to calculate for this asset.
         *                      If <code>assetHash</code> is configured, this option must be <code>undefined</code> or
         *                      <code>AssetHashType.CUSTOM</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetHashType(software.amazon.awscdk.AssetHashType assetHashType) {
            this.assetHashType = assetHashType;
            return this;
        }

        /**
         * Sets the value of {@link InitFileAssetOptions#getBundling}
         * @param bundling Bundle the asset by executing a command in a Docker container or a custom bundling provider.
         *                 The asset path will be mounted at <code>/asset-input</code>. The Docker
         *                 container is responsible for putting content at <code>/asset-output</code>.
         *                 The content at <code>/asset-output</code> will be zipped and used as the
         *                 final asset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bundling(software.amazon.awscdk.BundlingOptions bundling) {
            this.bundling = bundling;
            return this;
        }

        /**
         * Sets the value of {@link InitFileAssetOptions#getExclude}
         * @param exclude Glob patterns to exclude from the copy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder exclude(java.util.List<java.lang.String> exclude) {
            this.exclude = exclude;
            return this;
        }

        /**
         * Sets the value of {@link InitFileAssetOptions#getFollowSymlinks}
         * @param followSymlinks A strategy for how to handle symlinks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder followSymlinks(software.amazon.awscdk.SymlinkFollowMode followSymlinks) {
            this.followSymlinks = followSymlinks;
            return this;
        }

        /**
         * Sets the value of {@link InitFileAssetOptions#getIgnoreMode}
         * @param ignoreMode The ignore behavior to use for exclude patterns.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ignoreMode(software.amazon.awscdk.IgnoreMode ignoreMode) {
            this.ignoreMode = ignoreMode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InitFileAssetOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public InitFileAssetOptions build() {
            return new Jsii$Proxy(base64Encoded, group, mode, owner, serviceRestartHandles, readers, assetHash, assetHashType, bundling, exclude, followSymlinks, ignoreMode);
        }
    }

    /**
     * An implementation for {@link InitFileAssetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InitFileAssetOptions {
        private final java.lang.Boolean base64Encoded;
        private final java.lang.String group;
        private final java.lang.String mode;
        private final java.lang.String owner;
        private final java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles;
        private final java.util.List<software.amazon.awscdk.services.iam.IGrantable> readers;
        private final java.lang.String assetHash;
        private final software.amazon.awscdk.AssetHashType assetHashType;
        private final software.amazon.awscdk.BundlingOptions bundling;
        private final java.util.List<java.lang.String> exclude;
        private final software.amazon.awscdk.SymlinkFollowMode followSymlinks;
        private final software.amazon.awscdk.IgnoreMode ignoreMode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.base64Encoded = software.amazon.jsii.Kernel.get(this, "base64Encoded", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.group = software.amazon.jsii.Kernel.get(this, "group", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.owner = software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceRestartHandles = software.amazon.jsii.Kernel.get(this, "serviceRestartHandles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitServiceRestartHandle.class)));
            this.readers = software.amazon.jsii.Kernel.get(this, "readers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IGrantable.class)));
            this.assetHash = software.amazon.jsii.Kernel.get(this, "assetHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetHashType = software.amazon.jsii.Kernel.get(this, "assetHashType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.AssetHashType.class));
            this.bundling = software.amazon.jsii.Kernel.get(this, "bundling", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.BundlingOptions.class));
            this.exclude = software.amazon.jsii.Kernel.get(this, "exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.followSymlinks = software.amazon.jsii.Kernel.get(this, "followSymlinks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SymlinkFollowMode.class));
            this.ignoreMode = software.amazon.jsii.Kernel.get(this, "ignoreMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IgnoreMode.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.Boolean base64Encoded, final java.lang.String group, final java.lang.String mode, final java.lang.String owner, final java.util.List<? extends software.amazon.awscdk.services.ec2.InitServiceRestartHandle> serviceRestartHandles, final java.util.List<? extends software.amazon.awscdk.services.iam.IGrantable> readers, final java.lang.String assetHash, final software.amazon.awscdk.AssetHashType assetHashType, final software.amazon.awscdk.BundlingOptions bundling, final java.util.List<java.lang.String> exclude, final software.amazon.awscdk.SymlinkFollowMode followSymlinks, final software.amazon.awscdk.IgnoreMode ignoreMode) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.base64Encoded = base64Encoded;
            this.group = group;
            this.mode = mode;
            this.owner = owner;
            this.serviceRestartHandles = (java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle>)serviceRestartHandles;
            this.readers = (java.util.List<software.amazon.awscdk.services.iam.IGrantable>)readers;
            this.assetHash = assetHash;
            this.assetHashType = assetHashType;
            this.bundling = bundling;
            this.exclude = exclude;
            this.followSymlinks = followSymlinks;
            this.ignoreMode = ignoreMode;
        }

        @Override
        public final java.lang.Boolean getBase64Encoded() {
            return this.base64Encoded;
        }

        @Override
        public final java.lang.String getGroup() {
            return this.group;
        }

        @Override
        public final java.lang.String getMode() {
            return this.mode;
        }

        @Override
        public final java.lang.String getOwner() {
            return this.owner;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.InitServiceRestartHandle> getServiceRestartHandles() {
            return this.serviceRestartHandles;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.IGrantable> getReaders() {
            return this.readers;
        }

        @Override
        public final java.lang.String getAssetHash() {
            return this.assetHash;
        }

        @Override
        public final software.amazon.awscdk.AssetHashType getAssetHashType() {
            return this.assetHashType;
        }

        @Override
        public final software.amazon.awscdk.BundlingOptions getBundling() {
            return this.bundling;
        }

        @Override
        public final java.util.List<java.lang.String> getExclude() {
            return this.exclude;
        }

        @Override
        public final software.amazon.awscdk.SymlinkFollowMode getFollowSymlinks() {
            return this.followSymlinks;
        }

        @Override
        public final software.amazon.awscdk.IgnoreMode getIgnoreMode() {
            return this.ignoreMode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBase64Encoded() != null) {
                data.set("base64Encoded", om.valueToTree(this.getBase64Encoded()));
            }
            if (this.getGroup() != null) {
                data.set("group", om.valueToTree(this.getGroup()));
            }
            if (this.getMode() != null) {
                data.set("mode", om.valueToTree(this.getMode()));
            }
            if (this.getOwner() != null) {
                data.set("owner", om.valueToTree(this.getOwner()));
            }
            if (this.getServiceRestartHandles() != null) {
                data.set("serviceRestartHandles", om.valueToTree(this.getServiceRestartHandles()));
            }
            if (this.getReaders() != null) {
                data.set("readers", om.valueToTree(this.getReaders()));
            }
            if (this.getAssetHash() != null) {
                data.set("assetHash", om.valueToTree(this.getAssetHash()));
            }
            if (this.getAssetHashType() != null) {
                data.set("assetHashType", om.valueToTree(this.getAssetHashType()));
            }
            if (this.getBundling() != null) {
                data.set("bundling", om.valueToTree(this.getBundling()));
            }
            if (this.getExclude() != null) {
                data.set("exclude", om.valueToTree(this.getExclude()));
            }
            if (this.getFollowSymlinks() != null) {
                data.set("followSymlinks", om.valueToTree(this.getFollowSymlinks()));
            }
            if (this.getIgnoreMode() != null) {
                data.set("ignoreMode", om.valueToTree(this.getIgnoreMode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.InitFileAssetOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InitFileAssetOptions.Jsii$Proxy that = (InitFileAssetOptions.Jsii$Proxy) o;

            if (this.base64Encoded != null ? !this.base64Encoded.equals(that.base64Encoded) : that.base64Encoded != null) return false;
            if (this.group != null ? !this.group.equals(that.group) : that.group != null) return false;
            if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
            if (this.owner != null ? !this.owner.equals(that.owner) : that.owner != null) return false;
            if (this.serviceRestartHandles != null ? !this.serviceRestartHandles.equals(that.serviceRestartHandles) : that.serviceRestartHandles != null) return false;
            if (this.readers != null ? !this.readers.equals(that.readers) : that.readers != null) return false;
            if (this.assetHash != null ? !this.assetHash.equals(that.assetHash) : that.assetHash != null) return false;
            if (this.assetHashType != null ? !this.assetHashType.equals(that.assetHashType) : that.assetHashType != null) return false;
            if (this.bundling != null ? !this.bundling.equals(that.bundling) : that.bundling != null) return false;
            if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
            if (this.followSymlinks != null ? !this.followSymlinks.equals(that.followSymlinks) : that.followSymlinks != null) return false;
            return this.ignoreMode != null ? this.ignoreMode.equals(that.ignoreMode) : that.ignoreMode == null;
        }

        @Override
        public final int hashCode() {
            int result = this.base64Encoded != null ? this.base64Encoded.hashCode() : 0;
            result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
            result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
            result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
            result = 31 * result + (this.serviceRestartHandles != null ? this.serviceRestartHandles.hashCode() : 0);
            result = 31 * result + (this.readers != null ? this.readers.hashCode() : 0);
            result = 31 * result + (this.assetHash != null ? this.assetHash.hashCode() : 0);
            result = 31 * result + (this.assetHashType != null ? this.assetHashType.hashCode() : 0);
            result = 31 * result + (this.bundling != null ? this.bundling.hashCode() : 0);
            result = 31 * result + (this.exclude != null ? this.exclude.hashCode() : 0);
            result = 31 * result + (this.followSymlinks != null ? this.followSymlinks.hashCode() : 0);
            result = 31 * result + (this.ignoreMode != null ? this.ignoreMode.hashCode() : 0);
            return result;
        }
    }
}
