package software.amazon.awscdk.services.ec2;

/**
 * (experimental) Creates an Amazon EC2 security group within a VPC.
 * <p>
 * Security Groups act like a firewall with a set of rules, and are associated
 * with any AWS resource that has or creates Elastic Network Interfaces (ENIs).
 * A typical example of a resource that has a security group is an Instance (or
 * Auto Scaling Group of instances)
 * <p>
 * If you are defining new infrastructure in CDK, there is a good chance you
 * won't have to interact with this class at all. Like IAM Roles, Security
 * Groups need to exist to control access between AWS resources, but CDK will
 * automatically generate and populate them with least-privilege permissions
 * for you so you can concentrate on your business logic.
 * <p>
 * All Constructs that require Security Groups will create one for you if you
 * don't specify one at construction. After construction, you can selectively
 * allow connections to and between constructs via--for example-- the <code>instance.connections</code>
 * object. Think of it as "allowing connections to your instance", rather than
 * "adding ingress rules a security group". See the <a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-ec2-readme.html#allowing-connections">Allowing
 * Connections</a>
 * section in the library documentation for examples.
 * <p>
 * Direct manipulation of the Security Group through <code>addIngressRule</code> and
 * <code>addEgressRule</code> is possible, but mutation through the <code>.connections</code> object
 * is recommended. If you peer two constructs with security groups this way,
 * appropriate rules will be created in both.
 * <p>
 * If you have an existing security group you want to use in your CDK application,
 * you would import it like this:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object securityGroup = SecurityGroup.fromSecurityGroupId(this, "SG", "sg-12345", Map.of(
 *         "mutable", false));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:16.747Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.SecurityGroup")
public class SecurityGroup extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ec2.ISecurityGroup {

    protected SecurityGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SecurityGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SecurityGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SecurityGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Look up a security group by id.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param securityGroupId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup fromLookup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String securityGroupId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.SecurityGroup.class, "fromLookup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(securityGroupId, "securityGroupId is required") });
    }

    /**
     * (experimental) Import an existing security group into this app.
     * <p>
     * This method will assume that the Security Group has a rule in it which allows
     * all outbound traffic, and so will not add egress rules to the imported Security
     * Group (only ingress rules).
     * <p>
     * If your existing Security Group needs to have egress rules added, pass the
     * <code>allowAllOutbound: false</code> option on import.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param securityGroupId This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup fromSecurityGroupId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String securityGroupId, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SecurityGroupImportOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.SecurityGroup.class, "fromSecurityGroupId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(securityGroupId, "securityGroupId is required"), options });
    }

    /**
     * (experimental) Import an existing security group into this app.
     * <p>
     * This method will assume that the Security Group has a rule in it which allows
     * all outbound traffic, and so will not add egress rules to the imported Security
     * Group (only ingress rules).
     * <p>
     * If your existing Security Group needs to have egress rules added, pass the
     * <code>allowAllOutbound: false</code> option on import.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param securityGroupId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup fromSecurityGroupId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String securityGroupId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.SecurityGroup.class, "fromSecurityGroupId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(securityGroupId, "securityGroupId is required") });
    }

    /**
     * (experimental) Return whether the indicated object is a security group.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isSecurityGroup(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.SecurityGroup.class, "isSecurityGroup", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * (experimental) Add an egress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     * @param description
     * @param remoteRule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addEgressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description, final @org.jetbrains.annotations.Nullable java.lang.Boolean remoteRule) {
        software.amazon.jsii.Kernel.call(this, "addEgressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description, remoteRule });
    }

    /**
     * (experimental) Add an egress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addEgressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description) {
        software.amazon.jsii.Kernel.call(this, "addEgressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description });
    }

    /**
     * (experimental) Add an egress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addEgressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection) {
        software.amazon.jsii.Kernel.call(this, "addEgressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required") });
    }

    /**
     * (experimental) Add an ingress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     * @param description
     * @param remoteRule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addIngressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description, final @org.jetbrains.annotations.Nullable java.lang.Boolean remoteRule) {
        software.amazon.jsii.Kernel.call(this, "addIngressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description, remoteRule });
    }

    /**
     * (experimental) Add an ingress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addIngressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description) {
        software.amazon.jsii.Kernel.call(this, "addIngressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description });
    }

    /**
     * (experimental) Add an ingress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addIngressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection) {
        software.amazon.jsii.Kernel.call(this, "addIngressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required") });
    }

    /**
     * (experimental) Produce the egress rule JSON for the given connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object toEgressRuleConfig() {
        return software.amazon.jsii.Kernel.call(this, "toEgressRuleConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * (experimental) Produce the ingress rule JSON for the given connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object toIngressRuleConfig() {
        return software.amazon.jsii.Kernel.call(this, "toIngressRuleConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * (experimental) Whether the SecurityGroup has been configured to allow all outbound traffic.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getAllowAllOutbound() {
        return software.amazon.jsii.Kernel.get(this, "allowAllOutbound", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) Whether the rule can be inlined into a SecurityGroup or not.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getCanInlineRule() {
        return software.amazon.jsii.Kernel.get(this, "canInlineRule", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) The network connections associated with this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * (experimental) The ID of the security group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecurityGroupId() {
        return software.amazon.jsii.Kernel.get(this, "securityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) An attribute that represents the security group name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecurityGroupName() {
        return software.amazon.jsii.Kernel.get(this, "securityGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The VPC ID this security group is part of.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecurityGroupVpcId() {
        return software.amazon.jsii.Kernel.get(this, "securityGroupVpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A unique identifier for this connection peer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getUniqueId() {
        return software.amazon.jsii.Kernel.get(this, "uniqueId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.Port getDefaultPort() {
        return software.amazon.jsii.Kernel.get(this, "defaultPort", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.ec2.SecurityGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.SecurityGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.SecurityGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.SecurityGroupProps.Builder();
        }

        /**
         * (experimental) The VPC in which to create the security group.
         * <p>
         * @return {@code this}
         * @param vpc The VPC in which to create the security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * (experimental) Whether to allow all outbound traffic by default.
         * <p>
         * If this is set to true, there will only be a single egress rule which allows all
         * outbound traffic. If this is set to false, no outbound traffic will be allowed by
         * default and all egress traffic must be explicitly authorized.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param allowAllOutbound Whether to allow all outbound traffic by default. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowAllOutbound(final java.lang.Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        /**
         * (experimental) A description of the security group.
         * <p>
         * Default: The default name will be the construct's CDK path.
         * <p>
         * @return {@code this}
         * @param description A description of the security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (experimental) Whether to disable inline ingress and egress rule optimization.
         * <p>
         * If this is set to true, ingress and egress rules will not be declared under the
         * SecurityGroup in cloudformation, but will be separate elements.
         * <p>
         * Inlining rules is an optimization for producing smaller stack templates. Sometimes
         * this is not desirable, for example when security group access is managed via tags.
         * <p>
         * The default value can be overriden globally by setting the context variable
         * '&#64;aws-cdk/aws-ec2.securityGroupDisableInlineRules'.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param disableInlineRules Whether to disable inline ingress and egress rule optimization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder disableInlineRules(final java.lang.Boolean disableInlineRules) {
            this.props.disableInlineRules(disableInlineRules);
            return this;
        }

        /**
         * (experimental) The name of the security group.
         * <p>
         * For valid values, see the GroupName
         * parameter of the CreateSecurityGroup action in the Amazon EC2 API
         * Reference.
         * <p>
         * It is not recommended to use an explicit group name.
         * <p>
         * Default: If you don't specify a GroupName, AWS CloudFormation generates a
         * unique physical ID and uses that ID for the group name.
         * <p>
         * @return {@code this}
         * @param securityGroupName The name of the security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroupName(final java.lang.String securityGroupName) {
            this.props.securityGroupName(securityGroupName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.SecurityGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ec2.SecurityGroup build() {
            return new software.amazon.awscdk.services.ec2.SecurityGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
