package software.amazon.awscdk.services.ecs;

/**
 * (experimental) The authorization configuration details for the Amazon EFS file system.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:16.808Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AuthorizationConfig")
@software.amazon.jsii.Jsii.Proxy(AuthorizationConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AuthorizationConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The access point ID to use.
     * <p>
     * If an access point is specified, the root directory value will be
     * relative to the directory set for the access point.
     * If specified, transit encryption must be enabled in the EFSVolumeConfiguration.
     * <p>
     * Default: No id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccessPointId() {
        return null;
    }

    /**
     * (experimental) Whether or not to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file system.
     * <p>
     * If enabled, transit encryption must be enabled in the EFSVolumeConfiguration.
     * <p>
     * Valid values: ENABLED | DISABLED
     * <p>
     * Default: If this parameter is omitted, the default value of DISABLED is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getIam() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AuthorizationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AuthorizationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AuthorizationConfig> {
        private java.lang.String accessPointId;
        private java.lang.String iam;

        /**
         * Sets the value of {@link AuthorizationConfig#getAccessPointId}
         * @param accessPointId The access point ID to use.
         *                      If an access point is specified, the root directory value will be
         *                      relative to the directory set for the access point.
         *                      If specified, transit encryption must be enabled in the EFSVolumeConfiguration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accessPointId(java.lang.String accessPointId) {
            this.accessPointId = accessPointId;
            return this;
        }

        /**
         * Sets the value of {@link AuthorizationConfig#getIam}
         * @param iam Whether or not to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file system.
         *            If enabled, transit encryption must be enabled in the EFSVolumeConfiguration.
         *            <p>
         *            Valid values: ENABLED | DISABLED
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder iam(java.lang.String iam) {
            this.iam = iam;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AuthorizationConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AuthorizationConfig build() {
            return new Jsii$Proxy(accessPointId, iam);
        }
    }

    /**
     * An implementation for {@link AuthorizationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthorizationConfig {
        private final java.lang.String accessPointId;
        private final java.lang.String iam;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessPointId = software.amazon.jsii.Kernel.get(this, "accessPointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.iam = software.amazon.jsii.Kernel.get(this, "iam", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String accessPointId, final java.lang.String iam) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessPointId = accessPointId;
            this.iam = iam;
        }

        @Override
        public final java.lang.String getAccessPointId() {
            return this.accessPointId;
        }

        @Override
        public final java.lang.String getIam() {
            return this.iam;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccessPointId() != null) {
                data.set("accessPointId", om.valueToTree(this.getAccessPointId()));
            }
            if (this.getIam() != null) {
                data.set("iam", om.valueToTree(this.getIam()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.AuthorizationConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AuthorizationConfig.Jsii$Proxy that = (AuthorizationConfig.Jsii$Proxy) o;

            if (this.accessPointId != null ? !this.accessPointId.equals(that.accessPointId) : that.accessPointId != null) return false;
            return this.iam != null ? this.iam.equals(that.iam) : that.iam == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessPointId != null ? this.accessPointId.hashCode() : 0;
            result = 31 * result + (this.iam != null ? this.iam.hashCode() : 0);
            return result;
        }
    }
}
