package software.amazon.awscdk.services.ecs;

/**
 * (experimental) A log driver that sends log information to CloudWatch Logs.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:16.808Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AwsLogDriver")
public class AwsLogDriver extends software.amazon.awscdk.services.ecs.LogDriver {

    protected AwsLogDriver(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AwsLogDriver(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Constructs a new instance of the AwsLogDriver class.
     * <p>
     * @param props the awslogs log driver configuration options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AwsLogDriver(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AwsLogDriverProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Called when the log driver is configured on a container.
     * <p>
     * @param scope This parameter is required.
     * @param containerDefinition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriverConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition containerDefinition) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriverConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(containerDefinition, "containerDefinition is required") });
    }

    /**
     * (experimental) The log group to send log streams to.
     * <p>
     * Only available after the LogDriver has been bound to a ContainerDefinition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
    }

    /**
     * (experimental) The log group to send log streams to.
     * <p>
     * Only available after the LogDriver has been bound to a ContainerDefinition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setLogGroup(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup value) {
        software.amazon.jsii.Kernel.set(this, "logGroup", value);
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.ecs.AwsLogDriver}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.AwsLogDriver> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.ecs.AwsLogDriverProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.ecs.AwsLogDriverProps.Builder();
        }

        /**
         * (experimental) Prefix for the log streams.
         * <p>
         * The awslogs-stream-prefix option allows you to associate a log stream
         * with the specified prefix, the container name, and the ID of the Amazon
         * ECS task to which the container belongs. If you specify a prefix with
         * this option, then the log stream takes the following format:
         * <p>
         * <blockquote><pre>
         *  prefix-name/container-name/ecs-task-id
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param streamPrefix Prefix for the log streams. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder streamPrefix(final java.lang.String streamPrefix) {
            this.props.streamPrefix(streamPrefix);
            return this;
        }

        /**
         * (experimental) This option defines a multiline start pattern in Python strftime format.
         * <p>
         * A log message consists of a line that matches the pattern and any
         * following lines that don’t match the pattern. Thus the matched line is
         * the delimiter between log messages.
         * <p>
         * Default: - No multiline matching.
         * <p>
         * @return {@code this}
         * @param datetimeFormat This option defines a multiline start pattern in Python strftime format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder datetimeFormat(final java.lang.String datetimeFormat) {
            this.props.datetimeFormat(datetimeFormat);
            return this;
        }

        /**
         * (experimental) The log group to log to.
         * <p>
         * Default: - A log group is automatically created.
         * <p>
         * @return {@code this}
         * @param logGroup The log group to log to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logGroup(final software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.props.logGroup(logGroup);
            return this;
        }

        /**
         * (experimental) The number of days log events are kept in CloudWatch Logs when the log group is automatically created by this construct.
         * <p>
         * Default: - Logs never expire.
         * <p>
         * @return {@code this}
         * @param logRetention The number of days log events are kept in CloudWatch Logs when the log group is automatically created by this construct. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logRetention(final software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.props.logRetention(logRetention);
            return this;
        }

        /**
         * (experimental) The delivery mode of log messages from the container to awslogs.
         * <p>
         * Default: - AwsLogDriverMode.BLOCKING
         * <p>
         * @return {@code this}
         * @param mode The delivery mode of log messages from the container to awslogs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mode(final software.amazon.awscdk.services.ecs.AwsLogDriverMode mode) {
            this.props.mode(mode);
            return this;
        }

        /**
         * (experimental) This option defines a multiline start pattern using a regular expression.
         * <p>
         * A log message consists of a line that matches the pattern and any
         * following lines that don’t match the pattern. Thus the matched line is
         * the delimiter between log messages.
         * <p>
         * This option is ignored if datetimeFormat is also configured.
         * <p>
         * Default: - No multiline matching.
         * <p>
         * @return {@code this}
         * @param multilinePattern This option defines a multiline start pattern using a regular expression. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder multilinePattern(final java.lang.String multilinePattern) {
            this.props.multilinePattern(multilinePattern);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.AwsLogDriver}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ecs.AwsLogDriver build() {
            return new software.amazon.awscdk.services.ecs.AwsLogDriver(
                this.props.build()
            );
        }
    }
}
