package software.amazon.awscdk.services.ecs;

/**
 * (experimental) The properties in a container definition.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:16.844Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.ContainerDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(ContainerDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ContainerDefinitionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.ContainerDefinitionOptions {

    /**
     * (experimental) The name of the task definition that includes this container definition.
     * <p>
     * [disable-awslint:ref-via-interface]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition getTaskDefinition();

    /**
     * @return a {@link Builder} of {@link ContainerDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContainerDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ContainerDefinitionProps> {
        private software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition;
        private software.amazon.awscdk.services.ecs.ContainerImage image;
        private java.util.List<java.lang.String> command;
        private java.lang.String containerName;
        private java.lang.Number cpu;
        private java.lang.Boolean disableNetworking;
        private java.util.List<java.lang.String> dnsSearchDomains;
        private java.util.List<java.lang.String> dnsServers;
        private java.util.Map<java.lang.String, java.lang.String> dockerLabels;
        private java.util.List<java.lang.String> dockerSecurityOptions;
        private java.util.List<java.lang.String> entryPoint;
        private java.util.Map<java.lang.String, java.lang.String> environment;
        private java.util.List<software.amazon.awscdk.services.ecs.EnvironmentFile> environmentFiles;
        private java.lang.Boolean essential;
        private java.util.Map<java.lang.String, java.lang.String> extraHosts;
        private java.lang.Number gpuCount;
        private software.amazon.awscdk.services.ecs.HealthCheck healthCheck;
        private java.lang.String hostname;
        private java.util.List<java.lang.String> inferenceAcceleratorResources;
        private software.amazon.awscdk.services.ecs.LinuxParameters linuxParameters;
        private software.amazon.awscdk.services.ecs.LogDriver logging;
        private java.lang.Number memoryLimitMiB;
        private java.lang.Number memoryReservationMiB;
        private java.util.List<software.amazon.awscdk.services.ecs.PortMapping> portMappings;
        private java.lang.Boolean privileged;
        private java.lang.Boolean readonlyRootFilesystem;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets;
        private software.amazon.awscdk.Duration startTimeout;
        private software.amazon.awscdk.Duration stopTimeout;
        private java.lang.String user;
        private java.lang.String workingDirectory;

        /**
         * Sets the value of {@link ContainerDefinitionProps#getTaskDefinition}
         * @param taskDefinition The name of the task definition that includes this container definition. This parameter is required.
         *                       [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder taskDefinition(software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getImage}
         * @param image The image used to start a container. This parameter is required.
         *              This string is passed directly to the Docker daemon.
         *              Images in the Docker Hub registry are available by default.
         *              Other repositories are specified with either repository-url/image:tag or repository-url/image&#64;digest.
         *              TODO: Update these to specify using classes of IContainerImage
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder image(software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getCommand}
         * @param command The command that is passed to the container.
         *                If you provide a shell command as a single string, you have to quote command-line arguments.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getContainerName}
         * @param containerName The name of the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder containerName(java.lang.String containerName) {
            this.containerName = containerName;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getCpu}
         * @param cpu The minimum number of CPU units to reserve for the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cpu(java.lang.Number cpu) {
            this.cpu = cpu;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getDisableNetworking}
         * @param disableNetworking Specifies whether networking is disabled within the container.
         *                          When this parameter is true, networking is disabled within the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder disableNetworking(java.lang.Boolean disableNetworking) {
            this.disableNetworking = disableNetworking;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getDnsSearchDomains}
         * @param dnsSearchDomains A list of DNS search domains that are presented to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dnsSearchDomains(java.util.List<java.lang.String> dnsSearchDomains) {
            this.dnsSearchDomains = dnsSearchDomains;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getDnsServers}
         * @param dnsServers A list of DNS servers that are presented to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dnsServers(java.util.List<java.lang.String> dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getDockerLabels}
         * @param dockerLabels A key/value map of labels to add to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dockerLabels(java.util.Map<java.lang.String, java.lang.String> dockerLabels) {
            this.dockerLabels = dockerLabels;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getDockerSecurityOptions}
         * @param dockerSecurityOptions A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dockerSecurityOptions(java.util.List<java.lang.String> dockerSecurityOptions) {
            this.dockerSecurityOptions = dockerSecurityOptions;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getEntryPoint}
         * @param entryPoint The ENTRYPOINT value to pass to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder entryPoint(java.util.List<java.lang.String> entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getEnvironment}
         * @param environment The environment variables to pass to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getEnvironmentFiles}
         * @param environmentFiles The environment files to pass to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder environmentFiles(java.util.List<? extends software.amazon.awscdk.services.ecs.EnvironmentFile> environmentFiles) {
            this.environmentFiles = (java.util.List<software.amazon.awscdk.services.ecs.EnvironmentFile>)environmentFiles;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getEssential}
         * @param essential Specifies whether the container is marked essential.
         *                  If the essential parameter of a container is marked as true, and that container fails
         *                  or stops for any reason, all other containers that are part of the task are stopped.
         *                  If the essential parameter of a container is marked as false, then its failure does not
         *                  affect the rest of the containers in a task. All tasks must have at least one essential container.
         *                  <p>
         *                  If this parameter is omitted, a container is assumed to be essential.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder essential(java.lang.Boolean essential) {
            this.essential = essential;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getExtraHosts}
         * @param extraHosts A list of hostnames and IP address mappings to append to the /etc/hosts file on the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder extraHosts(java.util.Map<java.lang.String, java.lang.String> extraHosts) {
            this.extraHosts = extraHosts;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getGpuCount}
         * @param gpuCount The number of GPUs assigned to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder gpuCount(java.lang.Number gpuCount) {
            this.gpuCount = gpuCount;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getHealthCheck}
         * @param healthCheck The health check command and associated configuration parameters for the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder healthCheck(software.amazon.awscdk.services.ecs.HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getHostname}
         * @param hostname The hostname to use for your container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder hostname(java.lang.String hostname) {
            this.hostname = hostname;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getInferenceAcceleratorResources}
         * @param inferenceAcceleratorResources The inference accelerators referenced by the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder inferenceAcceleratorResources(java.util.List<java.lang.String> inferenceAcceleratorResources) {
            this.inferenceAcceleratorResources = inferenceAcceleratorResources;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getLinuxParameters}
         * @param linuxParameters Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.
         *                        For more information see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html">KernelCapabilities</a>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder linuxParameters(software.amazon.awscdk.services.ecs.LinuxParameters linuxParameters) {
            this.linuxParameters = linuxParameters;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getLogging}
         * @param logging The log configuration specification for the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logging(software.amazon.awscdk.services.ecs.LogDriver logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getMemoryLimitMiB}
         * @param memoryLimitMiB The amount (in MiB) of memory to present to the container.
         *                       If your container attempts to exceed the allocated memory, the container
         *                       is terminated.
         *                       <p>
         *                       At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder memoryLimitMiB(java.lang.Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getMemoryReservationMiB}
         * @param memoryReservationMiB The soft limit (in MiB) of memory to reserve for the container.
         *                             When system memory is under heavy contention, Docker attempts to keep the
         *                             container memory to this soft limit. However, your container can consume more
         *                             memory when it needs to, up to either the hard limit specified with the memory
         *                             parameter (if applicable), or all of the available memory on the container
         *                             instance, whichever comes first.
         *                             <p>
         *                             At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder memoryReservationMiB(java.lang.Number memoryReservationMiB) {
            this.memoryReservationMiB = memoryReservationMiB;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getPortMappings}
         * @param portMappings The port mappings to add to the container definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder portMappings(java.util.List<? extends software.amazon.awscdk.services.ecs.PortMapping> portMappings) {
            this.portMappings = (java.util.List<software.amazon.awscdk.services.ecs.PortMapping>)portMappings;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getPrivileged}
         * @param privileged Specifies whether the container is marked as privileged.
         *                   When this parameter is true, the container is given elevated privileges on the host container instance (similar to the root user).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder privileged(java.lang.Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getReadonlyRootFilesystem}
         * @param readonlyRootFilesystem When this parameter is true, the container is given read-only access to its root file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder readonlyRootFilesystem(java.lang.Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getSecrets}
         * @param secrets The secret environment variables to pass to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder secrets(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ecs.Secret> secrets) {
            this.secrets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret>)secrets;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getStartTimeout}
         * @param startTimeout Time duration (in seconds) to wait before giving up on resolving dependencies for a container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder startTimeout(software.amazon.awscdk.Duration startTimeout) {
            this.startTimeout = startTimeout;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getStopTimeout}
         * @param stopTimeout Time duration (in seconds) to wait before the container is forcefully killed if it doesn't exit normally on its own.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stopTimeout(software.amazon.awscdk.Duration stopTimeout) {
            this.stopTimeout = stopTimeout;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getUser}
         * @param user The user name to use inside the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder user(java.lang.String user) {
            this.user = user;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionProps#getWorkingDirectory}
         * @param workingDirectory The working directory in which to run commands inside the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workingDirectory(java.lang.String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContainerDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ContainerDefinitionProps build() {
            return new Jsii$Proxy(taskDefinition, image, command, containerName, cpu, disableNetworking, dnsSearchDomains, dnsServers, dockerLabels, dockerSecurityOptions, entryPoint, environment, environmentFiles, essential, extraHosts, gpuCount, healthCheck, hostname, inferenceAcceleratorResources, linuxParameters, logging, memoryLimitMiB, memoryReservationMiB, portMappings, privileged, readonlyRootFilesystem, secrets, startTimeout, stopTimeout, user, workingDirectory);
        }
    }

    /**
     * An implementation for {@link ContainerDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerDefinitionProps {
        private final software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition;
        private final software.amazon.awscdk.services.ecs.ContainerImage image;
        private final java.util.List<java.lang.String> command;
        private final java.lang.String containerName;
        private final java.lang.Number cpu;
        private final java.lang.Boolean disableNetworking;
        private final java.util.List<java.lang.String> dnsSearchDomains;
        private final java.util.List<java.lang.String> dnsServers;
        private final java.util.Map<java.lang.String, java.lang.String> dockerLabels;
        private final java.util.List<java.lang.String> dockerSecurityOptions;
        private final java.util.List<java.lang.String> entryPoint;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.util.List<software.amazon.awscdk.services.ecs.EnvironmentFile> environmentFiles;
        private final java.lang.Boolean essential;
        private final java.util.Map<java.lang.String, java.lang.String> extraHosts;
        private final java.lang.Number gpuCount;
        private final software.amazon.awscdk.services.ecs.HealthCheck healthCheck;
        private final java.lang.String hostname;
        private final java.util.List<java.lang.String> inferenceAcceleratorResources;
        private final software.amazon.awscdk.services.ecs.LinuxParameters linuxParameters;
        private final software.amazon.awscdk.services.ecs.LogDriver logging;
        private final java.lang.Number memoryLimitMiB;
        private final java.lang.Number memoryReservationMiB;
        private final java.util.List<software.amazon.awscdk.services.ecs.PortMapping> portMappings;
        private final java.lang.Boolean privileged;
        private final java.lang.Boolean readonlyRootFilesystem;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets;
        private final software.amazon.awscdk.Duration startTimeout;
        private final software.amazon.awscdk.Duration stopTimeout;
        private final java.lang.String user;
        private final java.lang.String workingDirectory;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.taskDefinition = software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.TaskDefinition.class));
            this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class));
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.disableNetworking = software.amazon.jsii.Kernel.get(this, "disableNetworking", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.dnsSearchDomains = software.amazon.jsii.Kernel.get(this, "dnsSearchDomains", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dnsServers = software.amazon.jsii.Kernel.get(this, "dnsServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dockerLabels = software.amazon.jsii.Kernel.get(this, "dockerLabels", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dockerSecurityOptions = software.amazon.jsii.Kernel.get(this, "dockerSecurityOptions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.entryPoint = software.amazon.jsii.Kernel.get(this, "entryPoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environmentFiles = software.amazon.jsii.Kernel.get(this, "environmentFiles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EnvironmentFile.class)));
            this.essential = software.amazon.jsii.Kernel.get(this, "essential", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.extraHosts = software.amazon.jsii.Kernel.get(this, "extraHosts", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.gpuCount = software.amazon.jsii.Kernel.get(this, "gpuCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.healthCheck = software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.HealthCheck.class));
            this.hostname = software.amazon.jsii.Kernel.get(this, "hostname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inferenceAcceleratorResources = software.amazon.jsii.Kernel.get(this, "inferenceAcceleratorResources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.linuxParameters = software.amazon.jsii.Kernel.get(this, "linuxParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LinuxParameters.class));
            this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class));
            this.memoryLimitMiB = software.amazon.jsii.Kernel.get(this, "memoryLimitMiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.memoryReservationMiB = software.amazon.jsii.Kernel.get(this, "memoryReservationMiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.portMappings = software.amazon.jsii.Kernel.get(this, "portMappings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PortMapping.class)));
            this.privileged = software.amazon.jsii.Kernel.get(this, "privileged", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.readonlyRootFilesystem = software.amazon.jsii.Kernel.get(this, "readonlyRootFilesystem", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.secrets = software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Secret.class)));
            this.startTimeout = software.amazon.jsii.Kernel.get(this, "startTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.stopTimeout = software.amazon.jsii.Kernel.get(this, "stopTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workingDirectory = software.amazon.jsii.Kernel.get(this, "workingDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition, final software.amazon.awscdk.services.ecs.ContainerImage image, final java.util.List<java.lang.String> command, final java.lang.String containerName, final java.lang.Number cpu, final java.lang.Boolean disableNetworking, final java.util.List<java.lang.String> dnsSearchDomains, final java.util.List<java.lang.String> dnsServers, final java.util.Map<java.lang.String, java.lang.String> dockerLabels, final java.util.List<java.lang.String> dockerSecurityOptions, final java.util.List<java.lang.String> entryPoint, final java.util.Map<java.lang.String, java.lang.String> environment, final java.util.List<? extends software.amazon.awscdk.services.ecs.EnvironmentFile> environmentFiles, final java.lang.Boolean essential, final java.util.Map<java.lang.String, java.lang.String> extraHosts, final java.lang.Number gpuCount, final software.amazon.awscdk.services.ecs.HealthCheck healthCheck, final java.lang.String hostname, final java.util.List<java.lang.String> inferenceAcceleratorResources, final software.amazon.awscdk.services.ecs.LinuxParameters linuxParameters, final software.amazon.awscdk.services.ecs.LogDriver logging, final java.lang.Number memoryLimitMiB, final java.lang.Number memoryReservationMiB, final java.util.List<? extends software.amazon.awscdk.services.ecs.PortMapping> portMappings, final java.lang.Boolean privileged, final java.lang.Boolean readonlyRootFilesystem, final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ecs.Secret> secrets, final software.amazon.awscdk.Duration startTimeout, final software.amazon.awscdk.Duration stopTimeout, final java.lang.String user, final java.lang.String workingDirectory) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.taskDefinition = java.util.Objects.requireNonNull(taskDefinition, "taskDefinition is required");
            this.image = java.util.Objects.requireNonNull(image, "image is required");
            this.command = command;
            this.containerName = containerName;
            this.cpu = cpu;
            this.disableNetworking = disableNetworking;
            this.dnsSearchDomains = dnsSearchDomains;
            this.dnsServers = dnsServers;
            this.dockerLabels = dockerLabels;
            this.dockerSecurityOptions = dockerSecurityOptions;
            this.entryPoint = entryPoint;
            this.environment = environment;
            this.environmentFiles = (java.util.List<software.amazon.awscdk.services.ecs.EnvironmentFile>)environmentFiles;
            this.essential = essential;
            this.extraHosts = extraHosts;
            this.gpuCount = gpuCount;
            this.healthCheck = healthCheck;
            this.hostname = hostname;
            this.inferenceAcceleratorResources = inferenceAcceleratorResources;
            this.linuxParameters = linuxParameters;
            this.logging = logging;
            this.memoryLimitMiB = memoryLimitMiB;
            this.memoryReservationMiB = memoryReservationMiB;
            this.portMappings = (java.util.List<software.amazon.awscdk.services.ecs.PortMapping>)portMappings;
            this.privileged = privileged;
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            this.secrets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret>)secrets;
            this.startTimeout = startTimeout;
            this.stopTimeout = stopTimeout;
            this.user = user;
            this.workingDirectory = workingDirectory;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.TaskDefinition getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return this.image;
        }

        @Override
        public final java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public final java.lang.String getContainerName() {
            return this.containerName;
        }

        @Override
        public final java.lang.Number getCpu() {
            return this.cpu;
        }

        @Override
        public final java.lang.Boolean getDisableNetworking() {
            return this.disableNetworking;
        }

        @Override
        public final java.util.List<java.lang.String> getDnsSearchDomains() {
            return this.dnsSearchDomains;
        }

        @Override
        public final java.util.List<java.lang.String> getDnsServers() {
            return this.dnsServers;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getDockerLabels() {
            return this.dockerLabels;
        }

        @Override
        public final java.util.List<java.lang.String> getDockerSecurityOptions() {
            return this.dockerSecurityOptions;
        }

        @Override
        public final java.util.List<java.lang.String> getEntryPoint() {
            return this.entryPoint;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.EnvironmentFile> getEnvironmentFiles() {
            return this.environmentFiles;
        }

        @Override
        public final java.lang.Boolean getEssential() {
            return this.essential;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getExtraHosts() {
            return this.extraHosts;
        }

        @Override
        public final java.lang.Number getGpuCount() {
            return this.gpuCount;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public final java.lang.String getHostname() {
            return this.hostname;
        }

        @Override
        public final java.util.List<java.lang.String> getInferenceAcceleratorResources() {
            return this.inferenceAcceleratorResources;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.LinuxParameters getLinuxParameters() {
            return this.linuxParameters;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.LogDriver getLogging() {
            return this.logging;
        }

        @Override
        public final java.lang.Number getMemoryLimitMiB() {
            return this.memoryLimitMiB;
        }

        @Override
        public final java.lang.Number getMemoryReservationMiB() {
            return this.memoryReservationMiB;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.PortMapping> getPortMappings() {
            return this.portMappings;
        }

        @Override
        public final java.lang.Boolean getPrivileged() {
            return this.privileged;
        }

        @Override
        public final java.lang.Boolean getReadonlyRootFilesystem() {
            return this.readonlyRootFilesystem;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> getSecrets() {
            return this.secrets;
        }

        @Override
        public final software.amazon.awscdk.Duration getStartTimeout() {
            return this.startTimeout;
        }

        @Override
        public final software.amazon.awscdk.Duration getStopTimeout() {
            return this.stopTimeout;
        }

        @Override
        public final java.lang.String getUser() {
            return this.user;
        }

        @Override
        public final java.lang.String getWorkingDirectory() {
            return this.workingDirectory;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("taskDefinition", om.valueToTree(this.getTaskDefinition()));
            data.set("image", om.valueToTree(this.getImage()));
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getContainerName() != null) {
                data.set("containerName", om.valueToTree(this.getContainerName()));
            }
            if (this.getCpu() != null) {
                data.set("cpu", om.valueToTree(this.getCpu()));
            }
            if (this.getDisableNetworking() != null) {
                data.set("disableNetworking", om.valueToTree(this.getDisableNetworking()));
            }
            if (this.getDnsSearchDomains() != null) {
                data.set("dnsSearchDomains", om.valueToTree(this.getDnsSearchDomains()));
            }
            if (this.getDnsServers() != null) {
                data.set("dnsServers", om.valueToTree(this.getDnsServers()));
            }
            if (this.getDockerLabels() != null) {
                data.set("dockerLabels", om.valueToTree(this.getDockerLabels()));
            }
            if (this.getDockerSecurityOptions() != null) {
                data.set("dockerSecurityOptions", om.valueToTree(this.getDockerSecurityOptions()));
            }
            if (this.getEntryPoint() != null) {
                data.set("entryPoint", om.valueToTree(this.getEntryPoint()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getEnvironmentFiles() != null) {
                data.set("environmentFiles", om.valueToTree(this.getEnvironmentFiles()));
            }
            if (this.getEssential() != null) {
                data.set("essential", om.valueToTree(this.getEssential()));
            }
            if (this.getExtraHosts() != null) {
                data.set("extraHosts", om.valueToTree(this.getExtraHosts()));
            }
            if (this.getGpuCount() != null) {
                data.set("gpuCount", om.valueToTree(this.getGpuCount()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getHostname() != null) {
                data.set("hostname", om.valueToTree(this.getHostname()));
            }
            if (this.getInferenceAcceleratorResources() != null) {
                data.set("inferenceAcceleratorResources", om.valueToTree(this.getInferenceAcceleratorResources()));
            }
            if (this.getLinuxParameters() != null) {
                data.set("linuxParameters", om.valueToTree(this.getLinuxParameters()));
            }
            if (this.getLogging() != null) {
                data.set("logging", om.valueToTree(this.getLogging()));
            }
            if (this.getMemoryLimitMiB() != null) {
                data.set("memoryLimitMiB", om.valueToTree(this.getMemoryLimitMiB()));
            }
            if (this.getMemoryReservationMiB() != null) {
                data.set("memoryReservationMiB", om.valueToTree(this.getMemoryReservationMiB()));
            }
            if (this.getPortMappings() != null) {
                data.set("portMappings", om.valueToTree(this.getPortMappings()));
            }
            if (this.getPrivileged() != null) {
                data.set("privileged", om.valueToTree(this.getPrivileged()));
            }
            if (this.getReadonlyRootFilesystem() != null) {
                data.set("readonlyRootFilesystem", om.valueToTree(this.getReadonlyRootFilesystem()));
            }
            if (this.getSecrets() != null) {
                data.set("secrets", om.valueToTree(this.getSecrets()));
            }
            if (this.getStartTimeout() != null) {
                data.set("startTimeout", om.valueToTree(this.getStartTimeout()));
            }
            if (this.getStopTimeout() != null) {
                data.set("stopTimeout", om.valueToTree(this.getStopTimeout()));
            }
            if (this.getUser() != null) {
                data.set("user", om.valueToTree(this.getUser()));
            }
            if (this.getWorkingDirectory() != null) {
                data.set("workingDirectory", om.valueToTree(this.getWorkingDirectory()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.ContainerDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContainerDefinitionProps.Jsii$Proxy that = (ContainerDefinitionProps.Jsii$Proxy) o;

            if (!taskDefinition.equals(that.taskDefinition)) return false;
            if (!image.equals(that.image)) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.containerName != null ? !this.containerName.equals(that.containerName) : that.containerName != null) return false;
            if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
            if (this.disableNetworking != null ? !this.disableNetworking.equals(that.disableNetworking) : that.disableNetworking != null) return false;
            if (this.dnsSearchDomains != null ? !this.dnsSearchDomains.equals(that.dnsSearchDomains) : that.dnsSearchDomains != null) return false;
            if (this.dnsServers != null ? !this.dnsServers.equals(that.dnsServers) : that.dnsServers != null) return false;
            if (this.dockerLabels != null ? !this.dockerLabels.equals(that.dockerLabels) : that.dockerLabels != null) return false;
            if (this.dockerSecurityOptions != null ? !this.dockerSecurityOptions.equals(that.dockerSecurityOptions) : that.dockerSecurityOptions != null) return false;
            if (this.entryPoint != null ? !this.entryPoint.equals(that.entryPoint) : that.entryPoint != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.environmentFiles != null ? !this.environmentFiles.equals(that.environmentFiles) : that.environmentFiles != null) return false;
            if (this.essential != null ? !this.essential.equals(that.essential) : that.essential != null) return false;
            if (this.extraHosts != null ? !this.extraHosts.equals(that.extraHosts) : that.extraHosts != null) return false;
            if (this.gpuCount != null ? !this.gpuCount.equals(that.gpuCount) : that.gpuCount != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) return false;
            if (this.inferenceAcceleratorResources != null ? !this.inferenceAcceleratorResources.equals(that.inferenceAcceleratorResources) : that.inferenceAcceleratorResources != null) return false;
            if (this.linuxParameters != null ? !this.linuxParameters.equals(that.linuxParameters) : that.linuxParameters != null) return false;
            if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
            if (this.memoryLimitMiB != null ? !this.memoryLimitMiB.equals(that.memoryLimitMiB) : that.memoryLimitMiB != null) return false;
            if (this.memoryReservationMiB != null ? !this.memoryReservationMiB.equals(that.memoryReservationMiB) : that.memoryReservationMiB != null) return false;
            if (this.portMappings != null ? !this.portMappings.equals(that.portMappings) : that.portMappings != null) return false;
            if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) return false;
            if (this.readonlyRootFilesystem != null ? !this.readonlyRootFilesystem.equals(that.readonlyRootFilesystem) : that.readonlyRootFilesystem != null) return false;
            if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) return false;
            if (this.startTimeout != null ? !this.startTimeout.equals(that.startTimeout) : that.startTimeout != null) return false;
            if (this.stopTimeout != null ? !this.stopTimeout.equals(that.stopTimeout) : that.stopTimeout != null) return false;
            if (this.user != null ? !this.user.equals(that.user) : that.user != null) return false;
            return this.workingDirectory != null ? this.workingDirectory.equals(that.workingDirectory) : that.workingDirectory == null;
        }

        @Override
        public final int hashCode() {
            int result = this.taskDefinition.hashCode();
            result = 31 * result + (this.image.hashCode());
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.containerName != null ? this.containerName.hashCode() : 0);
            result = 31 * result + (this.cpu != null ? this.cpu.hashCode() : 0);
            result = 31 * result + (this.disableNetworking != null ? this.disableNetworking.hashCode() : 0);
            result = 31 * result + (this.dnsSearchDomains != null ? this.dnsSearchDomains.hashCode() : 0);
            result = 31 * result + (this.dnsServers != null ? this.dnsServers.hashCode() : 0);
            result = 31 * result + (this.dockerLabels != null ? this.dockerLabels.hashCode() : 0);
            result = 31 * result + (this.dockerSecurityOptions != null ? this.dockerSecurityOptions.hashCode() : 0);
            result = 31 * result + (this.entryPoint != null ? this.entryPoint.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.environmentFiles != null ? this.environmentFiles.hashCode() : 0);
            result = 31 * result + (this.essential != null ? this.essential.hashCode() : 0);
            result = 31 * result + (this.extraHosts != null ? this.extraHosts.hashCode() : 0);
            result = 31 * result + (this.gpuCount != null ? this.gpuCount.hashCode() : 0);
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
            result = 31 * result + (this.inferenceAcceleratorResources != null ? this.inferenceAcceleratorResources.hashCode() : 0);
            result = 31 * result + (this.linuxParameters != null ? this.linuxParameters.hashCode() : 0);
            result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
            result = 31 * result + (this.memoryLimitMiB != null ? this.memoryLimitMiB.hashCode() : 0);
            result = 31 * result + (this.memoryReservationMiB != null ? this.memoryReservationMiB.hashCode() : 0);
            result = 31 * result + (this.portMappings != null ? this.portMappings.hashCode() : 0);
            result = 31 * result + (this.privileged != null ? this.privileged.hashCode() : 0);
            result = 31 * result + (this.readonlyRootFilesystem != null ? this.readonlyRootFilesystem.hashCode() : 0);
            result = 31 * result + (this.secrets != null ? this.secrets.hashCode() : 0);
            result = 31 * result + (this.startTimeout != null ? this.startTimeout.hashCode() : 0);
            result = 31 * result + (this.stopTimeout != null ? this.stopTimeout.hashCode() : 0);
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
            return result;
        }
    }
}
