package software.amazon.awscdk.services.ecs;

/**
 * (experimental) A container instance host device.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:16.846Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.Device")
@software.amazon.jsii.Jsii.Proxy(Device.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface Device extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The path for the device on the host container instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getHostPath();

    /**
     * (experimental) The path inside the container at which to expose the host device.
     * <p>
     * Default: Same path as the host
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getContainerPath() {
        return null;
    }

    /**
     * (experimental) The explicit permissions to provide to the container for the device.
     * <p>
     * By default, the container has permissions for read, write, and mknod for the device.
     * <p>
     * Default: Readonly
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.DevicePermission> getPermissions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Device}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Device}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<Device> {
        private java.lang.String hostPath;
        private java.lang.String containerPath;
        private java.util.List<software.amazon.awscdk.services.ecs.DevicePermission> permissions;

        /**
         * Sets the value of {@link Device#getHostPath}
         * @param hostPath The path for the device on the host container instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder hostPath(java.lang.String hostPath) {
            this.hostPath = hostPath;
            return this;
        }

        /**
         * Sets the value of {@link Device#getContainerPath}
         * @param containerPath The path inside the container at which to expose the host device.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder containerPath(java.lang.String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        /**
         * Sets the value of {@link Device#getPermissions}
         * @param permissions The explicit permissions to provide to the container for the device.
         *                    By default, the container has permissions for read, write, and mknod for the device.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder permissions(java.util.List<? extends software.amazon.awscdk.services.ecs.DevicePermission> permissions) {
            this.permissions = (java.util.List<software.amazon.awscdk.services.ecs.DevicePermission>)permissions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Device}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public Device build() {
            return new Jsii$Proxy(hostPath, containerPath, permissions);
        }
    }

    /**
     * An implementation for {@link Device}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Device {
        private final java.lang.String hostPath;
        private final java.lang.String containerPath;
        private final java.util.List<software.amazon.awscdk.services.ecs.DevicePermission> permissions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostPath = software.amazon.jsii.Kernel.get(this, "hostPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.permissions = software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DevicePermission.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.String hostPath, final java.lang.String containerPath, final java.util.List<? extends software.amazon.awscdk.services.ecs.DevicePermission> permissions) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostPath = java.util.Objects.requireNonNull(hostPath, "hostPath is required");
            this.containerPath = containerPath;
            this.permissions = (java.util.List<software.amazon.awscdk.services.ecs.DevicePermission>)permissions;
        }

        @Override
        public final java.lang.String getHostPath() {
            return this.hostPath;
        }

        @Override
        public final java.lang.String getContainerPath() {
            return this.containerPath;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.DevicePermission> getPermissions() {
            return this.permissions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("hostPath", om.valueToTree(this.getHostPath()));
            if (this.getContainerPath() != null) {
                data.set("containerPath", om.valueToTree(this.getContainerPath()));
            }
            if (this.getPermissions() != null) {
                data.set("permissions", om.valueToTree(this.getPermissions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.Device"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Device.Jsii$Proxy that = (Device.Jsii$Proxy) o;

            if (!hostPath.equals(that.hostPath)) return false;
            if (this.containerPath != null ? !this.containerPath.equals(that.containerPath) : that.containerPath != null) return false;
            return this.permissions != null ? this.permissions.equals(that.permissions) : that.permissions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.hostPath.hashCode();
            result = 31 * result + (this.containerPath != null ? this.containerPath.hashCode() : 0);
            result = 31 * result + (this.permissions != null ? this.permissions.hashCode() : 0);
            return result;
        }
    }
}
