/**
 * <h1>CDK Construct library for higher-level ECS Constructs</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This library provides higher-level Amazon ECS constructs which follow common architectural patterns. It contains:
 * <p>
 * <ul>
 * <li>Application Load Balanced Services</li>
 * <li>Network Load Balanced Services</li>
 * <li>Queue Processing Services</li>
 * <li>Scheduled Tasks (cron jobs)</li>
 * <li>Additional Examples</li>
 * </ul>
 * <p>
 * <h2>Application Load Balanced Services</h2>
 * <p>
 * To define an Amazon ECS service that is behind an application load balancer, instantiate one of the following:
 * <p>
 * <ul>
 * <li><code>ApplicationLoadBalancedEc2Service</code></li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object loadBalancedEcsService = ApplicationLoadBalancedEc2Service.Builder.create(stack, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(1024)
 *         .taskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("test"),
 *                 "environment", Map.of(
 *                         "TEST_ENVIRONMENT_VARIABLE1", "test environment variable 1 value",
 *                         "TEST_ENVIRONMENT_VARIABLE2", "test environment variable 2 value")))
 *         .desiredCount(2)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>ApplicationLoadBalancedFargateService</code></li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object loadBalancedFargateService = ApplicationLoadBalancedFargateService.Builder.create(stack, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(1024)
 *         .cpu(512)
 *         .taskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample")))
 *         .build();
 * 
 * loadBalancedFargateService.targetGroup.configureHealthCheck(Map.of(
 *         "path", "/custom-health-path"));
 * </pre></blockquote>
 * <p>
 * Instead of providing a cluster you can specify a VPC and CDK will create a new ECS cluster.
 * If you deploy multiple services CDK will only create one cluster per VPC.
 * <p>
 * You can omit <code>cluster</code> and <code>vpc</code> to let CDK create a new VPC with two AZs and create a cluster inside this VPC.
 * <p>
 * You can customize the health check for your target group; otherwise it defaults to <code>HTTP</code> over port <code>80</code> hitting path <code>/</code>.
 * <p>
 * Fargate services will use the <code>LATEST</code> platform version by default, but you can override by providing a value for the <code>platformVersion</code> property in the constructor.
 * <p>
 * Fargate services use the default VPC Security Group unless one or more are provided using the <code>securityGroups</code> property in the constructor.
 * <p>
 * By setting <code>redirectHTTP</code> to true, CDK will automatically create a listener on port 80 that redirects HTTP traffic to the HTTPS port.
 * <p>
 * If you specify the option <code>recordType</code> you can decide if you want the construct to use CNAME or Route53-Aliases as record sets.
 * <p>
 * If you need to encrypt the traffic between the load balancer and the ECS tasks, you can set the <code>targetProtocol</code> to <code>HTTPS</code>.
 * <p>
 * Additionally, if more than one application target group are needed, instantiate one of the following:
 * <p>
 * <ul>
 * <li><code>ApplicationMultipleTargetGroupsEc2Service</code></li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // One application load balancer with one listener and two target groups.
 * Object loadBalancedEc2Service = ApplicationMultipleTargetGroupsEc2Service.Builder.create(stack, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(256)
 *         .taskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample")))
 *         .targetGroups(asList(Map.of(
 *                 "containerPort", 80), Map.of(
 *                 "containerPort", 90,
 *                 "pathPattern", "a/b/c",
 *                 "priority", 10)))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>ApplicationMultipleTargetGroupsFargateService</code></li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // One application load balancer with one listener and two target groups.
 * Object loadBalancedFargateService = ApplicationMultipleTargetGroupsFargateService.Builder.create(stack, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(1024)
 *         .cpu(512)
 *         .taskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample")))
 *         .targetGroups(asList(Map.of(
 *                 "containerPort", 80), Map.of(
 *                 "containerPort", 90,
 *                 "pathPattern", "a/b/c",
 *                 "priority", 10)))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Network Load Balanced Services</h2>
 * <p>
 * To define an Amazon ECS service that is behind a network load balancer, instantiate one of the following:
 * <p>
 * <ul>
 * <li><code>NetworkLoadBalancedEc2Service</code></li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object loadBalancedEcsService = NetworkLoadBalancedEc2Service.Builder.create(stack, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(1024)
 *         .taskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("test"),
 *                 "environment", Map.of(
 *                         "TEST_ENVIRONMENT_VARIABLE1", "test environment variable 1 value",
 *                         "TEST_ENVIRONMENT_VARIABLE2", "test environment variable 2 value")))
 *         .desiredCount(2)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>NetworkLoadBalancedFargateService</code></li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object loadBalancedFargateService = NetworkLoadBalancedFargateService.Builder.create(stack, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(1024)
 *         .cpu(512)
 *         .taskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample")))
 *         .build();
 * </pre></blockquote>
 * <p>
 * The CDK will create a new Amazon ECS cluster if you specify a VPC and omit <code>cluster</code>. If you deploy multiple services the CDK will only create one cluster per VPC.
 * <p>
 * If <code>cluster</code> and <code>vpc</code> are omitted, the CDK creates a new VPC with subnets in two Availability Zones and a cluster within this VPC.
 * <p>
 * If you specify the option <code>recordType</code> you can decide if you want the construct to use CNAME or Route53-Aliases as record sets.
 * <p>
 * Additionally, if more than one network target group is needed, instantiate one of the following:
 * <p>
 * <ul>
 * <li>NetworkMultipleTargetGroupsEc2Service</li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // Two network load balancers, each with their own listener and target group.
 * Object loadBalancedEc2Service = NetworkMultipleTargetGroupsEc2Service.Builder.create(stack, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(256)
 *         .taskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample")))
 *         .loadBalancers(asList(Map.of(
 *                 "name", "lb1",
 *                 "listeners", asList(Map.of(
 *                         "name", "listener1"))), Map.of(
 *                 "name", "lb2",
 *                 "listeners", asList(Map.of(
 *                         "name", "listener2")))))
 *         .targetGroups(asList(Map.of(
 *                 "containerPort", 80,
 *                 "listener", "listener1"), Map.of(
 *                 "containerPort", 90,
 *                 "listener", "listener2")))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li>NetworkMultipleTargetGroupsFargateService</li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // Two network load balancers, each with their own listener and target group.
 * Object loadBalancedFargateService = NetworkMultipleTargetGroupsFargateService.Builder.create(stack, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(512)
 *         .taskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample")))
 *         .loadBalancers(asList(Map.of(
 *                 "name", "lb1",
 *                 "listeners", asList(Map.of(
 *                         "name", "listener1"))), Map.of(
 *                 "name", "lb2",
 *                 "listeners", asList(Map.of(
 *                         "name", "listener2")))))
 *         .targetGroups(asList(Map.of(
 *                 "containerPort", 80,
 *                 "listener", "listener1"), Map.of(
 *                 "containerPort", 90,
 *                 "listener", "listener2")))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Queue Processing Services</h2>
 * <p>
 * To define a service that creates a queue and reads from that queue, instantiate one of the following:
 * <p>
 * <ul>
 * <li><code>QueueProcessingEc2Service</code></li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object queueProcessingEc2Service = QueueProcessingEc2Service.Builder.create(stack, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(1024)
 *         .image(ecs.ContainerImage.fromRegistry("test"))
 *         .command(asList("-c", "4", "amazon.com"))
 *         .enableLogging(false)
 *         .desiredTaskCount(2)
 *         .environment(Map.of(
 *                 "TEST_ENVIRONMENT_VARIABLE1", "test environment variable 1 value",
 *                 "TEST_ENVIRONMENT_VARIABLE2", "test environment variable 2 value"))
 *         .queue(queue)
 *         .maxScalingCapacity(5)
 *         .containerName("test")
 *         .build();
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>QueueProcessingFargateService</code></li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object queueProcessingFargateService = QueueProcessingFargateService.Builder.create(stack, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(512)
 *         .image(ecs.ContainerImage.fromRegistry("test"))
 *         .command(asList("-c", "4", "amazon.com"))
 *         .enableLogging(false)
 *         .desiredTaskCount(2)
 *         .environment(Map.of(
 *                 "TEST_ENVIRONMENT_VARIABLE1", "test environment variable 1 value",
 *                 "TEST_ENVIRONMENT_VARIABLE2", "test environment variable 2 value"))
 *         .queue(queue)
 *         .maxScalingCapacity(5)
 *         .containerName("test")
 *         .build();
 * </pre></blockquote>
 * <p>
 * when queue not provided by user, CDK will create a primary queue and a dead letter queue with default redrive policy and attach permission to the task to be able to access the primary queue.
 * <p>
 * <h2>Scheduled Tasks</h2>
 * <p>
 * To define a task that runs periodically, there are 2 options:
 * <p>
 * <ul>
 * <li><code>ScheduledEc2Task</code></li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // Instantiate an Amazon EC2 Task to run at a scheduled interval
 * Object ecsScheduledTask = ScheduledEc2Task.Builder.create(stack, "ScheduledTask")
 *         .cluster(cluster)
 *         .scheduledEc2TaskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample"),
 *                 "memoryLimitMiB", 256,
 *                 "environment", Map.of("name", "TRIGGER", "value", "CloudWatch Events")))
 *         .schedule(events.Schedule.expression("rate(1 minute)"))
 *         .enabled(true)
 *         .ruleName("sample-scheduled-task-rule")
 *         .build();
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>ScheduledFargateTask</code></li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object scheduledFargateTask = ScheduledFargateTask.Builder.create(stack, "ScheduledFargateTask")
 *         .cluster(cluster)
 *         .scheduledFargateTaskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample"),
 *                 "memoryLimitMiB", 512))
 *         .schedule(events.Schedule.expression("rate(1 minute)"))
 *         .platformVersion(ecs.FargatePlatformVersion.getLATEST())
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Additional Examples</h2>
 * <p>
 * In addition to using the constructs, users can also add logic to customize these constructs:
 * <p>
 * <h3>Add Schedule-Based Auto-Scaling to an ApplicationLoadBalancedFargateService</h3>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import aws.cdk.lib.aws.applicationautoscaling.Schedule;
 * import application.load.balanced.fargate.service.ApplicationLoadBalancedFargateService;
 * import application.load.balanced.fargate.service.ApplicationLoadBalancedFargateServiceProps;
 * 
 * 
 * Object loadBalancedFargateService = ApplicationLoadBalancedFargateService.Builder.create(stack, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(1024)
 *         .desiredCount(1)
 *         .cpu(512)
 *         .taskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample")))
 *         .build();
 * 
 * Object scalableTarget = loadBalancedFargateService.service.autoScaleTaskCount(Map.of(
 *         "minCapacity", 5,
 *         "maxCapacity", 20));
 * 
 * scalableTarget.scaleOnSchedule("DaytimeScaleDown", Map.of(
 *         "schedule", Schedule.cron(new CronOptions().hour("8").minute("0")),
 *         "minCapacity", 1));
 * 
 * scalableTarget.scaleOnSchedule("EveningRushScaleUp", Map.of(
 *         "schedule", Schedule.cron(new CronOptions().hour("20").minute("0")),
 *         "minCapacity", 10));
 * </pre></blockquote>
 * <p>
 * <h3>Add Metric-Based Auto-Scaling to an ApplicationLoadBalancedFargateService</h3>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import application.load.balanced.fargate.service.ApplicationLoadBalancedFargateService;
 * 
 * 
 * Object loadBalancedFargateService = ApplicationLoadBalancedFargateService.Builder.create(stack, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(1024)
 *         .desiredCount(1)
 *         .cpu(512)
 *         .taskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample")))
 *         .build();
 * 
 * Object scalableTarget = loadBalancedFargateService.service.autoScaleTaskCount(Map.of(
 *         "minCapacity", 1,
 *         "maxCapacity", 20));
 * 
 * scalableTarget.scaleOnCpuUtilization("CpuScaling", Map.of(
 *         "targetUtilizationPercent", 50));
 * 
 * scalableTarget.scaleOnMemoryUtilization("MemoryScaling", Map.of(
 *         "targetUtilizationPercent", 50));
 * </pre></blockquote>
 * <p>
 * <h3>Change the default Deployment Controller</h3>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import application.load.balanced.fargate.service.ApplicationLoadBalancedFargateService;
 * 
 * 
 * Object loadBalancedFargateService = ApplicationLoadBalancedFargateService.Builder.create(stack, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(1024)
 *         .desiredCount(1)
 *         .cpu(512)
 *         .taskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample")))
 *         .deploymentController(Map.of(
 *                 "type", ecs.DeploymentControllerType.getCODE_DEPLOY()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Deployment circuit breaker and rollback</h3>
 * <p>
 * Amazon ECS <a href="https://aws.amazon.com/tw/blogs/containers/announcing-amazon-ecs-deployment-circuit-breaker/">deployment circuit breaker</a>
 * automatically rolls back unhealthy service deployments without the need for manual intervention. Use <code>circuitBreaker</code> to enable
 * deployment circuit breaker and optionally enable <code>rollback</code> for automatic rollback. See <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html">Using the deployment circuit breaker</a>
 * for more details.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object service = ApplicationLoadBalancedFargateService.Builder.create(stack, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(1024)
 *         .desiredCount(1)
 *         .cpu(512)
 *         .taskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample")))
 *         .circuitBreaker(Map.of("rollback", true))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Set deployment configuration on QueueProcessingService</h3>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object queueProcessingFargateService = QueueProcessingFargateService.Builder.create(stack, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(512)
 *         .image(ecs.ContainerImage.fromRegistry("test"))
 *         .command(asList("-c", "4", "amazon.com"))
 *         .enableLogging(false)
 *         .desiredTaskCount(2)
 *         .environment(Map.of())
 *         .queue(queue)
 *         .maxScalingCapacity(5)
 *         .maxHealthyPercent(200)
 *         .minHealthPercent(66)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Set taskSubnets and securityGroups for QueueProcessingFargateService</h3>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object queueProcessingFargateService = QueueProcessingFargateService.Builder.create(stack, "Service")
 *         .vpc(vpc)
 *         .memoryLimitMiB(512)
 *         .image(ecs.ContainerImage.fromRegistry("test"))
 *         .securityGroups(asList(securityGroup))
 *         .taskSubnets(Map.of("subnetType", ec2.SubnetType.getISOLATED()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Define tasks with public IPs for QueueProcessingFargateService</h3>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object queueProcessingFargateService = QueueProcessingFargateService.Builder.create(stack, "Service")
 *         .vpc(vpc)
 *         .memoryLimitMiB(512)
 *         .image(ecs.ContainerImage.fromRegistry("test"))
 *         .assignPublicIp(true)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Define tasks with custom queue parameters for QueueProcessingFargateService</h3>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object queueProcessingFargateService = QueueProcessingFargateService.Builder.create(stack, "Service")
 *         .vpc(vpc)
 *         .memoryLimitMiB(512)
 *         .image(ecs.ContainerImage.fromRegistry("test"))
 *         .maxReceiveCount(42)
 *         .retentionPeriod(cdk.Duration.days(7))
 *         .visibilityTimeout(cdk.Duration.minutes(5))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Select specific vpc subnets for ApplicationLoadBalancedFargateService</h3>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object loadBalancedFargateService = ApplicationLoadBalancedFargateService.Builder.create(stack, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(1024)
 *         .desiredCount(1)
 *         .cpu(512)
 *         .taskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample")))
 *         .vpcSubnets(Map.of(
 *                 "subnets", asList(ec2.Subnet.fromSubnetId(stack, "subnet", "VpcISOLATEDSubnet1Subnet80F07FA0"))))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Set PlatformVersion for ScheduledFargateTask</h3>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object scheduledFargateTask = ScheduledFargateTask.Builder.create(stack, "ScheduledFargateTask")
 *         .cluster(cluster)
 *         .scheduledFargateTaskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample"),
 *                 "memoryLimitMiB", 512))
 *         .schedule(events.Schedule.expression("rate(1 minute)"))
 *         .platformVersion(ecs.FargatePlatformVersion.getVERSION1_4())
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Set SecurityGroups for ScheduledFargateTask</h3>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object stack = new Stack();
 * Object vpc = Vpc.Builder.create(stack, "Vpc").maxAzs(1).build();
 * Object cluster = Cluster.Builder.create(stack, "EcsCluster").vpc(vpc).build();
 * Object securityGroup = SecurityGroup.Builder.create(stack, "SG").vpc(vpc).build();
 * 
 * Object scheduledFargateTask = ScheduledFargateTask.Builder.create(stack, "ScheduledFargateTask")
 *         .cluster(cluster)
 *         .scheduledFargateTaskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample"),
 *                 "memoryLimitMiB", 512))
 *         .schedule(events.Schedule.expression("rate(1 minute)"))
 *         .securityGroups(asList(securityGroup))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Use the REMOVE_DEFAULT_DESIRED_COUNT feature flag</h3>
 * <p>
 * The REMOVE_DEFAULT_DESIRED_COUNT feature flag is used to override the default desiredCount that is autogenerated by the CDK. This will set the desiredCount of any service created by any of the following constructs to be undefined.
 * <p>
 * <ul>
 * <li>ApplicationLoadBalancedEc2Service</li>
 * <li>ApplicationLoadBalancedFargateService</li>
 * <li>NetworkLoadBalancedEc2Service</li>
 * <li>NetworkLoadBalancedFargateService</li>
 * <li>QueueProcessingEc2Service</li>
 * <li>QueueProcessingFargateService</li>
 * </ul>
 * <p>
 * If a desiredCount is not passed in as input to the above constructs, CloudFormation will either create a new service to start up with a desiredCount of 1, or update an existing service to start up with the same desiredCount as prior to the update.
 * <p>
 * To enable the feature flag, ensure that the REMOVE_DEFAULT_DESIRED_COUNT flag within an application stack context is set to true, like so:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * stack.node.setContext(cxapi.getECS_REMOVE_DEFAULT_DESIRED_COUNT(), true);
 * </pre></blockquote>
 * <p>
 * The following is an example of an application with the REMOVE_DEFAULT_DESIRED_COUNT feature flag enabled:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * App app = new App();
 * 
 * Stack stack = new Stack(app, "aws-ecs-patterns-queue");
 * stack.node.setContext(cxapi.getECS_REMOVE_DEFAULT_DESIRED_COUNT(), true);
 * 
 * Object vpc = Vpc.Builder.create(stack, "VPC")
 *         .maxAzs(2)
 *         .build();
 * 
 * QueueProcessingFargateService.Builder.create(stack, "QueueProcessingService")
 *         .vpc(vpc)
 *         .memoryLimitMiB(512)
 *         .image(new AssetImage(path.join(__dirname, "..", "sqs-reader")))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Deploy application and metrics sidecar</h3>
 * <p>
 * The following is an example of deploying an application along with a metrics sidecar container that utilizes <code>dockerLabels</code> for discovery:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object service = ApplicationLoadBalancedFargateService.Builder.create(stack, "Service")
 *         .cluster(cluster)
 *         .vpc(vpc)
 *         .desiredCount(1)
 *         .taskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample")))
 *         .dockerLabels(Map.of(
 *                 "application.label.one", "first_label",
 *                 "application.label.two", "second_label"))
 *         .build();
 * 
 * service.taskDefinition.addContainer("Sidecar", Map.of(
 *         "image", ContainerImage.fromRegistry("example/metrics-sidecar")));
 * </pre></blockquote>
 * <p>
 * <h3>Select specific load balancer name ApplicationLoadBalancedFargateService</h3>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object loadBalancedFargateService = ApplicationLoadBalancedFargateService.Builder.create(stack, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(1024)
 *         .desiredCount(1)
 *         .cpu(512)
 *         .taskImageOptions(Map.of(
 *                 "image", ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample")))
 *         .vpcSubnets(Map.of(
 *                 "subnets", asList(ec2.Subnet.fromSubnetId(stack, "subnet", "VpcISOLATEDSubnet1Subnet80F07FA0"))))
 *         .loadBalancerName("application-lb-name")
 *         .build();
 * </pre></blockquote>
 */
package software.amazon.awscdk.services.ecs.patterns;
