package software.amazon.awscdk.services.efs;

/**
 * (experimental) Represents an Amazon EFS file system.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:16.995Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.IFileSystem")
@software.amazon.jsii.Jsii.Proxy(IFileSystem.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface IFileSystem extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.IConnectable, software.amazon.awscdk.IResource {

    /**
     * (experimental) The ARN of the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getFileSystemArn();

    /**
     * (experimental) The ID of the file system, assigned by Amazon EFS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId();

    /**
     * (experimental) Dependable that can be depended upon to ensure the mount targets of the filesystem are ready.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.constructs.IDependable getMountTargetsAvailable();

    /**
     * (experimental) Grant the actions defined in actions to the given grantee on this File System resource.
     * <p>
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.efs.IFileSystem.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) The network connections associated with this resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
            return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
        }

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * (experimental) The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * (experimental) The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * (experimental) The ARN of the file system.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getFileSystemArn() {
            return software.amazon.jsii.Kernel.get(this, "fileSystemArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The ID of the file system, assigned by Amazon EFS.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId() {
            return software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) Dependable that can be depended upon to ensure the mount targets of the filesystem are ready.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.constructs.IDependable getMountTargetsAvailable() {
            return software.amazon.jsii.Kernel.get(this, "mountTargetsAvailable", software.amazon.jsii.NativeType.forClass(software.constructs.IDependable.class));
        }

        /**
         * (experimental) Grant the actions defined in actions to the given grantee on this File System resource.
         * <p>
         * @param grantee This parameter is required.
         * @param actions This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
            return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
        }
    }

    /**
     * Internal default implementation for {@link IFileSystem}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IFileSystem, software.amazon.awscdk.IResource.Jsii$Default, software.amazon.awscdk.services.ec2.IConnectable.Jsii$Default {

        /**
         * (experimental) The network connections associated with this resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
            return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
        }

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * (experimental) The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * (experimental) The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * (experimental) The ARN of the file system.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getFileSystemArn() {
            return software.amazon.jsii.Kernel.get(this, "fileSystemArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The ID of the file system, assigned by Amazon EFS.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId() {
            return software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) Dependable that can be depended upon to ensure the mount targets of the filesystem are ready.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.constructs.IDependable getMountTargetsAvailable() {
            return software.amazon.jsii.Kernel.get(this, "mountTargetsAvailable", software.amazon.jsii.NativeType.forClass(software.constructs.IDependable.class));
        }

        /**
         * (experimental) Grant the actions defined in actions to the given grantee on this File System resource.
         * <p>
         * @param grantee This parameter is required.
         * @param actions This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
            return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
        }
    }
}
