package software.amazon.awscdk.services.eks;

/**
 * (experimental) Options for `KubernetesManifest`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:18.305Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.KubernetesManifestOptions")
@software.amazon.jsii.Jsii.Proxy(KubernetesManifestOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface KubernetesManifestOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) When a resource is removed from a Kubernetes manifest, it no longer appears in the manifest, and there is no way to know that this resource needs to be deleted.
     * <p>
     * To address this, <code>kubectl apply</code> has a <code>--prune</code> option which will
     * query the cluster for all resources with a specific label and will remove
     * all the labeld resources that are not part of the applied manifest. If this
     * option is disabled and a resource is removed, it will become "orphaned" and
     * will not be deleted from the cluster.
     * <p>
     * When this option is enabled (default), the construct will inject a label to
     * all Kubernetes resources included in this manifest which will be used to
     * prune resources when the manifest changes via <code>kubectl apply --prune</code>.
     * <p>
     * The label name will be <code>aws.cdk.eks/prune-&lt;ADDR&gt;</code> where <code>&lt;ADDR&gt;</code> is the
     * 42-char unique address of this construct in the construct tree. Value is
     * empty.
     * <p>
     * Default: - based on the prune option of the cluster, which is `true` unless
     * otherwise specified.
     * <p>
     * @see https://kubernetes.io/docs/tasks/manage-kubernetes-objects/declarative-config/#alternative-kubectl-apply-f-directory-prune-l-your-label
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrune() {
        return null;
    }

    /**
     * (experimental) A flag to signify if the manifest validation should be skipped.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSkipValidation() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link KubernetesManifestOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KubernetesManifestOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<KubernetesManifestOptions> {
        private java.lang.Boolean prune;
        private java.lang.Boolean skipValidation;

        /**
         * Sets the value of {@link KubernetesManifestOptions#getPrune}
         * @param prune When a resource is removed from a Kubernetes manifest, it no longer appears in the manifest, and there is no way to know that this resource needs to be deleted.
         *              To address this, <code>kubectl apply</code> has a <code>--prune</code> option which will
         *              query the cluster for all resources with a specific label and will remove
         *              all the labeld resources that are not part of the applied manifest. If this
         *              option is disabled and a resource is removed, it will become "orphaned" and
         *              will not be deleted from the cluster.
         *              <p>
         *              When this option is enabled (default), the construct will inject a label to
         *              all Kubernetes resources included in this manifest which will be used to
         *              prune resources when the manifest changes via <code>kubectl apply --prune</code>.
         *              <p>
         *              The label name will be <code>aws.cdk.eks/prune-&lt;ADDR&gt;</code> where <code>&lt;ADDR&gt;</code> is the
         *              42-char unique address of this construct in the construct tree. Value is
         *              empty.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder prune(java.lang.Boolean prune) {
            this.prune = prune;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesManifestOptions#getSkipValidation}
         * @param skipValidation A flag to signify if the manifest validation should be skipped.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder skipValidation(java.lang.Boolean skipValidation) {
            this.skipValidation = skipValidation;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KubernetesManifestOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public KubernetesManifestOptions build() {
            return new Jsii$Proxy(prune, skipValidation);
        }
    }

    /**
     * An implementation for {@link KubernetesManifestOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KubernetesManifestOptions {
        private final java.lang.Boolean prune;
        private final java.lang.Boolean skipValidation;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.prune = software.amazon.jsii.Kernel.get(this, "prune", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.skipValidation = software.amazon.jsii.Kernel.get(this, "skipValidation", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Boolean prune, final java.lang.Boolean skipValidation) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.prune = prune;
            this.skipValidation = skipValidation;
        }

        @Override
        public final java.lang.Boolean getPrune() {
            return this.prune;
        }

        @Override
        public final java.lang.Boolean getSkipValidation() {
            return this.skipValidation;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPrune() != null) {
                data.set("prune", om.valueToTree(this.getPrune()));
            }
            if (this.getSkipValidation() != null) {
                data.set("skipValidation", om.valueToTree(this.getSkipValidation()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.KubernetesManifestOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KubernetesManifestOptions.Jsii$Proxy that = (KubernetesManifestOptions.Jsii$Proxy) o;

            if (this.prune != null ? !this.prune.equals(that.prune) : that.prune != null) return false;
            return this.skipValidation != null ? this.skipValidation.equals(that.skipValidation) : that.skipValidation == null;
        }

        @Override
        public final int hashCode() {
            int result = this.prune != null ? this.prune.hashCode() : 0;
            result = 31 * result + (this.skipValidation != null ? this.skipValidation.hashCode() : 0);
            return result;
        }
    }
}
