package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * (experimental) Define a Network Listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:30.371Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.NetworkListener")
public class NetworkListener extends software.amazon.awscdk.services.elasticloadbalancingv2.BaseListener implements software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener {

    protected NetworkListener(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkListener(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public NetworkListener(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Looks up a network listener.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener fromLookup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerLookupOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener.class, "fromLookup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Import an existing listener.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param networkListenerArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener fromNetworkListenerArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String networkListenerArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener.class, "fromNetworkListenerArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(networkListenerArn, "networkListenerArn is required") });
    }

    /**
     * (experimental) Perform the given Action on incoming requests.
     * <p>
     * This allows full control of the default Action of the load balancer,
     * including weighted forwarding. See the <code>NetworkListenerAction</code> class for
     * all options.
     * <p>
     * @param _id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addAction(final @org.jetbrains.annotations.NotNull java.lang.String _id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.AddNetworkActionProps props) {
        software.amazon.jsii.Kernel.call(this, "addAction", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(_id, "_id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Load balance incoming requests to the given target groups.
     * <p>
     * All target groups will be load balanced to with equal weight and without
     * stickiness. For a more complex configuration than that, use <code>addAction()</code>.
     * <p>
     * @param _id This parameter is required.
     * @param targetGroups This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addTargetGroups(final @org.jetbrains.annotations.NotNull java.lang.String _id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup... targetGroups) {
        software.amazon.jsii.Kernel.call(this, "addTargetGroups", software.amazon.jsii.NativeType.VOID, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(_id, "_id is required") }), java.util.Arrays.<Object>stream(targetGroups)).toArray(Object[]::new));
    }

    /**
     * (experimental) Load balance incoming requests to the given load balancing targets.
     * <p>
     * This method implicitly creates a NetworkTargetGroup for the targets
     * involved, and a 'forward' action to route traffic to the given TargetGroup.
     * <p>
     * If you want more control over the precise setup, create the TargetGroup
     * and use <code>addAction</code> yourself.
     * <p>
     * It's possible to add conditions to the targets added in this way. At least
     * one set of targets must be added without conditions.
     * <p>
     * @return The newly created target group
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup addTargets(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.AddNetworkTargetsProps props) {
        return software.amazon.jsii.Kernel.call(this, "addTargets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) The load balancer this listener is attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer getLoadBalancer() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerProps.Builder();
        }

        /**
         * (experimental) The port on which the listener listens for requests.
         * <p>
         * @return {@code this}
         * @param port The port on which the listener listens for requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * (experimental) Certificate list of ACM cert ARNs.
         * <p>
         * Default: - No certificates.
         * <p>
         * @return {@code this}
         * @param certificates Certificate list of ACM cert ARNs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder certificates(final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> certificates) {
            this.props.certificates(certificates);
            return this;
        }

        /**
         * (experimental) Default action to take for requests to this listener.
         * <p>
         * This allows full control of the default Action of the load balancer,
         * including weighted forwarding. See the <code>NetworkListenerAction</code> class for
         * all options.
         * <p>
         * Cannot be specified together with <code>defaultTargetGroups</code>.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param defaultAction Default action to take for requests to this listener. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultAction(final software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction defaultAction) {
            this.props.defaultAction(defaultAction);
            return this;
        }

        /**
         * (experimental) Default target groups to load balance to.
         * <p>
         * All target groups will be load balanced to with equal weight and without
         * stickiness. For a more complex configuration than that, use
         * either <code>defaultAction</code> or <code>addAction()</code>.
         * <p>
         * Cannot be specified together with <code>defaultAction</code>.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param defaultTargetGroups Default target groups to load balance to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultTargetGroups(final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> defaultTargetGroups) {
            this.props.defaultTargetGroups(defaultTargetGroups);
            return this;
        }

        /**
         * (experimental) Protocol for listener, expects TCP, TLS, UDP, or TCP_UDP.
         * <p>
         * Default: - TLS if certificates are provided. TCP otherwise.
         * <p>
         * @return {@code this}
         * @param protocol Protocol for listener, expects TCP, TLS, UDP, or TCP_UDP. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder protocol(final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        /**
         * (experimental) SSL Policy.
         * <p>
         * Default: - Current predefined security policy.
         * <p>
         * @return {@code this}
         * @param sslPolicy SSL Policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sslPolicy(final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy) {
            this.props.sslPolicy(sslPolicy);
            return this;
        }

        /**
         * (experimental) The load balancer to attach this listener to.
         * <p>
         * @return {@code this}
         * @param loadBalancer The load balancer to attach this listener to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder loadBalancer(final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer) {
            this.props.loadBalancer(loadBalancer);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
