/**
 * <h1>Actions for AWS Elastic Load Balancing V2</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This package contains integration actions for ELBv2. See the README of the <code>&#64;aws-cdk/aws-elasticloadbalancingv2</code> library.
 * <p>
 * <h2>Cognito</h2>
 * <p>
 * ELB allows for requests to be authenticated against a Cognito user pool using
 * the <code>AuthenticateCognitoAction</code>. For details on the setup's requirements,
 * read <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/listener-authenticate-users.html#cognito-requirements">Prepare to use Amazon
 * Cognito</a>.
 * Here's an example:
 * <p>
 * <a href="test/integ.cognito.lit.ts">Example of using AuthenticateCognitoAction</a>
 * <p>
 * <blockquote>
 * <p>
 * NOTE: this example seems incomplete, I was not able to get the redirect back to the
 * Load Balancer after authentication working. Would love some pointers on what a full working
 * setup actually looks like!
 * <p>
 * </blockquote>
 */
package software.amazon.awscdk.services.elasticloadbalancingv2.actions;
