package software.amazon.awscdk.services.events.targets;

/**
 * (experimental) Use an SQS Queue as a target for Amazon EventBridge rules.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>{@code
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * // publish to an SQS queue every time code is committed
 * // to a CodeCommit repository
 * repository.onCommit("onCommit", new OnCommitOptions().target(new SqsQueue(queue)));}</pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:31.708Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.SqsQueue")
public class SqsQueue extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected SqsQueue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqsQueue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param queue This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SqsQueue(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.targets.SqsQueueProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required"), props });
    }

    /**
     * @param queue This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SqsQueue(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required") });
    }

    /**
     * (experimental) Returns a RuleTarget that can be used to trigger this SQS queue as a result from an EventBridge event.
     * <p>
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sqs-permissions
     * @param rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule rule, final @org.jetbrains.annotations.Nullable java.lang.String _id) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required"), _id });
    }

    /**
     * (experimental) Returns a RuleTarget that can be used to trigger this SQS queue as a result from an EventBridge event.
     * <p>
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sqs-permissions
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue getQueue() {
        return software.amazon.jsii.Kernel.get(this, "queue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.events.targets.SqsQueue}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.targets.SqsQueue> {
        /**
         * @return a new instance of {@link Builder}.
         * @param queue This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.sqs.IQueue queue) {
            return new Builder(queue);
        }

        private final software.amazon.awscdk.services.sqs.IQueue queue;
        private software.amazon.awscdk.services.events.targets.SqsQueueProps.Builder props;

        private Builder(final software.amazon.awscdk.services.sqs.IQueue queue) {
            this.queue = queue;
        }

        /**
         * (experimental) The message to send to the queue.
         * <p>
         * Must be a valid JSON text passed to the target queue.
         * <p>
         * Default: the entire EventBridge event
         * <p>
         * @return {@code this}
         * @param message The message to send to the queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder message(final software.amazon.awscdk.services.events.RuleTargetInput message) {
            this.props().message(message);
            return this;
        }

        /**
         * (experimental) Message Group ID for messages sent to this queue.
         * <p>
         * Required for FIFO queues, leave empty for regular queues.
         * <p>
         * Default: - no message group ID (regular queue)
         * <p>
         * @return {@code this}
         * @param messageGroupId Message Group ID for messages sent to this queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder messageGroupId(final java.lang.String messageGroupId) {
            this.props().messageGroupId(messageGroupId);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.events.targets.SqsQueue}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.events.targets.SqsQueue build() {
            return new software.amazon.awscdk.services.events.targets.SqsQueue(
                this.queue,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.events.targets.SqsQueueProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.events.targets.SqsQueueProps.Builder();
            }
            return this.props;
        }
    }
}
