/**
 * <h1>Amazon Kinesis Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * <a href="https://docs.aws.amazon.com/streams/latest/dev/introduction.html">Amazon Kinesis</a> provides collection and processing of large
 * <a href="https://aws.amazon.com/streaming-data/">streams</a> of data records in real time. Kinesis data streams can be used for rapid and continuous data
 * intake and aggregation.
 * <p>
 * <h2>Table Of Contents</h2>
 * <p>
 * <ul>
 * <li><a href="#streams">Streams</a>
 * <p>
 * <ul>
 * <li><a href="#encryption">Encryption</a></li>
 * <li><a href="#import">Import</a></li>
 * <li><a href="#permission-grants">Permission Grants</a>
 * <p>
 * <ul>
 * <li><a href="#read-permissions">Read Permissions</a></li>
 * <li><a href="#write-permissions">Write Permissions</a></li>
 * <li><a href="#custom-permissions">Custom Permissions</a></li>
 * </ul></li>
 * <li><a href="#metrics">Metrics</a></li>
 * </ul></li>
 * </ul>
 * <p>
 * <h2>Streams</h2>
 * <p>
 * Amazon Kinesis Data Streams ingests a large amount of data in real time, durably stores the data, and makes the data available for consumption.
 * <p>
 * Using the CDK, a new Kinesis stream can be created as part of the stack using the construct's constructor. You may specify the <code>streamName</code> to give
 * your own identifier to the stream. If not, CloudFormation will generate a name.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Stream.Builder.create(this, "MyFirstStream")
 *         .streamName("my-awesome-stream")
 *         .build();
 * </pre></blockquote>
 * <p>
 * You can also specify properties such as <code>shardCount</code> to indicate how many shards the stream should choose and a <code>retentionPeriod</code>
 * to specify how long the data in the shards should remain accessible.
 * Read more at <a href="https://docs.aws.amazon.com/streams/latest/dev/working-with-streams.html">Creating and Managing Streams</a>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Stream.Builder.create(this, "MyFirstStream")
 *         .streamName("my-awesome-stream")
 *         .shardCount(3)
 *         .retentionPeriod(Duration.hours(48))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Encryption</h3>
 * <p>
 * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html">Stream encryption</a> enables
 * server-side encryption using an AWS KMS key for a specified stream.
 * <p>
 * Encryption is enabled by default on your stream with the master key owned by Kinesis Data Streams in regions where it is supported.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * new Stream(this, "MyEncryptedStream");
 * </pre></blockquote>
 * <p>
 * You can enable encryption on your stream with a user-managed key by specifying the <code>encryption</code> property.
 * A KMS key will be created for you and associated with the stream.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Stream.Builder.create(this, "MyEncryptedStream")
 *         .encryption(StreamEncryption.getKMS())
 *         .build();
 * </pre></blockquote>
 * <p>
 * You can also supply your own external KMS key to use for stream encryption by specifying the <code>encryptionKey</code> property.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.aws_kms;
 * 
 * 
 * Key key = new Key(this, "MyKey");
 * 
 * Stream.Builder.create(this, "MyEncryptedStream")
 *         .encryption(StreamEncryption.getKMS())
 *         .encryptionKey(key)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Import</h3>
 * <p>
 * Any Kinesis stream that has been created outside the stack can be imported into your CDK app.
 * <p>
 * Streams can be imported by their ARN via the <code>Stream.fromStreamArn()</code> API
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Stack stack = new Stack(app, "MyStack");
 * 
 * Object importedStream = Stream.fromStreamArn(stack, "ImportedStream", "arn:aws:kinesis:us-east-2:123456789012:stream/f3j09j2230j");
 * </pre></blockquote>
 * <p>
 * Encrypted Streams can also be imported by their attributes via the <code>Stream.fromStreamAttributes()</code> API
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import aws.cdk.lib.aws.kms.Key;
 * 
 * 
 * Stack stack = new Stack(app, "MyStack");
 * 
 * Object importedStream = Stream.fromStreamAttributes(stack, "ImportedEncryptedStream", Map.of(
 *         "streamArn", "arn:aws:kinesis:us-east-2:123456789012:stream/f3j09j2230j",
 *         "encryptionKey", kms.Key.fromKeyArn("arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012")));
 * </pre></blockquote>
 * <p>
 * <h3>Permission Grants</h3>
 * <p>
 * IAM roles, users or groups which need to be able to work with Amazon Kinesis streams at runtime should be granted IAM permissions.
 * <p>
 * Any object that implements the <code>IGrantable</code> interface (has an associated principal) can be granted permissions by calling:
 * <p>
 * <ul>
 * <li><code>grantRead(principal)</code> - grants the principal read access</li>
 * <li><code>grantWrite(principal)</code> - grants the principal write permissions to a Stream</li>
 * <li><code>grantReadWrite(principal)</code> - grants principal read and write permissions</li>
 * </ul>
 * <p>
 * <h4>Read Permissions</h4>
 * <p>
 * Grant <code>read</code> access to a stream by calling the <code>grantRead()</code> API.
 * If the stream has an encryption key, read permissions will also be granted to the key.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Role lambdaRole = new Role(this, "Role", new RoleProps()
 *         .assumedBy(new ServicePrincipal("lambda.amazonaws.com"))
 *         .description("Example role..."));
 * 
 * Object stream = Stream.Builder.create(this, "MyEncryptedStream")
 *         .encryption(StreamEncryption.getKMS())
 *         .build();
 * 
 * // give lambda permissions to read stream
 * stream.grantRead(lambdaRole);
 * </pre></blockquote>
 * <p>
 * The following read permissions are provided to a service principal by the <code>grantRead()</code> API:
 * <p>
 * <ul>
 * <li><code>kinesis:DescribeStreamSummary</code></li>
 * <li><code>kinesis:GetRecords</code></li>
 * <li><code>kinesis:GetShardIterator</code></li>
 * <li><code>kinesis:ListShards</code></li>
 * <li><code>kinesis:SubscribeToShard</code></li>
 * </ul>
 * <p>
 * <h4>Write Permissions</h4>
 * <p>
 * Grant <code>write</code> permissions to a stream is provided by calling the <code>grantWrite()</code> API.
 * If the stream has an encryption key, write permissions will also be granted to the key.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Role lambdaRole = new Role(this, "Role", new RoleProps()
 *         .assumedBy(new ServicePrincipal("lambda.amazonaws.com"))
 *         .description("Example role..."));
 * 
 * Object stream = Stream.Builder.create(this, "MyEncryptedStream")
 *         .encryption(StreamEncryption.getKMS())
 *         .build();
 * 
 * // give lambda permissions to write to stream
 * stream.grantWrite(lambdaRole);
 * </pre></blockquote>
 * <p>
 * The following write permissions are provided to a service principal by the <code>grantWrite()</code> API:
 * <p>
 * <ul>
 * <li><code>kinesis:ListShards</code></li>
 * <li><code>kinesis:PutRecord</code></li>
 * <li><code>kinesis:PutRecords</code></li>
 * </ul>
 * <p>
 * <h4>Custom Permissions</h4>
 * <p>
 * You can add any set of permissions to a stream by calling the <code>grant()</code> API.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * User user = new User(stack, "MyUser");
 * 
 * Object stream = new Stream(stack, "MyStream");
 * 
 * // give my user permissions to list shards
 * stream.grant(user, "kinesis:ListShards");
 * </pre></blockquote>
 * <p>
 * <h3>Metrics</h3>
 * <p>
 * You can use common metrics from your stream to create alarms and/or dashboards. The <code>stream.metric('MetricName')</code> method creates a metric with the stream namespace and dimension. You can also use pre-define methods like <code>stream.metricGetRecordsSuccess()</code>. To find out more about Kinesis metrics check <a href="https://docs.aws.amazon.com/streams/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon Kinesis Data Streams Service with Amazon CloudWatch</a>.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object stream = new Stream(stack, "MyStream");
 * 
 * // Using base metric method passing the metric name
 * stream.metric("GetRecords.Success");
 * 
 * // using pre-defined metric method
 * stream.metricGetRecordsSuccess();
 * 
 * // using pre-defined and overriding the statistic
 * stream.metricGetRecordsSuccess(Map.of("statistic", "Maximum"));
 * </pre></blockquote>
 */
package software.amazon.awscdk.services.kinesis;
