package software.amazon.awscdk.services.kinesisanalytics;

/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationOutput`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:32.058Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutput")
public class CfnApplicationOutput extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnApplicationOutput(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplicationOutput(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::KinesisAnalytics::ApplicationOutput`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApplicationOutput(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutputProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::KinesisAnalytics::ApplicationOutput.ApplicationName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationName() {
        return software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::KinesisAnalytics::ApplicationOutput.ApplicationName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
    }

    /**
     * `AWS::KinesisAnalytics::ApplicationOutput.Output`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getOutput() {
        return software.amazon.jsii.Kernel.get(this, "output", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::KinesisAnalytics::ApplicationOutput.Output`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput.OutputProperty value) {
        software.amazon.jsii.Kernel.set(this, "output", java.util.Objects.requireNonNull(value, "output is required"));
    }

    /**
     * `AWS::KinesisAnalytics::ApplicationOutput.Output`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "output", java.util.Objects.requireNonNull(value, "output is required"));
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutput.DestinationSchemaProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationSchemaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationSchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationOutput.DestinationSchemaProperty.RecordFormatType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRecordFormatType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DestinationSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationSchemaProperty> {
            private java.lang.String recordFormatType;

            /**
             * Sets the value of {@link DestinationSchemaProperty#getRecordFormatType}
             * @param recordFormatType `CfnApplicationOutput.DestinationSchemaProperty.RecordFormatType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordFormatType(java.lang.String recordFormatType) {
                this.recordFormatType = recordFormatType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationSchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationSchemaProperty build() {
                return new Jsii$Proxy(recordFormatType);
            }
        }

        /**
         * An implementation for {@link DestinationSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationSchemaProperty {
            private final java.lang.String recordFormatType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recordFormatType = software.amazon.jsii.Kernel.get(this, "recordFormatType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String recordFormatType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordFormatType = recordFormatType;
            }

            @Override
            public final java.lang.String getRecordFormatType() {
                return this.recordFormatType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRecordFormatType() != null) {
                    data.set("recordFormatType", om.valueToTree(this.getRecordFormatType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutput.DestinationSchemaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationSchemaProperty.Jsii$Proxy that = (DestinationSchemaProperty.Jsii$Proxy) o;

                return this.recordFormatType != null ? this.recordFormatType.equals(that.recordFormatType) : that.recordFormatType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.recordFormatType != null ? this.recordFormatType.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutput.KinesisFirehoseOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisFirehoseOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisFirehoseOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationOutput.KinesisFirehoseOutputProperty.ResourceARN`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

        /**
         * `CfnApplicationOutput.KinesisFirehoseOutputProperty.RoleARN`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link KinesisFirehoseOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisFirehoseOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisFirehoseOutputProperty> {
            private java.lang.String resourceArn;
            private java.lang.String roleArn;

            /**
             * Sets the value of {@link KinesisFirehoseOutputProperty#getResourceArn}
             * @param resourceArn `CfnApplicationOutput.KinesisFirehoseOutputProperty.ResourceARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Sets the value of {@link KinesisFirehoseOutputProperty#getRoleArn}
             * @param roleArn `CfnApplicationOutput.KinesisFirehoseOutputProperty.RoleARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisFirehoseOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisFirehoseOutputProperty build() {
                return new Jsii$Proxy(resourceArn, roleArn);
            }
        }

        /**
         * An implementation for {@link KinesisFirehoseOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisFirehoseOutputProperty {
            private final java.lang.String resourceArn;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String resourceArn, final java.lang.String roleArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(resourceArn, "resourceArn is required");
                this.roleArn = java.util.Objects.requireNonNull(roleArn, "roleArn is required");
            }

            @Override
            public final java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceArn", om.valueToTree(this.getResourceArn()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutput.KinesisFirehoseOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisFirehoseOutputProperty.Jsii$Proxy that = (KinesisFirehoseOutputProperty.Jsii$Proxy) o;

                if (!resourceArn.equals(that.resourceArn)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.resourceArn.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutput.KinesisStreamsOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisStreamsOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisStreamsOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationOutput.KinesisStreamsOutputProperty.ResourceARN`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

        /**
         * `CfnApplicationOutput.KinesisStreamsOutputProperty.RoleARN`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link KinesisStreamsOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisStreamsOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisStreamsOutputProperty> {
            private java.lang.String resourceArn;
            private java.lang.String roleArn;

            /**
             * Sets the value of {@link KinesisStreamsOutputProperty#getResourceArn}
             * @param resourceArn `CfnApplicationOutput.KinesisStreamsOutputProperty.ResourceARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Sets the value of {@link KinesisStreamsOutputProperty#getRoleArn}
             * @param roleArn `CfnApplicationOutput.KinesisStreamsOutputProperty.RoleARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisStreamsOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisStreamsOutputProperty build() {
                return new Jsii$Proxy(resourceArn, roleArn);
            }
        }

        /**
         * An implementation for {@link KinesisStreamsOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisStreamsOutputProperty {
            private final java.lang.String resourceArn;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String resourceArn, final java.lang.String roleArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(resourceArn, "resourceArn is required");
                this.roleArn = java.util.Objects.requireNonNull(roleArn, "roleArn is required");
            }

            @Override
            public final java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceArn", om.valueToTree(this.getResourceArn()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutput.KinesisStreamsOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisStreamsOutputProperty.Jsii$Proxy that = (KinesisStreamsOutputProperty.Jsii$Proxy) o;

                if (!resourceArn.equals(that.resourceArn)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.resourceArn.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutput.LambdaOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationOutput.LambdaOutputProperty.ResourceARN`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

        /**
         * `CfnApplicationOutput.LambdaOutputProperty.RoleARN`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link LambdaOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaOutputProperty> {
            private java.lang.String resourceArn;
            private java.lang.String roleArn;

            /**
             * Sets the value of {@link LambdaOutputProperty#getResourceArn}
             * @param resourceArn `CfnApplicationOutput.LambdaOutputProperty.ResourceARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Sets the value of {@link LambdaOutputProperty#getRoleArn}
             * @param roleArn `CfnApplicationOutput.LambdaOutputProperty.RoleARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaOutputProperty build() {
                return new Jsii$Proxy(resourceArn, roleArn);
            }
        }

        /**
         * An implementation for {@link LambdaOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaOutputProperty {
            private final java.lang.String resourceArn;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String resourceArn, final java.lang.String roleArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(resourceArn, "resourceArn is required");
                this.roleArn = java.util.Objects.requireNonNull(roleArn, "roleArn is required");
            }

            @Override
            public final java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceArn", om.valueToTree(this.getResourceArn()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutput.LambdaOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaOutputProperty.Jsii$Proxy that = (LambdaOutputProperty.Jsii$Proxy) o;

                if (!resourceArn.equals(that.resourceArn)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.resourceArn.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutput.OutputProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationOutput.OutputProperty.DestinationSchema`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestinationSchema();

        /**
         * `CfnApplicationOutput.OutputProperty.KinesisFirehoseOutput`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisFirehoseOutput() {
            return null;
        }

        /**
         * `CfnApplicationOutput.OutputProperty.KinesisStreamsOutput`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisStreamsOutput() {
            return null;
        }

        /**
         * `CfnApplicationOutput.OutputProperty.LambdaOutput`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaOutput() {
            return null;
        }

        /**
         * `CfnApplicationOutput.OutputProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputProperty> {
            private java.lang.Object destinationSchema;
            private java.lang.Object kinesisFirehoseOutput;
            private java.lang.Object kinesisStreamsOutput;
            private java.lang.Object lambdaOutput;
            private java.lang.String name;

            /**
             * Sets the value of {@link OutputProperty#getDestinationSchema}
             * @param destinationSchema `CfnApplicationOutput.OutputProperty.DestinationSchema`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationSchema(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput.DestinationSchemaProperty destinationSchema) {
                this.destinationSchema = destinationSchema;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getDestinationSchema}
             * @param destinationSchema `CfnApplicationOutput.OutputProperty.DestinationSchema`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationSchema(software.amazon.awscdk.IResolvable destinationSchema) {
                this.destinationSchema = destinationSchema;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getKinesisFirehoseOutput}
             * @param kinesisFirehoseOutput `CfnApplicationOutput.OutputProperty.KinesisFirehoseOutput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisFirehoseOutput(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput.KinesisFirehoseOutputProperty kinesisFirehoseOutput) {
                this.kinesisFirehoseOutput = kinesisFirehoseOutput;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getKinesisFirehoseOutput}
             * @param kinesisFirehoseOutput `CfnApplicationOutput.OutputProperty.KinesisFirehoseOutput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisFirehoseOutput(software.amazon.awscdk.IResolvable kinesisFirehoseOutput) {
                this.kinesisFirehoseOutput = kinesisFirehoseOutput;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getKinesisStreamsOutput}
             * @param kinesisStreamsOutput `CfnApplicationOutput.OutputProperty.KinesisStreamsOutput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisStreamsOutput(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput.KinesisStreamsOutputProperty kinesisStreamsOutput) {
                this.kinesisStreamsOutput = kinesisStreamsOutput;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getKinesisStreamsOutput}
             * @param kinesisStreamsOutput `CfnApplicationOutput.OutputProperty.KinesisStreamsOutput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisStreamsOutput(software.amazon.awscdk.IResolvable kinesisStreamsOutput) {
                this.kinesisStreamsOutput = kinesisStreamsOutput;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getLambdaOutput}
             * @param lambdaOutput `CfnApplicationOutput.OutputProperty.LambdaOutput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaOutput(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput.LambdaOutputProperty lambdaOutput) {
                this.lambdaOutput = lambdaOutput;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getLambdaOutput}
             * @param lambdaOutput `CfnApplicationOutput.OutputProperty.LambdaOutput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaOutput(software.amazon.awscdk.IResolvable lambdaOutput) {
                this.lambdaOutput = lambdaOutput;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getName}
             * @param name `CfnApplicationOutput.OutputProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputProperty build() {
                return new Jsii$Proxy(destinationSchema, kinesisFirehoseOutput, kinesisStreamsOutput, lambdaOutput, name);
            }
        }

        /**
         * An implementation for {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputProperty {
            private final java.lang.Object destinationSchema;
            private final java.lang.Object kinesisFirehoseOutput;
            private final java.lang.Object kinesisStreamsOutput;
            private final java.lang.Object lambdaOutput;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationSchema = software.amazon.jsii.Kernel.get(this, "destinationSchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesisFirehoseOutput = software.amazon.jsii.Kernel.get(this, "kinesisFirehoseOutput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesisStreamsOutput = software.amazon.jsii.Kernel.get(this, "kinesisStreamsOutput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambdaOutput = software.amazon.jsii.Kernel.get(this, "lambdaOutput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object destinationSchema, final java.lang.Object kinesisFirehoseOutput, final java.lang.Object kinesisStreamsOutput, final java.lang.Object lambdaOutput, final java.lang.String name) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationSchema = java.util.Objects.requireNonNull(destinationSchema, "destinationSchema is required");
                this.kinesisFirehoseOutput = kinesisFirehoseOutput;
                this.kinesisStreamsOutput = kinesisStreamsOutput;
                this.lambdaOutput = lambdaOutput;
                this.name = name;
            }

            @Override
            public final java.lang.Object getDestinationSchema() {
                return this.destinationSchema;
            }

            @Override
            public final java.lang.Object getKinesisFirehoseOutput() {
                return this.kinesisFirehoseOutput;
            }

            @Override
            public final java.lang.Object getKinesisStreamsOutput() {
                return this.kinesisStreamsOutput;
            }

            @Override
            public final java.lang.Object getLambdaOutput() {
                return this.lambdaOutput;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationSchema", om.valueToTree(this.getDestinationSchema()));
                if (this.getKinesisFirehoseOutput() != null) {
                    data.set("kinesisFirehoseOutput", om.valueToTree(this.getKinesisFirehoseOutput()));
                }
                if (this.getKinesisStreamsOutput() != null) {
                    data.set("kinesisStreamsOutput", om.valueToTree(this.getKinesisStreamsOutput()));
                }
                if (this.getLambdaOutput() != null) {
                    data.set("lambdaOutput", om.valueToTree(this.getLambdaOutput()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplicationOutput.OutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputProperty.Jsii$Proxy that = (OutputProperty.Jsii$Proxy) o;

                if (!destinationSchema.equals(that.destinationSchema)) return false;
                if (this.kinesisFirehoseOutput != null ? !this.kinesisFirehoseOutput.equals(that.kinesisFirehoseOutput) : that.kinesisFirehoseOutput != null) return false;
                if (this.kinesisStreamsOutput != null ? !this.kinesisStreamsOutput.equals(that.kinesisStreamsOutput) : that.kinesisStreamsOutput != null) return false;
                if (this.lambdaOutput != null ? !this.lambdaOutput.equals(that.lambdaOutput) : that.lambdaOutput != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationSchema.hashCode();
                result = 31 * result + (this.kinesisFirehoseOutput != null ? this.kinesisFirehoseOutput.hashCode() : 0);
                result = 31 * result + (this.kinesisStreamsOutput != null ? this.kinesisStreamsOutput.hashCode() : 0);
                result = 31 * result + (this.lambdaOutput != null ? this.lambdaOutput.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutputProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutputProps.Builder();
        }

        /**
         * `AWS::KinesisAnalytics::ApplicationOutput.ApplicationName`.
         * <p>
         * @return {@code this}
         * @param applicationName `AWS::KinesisAnalytics::ApplicationOutput.ApplicationName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(final java.lang.String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        /**
         * `AWS::KinesisAnalytics::ApplicationOutput.Output`.
         * <p>
         * @return {@code this}
         * @param output `AWS::KinesisAnalytics::ApplicationOutput.Output`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput.OutputProperty output) {
            this.props.output(output);
            return this;
        }
        /**
         * `AWS::KinesisAnalytics::ApplicationOutput.Output`.
         * <p>
         * @return {@code this}
         * @param output `AWS::KinesisAnalytics::ApplicationOutput.Output`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(final software.amazon.awscdk.IResolvable output) {
            this.props.output(output);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput build() {
            return new software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
