package software.amazon.awscdk.services.lambda;

/**
 * (experimental) Represents a permission statement that can be added to a Lambda's resource policy via the `addToResourcePolicy` method.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:32.168Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.Permission")
@software.amazon.jsii.Jsii.Proxy(Permission.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface Permission extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The entity for which you are granting permission to invoke the Lambda function.
     * <p>
     * This entity can be any valid AWS service principal, such as
     * s3.amazonaws.com or sns.amazonaws.com, or, if you are granting
     * cross-account permission, an AWS account ID. For example, you might want
     * to allow a custom application in another AWS account to push events to
     * Lambda by invoking your function.
     * <p>
     * The principal can be either an AccountPrincipal or a ServicePrincipal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getPrincipal();

    /**
     * (experimental) The Lambda actions that you want to allow in this statement.
     * <p>
     * For example,
     * you can specify lambda:CreateFunction to specify a certain action, or use
     * a wildcard (<code>lambda:*</code>) to grant permission to all Lambda actions. For a
     * list of actions, see Actions and Condition Context Keys for AWS Lambda in
     * the IAM User Guide.
     * <p>
     * Default: 'lambda:InvokeFunction'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAction() {
        return null;
    }

    /**
     * (experimental) A unique token that must be supplied by the principal invoking the function.
     * <p>
     * Default: The caller would not need to present a token.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getEventSourceToken() {
        return null;
    }

    /**
     * (experimental) The scope to which the permission constructs be attached.
     * <p>
     * The default is
     * the Lambda function construct itself, but this would need to be different
     * in cases such as cross-stack references where the Permissions would need
     * to sit closer to the consumer of this permission (i.e., the caller).
     * <p>
     * Default: - The instance of lambda.IFunction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.constructs.Construct getScope() {
        return null;
    }

    /**
     * (experimental) The AWS account ID (without hyphens) of the source owner.
     * <p>
     * For example, if
     * you specify an S3 bucket in the SourceArn property, this value is the
     * bucket owner's account ID. You can use this property to ensure that all
     * source principals are owned by a specific account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceAccount() {
        return null;
    }

    /**
     * (experimental) The ARN of a resource that is invoking your function.
     * <p>
     * When granting
     * Amazon Simple Storage Service (Amazon S3) permission to invoke your
     * function, specify this property with the bucket ARN as its value. This
     * ensures that events generated only from the specified bucket, not just
     * any bucket from any AWS account that creates a mapping to your function,
     * can invoke the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Permission}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Permission}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<Permission> {
        private software.amazon.awscdk.services.iam.IPrincipal principal;
        private java.lang.String action;
        private java.lang.String eventSourceToken;
        private software.constructs.Construct scope;
        private java.lang.String sourceAccount;
        private java.lang.String sourceArn;

        /**
         * Sets the value of {@link Permission#getPrincipal}
         * @param principal The entity for which you are granting permission to invoke the Lambda function. This parameter is required.
         *                  This entity can be any valid AWS service principal, such as
         *                  s3.amazonaws.com or sns.amazonaws.com, or, if you are granting
         *                  cross-account permission, an AWS account ID. For example, you might want
         *                  to allow a custom application in another AWS account to push events to
         *                  Lambda by invoking your function.
         *                  <p>
         *                  The principal can be either an AccountPrincipal or a ServicePrincipal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder principal(software.amazon.awscdk.services.iam.IPrincipal principal) {
            this.principal = principal;
            return this;
        }

        /**
         * Sets the value of {@link Permission#getAction}
         * @param action The Lambda actions that you want to allow in this statement.
         *               For example,
         *               you can specify lambda:CreateFunction to specify a certain action, or use
         *               a wildcard (<code>lambda:*</code>) to grant permission to all Lambda actions. For a
         *               list of actions, see Actions and Condition Context Keys for AWS Lambda in
         *               the IAM User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder action(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link Permission#getEventSourceToken}
         * @param eventSourceToken A unique token that must be supplied by the principal invoking the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder eventSourceToken(java.lang.String eventSourceToken) {
            this.eventSourceToken = eventSourceToken;
            return this;
        }

        /**
         * Sets the value of {@link Permission#getScope}
         * @param scope The scope to which the permission constructs be attached.
         *              The default is
         *              the Lambda function construct itself, but this would need to be different
         *              in cases such as cross-stack references where the Permissions would need
         *              to sit closer to the consumer of this permission (i.e., the caller).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scope(software.constructs.Construct scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link Permission#getSourceAccount}
         * @param sourceAccount The AWS account ID (without hyphens) of the source owner.
         *                      For example, if
         *                      you specify an S3 bucket in the SourceArn property, this value is the
         *                      bucket owner's account ID. You can use this property to ensure that all
         *                      source principals are owned by a specific account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sourceAccount(java.lang.String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        /**
         * Sets the value of {@link Permission#getSourceArn}
         * @param sourceArn The ARN of a resource that is invoking your function.
         *                  When granting
         *                  Amazon Simple Storage Service (Amazon S3) permission to invoke your
         *                  function, specify this property with the bucket ARN as its value. This
         *                  ensures that events generated only from the specified bucket, not just
         *                  any bucket from any AWS account that creates a mapping to your function,
         *                  can invoke the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sourceArn(java.lang.String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Permission}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public Permission build() {
            return new Jsii$Proxy(principal, action, eventSourceToken, scope, sourceAccount, sourceArn);
        }
    }

    /**
     * An implementation for {@link Permission}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Permission {
        private final software.amazon.awscdk.services.iam.IPrincipal principal;
        private final java.lang.String action;
        private final java.lang.String eventSourceToken;
        private final software.constructs.Construct scope;
        private final java.lang.String sourceAccount;
        private final java.lang.String sourceArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventSourceToken = software.amazon.jsii.Kernel.get(this, "eventSourceToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(software.constructs.Construct.class));
            this.sourceAccount = software.amazon.jsii.Kernel.get(this, "sourceAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceArn = software.amazon.jsii.Kernel.get(this, "sourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.iam.IPrincipal principal, final java.lang.String action, final java.lang.String eventSourceToken, final software.constructs.Construct scope, final java.lang.String sourceAccount, final java.lang.String sourceArn) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.principal = java.util.Objects.requireNonNull(principal, "principal is required");
            this.action = action;
            this.eventSourceToken = eventSourceToken;
            this.scope = scope;
            this.sourceAccount = sourceAccount;
            this.sourceArn = sourceArn;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IPrincipal getPrincipal() {
            return this.principal;
        }

        @Override
        public final java.lang.String getAction() {
            return this.action;
        }

        @Override
        public final java.lang.String getEventSourceToken() {
            return this.eventSourceToken;
        }

        @Override
        public final software.constructs.Construct getScope() {
            return this.scope;
        }

        @Override
        public final java.lang.String getSourceAccount() {
            return this.sourceAccount;
        }

        @Override
        public final java.lang.String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("principal", om.valueToTree(this.getPrincipal()));
            if (this.getAction() != null) {
                data.set("action", om.valueToTree(this.getAction()));
            }
            if (this.getEventSourceToken() != null) {
                data.set("eventSourceToken", om.valueToTree(this.getEventSourceToken()));
            }
            if (this.getScope() != null) {
                data.set("scope", om.valueToTree(this.getScope()));
            }
            if (this.getSourceAccount() != null) {
                data.set("sourceAccount", om.valueToTree(this.getSourceAccount()));
            }
            if (this.getSourceArn() != null) {
                data.set("sourceArn", om.valueToTree(this.getSourceArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.Permission"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Permission.Jsii$Proxy that = (Permission.Jsii$Proxy) o;

            if (!principal.equals(that.principal)) return false;
            if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
            if (this.eventSourceToken != null ? !this.eventSourceToken.equals(that.eventSourceToken) : that.eventSourceToken != null) return false;
            if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
            if (this.sourceAccount != null ? !this.sourceAccount.equals(that.sourceAccount) : that.sourceAccount != null) return false;
            return this.sourceArn != null ? this.sourceArn.equals(that.sourceArn) : that.sourceArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.principal.hashCode();
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            result = 31 * result + (this.eventSourceToken != null ? this.eventSourceToken.hashCode() : 0);
            result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
            result = 31 * result + (this.sourceAccount != null ? this.sourceAccount.hashCode() : 0);
            result = 31 * result + (this.sourceArn != null ? this.sourceArn.hashCode() : 0);
            return result;
        }
    }
}
