package software.amazon.awscdk.services.lambda;

/**
 * (experimental) A single newly-deployed version of a Lambda function.
 * <p>
 * This object exists to--at deploy time--query the "then-current" version of
 * the Lambda function that it refers to. This Version object can then be
 * used in <code>Alias</code> to refer to a particular deployment of a Lambda.
 * <p>
 * This means that for every new update you deploy to your Lambda (using the
 * CDK and Aliases), you must always create a new Version object. In
 * particular, it must have a different name, so that a new resource is
 * created.
 * <p>
 * If you want to ensure that you're associating the right version with
 * the right deployment, specify the <code>codeSha256</code> property while
 * creating the `Version.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:32.174Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.Version")
public class Version extends software.amazon.awscdk.services.lambda.QualifiedFunctionBase implements software.amazon.awscdk.services.lambda.IVersion {

    protected Version(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Version(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Version(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.VersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Construct a Version object from a Version ARN.
     * <p>
     * @param scope The cdk scope creating this resource. This parameter is required.
     * @param id The cdk id of this resource. This parameter is required.
     * @param versionArn The version ARN to create this version from. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IVersion fromVersionArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String versionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Version.class, "fromVersionArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IVersion.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(versionArn, "versionArn is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IVersion fromVersionAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.VersionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Version.class, "fromVersionAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IVersion.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) Defines an alias for this version.
     * <p>
     * @param aliasName The name of the alias (e.g. "live"). This parameter is required.
     * @param options Alias options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Alias addAlias(final @org.jetbrains.annotations.NotNull java.lang.String aliasName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.AliasOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addAlias", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Alias.class), new Object[] { java.util.Objects.requireNonNull(aliasName, "aliasName is required"), options });
    }

    /**
     * (experimental) Defines an alias for this version.
     * <p>
     * @param aliasName The name of the alias (e.g. "live"). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Alias addAlias(final @org.jetbrains.annotations.NotNull java.lang.String aliasName) {
        return software.amazon.jsii.Kernel.call(this, "addAlias", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Alias.class), new Object[] { java.util.Objects.requireNonNull(aliasName, "aliasName is required") });
    }

    /**
     * (experimental) Return the given named metric for this Function.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * (experimental) Return the given named metric for this Function.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * (experimental) Whether the addPermission() call adds any permissions.
     * <p>
     * True for new Lambdas, false for version $LATEST and imported Lambdas
     * from different accounts.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getCanCreatePermissions() {
        return software.amazon.jsii.Kernel.get(this, "canCreatePermissions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) The ARN of the version for Lambda@Edge.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getEdgeArn() {
        return software.amazon.jsii.Kernel.get(this, "edgeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The ARN fo the function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn() {
        return software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionName() {
        return software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The principal this Lambda Function is running as.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * (experimental) The underlying AWS Lambda function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getLambda() {
        return software.amazon.jsii.Kernel.get(this, "lambda", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
    }

    /**
     * (experimental) The qualifier of the version or alias of this function.
     * <p>
     * A qualifier is the identifier that's appended to a version or alias ARN.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull java.lang.String getQualifier() {
        return software.amazon.jsii.Kernel.get(this, "qualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The most recently deployed version of this function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The IAM role associated with this function.
     * <p>
     * Undefined if the function was imported without a role.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.lambda.Version}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.Version> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.VersionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.VersionProps.Builder();
        }

        /**
         * (experimental) The maximum age of a request that Lambda sends to a function for processing.
         * <p>
         * Minimum: 60 seconds
         * Maximum: 6 hours
         * <p>
         * Default: Duration.hours(6)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxEventAge(final software.amazon.awscdk.Duration maxEventAge) {
            this.props.maxEventAge(maxEventAge);
            return this;
        }

        /**
         * (experimental) The destination for failed invocations.
         * <p>
         * Default: - no destination
         * <p>
         * @return {@code this}
         * @param onFailure The destination for failed invocations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder onFailure(final software.amazon.awscdk.services.lambda.IDestination onFailure) {
            this.props.onFailure(onFailure);
            return this;
        }

        /**
         * (experimental) The destination for successful invocations.
         * <p>
         * Default: - no destination
         * <p>
         * @return {@code this}
         * @param onSuccess The destination for successful invocations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder onSuccess(final software.amazon.awscdk.services.lambda.IDestination onSuccess) {
            this.props.onSuccess(onSuccess);
            return this;
        }

        /**
         * (experimental) The maximum number of times to retry when the function returns an error.
         * <p>
         * Minimum: 0
         * Maximum: 2
         * <p>
         * Default: 2
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the function returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * (experimental) SHA256 of the version of the Lambda source code.
         * <p>
         * Specify to validate that you're deploying the right version.
         * <p>
         * Default: No validation is performed
         * <p>
         * @return {@code this}
         * @param codeSha256 SHA256 of the version of the Lambda source code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder codeSha256(final java.lang.String codeSha256) {
            this.props.codeSha256(codeSha256);
            return this;
        }

        /**
         * (experimental) Description of the version.
         * <p>
         * Default: Description of the Lambda
         * <p>
         * @return {@code this}
         * @param description Description of the version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (experimental) Specifies a provisioned concurrency configuration for a function's version.
         * <p>
         * Default: No provisioned concurrency
         * <p>
         * @return {@code this}
         * @param provisionedConcurrentExecutions Specifies a provisioned concurrency configuration for a function's version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder provisionedConcurrentExecutions(final java.lang.Number provisionedConcurrentExecutions) {
            this.props.provisionedConcurrentExecutions(provisionedConcurrentExecutions);
            return this;
        }

        /**
         * (experimental) Whether to retain old versions of this function when a new version is created.
         * <p>
         * Default: RemovalPolicy.DESTROY
         * <p>
         * @return {@code this}
         * @param removalPolicy Whether to retain old versions of this function when a new version is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * (experimental) Function to get the value of.
         * <p>
         * @return {@code this}
         * @param lambda Function to get the value of. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lambda(final software.amazon.awscdk.services.lambda.IFunction lambda) {
            this.props.lambda(lambda);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.Version}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.lambda.Version build() {
            return new software.amazon.awscdk.services.lambda.Version(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
