package software.amazon.awscdk.services.lambda.eventsources;

/**
 * (experimental) Use a MSK cluster as a streaming source for AWS Lambda.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:32.193Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_event_sources.ManagedKafkaEventSource")
public class ManagedKafkaEventSource extends software.amazon.awscdk.services.lambda.eventsources.StreamEventSource {

    protected ManagedKafkaEventSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ManagedKafkaEventSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ManagedKafkaEventSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Called by `lambda.addEventSource` to allow the event source to bind to this function.
     * <p>
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction target) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSourceProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSourceProps.Builder();
        }

        /**
         * (experimental) Where to begin consuming the stream.
         * <p>
         * @return {@code this}
         * @param startingPosition Where to begin consuming the stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder startingPosition(final software.amazon.awscdk.services.lambda.StartingPosition startingPosition) {
            this.props.startingPosition(startingPosition);
            return this;
        }

        /**
         * (experimental) The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         * <p>
         * Your function receives an
         * event with all the retrieved records.
         * <p>
         * Valid Range:
         * <p>
         * <ul>
         * <li>Minimum value of 1</li>
         * <li>Maximum value of:
         * <p>
         * <ul>
         * <li>1000 for {&#64;link DynamoEventSource}</li>
         * <li>10000 for {&#64;link KinesisEventSource}</li>
         * </ul></li>
         * </ul>
         * <p>
         * Default: 100
         * <p>
         * @return {@code this}
         * @param batchSize The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder batchSize(final java.lang.Number batchSize) {
            this.props.batchSize(batchSize);
            return this;
        }

        /**
         * (experimental) If the function returns an error, split the batch in two and retry.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param bisectBatchOnError If the function returns an error, split the batch in two and retry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bisectBatchOnError(final java.lang.Boolean bisectBatchOnError) {
            this.props.bisectBatchOnError(bisectBatchOnError);
            return this;
        }

        /**
         * (experimental) If the stream event source mapping should be enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled If the stream event source mapping should be enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * (experimental) The maximum amount of time to gather records before invoking the function.
         * <p>
         * Maximum of Duration.minutes(5)
         * <p>
         * Default: Duration.seconds(0)
         * <p>
         * @return {@code this}
         * @param maxBatchingWindow The maximum amount of time to gather records before invoking the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxBatchingWindow(final software.amazon.awscdk.Duration maxBatchingWindow) {
            this.props.maxBatchingWindow(maxBatchingWindow);
            return this;
        }

        /**
         * (experimental) The maximum age of a record that Lambda sends to a function for processing.
         * <p>
         * Valid Range:
         * <p>
         * <ul>
         * <li>Minimum value of 60 seconds</li>
         * <li>Maximum value of 7 days</li>
         * </ul>
         * <p>
         * Default: - the retention period configured on the stream
         * <p>
         * @return {@code this}
         * @param maxRecordAge The maximum age of a record that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxRecordAge(final software.amazon.awscdk.Duration maxRecordAge) {
            this.props.maxRecordAge(maxRecordAge);
            return this;
        }

        /**
         * (experimental) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         * <p>
         * Default: discarded records are ignored
         * <p>
         * @return {@code this}
         * @param onFailure An Amazon SQS queue or Amazon SNS topic destination for discarded records. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder onFailure(final software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure) {
            this.props.onFailure(onFailure);
            return this;
        }

        /**
         * (experimental) The number of batches to process from each shard concurrently.
         * <p>
         * Valid Range:
         * <p>
         * <ul>
         * <li>Minimum value of 1</li>
         * <li>Maximum value of 10</li>
         * </ul>
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param parallelizationFactor The number of batches to process from each shard concurrently. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parallelizationFactor(final java.lang.Number parallelizationFactor) {
            this.props.parallelizationFactor(parallelizationFactor);
            return this;
        }

        /**
         * (experimental) Allow functions to return partially successful responses for a batch of records.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting
         * @param reportBatchItemFailures Allow functions to return partially successful responses for a batch of records. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder reportBatchItemFailures(final java.lang.Boolean reportBatchItemFailures) {
            this.props.reportBatchItemFailures(reportBatchItemFailures);
            return this;
        }

        /**
         * (experimental) Maximum number of retry attempts Valid Range: * Minimum value of 0 * Maximum value of 10000.
         * <p>
         * Default: - retry until the record expires
         * <p>
         * @return {@code this}
         * @param retryAttempts Maximum number of retry attempts Valid Range: * Minimum value of 0 * Maximum value of 10000. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * (experimental) The size of the tumbling windows to group records sent to DynamoDB or Kinesis Valid Range: 0 - 15 minutes.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param tumblingWindow The size of the tumbling windows to group records sent to DynamoDB or Kinesis Valid Range: 0 - 15 minutes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tumblingWindow(final software.amazon.awscdk.Duration tumblingWindow) {
            this.props.tumblingWindow(tumblingWindow);
            return this;
        }

        /**
         * (experimental) The Kafka topic to subscribe to.
         * <p>
         * @return {@code this}
         * @param topic The Kafka topic to subscribe to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder topic(final java.lang.String topic) {
            this.props.topic(topic);
            return this;
        }

        /**
         * (experimental) The secret with the Kafka credentials, see https://docs.aws.amazon.com/msk/latest/developerguide/msk-password.html for details This field is required if your Kafka brokers are accessed over the Internet.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param secret The secret with the Kafka credentials, see https://docs.aws.amazon.com/msk/latest/developerguide/msk-password.html for details This field is required if your Kafka brokers are accessed over the Internet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder secret(final software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.props.secret(secret);
            return this;
        }

        /**
         * (experimental) An MSK cluster construct.
         * <p>
         * @return {@code this}
         * @param clusterArn An MSK cluster construct. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterArn(final java.lang.String clusterArn) {
            this.props.clusterArn(clusterArn);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource build() {
            return new software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource(
                this.props.build()
            );
        }
    }
}
