package software.amazon.awscdk.services.rds;

/**
 * (experimental) Properties that describe an existing cluster instance.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:32.468Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseClusterAttributes")
@software.amazon.jsii.Jsii.Proxy(DatabaseClusterAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DatabaseClusterAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Identifier for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier();

    /**
     * (experimental) Cluster endpoint address.
     * <p>
     * Default: - no endpoint address
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterEndpointAddress() {
        return null;
    }

    /**
     * (experimental) The engine of the existing Cluster.
     * <p>
     * Default: - the imported Cluster's engine is unknown
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.IClusterEngine getEngine() {
        return null;
    }

    /**
     * (experimental) Endpoint addresses of individual instances.
     * <p>
     * Default: - no instance endpoints
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstanceEndpointAddresses() {
        return null;
    }

    /**
     * (experimental) Identifier for the instances.
     * <p>
     * Default: - no instance identifiers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstanceIdentifiers() {
        return null;
    }

    /**
     * (experimental) The database port.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * (experimental) Reader endpoint address.
     * <p>
     * Default: - no reader address
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getReaderEndpointAddress() {
        return null;
    }

    /**
     * (experimental) The security groups of the database cluster.
     * <p>
     * Default: - no security groups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DatabaseClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseClusterAttributes> {
        private java.lang.String clusterIdentifier;
        private java.lang.String clusterEndpointAddress;
        private software.amazon.awscdk.services.rds.IClusterEngine engine;
        private java.util.List<java.lang.String> instanceEndpointAddresses;
        private java.util.List<java.lang.String> instanceIdentifiers;
        private java.lang.Number port;
        private java.lang.String readerEndpointAddress;
        private java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getClusterIdentifier}
         * @param clusterIdentifier Identifier for the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterIdentifier(java.lang.String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getClusterEndpointAddress}
         * @param clusterEndpointAddress Cluster endpoint address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterEndpointAddress(java.lang.String clusterEndpointAddress) {
            this.clusterEndpointAddress = clusterEndpointAddress;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getEngine}
         * @param engine The engine of the existing Cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder engine(software.amazon.awscdk.services.rds.IClusterEngine engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getInstanceEndpointAddresses}
         * @param instanceEndpointAddresses Endpoint addresses of individual instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceEndpointAddresses(java.util.List<java.lang.String> instanceEndpointAddresses) {
            this.instanceEndpointAddresses = instanceEndpointAddresses;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getInstanceIdentifiers}
         * @param instanceIdentifiers Identifier for the instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceIdentifiers(java.util.List<java.lang.String> instanceIdentifiers) {
            this.instanceIdentifiers = instanceIdentifiers;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getPort}
         * @param port The database port.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getReaderEndpointAddress}
         * @param readerEndpointAddress Reader endpoint address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder readerEndpointAddress(java.lang.String readerEndpointAddress) {
            this.readerEndpointAddress = readerEndpointAddress;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getSecurityGroups}
         * @param securityGroups The security groups of the database cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseClusterAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DatabaseClusterAttributes build() {
            return new Jsii$Proxy(clusterIdentifier, clusterEndpointAddress, engine, instanceEndpointAddresses, instanceIdentifiers, port, readerEndpointAddress, securityGroups);
        }
    }

    /**
     * An implementation for {@link DatabaseClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseClusterAttributes {
        private final java.lang.String clusterIdentifier;
        private final java.lang.String clusterEndpointAddress;
        private final software.amazon.awscdk.services.rds.IClusterEngine engine;
        private final java.util.List<java.lang.String> instanceEndpointAddresses;
        private final java.util.List<java.lang.String> instanceIdentifiers;
        private final java.lang.Number port;
        private final java.lang.String readerEndpointAddress;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterIdentifier = software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterEndpointAddress = software.amazon.jsii.Kernel.get(this, "clusterEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class));
            this.instanceEndpointAddresses = software.amazon.jsii.Kernel.get(this, "instanceEndpointAddresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.instanceIdentifiers = software.amazon.jsii.Kernel.get(this, "instanceIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.readerEndpointAddress = software.amazon.jsii.Kernel.get(this, "readerEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.String clusterIdentifier, final java.lang.String clusterEndpointAddress, final software.amazon.awscdk.services.rds.IClusterEngine engine, final java.util.List<java.lang.String> instanceEndpointAddresses, final java.util.List<java.lang.String> instanceIdentifiers, final java.lang.Number port, final java.lang.String readerEndpointAddress, final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterIdentifier = java.util.Objects.requireNonNull(clusterIdentifier, "clusterIdentifier is required");
            this.clusterEndpointAddress = clusterEndpointAddress;
            this.engine = engine;
            this.instanceEndpointAddresses = instanceEndpointAddresses;
            this.instanceIdentifiers = instanceIdentifiers;
            this.port = port;
            this.readerEndpointAddress = readerEndpointAddress;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
        }

        @Override
        public final java.lang.String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final java.lang.String getClusterEndpointAddress() {
            return this.clusterEndpointAddress;
        }

        @Override
        public final software.amazon.awscdk.services.rds.IClusterEngine getEngine() {
            return this.engine;
        }

        @Override
        public final java.util.List<java.lang.String> getInstanceEndpointAddresses() {
            return this.instanceEndpointAddresses;
        }

        @Override
        public final java.util.List<java.lang.String> getInstanceIdentifiers() {
            return this.instanceIdentifiers;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getReaderEndpointAddress() {
            return this.readerEndpointAddress;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterIdentifier", om.valueToTree(this.getClusterIdentifier()));
            if (this.getClusterEndpointAddress() != null) {
                data.set("clusterEndpointAddress", om.valueToTree(this.getClusterEndpointAddress()));
            }
            if (this.getEngine() != null) {
                data.set("engine", om.valueToTree(this.getEngine()));
            }
            if (this.getInstanceEndpointAddresses() != null) {
                data.set("instanceEndpointAddresses", om.valueToTree(this.getInstanceEndpointAddresses()));
            }
            if (this.getInstanceIdentifiers() != null) {
                data.set("instanceIdentifiers", om.valueToTree(this.getInstanceIdentifiers()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getReaderEndpointAddress() != null) {
                data.set("readerEndpointAddress", om.valueToTree(this.getReaderEndpointAddress()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.DatabaseClusterAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseClusterAttributes.Jsii$Proxy that = (DatabaseClusterAttributes.Jsii$Proxy) o;

            if (!clusterIdentifier.equals(that.clusterIdentifier)) return false;
            if (this.clusterEndpointAddress != null ? !this.clusterEndpointAddress.equals(that.clusterEndpointAddress) : that.clusterEndpointAddress != null) return false;
            if (this.engine != null ? !this.engine.equals(that.engine) : that.engine != null) return false;
            if (this.instanceEndpointAddresses != null ? !this.instanceEndpointAddresses.equals(that.instanceEndpointAddresses) : that.instanceEndpointAddresses != null) return false;
            if (this.instanceIdentifiers != null ? !this.instanceIdentifiers.equals(that.instanceIdentifiers) : that.instanceIdentifiers != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.readerEndpointAddress != null ? !this.readerEndpointAddress.equals(that.readerEndpointAddress) : that.readerEndpointAddress != null) return false;
            return this.securityGroups != null ? this.securityGroups.equals(that.securityGroups) : that.securityGroups == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterIdentifier.hashCode();
            result = 31 * result + (this.clusterEndpointAddress != null ? this.clusterEndpointAddress.hashCode() : 0);
            result = 31 * result + (this.engine != null ? this.engine.hashCode() : 0);
            result = 31 * result + (this.instanceEndpointAddresses != null ? this.instanceEndpointAddresses.hashCode() : 0);
            result = 31 * result + (this.instanceIdentifiers != null ? this.instanceIdentifiers.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.readerEndpointAddress != null ? this.readerEndpointAddress.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            return result;
        }
    }
}
