package software.amazon.awscdk.services.rds;

/**
 * (experimental) Construction properties for a DatabaseInstanceReadReplica.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:32.512Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseInstanceReadReplicaProps")
@software.amazon.jsii.Jsii.Proxy(DatabaseInstanceReadReplicaProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DatabaseInstanceReadReplicaProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.rds.DatabaseInstanceNewProps {

    /**
     * (experimental) The name of the compute and memory capacity classes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType getInstanceType();

    /**
     * (experimental) The source database instance.
     * <p>
     * Each DB instance can have a limited number of read replicas. For more
     * information, see https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/USER_ReadRepl.html.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IDatabaseInstance getSourceDatabaseInstance();

    /**
     * (experimental) Indicates whether the DB instance is encrypted.
     * <p>
     * Default: - true if storageEncryptionKey has been provided, false otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getStorageEncrypted() {
        return null;
    }

    /**
     * (experimental) The KMS key that's used to encrypt the DB instance.
     * <p>
     * Default: - default master key if storageEncrypted is true, no key otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getStorageEncryptionKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DatabaseInstanceReadReplicaProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseInstanceReadReplicaProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseInstanceReadReplicaProps> {
        private software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private software.amazon.awscdk.services.rds.IDatabaseInstance sourceDatabaseInstance;
        private java.lang.Boolean storageEncrypted;
        private software.amazon.awscdk.services.kms.IKey storageEncryptionKey;
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private java.lang.Boolean autoMinorVersionUpgrade;
        private java.lang.String availabilityZone;
        private software.amazon.awscdk.Duration backupRetention;
        private java.util.List<java.lang.String> cloudwatchLogsExports;
        private software.amazon.awscdk.services.logs.RetentionDays cloudwatchLogsRetention;
        private software.amazon.awscdk.services.iam.IRole cloudwatchLogsRetentionRole;
        private java.lang.Boolean copyTagsToSnapshot;
        private java.lang.Boolean deleteAutomatedBackups;
        private java.lang.Boolean deletionProtection;
        private java.lang.String domain;
        private software.amazon.awscdk.services.iam.IRole domainRole;
        private java.lang.Boolean enablePerformanceInsights;
        private java.lang.Boolean iamAuthentication;
        private java.lang.String instanceIdentifier;
        private java.lang.Number iops;
        private java.lang.Number maxAllocatedStorage;
        private software.amazon.awscdk.Duration monitoringInterval;
        private software.amazon.awscdk.services.iam.IRole monitoringRole;
        private java.lang.Boolean multiAz;
        private software.amazon.awscdk.services.rds.IOptionGroup optionGroup;
        private software.amazon.awscdk.services.kms.IKey performanceInsightEncryptionKey;
        private software.amazon.awscdk.services.rds.PerformanceInsightRetention performanceInsightRetention;
        private java.lang.Number port;
        private java.lang.String preferredBackupWindow;
        private java.lang.String preferredMaintenanceWindow;
        private software.amazon.awscdk.services.rds.ProcessorFeatures processorFeatures;
        private java.lang.Boolean publiclyAccessible;
        private software.amazon.awscdk.RemovalPolicy removalPolicy;
        private java.util.List<software.amazon.awscdk.services.s3.IBucket> s3ExportBuckets;
        private software.amazon.awscdk.services.iam.IRole s3ExportRole;
        private java.util.List<software.amazon.awscdk.services.s3.IBucket> s3ImportBuckets;
        private software.amazon.awscdk.services.iam.IRole s3ImportRole;
        private java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private software.amazon.awscdk.services.rds.StorageType storageType;
        private software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup;
        private software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getInstanceType}
         * @param instanceType The name of the compute and memory capacity classes. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getSourceDatabaseInstance}
         * @param sourceDatabaseInstance The source database instance. This parameter is required.
         *                               Each DB instance can have a limited number of read replicas. For more
         *                               information, see https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/USER_ReadRepl.html.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sourceDatabaseInstance(software.amazon.awscdk.services.rds.IDatabaseInstance sourceDatabaseInstance) {
            this.sourceDatabaseInstance = sourceDatabaseInstance;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getStorageEncrypted}
         * @param storageEncrypted Indicates whether the DB instance is encrypted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder storageEncrypted(java.lang.Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getStorageEncryptionKey}
         * @param storageEncryptionKey The KMS key that's used to encrypt the DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder storageEncryptionKey(software.amazon.awscdk.services.kms.IKey storageEncryptionKey) {
            this.storageEncryptionKey = storageEncryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getVpc}
         * @param vpc The VPC network where the DB subnet group should be created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getAutoMinorVersionUpgrade}
         * @param autoMinorVersionUpgrade Indicates that minor engine upgrades are applied automatically to the DB instance during the maintenance window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoMinorVersionUpgrade(java.lang.Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getAvailabilityZone}
         * @param availabilityZone The name of the Availability Zone where the DB instance will be located.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getBackupRetention}
         * @param backupRetention The number of days during which automatic DB snapshots are retained.
         *                        Set to zero to disable backups.
         *                        When creating a read replica, you must enable automatic backups on the source
         *                        database instance by setting the backup retention to a value other than zero.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder backupRetention(software.amazon.awscdk.Duration backupRetention) {
            this.backupRetention = backupRetention;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getCloudwatchLogsExports}
         * @param cloudwatchLogsExports The list of log types that need to be enabled for exporting to CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudwatchLogsExports(java.util.List<java.lang.String> cloudwatchLogsExports) {
            this.cloudwatchLogsExports = cloudwatchLogsExports;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getCloudwatchLogsRetention}
         * @param cloudwatchLogsRetention The number of days log events are kept in CloudWatch Logs.
         *                                When updating
         *                                this property, unsetting it doesn't remove the log retention policy. To
         *                                remove the retention policy, set the value to <code>Infinity</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudwatchLogsRetention(software.amazon.awscdk.services.logs.RetentionDays cloudwatchLogsRetention) {
            this.cloudwatchLogsRetention = cloudwatchLogsRetention;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getCloudwatchLogsRetentionRole}
         * @param cloudwatchLogsRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudwatchLogsRetentionRole(software.amazon.awscdk.services.iam.IRole cloudwatchLogsRetentionRole) {
            this.cloudwatchLogsRetentionRole = cloudwatchLogsRetentionRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getCopyTagsToSnapshot}
         * @param copyTagsToSnapshot Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder copyTagsToSnapshot(java.lang.Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getDeleteAutomatedBackups}
         * @param deleteAutomatedBackups Indicates whether automated backups should be deleted or retained when you delete a DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deleteAutomatedBackups(java.lang.Boolean deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getDeletionProtection}
         * @param deletionProtection Indicates whether the DB instance should have deletion protection enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getDomain}
         * @param domain The Active Directory directory ID to create the DB instance in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domain(java.lang.String domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getDomainRole}
         * @param domainRole The IAM role to be used when making API calls to the Directory Service.
         *                   The role needs the AWS-managed policy
         *                   AmazonRDSDirectoryServiceAccess or equivalent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainRole(software.amazon.awscdk.services.iam.IRole domainRole) {
            this.domainRole = domainRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getEnablePerformanceInsights}
         * @param enablePerformanceInsights Whether to enable Performance Insights for the DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enablePerformanceInsights(java.lang.Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getIamAuthentication}
         * @param iamAuthentication Whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder iamAuthentication(java.lang.Boolean iamAuthentication) {
            this.iamAuthentication = iamAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getInstanceIdentifier}
         * @param instanceIdentifier A name for the DB instance.
         *                           If you specify a name, AWS CloudFormation
         *                           converts it to lowercase.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceIdentifier(java.lang.String instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getIops}
         * @param iops The number of I/O operations per second (IOPS) that the database provisions.
         *             The value must be equal to or greater than 1000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder iops(java.lang.Number iops) {
            this.iops = iops;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getMaxAllocatedStorage}
         * @param maxAllocatedStorage Upper limit to which RDS can scale the storage in GiB(Gibibyte).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxAllocatedStorage(java.lang.Number maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getMonitoringInterval}
         * @param monitoringInterval The interval, in seconds, between points when Amazon RDS collects enhanced monitoring metrics for the DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder monitoringInterval(software.amazon.awscdk.Duration monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getMonitoringRole}
         * @param monitoringRole Role that will be used to manage DB instance monitoring.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder monitoringRole(software.amazon.awscdk.services.iam.IRole monitoringRole) {
            this.monitoringRole = monitoringRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getMultiAz}
         * @param multiAz Specifies if the database instance is a multiple Availability Zone deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder multiAz(java.lang.Boolean multiAz) {
            this.multiAz = multiAz;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getOptionGroup}
         * @param optionGroup The option group to associate with the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder optionGroup(software.amazon.awscdk.services.rds.IOptionGroup optionGroup) {
            this.optionGroup = optionGroup;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getPerformanceInsightEncryptionKey}
         * @param performanceInsightEncryptionKey The AWS KMS key for encryption of Performance Insights data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder performanceInsightEncryptionKey(software.amazon.awscdk.services.kms.IKey performanceInsightEncryptionKey) {
            this.performanceInsightEncryptionKey = performanceInsightEncryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getPerformanceInsightRetention}
         * @param performanceInsightRetention The amount of time, in days, to retain Performance Insights data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder performanceInsightRetention(software.amazon.awscdk.services.rds.PerformanceInsightRetention performanceInsightRetention) {
            this.performanceInsightRetention = performanceInsightRetention;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getPort}
         * @param port The port for the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getPreferredBackupWindow}
         * @param preferredBackupWindow The daily time range during which automated backups are performed.
         *                              Constraints:
         *                              <p>
         *                              <ul>
         *                              <li>Must be in the format <code>hh24:mi-hh24:mi</code>.</li>
         *                              <li>Must be in Universal Coordinated Time (UTC).</li>
         *                              <li>Must not conflict with the preferred maintenance window.</li>
         *                              <li>Must be at least 30 minutes.</li>
         *                              </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder preferredBackupWindow(java.lang.String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow The weekly time range (in UTC) during which system maintenance can occur.
         *                                   Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         *                                   Constraint: Minimum 30-minute window
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getProcessorFeatures}
         * @param processorFeatures The number of CPU cores and the number of threads per core.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder processorFeatures(software.amazon.awscdk.services.rds.ProcessorFeatures processorFeatures) {
            this.processorFeatures = processorFeatures;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getPubliclyAccessible}
         * @param publiclyAccessible Indicates whether the DB instance is an internet-facing instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publiclyAccessible(java.lang.Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getRemovalPolicy}
         * @param removalPolicy The CloudFormation policy to apply when the instance is removed from the stack or replaced during an update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getS3ExportBuckets}
         * @param s3ExportBuckets S3 buckets that you want to load data into.
         *                        This feature is only supported by the Microsoft SQL Server and Oracle engines.
         *                        <p>
         *                        This property must not be used if <code>s3ExportRole</code> is used.
         *                        <p>
         *                        For Microsoft SQL Server:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder s3ExportBuckets(java.util.List<? extends software.amazon.awscdk.services.s3.IBucket> s3ExportBuckets) {
            this.s3ExportBuckets = (java.util.List<software.amazon.awscdk.services.s3.IBucket>)s3ExportBuckets;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getS3ExportRole}
         * @param s3ExportRole Role that will be associated with this DB instance to enable S3 export.
         *                     This feature is only supported by the Microsoft SQL Server and Oracle engines.
         *                     <p>
         *                     This property must not be used if <code>s3ExportBuckets</code> is used.
         *                     <p>
         *                     For Microsoft SQL Server:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3ExportRole(software.amazon.awscdk.services.iam.IRole s3ExportRole) {
            this.s3ExportRole = s3ExportRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getS3ImportBuckets}
         * @param s3ImportBuckets S3 buckets that you want to load data from.
         *                        This feature is only supported by the Microsoft SQL Server, Oracle, and PostgreSQL engines.
         *                        <p>
         *                        This property must not be used if <code>s3ImportRole</code> is used.
         *                        <p>
         *                        For Microsoft SQL Server:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder s3ImportBuckets(java.util.List<? extends software.amazon.awscdk.services.s3.IBucket> s3ImportBuckets) {
            this.s3ImportBuckets = (java.util.List<software.amazon.awscdk.services.s3.IBucket>)s3ImportBuckets;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getS3ImportRole}
         * @param s3ImportRole Role that will be associated with this DB instance to enable S3 import.
         *                     This feature is only supported by the Microsoft SQL Server, Oracle, and PostgreSQL engines.
         *                     <p>
         *                     This property must not be used if <code>s3ImportBuckets</code> is used.
         *                     <p>
         *                     For Microsoft SQL Server:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3ImportRole(software.amazon.awscdk.services.iam.IRole s3ImportRole) {
            this.s3ImportRole = s3ImportRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getSecurityGroups}
         * @param securityGroups The security groups to assign to the DB instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getStorageType}
         * @param storageType The storage type.
         *                    Storage types supported are gp2, io1, standard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder storageType(software.amazon.awscdk.services.rds.StorageType storageType) {
            this.storageType = storageType;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getSubnetGroup}
         * @param subnetGroup Existing subnet group for the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetGroup(software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup) {
            this.subnetGroup = subnetGroup;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceReadReplicaProps#getVpcSubnets}
         * @param vpcSubnets The type of subnets to add to the created DB subnet group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseInstanceReadReplicaProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DatabaseInstanceReadReplicaProps build() {
            return new Jsii$Proxy(instanceType, sourceDatabaseInstance, storageEncrypted, storageEncryptionKey, vpc, autoMinorVersionUpgrade, availabilityZone, backupRetention, cloudwatchLogsExports, cloudwatchLogsRetention, cloudwatchLogsRetentionRole, copyTagsToSnapshot, deleteAutomatedBackups, deletionProtection, domain, domainRole, enablePerformanceInsights, iamAuthentication, instanceIdentifier, iops, maxAllocatedStorage, monitoringInterval, monitoringRole, multiAz, optionGroup, performanceInsightEncryptionKey, performanceInsightRetention, port, preferredBackupWindow, preferredMaintenanceWindow, processorFeatures, publiclyAccessible, removalPolicy, s3ExportBuckets, s3ExportRole, s3ImportBuckets, s3ImportRole, securityGroups, storageType, subnetGroup, vpcSubnets);
        }
    }

    /**
     * An implementation for {@link DatabaseInstanceReadReplicaProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseInstanceReadReplicaProps {
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final software.amazon.awscdk.services.rds.IDatabaseInstance sourceDatabaseInstance;
        private final java.lang.Boolean storageEncrypted;
        private final software.amazon.awscdk.services.kms.IKey storageEncryptionKey;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.Boolean autoMinorVersionUpgrade;
        private final java.lang.String availabilityZone;
        private final software.amazon.awscdk.Duration backupRetention;
        private final java.util.List<java.lang.String> cloudwatchLogsExports;
        private final software.amazon.awscdk.services.logs.RetentionDays cloudwatchLogsRetention;
        private final software.amazon.awscdk.services.iam.IRole cloudwatchLogsRetentionRole;
        private final java.lang.Boolean copyTagsToSnapshot;
        private final java.lang.Boolean deleteAutomatedBackups;
        private final java.lang.Boolean deletionProtection;
        private final java.lang.String domain;
        private final software.amazon.awscdk.services.iam.IRole domainRole;
        private final java.lang.Boolean enablePerformanceInsights;
        private final java.lang.Boolean iamAuthentication;
        private final java.lang.String instanceIdentifier;
        private final java.lang.Number iops;
        private final java.lang.Number maxAllocatedStorage;
        private final software.amazon.awscdk.Duration monitoringInterval;
        private final software.amazon.awscdk.services.iam.IRole monitoringRole;
        private final java.lang.Boolean multiAz;
        private final software.amazon.awscdk.services.rds.IOptionGroup optionGroup;
        private final software.amazon.awscdk.services.kms.IKey performanceInsightEncryptionKey;
        private final software.amazon.awscdk.services.rds.PerformanceInsightRetention performanceInsightRetention;
        private final java.lang.Number port;
        private final java.lang.String preferredBackupWindow;
        private final java.lang.String preferredMaintenanceWindow;
        private final software.amazon.awscdk.services.rds.ProcessorFeatures processorFeatures;
        private final java.lang.Boolean publiclyAccessible;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final java.util.List<software.amazon.awscdk.services.s3.IBucket> s3ExportBuckets;
        private final software.amazon.awscdk.services.iam.IRole s3ExportRole;
        private final java.util.List<software.amazon.awscdk.services.s3.IBucket> s3ImportBuckets;
        private final software.amazon.awscdk.services.iam.IRole s3ImportRole;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.rds.StorageType storageType;
        private final software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.sourceDatabaseInstance = software.amazon.jsii.Kernel.get(this, "sourceDatabaseInstance", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IDatabaseInstance.class));
            this.storageEncrypted = software.amazon.jsii.Kernel.get(this, "storageEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.storageEncryptionKey = software.amazon.jsii.Kernel.get(this, "storageEncryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.autoMinorVersionUpgrade = software.amazon.jsii.Kernel.get(this, "autoMinorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.backupRetention = software.amazon.jsii.Kernel.get(this, "backupRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.cloudwatchLogsExports = software.amazon.jsii.Kernel.get(this, "cloudwatchLogsExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cloudwatchLogsRetention = software.amazon.jsii.Kernel.get(this, "cloudwatchLogsRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RetentionDays.class));
            this.cloudwatchLogsRetentionRole = software.amazon.jsii.Kernel.get(this, "cloudwatchLogsRetentionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.copyTagsToSnapshot = software.amazon.jsii.Kernel.get(this, "copyTagsToSnapshot", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.deleteAutomatedBackups = software.amazon.jsii.Kernel.get(this, "deleteAutomatedBackups", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainRole = software.amazon.jsii.Kernel.get(this, "domainRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.enablePerformanceInsights = software.amazon.jsii.Kernel.get(this, "enablePerformanceInsights", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.iamAuthentication = software.amazon.jsii.Kernel.get(this, "iamAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.instanceIdentifier = software.amazon.jsii.Kernel.get(this, "instanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxAllocatedStorage = software.amazon.jsii.Kernel.get(this, "maxAllocatedStorage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.monitoringInterval = software.amazon.jsii.Kernel.get(this, "monitoringInterval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.monitoringRole = software.amazon.jsii.Kernel.get(this, "monitoringRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.multiAz = software.amazon.jsii.Kernel.get(this, "multiAz", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.optionGroup = software.amazon.jsii.Kernel.get(this, "optionGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IOptionGroup.class));
            this.performanceInsightEncryptionKey = software.amazon.jsii.Kernel.get(this, "performanceInsightEncryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.performanceInsightRetention = software.amazon.jsii.Kernel.get(this, "performanceInsightRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PerformanceInsightRetention.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.preferredBackupWindow = software.amazon.jsii.Kernel.get(this, "preferredBackupWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.processorFeatures = software.amazon.jsii.Kernel.get(this, "processorFeatures", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ProcessorFeatures.class));
            this.publiclyAccessible = software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.s3ExportBuckets = software.amazon.jsii.Kernel.get(this, "s3ExportBuckets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class)));
            this.s3ExportRole = software.amazon.jsii.Kernel.get(this, "s3ExportRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.s3ImportBuckets = software.amazon.jsii.Kernel.get(this, "s3ImportBuckets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class)));
            this.s3ImportRole = software.amazon.jsii.Kernel.get(this, "s3ImportRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.storageType = software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.StorageType.class));
            this.subnetGroup = software.amazon.jsii.Kernel.get(this, "subnetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ISubnetGroup.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.ec2.InstanceType instanceType, final software.amazon.awscdk.services.rds.IDatabaseInstance sourceDatabaseInstance, final java.lang.Boolean storageEncrypted, final software.amazon.awscdk.services.kms.IKey storageEncryptionKey, final software.amazon.awscdk.services.ec2.IVpc vpc, final java.lang.Boolean autoMinorVersionUpgrade, final java.lang.String availabilityZone, final software.amazon.awscdk.Duration backupRetention, final java.util.List<java.lang.String> cloudwatchLogsExports, final software.amazon.awscdk.services.logs.RetentionDays cloudwatchLogsRetention, final software.amazon.awscdk.services.iam.IRole cloudwatchLogsRetentionRole, final java.lang.Boolean copyTagsToSnapshot, final java.lang.Boolean deleteAutomatedBackups, final java.lang.Boolean deletionProtection, final java.lang.String domain, final software.amazon.awscdk.services.iam.IRole domainRole, final java.lang.Boolean enablePerformanceInsights, final java.lang.Boolean iamAuthentication, final java.lang.String instanceIdentifier, final java.lang.Number iops, final java.lang.Number maxAllocatedStorage, final software.amazon.awscdk.Duration monitoringInterval, final software.amazon.awscdk.services.iam.IRole monitoringRole, final java.lang.Boolean multiAz, final software.amazon.awscdk.services.rds.IOptionGroup optionGroup, final software.amazon.awscdk.services.kms.IKey performanceInsightEncryptionKey, final software.amazon.awscdk.services.rds.PerformanceInsightRetention performanceInsightRetention, final java.lang.Number port, final java.lang.String preferredBackupWindow, final java.lang.String preferredMaintenanceWindow, final software.amazon.awscdk.services.rds.ProcessorFeatures processorFeatures, final java.lang.Boolean publiclyAccessible, final software.amazon.awscdk.RemovalPolicy removalPolicy, final java.util.List<? extends software.amazon.awscdk.services.s3.IBucket> s3ExportBuckets, final software.amazon.awscdk.services.iam.IRole s3ExportRole, final java.util.List<? extends software.amazon.awscdk.services.s3.IBucket> s3ImportBuckets, final software.amazon.awscdk.services.iam.IRole s3ImportRole, final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups, final software.amazon.awscdk.services.rds.StorageType storageType, final software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup, final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(instanceType, "instanceType is required");
            this.sourceDatabaseInstance = java.util.Objects.requireNonNull(sourceDatabaseInstance, "sourceDatabaseInstance is required");
            this.storageEncrypted = storageEncrypted;
            this.storageEncryptionKey = storageEncryptionKey;
            this.vpc = java.util.Objects.requireNonNull(vpc, "vpc is required");
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            this.availabilityZone = availabilityZone;
            this.backupRetention = backupRetention;
            this.cloudwatchLogsExports = cloudwatchLogsExports;
            this.cloudwatchLogsRetention = cloudwatchLogsRetention;
            this.cloudwatchLogsRetentionRole = cloudwatchLogsRetentionRole;
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            this.deleteAutomatedBackups = deleteAutomatedBackups;
            this.deletionProtection = deletionProtection;
            this.domain = domain;
            this.domainRole = domainRole;
            this.enablePerformanceInsights = enablePerformanceInsights;
            this.iamAuthentication = iamAuthentication;
            this.instanceIdentifier = instanceIdentifier;
            this.iops = iops;
            this.maxAllocatedStorage = maxAllocatedStorage;
            this.monitoringInterval = monitoringInterval;
            this.monitoringRole = monitoringRole;
            this.multiAz = multiAz;
            this.optionGroup = optionGroup;
            this.performanceInsightEncryptionKey = performanceInsightEncryptionKey;
            this.performanceInsightRetention = performanceInsightRetention;
            this.port = port;
            this.preferredBackupWindow = preferredBackupWindow;
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            this.processorFeatures = processorFeatures;
            this.publiclyAccessible = publiclyAccessible;
            this.removalPolicy = removalPolicy;
            this.s3ExportBuckets = (java.util.List<software.amazon.awscdk.services.s3.IBucket>)s3ExportBuckets;
            this.s3ExportRole = s3ExportRole;
            this.s3ImportBuckets = (java.util.List<software.amazon.awscdk.services.s3.IBucket>)s3ImportBuckets;
            this.s3ImportRole = s3ImportRole;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            this.storageType = storageType;
            this.subnetGroup = subnetGroup;
            this.vpcSubnets = vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final software.amazon.awscdk.services.rds.IDatabaseInstance getSourceDatabaseInstance() {
            return this.sourceDatabaseInstance;
        }

        @Override
        public final java.lang.Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getStorageEncryptionKey() {
            return this.storageEncryptionKey;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.lang.Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final software.amazon.awscdk.Duration getBackupRetention() {
            return this.backupRetention;
        }

        @Override
        public final java.util.List<java.lang.String> getCloudwatchLogsExports() {
            return this.cloudwatchLogsExports;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RetentionDays getCloudwatchLogsRetention() {
            return this.cloudwatchLogsRetention;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getCloudwatchLogsRetentionRole() {
            return this.cloudwatchLogsRetentionRole;
        }

        @Override
        public final java.lang.Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        @Override
        public final java.lang.Boolean getDeleteAutomatedBackups() {
            return this.deleteAutomatedBackups;
        }

        @Override
        public final java.lang.Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final java.lang.String getDomain() {
            return this.domain;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getDomainRole() {
            return this.domainRole;
        }

        @Override
        public final java.lang.Boolean getEnablePerformanceInsights() {
            return this.enablePerformanceInsights;
        }

        @Override
        public final java.lang.Boolean getIamAuthentication() {
            return this.iamAuthentication;
        }

        @Override
        public final java.lang.String getInstanceIdentifier() {
            return this.instanceIdentifier;
        }

        @Override
        public final java.lang.Number getIops() {
            return this.iops;
        }

        @Override
        public final java.lang.Number getMaxAllocatedStorage() {
            return this.maxAllocatedStorage;
        }

        @Override
        public final software.amazon.awscdk.Duration getMonitoringInterval() {
            return this.monitoringInterval;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getMonitoringRole() {
            return this.monitoringRole;
        }

        @Override
        public final java.lang.Boolean getMultiAz() {
            return this.multiAz;
        }

        @Override
        public final software.amazon.awscdk.services.rds.IOptionGroup getOptionGroup() {
            return this.optionGroup;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getPerformanceInsightEncryptionKey() {
            return this.performanceInsightEncryptionKey;
        }

        @Override
        public final software.amazon.awscdk.services.rds.PerformanceInsightRetention getPerformanceInsightRetention() {
            return this.performanceInsightRetention;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final software.amazon.awscdk.services.rds.ProcessorFeatures getProcessorFeatures() {
            return this.processorFeatures;
        }

        @Override
        public final java.lang.Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.IBucket> getS3ExportBuckets() {
            return this.s3ExportBuckets;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getS3ExportRole() {
            return this.s3ExportRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.IBucket> getS3ImportBuckets() {
            return this.s3ImportBuckets;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getS3ImportRole() {
            return this.s3ImportRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.rds.StorageType getStorageType() {
            return this.storageType;
        }

        @Override
        public final software.amazon.awscdk.services.rds.ISubnetGroup getSubnetGroup() {
            return this.subnetGroup;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            data.set("sourceDatabaseInstance", om.valueToTree(this.getSourceDatabaseInstance()));
            if (this.getStorageEncrypted() != null) {
                data.set("storageEncrypted", om.valueToTree(this.getStorageEncrypted()));
            }
            if (this.getStorageEncryptionKey() != null) {
                data.set("storageEncryptionKey", om.valueToTree(this.getStorageEncryptionKey()));
            }
            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getAutoMinorVersionUpgrade() != null) {
                data.set("autoMinorVersionUpgrade", om.valueToTree(this.getAutoMinorVersionUpgrade()));
            }
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getBackupRetention() != null) {
                data.set("backupRetention", om.valueToTree(this.getBackupRetention()));
            }
            if (this.getCloudwatchLogsExports() != null) {
                data.set("cloudwatchLogsExports", om.valueToTree(this.getCloudwatchLogsExports()));
            }
            if (this.getCloudwatchLogsRetention() != null) {
                data.set("cloudwatchLogsRetention", om.valueToTree(this.getCloudwatchLogsRetention()));
            }
            if (this.getCloudwatchLogsRetentionRole() != null) {
                data.set("cloudwatchLogsRetentionRole", om.valueToTree(this.getCloudwatchLogsRetentionRole()));
            }
            if (this.getCopyTagsToSnapshot() != null) {
                data.set("copyTagsToSnapshot", om.valueToTree(this.getCopyTagsToSnapshot()));
            }
            if (this.getDeleteAutomatedBackups() != null) {
                data.set("deleteAutomatedBackups", om.valueToTree(this.getDeleteAutomatedBackups()));
            }
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getDomain() != null) {
                data.set("domain", om.valueToTree(this.getDomain()));
            }
            if (this.getDomainRole() != null) {
                data.set("domainRole", om.valueToTree(this.getDomainRole()));
            }
            if (this.getEnablePerformanceInsights() != null) {
                data.set("enablePerformanceInsights", om.valueToTree(this.getEnablePerformanceInsights()));
            }
            if (this.getIamAuthentication() != null) {
                data.set("iamAuthentication", om.valueToTree(this.getIamAuthentication()));
            }
            if (this.getInstanceIdentifier() != null) {
                data.set("instanceIdentifier", om.valueToTree(this.getInstanceIdentifier()));
            }
            if (this.getIops() != null) {
                data.set("iops", om.valueToTree(this.getIops()));
            }
            if (this.getMaxAllocatedStorage() != null) {
                data.set("maxAllocatedStorage", om.valueToTree(this.getMaxAllocatedStorage()));
            }
            if (this.getMonitoringInterval() != null) {
                data.set("monitoringInterval", om.valueToTree(this.getMonitoringInterval()));
            }
            if (this.getMonitoringRole() != null) {
                data.set("monitoringRole", om.valueToTree(this.getMonitoringRole()));
            }
            if (this.getMultiAz() != null) {
                data.set("multiAz", om.valueToTree(this.getMultiAz()));
            }
            if (this.getOptionGroup() != null) {
                data.set("optionGroup", om.valueToTree(this.getOptionGroup()));
            }
            if (this.getPerformanceInsightEncryptionKey() != null) {
                data.set("performanceInsightEncryptionKey", om.valueToTree(this.getPerformanceInsightEncryptionKey()));
            }
            if (this.getPerformanceInsightRetention() != null) {
                data.set("performanceInsightRetention", om.valueToTree(this.getPerformanceInsightRetention()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getPreferredBackupWindow() != null) {
                data.set("preferredBackupWindow", om.valueToTree(this.getPreferredBackupWindow()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getProcessorFeatures() != null) {
                data.set("processorFeatures", om.valueToTree(this.getProcessorFeatures()));
            }
            if (this.getPubliclyAccessible() != null) {
                data.set("publiclyAccessible", om.valueToTree(this.getPubliclyAccessible()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getS3ExportBuckets() != null) {
                data.set("s3ExportBuckets", om.valueToTree(this.getS3ExportBuckets()));
            }
            if (this.getS3ExportRole() != null) {
                data.set("s3ExportRole", om.valueToTree(this.getS3ExportRole()));
            }
            if (this.getS3ImportBuckets() != null) {
                data.set("s3ImportBuckets", om.valueToTree(this.getS3ImportBuckets()));
            }
            if (this.getS3ImportRole() != null) {
                data.set("s3ImportRole", om.valueToTree(this.getS3ImportRole()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getStorageType() != null) {
                data.set("storageType", om.valueToTree(this.getStorageType()));
            }
            if (this.getSubnetGroup() != null) {
                data.set("subnetGroup", om.valueToTree(this.getSubnetGroup()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.DatabaseInstanceReadReplicaProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseInstanceReadReplicaProps.Jsii$Proxy that = (DatabaseInstanceReadReplicaProps.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (!sourceDatabaseInstance.equals(that.sourceDatabaseInstance)) return false;
            if (this.storageEncrypted != null ? !this.storageEncrypted.equals(that.storageEncrypted) : that.storageEncrypted != null) return false;
            if (this.storageEncryptionKey != null ? !this.storageEncryptionKey.equals(that.storageEncryptionKey) : that.storageEncryptionKey != null) return false;
            if (!vpc.equals(that.vpc)) return false;
            if (this.autoMinorVersionUpgrade != null ? !this.autoMinorVersionUpgrade.equals(that.autoMinorVersionUpgrade) : that.autoMinorVersionUpgrade != null) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.backupRetention != null ? !this.backupRetention.equals(that.backupRetention) : that.backupRetention != null) return false;
            if (this.cloudwatchLogsExports != null ? !this.cloudwatchLogsExports.equals(that.cloudwatchLogsExports) : that.cloudwatchLogsExports != null) return false;
            if (this.cloudwatchLogsRetention != null ? !this.cloudwatchLogsRetention.equals(that.cloudwatchLogsRetention) : that.cloudwatchLogsRetention != null) return false;
            if (this.cloudwatchLogsRetentionRole != null ? !this.cloudwatchLogsRetentionRole.equals(that.cloudwatchLogsRetentionRole) : that.cloudwatchLogsRetentionRole != null) return false;
            if (this.copyTagsToSnapshot != null ? !this.copyTagsToSnapshot.equals(that.copyTagsToSnapshot) : that.copyTagsToSnapshot != null) return false;
            if (this.deleteAutomatedBackups != null ? !this.deleteAutomatedBackups.equals(that.deleteAutomatedBackups) : that.deleteAutomatedBackups != null) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) return false;
            if (this.domainRole != null ? !this.domainRole.equals(that.domainRole) : that.domainRole != null) return false;
            if (this.enablePerformanceInsights != null ? !this.enablePerformanceInsights.equals(that.enablePerformanceInsights) : that.enablePerformanceInsights != null) return false;
            if (this.iamAuthentication != null ? !this.iamAuthentication.equals(that.iamAuthentication) : that.iamAuthentication != null) return false;
            if (this.instanceIdentifier != null ? !this.instanceIdentifier.equals(that.instanceIdentifier) : that.instanceIdentifier != null) return false;
            if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
            if (this.maxAllocatedStorage != null ? !this.maxAllocatedStorage.equals(that.maxAllocatedStorage) : that.maxAllocatedStorage != null) return false;
            if (this.monitoringInterval != null ? !this.monitoringInterval.equals(that.monitoringInterval) : that.monitoringInterval != null) return false;
            if (this.monitoringRole != null ? !this.monitoringRole.equals(that.monitoringRole) : that.monitoringRole != null) return false;
            if (this.multiAz != null ? !this.multiAz.equals(that.multiAz) : that.multiAz != null) return false;
            if (this.optionGroup != null ? !this.optionGroup.equals(that.optionGroup) : that.optionGroup != null) return false;
            if (this.performanceInsightEncryptionKey != null ? !this.performanceInsightEncryptionKey.equals(that.performanceInsightEncryptionKey) : that.performanceInsightEncryptionKey != null) return false;
            if (this.performanceInsightRetention != null ? !this.performanceInsightRetention.equals(that.performanceInsightRetention) : that.performanceInsightRetention != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.preferredBackupWindow != null ? !this.preferredBackupWindow.equals(that.preferredBackupWindow) : that.preferredBackupWindow != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            if (this.processorFeatures != null ? !this.processorFeatures.equals(that.processorFeatures) : that.processorFeatures != null) return false;
            if (this.publiclyAccessible != null ? !this.publiclyAccessible.equals(that.publiclyAccessible) : that.publiclyAccessible != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.s3ExportBuckets != null ? !this.s3ExportBuckets.equals(that.s3ExportBuckets) : that.s3ExportBuckets != null) return false;
            if (this.s3ExportRole != null ? !this.s3ExportRole.equals(that.s3ExportRole) : that.s3ExportRole != null) return false;
            if (this.s3ImportBuckets != null ? !this.s3ImportBuckets.equals(that.s3ImportBuckets) : that.s3ImportBuckets != null) return false;
            if (this.s3ImportRole != null ? !this.s3ImportRole.equals(that.s3ImportRole) : that.s3ImportRole != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.storageType != null ? !this.storageType.equals(that.storageType) : that.storageType != null) return false;
            if (this.subnetGroup != null ? !this.subnetGroup.equals(that.subnetGroup) : that.subnetGroup != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.sourceDatabaseInstance.hashCode());
            result = 31 * result + (this.storageEncrypted != null ? this.storageEncrypted.hashCode() : 0);
            result = 31 * result + (this.storageEncryptionKey != null ? this.storageEncryptionKey.hashCode() : 0);
            result = 31 * result + (this.vpc.hashCode());
            result = 31 * result + (this.autoMinorVersionUpgrade != null ? this.autoMinorVersionUpgrade.hashCode() : 0);
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.backupRetention != null ? this.backupRetention.hashCode() : 0);
            result = 31 * result + (this.cloudwatchLogsExports != null ? this.cloudwatchLogsExports.hashCode() : 0);
            result = 31 * result + (this.cloudwatchLogsRetention != null ? this.cloudwatchLogsRetention.hashCode() : 0);
            result = 31 * result + (this.cloudwatchLogsRetentionRole != null ? this.cloudwatchLogsRetentionRole.hashCode() : 0);
            result = 31 * result + (this.copyTagsToSnapshot != null ? this.copyTagsToSnapshot.hashCode() : 0);
            result = 31 * result + (this.deleteAutomatedBackups != null ? this.deleteAutomatedBackups.hashCode() : 0);
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
            result = 31 * result + (this.domainRole != null ? this.domainRole.hashCode() : 0);
            result = 31 * result + (this.enablePerformanceInsights != null ? this.enablePerformanceInsights.hashCode() : 0);
            result = 31 * result + (this.iamAuthentication != null ? this.iamAuthentication.hashCode() : 0);
            result = 31 * result + (this.instanceIdentifier != null ? this.instanceIdentifier.hashCode() : 0);
            result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
            result = 31 * result + (this.maxAllocatedStorage != null ? this.maxAllocatedStorage.hashCode() : 0);
            result = 31 * result + (this.monitoringInterval != null ? this.monitoringInterval.hashCode() : 0);
            result = 31 * result + (this.monitoringRole != null ? this.monitoringRole.hashCode() : 0);
            result = 31 * result + (this.multiAz != null ? this.multiAz.hashCode() : 0);
            result = 31 * result + (this.optionGroup != null ? this.optionGroup.hashCode() : 0);
            result = 31 * result + (this.performanceInsightEncryptionKey != null ? this.performanceInsightEncryptionKey.hashCode() : 0);
            result = 31 * result + (this.performanceInsightRetention != null ? this.performanceInsightRetention.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.preferredBackupWindow != null ? this.preferredBackupWindow.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.processorFeatures != null ? this.processorFeatures.hashCode() : 0);
            result = 31 * result + (this.publiclyAccessible != null ? this.publiclyAccessible.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.s3ExportBuckets != null ? this.s3ExportBuckets.hashCode() : 0);
            result = 31 * result + (this.s3ExportRole != null ? this.s3ExportRole.hashCode() : 0);
            result = 31 * result + (this.s3ImportBuckets != null ? this.s3ImportBuckets.hashCode() : 0);
            result = 31 * result + (this.s3ImportRole != null ? this.s3ImportRole.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.storageType != null ? this.storageType.hashCode() : 0);
            result = 31 * result + (this.subnetGroup != null ? this.subnetGroup.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
