package software.amazon.awscdk.services.rds;

/**
 * (experimental) A version of an engine - for either a cluster, or instance.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:32.518Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.EngineVersion")
@software.amazon.jsii.Jsii.Proxy(EngineVersion.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface EngineVersion extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The major version of the engine, for example, "5.6". Used in specifying the ParameterGroup family and OptionGroup version for this engine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getMajorVersion();

    /**
     * (experimental) The full version string of the engine, for example, "5.6.mysql_aurora.1.22.1". It can be undefined, which means RDS should use whatever version it deems appropriate for the given engine type.
     * <p>
     * Default: - no version specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getFullVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EngineVersion}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EngineVersion}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<EngineVersion> {
        private java.lang.String majorVersion;
        private java.lang.String fullVersion;

        /**
         * Sets the value of {@link EngineVersion#getMajorVersion}
         * @param majorVersion The major version of the engine, for example, "5.6". Used in specifying the ParameterGroup family and OptionGroup version for this engine. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder majorVersion(java.lang.String majorVersion) {
            this.majorVersion = majorVersion;
            return this;
        }

        /**
         * Sets the value of {@link EngineVersion#getFullVersion}
         * @param fullVersion The full version string of the engine, for example, "5.6.mysql_aurora.1.22.1". It can be undefined, which means RDS should use whatever version it deems appropriate for the given engine type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder fullVersion(java.lang.String fullVersion) {
            this.fullVersion = fullVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EngineVersion}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public EngineVersion build() {
            return new Jsii$Proxy(majorVersion, fullVersion);
        }
    }

    /**
     * An implementation for {@link EngineVersion}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EngineVersion {
        private final java.lang.String majorVersion;
        private final java.lang.String fullVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.majorVersion = software.amazon.jsii.Kernel.get(this, "majorVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fullVersion = software.amazon.jsii.Kernel.get(this, "fullVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String majorVersion, final java.lang.String fullVersion) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.majorVersion = java.util.Objects.requireNonNull(majorVersion, "majorVersion is required");
            this.fullVersion = fullVersion;
        }

        @Override
        public final java.lang.String getMajorVersion() {
            return this.majorVersion;
        }

        @Override
        public final java.lang.String getFullVersion() {
            return this.fullVersion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("majorVersion", om.valueToTree(this.getMajorVersion()));
            if (this.getFullVersion() != null) {
                data.set("fullVersion", om.valueToTree(this.getFullVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.EngineVersion"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EngineVersion.Jsii$Proxy that = (EngineVersion.Jsii$Proxy) o;

            if (!majorVersion.equals(that.majorVersion)) return false;
            return this.fullVersion != null ? this.fullVersion.equals(that.fullVersion) : that.fullVersion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.majorVersion.hashCode();
            result = 31 * result + (this.fullVersion != null ? this.fullVersion.hashCode() : 0);
            return result;
        }
    }
}
