/**
 * <h1>Route53 Alias Record Targets for the CDK Route53 Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This library contains Route53 Alias Record targets for:
 * <p>
 * <ul>
 * <li>API Gateway custom domains
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(route53.RecordTarget.fromAlias(new ApiGateway(restApi)))
 *         .build();
 * </pre></blockquote></li>
 * <li>API Gateway V2 custom domains
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(route53.RecordTarget.fromAlias(new ApiGatewayv2DomainProperties(domainName.getRegionalDomainName(), domainName.getRegionalHostedZoneId())))
 *         .build();
 * </pre></blockquote></li>
 * <li>CloudFront distributions
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(route53.RecordTarget.fromAlias(new CloudFrontTarget(distribution)))
 *         .build();
 * </pre></blockquote></li>
 * <li>ELBv2 load balancers
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(route53.RecordTarget.fromAlias(new LoadBalancerTarget(elbv2)))
 *         .build();
 * </pre></blockquote></li>
 * <li>Classic load balancers
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(route53.RecordTarget.fromAlias(new ClassicLoadBalancerTarget(elb)))
 *         .build();
 * </pre></blockquote></li>
 * </ul>
 * <p>
 * <strong>Important:</strong> Based on <a href="https://aws.amazon.com/de/premiumsupport/knowledge-center/alias-resource-record-set-route53-cli/">AWS documentation</a>, all alias record in Route 53 that points to a Elastic Load Balancer will always include <em>dualstack</em> for the DNSName to resolve IPv4/IPv6 addresses (without <em>dualstack</em> IPv6 will not resolve).
 * <p>
 * For example, if the Amazon-provided DNS for the load balancer is <code>ALB-xxxxxxx.us-west-2.elb.amazonaws.com</code>, CDK will create alias target in Route 53 will be <code>dualstack.ALB-xxxxxxx.us-west-2.elb.amazonaws.com</code>.
 * <p>
 * <ul>
 * <li>GlobalAccelerator
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * ARecord.Builder.create(stack, "AliasRecord")
 *         .zone(zone)
 *         .target(route53.RecordTarget.fromAlias(new GlobalAcceleratorTarget(accelerator)))
 *         .build();
 * </pre></blockquote></li>
 * </ul>
 * <p>
 * <strong>Important:</strong> If you use GlobalAcceleratorDomainTarget, passing a string rather than an instance of IAccelerator, ensure that the string is a valid domain name of an existing Global Accelerator instance.
 * See <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/dns-addressing-custom-domains.dns-addressing.html">the documentation on DNS addressing</a> with Global Accelerator for more info.
 * <p>
 * <ul>
 * <li>InterfaceVpcEndpoints</li>
 * </ul>
 * <p>
 * <strong>Important:</strong> Based on the CFN docs for VPCEndpoints - <a href="attrDnsEntries">see here</a> - the attributes returned for DnsEntries in CloudFormation is a combination of the hosted zone ID and the DNS name. The entries are ordered as follows: regional public DNS, zonal public DNS, private DNS, and wildcard DNS. This order is not enforced for AWS Marketplace services, and therefore this CDK construct is ONLY guaranteed to work with non-marketplace services.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * ARecord.Builder.create(stack, "AliasRecord")
 *         .zone(zone)
 *         .target(route53.RecordTarget.fromAlias(new InterfaceVpcEndpointTarget(interfaceVpcEndpoint)))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li>S3 Bucket Website:</li>
 * </ul>
 * <p>
 * <strong>Important:</strong> The Bucket name must strictly match the full DNS name.
 * See <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/getting-started.html">the Developer Guide</a> for more info.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object [recordName, domainName] = asList("www", "example.com");
 * 
 * Object bucketWebsite = Bucket.Builder.create(this, "BucketWebsite")
 *         .bucketName([recordName, domainName].join("."))// www.example.com
 *         .publicReadAccess(true)
 *         .websiteIndexDocument("index.html")
 *         .build();
 * 
 * Object zone = HostedZone.fromLookup(this, "Zone", Map.of("domainName", domainName));// example.com
 * 
 * // example.com
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .recordName(recordName)// www
 *         .target(route53.RecordTarget.fromAlias(new BucketWebsiteTarget(bucket)))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li>User pool domain
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(route53.RecordTarget.fromAlias(new UserPoolDomainTarget(domain)))
 *         .build();
 * </pre></blockquote></li>
 * <li>Route 53 record
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(route53.RecordTarget.fromAlias(new Route53RecordTarget(record)))
 *         .build();
 * </pre></blockquote></li>
 * </ul>
 * <p>
 * See the documentation of <code>&#64;aws-cdk/aws-route53</code> for more information.
 */
package software.amazon.awscdk.services.route53.targets;
