package software.amazon.awscdk.services.s3.deployment;

/**
 * (experimental) Properties for `BucketDeployment`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:49.545Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3_deployment.BucketDeploymentProps")
@software.amazon.jsii.Jsii.Proxy(BucketDeploymentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BucketDeploymentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The S3 bucket to sync the contents of the zip file to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getDestinationBucket();

    /**
     * (experimental) The sources from which to deploy the contents of this bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.s3.deployment.ISource> getSources();

    /**
     * (experimental) System-defined x-amz-acl metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketAccessControl getAccessControl() {
        return null;
    }

    /**
     * (experimental) System-defined cache-control metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.deployment.CacheControl> getCacheControl() {
        return null;
    }

    /**
     * (experimental) System-defined cache-disposition metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentDisposition() {
        return null;
    }

    /**
     * (experimental) System-defined content-encoding metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentEncoding() {
        return null;
    }

    /**
     * (experimental) System-defined content-language metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentLanguage() {
        return null;
    }

    /**
     * (experimental) System-defined content-type metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentType() {
        return null;
    }

    /**
     * (experimental) Key prefix in the destination bucket.
     * <p>
     * Default: "/" (unzip to root of the destination bucket)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationKeyPrefix() {
        return null;
    }

    /**
     * (experimental) The CloudFront distribution using the destination bucket as an origin.
     * <p>
     * Files in the distribution's edge caches will be invalidated after
     * files are uploaded to the destination bucket.
     * <p>
     * Default: - No invalidation occurs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.IDistribution getDistribution() {
        return null;
    }

    /**
     * (experimental) The file paths to invalidate in the CloudFront distribution.
     * <p>
     * Default: - All files under the destination bucket key prefix will be invalidated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDistributionPaths() {
        return null;
    }

    /**
     * (experimental) If this is set, matching files or objects will be excluded from the deployment's sync command.
     * <p>
     * This can be used to exclude a file from being pruned in the destination bucket.
     * <p>
     * If you want to just exclude files from the deployment package (which excludes these files
     * evaluated when invalidating the asset), you should leverage the <code>exclude</code> property of
     * <code>AssetOptions</code> when defining your source.
     * <p>
     * Default: - No exclude filters are used
     * <p>
     * @see https://docs.aws.amazon.com/cli/latest/reference/s3/index.html#use-of-exclude-and-include-filters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclude() {
        return null;
    }

    /**
     * (experimental) System-defined expires metadata to be set on all objects in the deployment.
     * <p>
     * Default: - The objects in the distribution will not expire.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Expiration getExpires() {
        return null;
    }

    /**
     * (experimental) If this is set, matching files or objects will be included with the deployment's sync command.
     * <p>
     * Since all files from the deployment package are included by default, this property
     * is usually leveraged alongside an <code>exclude</code> filter.
     * <p>
     * Default: - No include filters are used and all files are included with the sync command
     * <p>
     * @see https://docs.aws.amazon.com/cli/latest/reference/s3/index.html#use-of-exclude-and-include-filters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclude() {
        return null;
    }

    /**
     * (experimental) The amount of memory (in MiB) to allocate to the AWS Lambda function which replicates the files from the CDK bucket to the destination bucket.
     * <p>
     * If you are deploying large files, you will need to increase this number
     * accordingly.
     * <p>
     * Default: 128
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryLimit() {
        return null;
    }

    /**
     * (experimental) User-defined object metadata to be set on all objects in the deployment.
     * <p>
     * Default: - No user metadata is set
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#UserMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.deployment.UserDefinedObjectMetadata getMetadata() {
        return null;
    }

    /**
     * (experimental) If this is set to false, files in the destination bucket that do not exist in the asset, will NOT be deleted during deployment (create/update).
     * <p>
     * Default: true
     * <p>
     * @see https://docs.aws.amazon.com/cli/latest/reference/s3/sync.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrune() {
        return null;
    }

    /**
     * (experimental) If this is set to "false", the destination files will be deleted when the resource is deleted or the destination is updated.
     * <p>
     * NOTICE: Configuring this to "false" might have operational implications. Please
     * visit to the package documentation referred below to make sure you fully understand those implications.
     * <p>
     * Default: true - when resource is deleted/updated, files are retained
     * <p>
     * @see https://github.com/aws/aws-cdk/tree/master/packages/%40aws-cdk/aws-s3-deployment#retain-on-delete
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRetainOnDelete() {
        return null;
    }

    /**
     * (experimental) Execution role associated with this function.
     * <p>
     * Default: - A role is automatically created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * (experimental) System-defined x-amz-server-side-encryption metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Server side encryption is not used.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.deployment.ServerSideEncryption getServerSideEncryption() {
        return null;
    }

    /**
     * (experimental) System-defined x-amz-server-side-encryption-aws-kms-key-id metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getServerSideEncryptionAwsKmsKeyId() {
        return null;
    }

    /**
     * (experimental) System-defined x-amz-server-side-encryption-customer-algorithm metadata to be set on all objects in the deployment.
     * <p>
     * Warning: This is not a useful parameter until this bug is fixed: https://github.com/aws/aws-cdk/issues/6080
     * <p>
     * Default: - Not set.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html#sse-c-how-to-programmatically-intro
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getServerSideEncryptionCustomerAlgorithm() {
        return null;
    }

    /**
     * (experimental) System-defined x-amz-storage-class metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Default storage-class for the bucket is used.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.deployment.StorageClass getStorageClass() {
        return null;
    }

    /**
     * (experimental) The VPC network to place the deployment lambda handler in.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * (experimental) Where in the VPC to place the deployment lambda handler.
     * <p>
     * Only used if 'vpc' is supplied.
     * <p>
     * Default: - the Vpc default strategy if not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * (experimental) System-defined x-amz-website-redirect-location metadata to be set on all objects in the deployment.
     * <p>
     * Default: - No website redirection.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getWebsiteRedirectLocation() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BucketDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BucketDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BucketDeploymentProps> {
        private software.amazon.awscdk.services.s3.IBucket destinationBucket;
        private java.util.List<software.amazon.awscdk.services.s3.deployment.ISource> sources;
        private software.amazon.awscdk.services.s3.BucketAccessControl accessControl;
        private java.util.List<software.amazon.awscdk.services.s3.deployment.CacheControl> cacheControl;
        private java.lang.String contentDisposition;
        private java.lang.String contentEncoding;
        private java.lang.String contentLanguage;
        private java.lang.String contentType;
        private java.lang.String destinationKeyPrefix;
        private software.amazon.awscdk.services.cloudfront.IDistribution distribution;
        private java.util.List<java.lang.String> distributionPaths;
        private java.util.List<java.lang.String> exclude;
        private software.amazon.awscdk.Expiration expires;
        private java.util.List<java.lang.String> include;
        private java.lang.Number memoryLimit;
        private software.amazon.awscdk.services.s3.deployment.UserDefinedObjectMetadata metadata;
        private java.lang.Boolean prune;
        private java.lang.Boolean retainOnDelete;
        private software.amazon.awscdk.services.iam.IRole role;
        private software.amazon.awscdk.services.s3.deployment.ServerSideEncryption serverSideEncryption;
        private java.lang.String serverSideEncryptionAwsKmsKeyId;
        private java.lang.String serverSideEncryptionCustomerAlgorithm;
        private software.amazon.awscdk.services.s3.deployment.StorageClass storageClass;
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;
        private java.lang.String websiteRedirectLocation;

        /**
         * Sets the value of {@link BucketDeploymentProps#getDestinationBucket}
         * @param destinationBucket The S3 bucket to sync the contents of the zip file to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder destinationBucket(software.amazon.awscdk.services.s3.IBucket destinationBucket) {
            this.destinationBucket = destinationBucket;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getSources}
         * @param sources The sources from which to deploy the contents of this bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder sources(java.util.List<? extends software.amazon.awscdk.services.s3.deployment.ISource> sources) {
            this.sources = (java.util.List<software.amazon.awscdk.services.s3.deployment.ISource>)sources;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getAccessControl}
         * @param accessControl System-defined x-amz-acl metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accessControl(software.amazon.awscdk.services.s3.BucketAccessControl accessControl) {
            this.accessControl = accessControl;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getCacheControl}
         * @param cacheControl System-defined cache-control metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder cacheControl(java.util.List<? extends software.amazon.awscdk.services.s3.deployment.CacheControl> cacheControl) {
            this.cacheControl = (java.util.List<software.amazon.awscdk.services.s3.deployment.CacheControl>)cacheControl;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getContentDisposition}
         * @param contentDisposition System-defined cache-disposition metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentDisposition(java.lang.String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getContentEncoding}
         * @param contentEncoding System-defined content-encoding metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentEncoding(java.lang.String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getContentLanguage}
         * @param contentLanguage System-defined content-language metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentLanguage(java.lang.String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getContentType}
         * @param contentType System-defined content-type metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentType(java.lang.String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getDestinationKeyPrefix}
         * @param destinationKeyPrefix Key prefix in the destination bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder destinationKeyPrefix(java.lang.String destinationKeyPrefix) {
            this.destinationKeyPrefix = destinationKeyPrefix;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getDistribution}
         * @param distribution The CloudFront distribution using the destination bucket as an origin.
         *                     Files in the distribution's edge caches will be invalidated after
         *                     files are uploaded to the destination bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder distribution(software.amazon.awscdk.services.cloudfront.IDistribution distribution) {
            this.distribution = distribution;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getDistributionPaths}
         * @param distributionPaths The file paths to invalidate in the CloudFront distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder distributionPaths(java.util.List<java.lang.String> distributionPaths) {
            this.distributionPaths = distributionPaths;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getExclude}
         * @param exclude If this is set, matching files or objects will be excluded from the deployment's sync command.
         *                This can be used to exclude a file from being pruned in the destination bucket.
         *                <p>
         *                If you want to just exclude files from the deployment package (which excludes these files
         *                evaluated when invalidating the asset), you should leverage the <code>exclude</code> property of
         *                <code>AssetOptions</code> when defining your source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder exclude(java.util.List<java.lang.String> exclude) {
            this.exclude = exclude;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getExpires}
         * @param expires System-defined expires metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder expires(software.amazon.awscdk.Expiration expires) {
            this.expires = expires;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getInclude}
         * @param include If this is set, matching files or objects will be included with the deployment's sync command.
         *                Since all files from the deployment package are included by default, this property
         *                is usually leveraged alongside an <code>exclude</code> filter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder include(java.util.List<java.lang.String> include) {
            this.include = include;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getMemoryLimit}
         * @param memoryLimit The amount of memory (in MiB) to allocate to the AWS Lambda function which replicates the files from the CDK bucket to the destination bucket.
         *                    If you are deploying large files, you will need to increase this number
         *                    accordingly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder memoryLimit(java.lang.Number memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getMetadata}
         * @param metadata User-defined object metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metadata(software.amazon.awscdk.services.s3.deployment.UserDefinedObjectMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getPrune}
         * @param prune If this is set to false, files in the destination bucket that do not exist in the asset, will NOT be deleted during deployment (create/update).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder prune(java.lang.Boolean prune) {
            this.prune = prune;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getRetainOnDelete}
         * @param retainOnDelete If this is set to "false", the destination files will be deleted when the resource is deleted or the destination is updated.
         *                       NOTICE: Configuring this to "false" might have operational implications. Please
         *                       visit to the package documentation referred below to make sure you fully understand those implications.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retainOnDelete(java.lang.Boolean retainOnDelete) {
            this.retainOnDelete = retainOnDelete;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getRole}
         * @param role Execution role associated with this function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getServerSideEncryption}
         * @param serverSideEncryption System-defined x-amz-server-side-encryption metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serverSideEncryption(software.amazon.awscdk.services.s3.deployment.ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getServerSideEncryptionAwsKmsKeyId}
         * @param serverSideEncryptionAwsKmsKeyId System-defined x-amz-server-side-encryption-aws-kms-key-id metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serverSideEncryptionAwsKmsKeyId(java.lang.String serverSideEncryptionAwsKmsKeyId) {
            this.serverSideEncryptionAwsKmsKeyId = serverSideEncryptionAwsKmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getServerSideEncryptionCustomerAlgorithm}
         * @param serverSideEncryptionCustomerAlgorithm System-defined x-amz-server-side-encryption-customer-algorithm metadata to be set on all objects in the deployment.
         *                                              Warning: This is not a useful parameter until this bug is fixed: https://github.com/aws/aws-cdk/issues/6080
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serverSideEncryptionCustomerAlgorithm(java.lang.String serverSideEncryptionCustomerAlgorithm) {
            this.serverSideEncryptionCustomerAlgorithm = serverSideEncryptionCustomerAlgorithm;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getStorageClass}
         * @param storageClass System-defined x-amz-storage-class metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder storageClass(software.amazon.awscdk.services.s3.deployment.StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getVpc}
         * @param vpc The VPC network to place the deployment lambda handler in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getVpcSubnets}
         * @param vpcSubnets Where in the VPC to place the deployment lambda handler.
         *                   Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getWebsiteRedirectLocation}
         * @param websiteRedirectLocation System-defined x-amz-website-redirect-location metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder websiteRedirectLocation(java.lang.String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketDeploymentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BucketDeploymentProps build() {
            return new Jsii$Proxy(destinationBucket, sources, accessControl, cacheControl, contentDisposition, contentEncoding, contentLanguage, contentType, destinationKeyPrefix, distribution, distributionPaths, exclude, expires, include, memoryLimit, metadata, prune, retainOnDelete, role, serverSideEncryption, serverSideEncryptionAwsKmsKeyId, serverSideEncryptionCustomerAlgorithm, storageClass, vpc, vpcSubnets, websiteRedirectLocation);
        }
    }

    /**
     * An implementation for {@link BucketDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketDeploymentProps {
        private final software.amazon.awscdk.services.s3.IBucket destinationBucket;
        private final java.util.List<software.amazon.awscdk.services.s3.deployment.ISource> sources;
        private final software.amazon.awscdk.services.s3.BucketAccessControl accessControl;
        private final java.util.List<software.amazon.awscdk.services.s3.deployment.CacheControl> cacheControl;
        private final java.lang.String contentDisposition;
        private final java.lang.String contentEncoding;
        private final java.lang.String contentLanguage;
        private final java.lang.String contentType;
        private final java.lang.String destinationKeyPrefix;
        private final software.amazon.awscdk.services.cloudfront.IDistribution distribution;
        private final java.util.List<java.lang.String> distributionPaths;
        private final java.util.List<java.lang.String> exclude;
        private final software.amazon.awscdk.Expiration expires;
        private final java.util.List<java.lang.String> include;
        private final java.lang.Number memoryLimit;
        private final software.amazon.awscdk.services.s3.deployment.UserDefinedObjectMetadata metadata;
        private final java.lang.Boolean prune;
        private final java.lang.Boolean retainOnDelete;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.s3.deployment.ServerSideEncryption serverSideEncryption;
        private final java.lang.String serverSideEncryptionAwsKmsKeyId;
        private final java.lang.String serverSideEncryptionCustomerAlgorithm;
        private final software.amazon.awscdk.services.s3.deployment.StorageClass storageClass;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;
        private final java.lang.String websiteRedirectLocation;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationBucket = software.amazon.jsii.Kernel.get(this, "destinationBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.sources = software.amazon.jsii.Kernel.get(this, "sources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.ISource.class)));
            this.accessControl = software.amazon.jsii.Kernel.get(this, "accessControl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BucketAccessControl.class));
            this.cacheControl = software.amazon.jsii.Kernel.get(this, "cacheControl", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.CacheControl.class)));
            this.contentDisposition = software.amazon.jsii.Kernel.get(this, "contentDisposition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentEncoding = software.amazon.jsii.Kernel.get(this, "contentEncoding", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentLanguage = software.amazon.jsii.Kernel.get(this, "contentLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationKeyPrefix = software.amazon.jsii.Kernel.get(this, "destinationKeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.distribution = software.amazon.jsii.Kernel.get(this, "distribution", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IDistribution.class));
            this.distributionPaths = software.amazon.jsii.Kernel.get(this, "distributionPaths", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.exclude = software.amazon.jsii.Kernel.get(this, "exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.expires = software.amazon.jsii.Kernel.get(this, "expires", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Expiration.class));
            this.include = software.amazon.jsii.Kernel.get(this, "include", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.memoryLimit = software.amazon.jsii.Kernel.get(this, "memoryLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.UserDefinedObjectMetadata.class));
            this.prune = software.amazon.jsii.Kernel.get(this, "prune", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.retainOnDelete = software.amazon.jsii.Kernel.get(this, "retainOnDelete", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.serverSideEncryption = software.amazon.jsii.Kernel.get(this, "serverSideEncryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.ServerSideEncryption.class));
            this.serverSideEncryptionAwsKmsKeyId = software.amazon.jsii.Kernel.get(this, "serverSideEncryptionAwsKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverSideEncryptionCustomerAlgorithm = software.amazon.jsii.Kernel.get(this, "serverSideEncryptionCustomerAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.storageClass = software.amazon.jsii.Kernel.get(this, "storageClass", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.StorageClass.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.websiteRedirectLocation = software.amazon.jsii.Kernel.get(this, "websiteRedirectLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.s3.IBucket destinationBucket, final java.util.List<? extends software.amazon.awscdk.services.s3.deployment.ISource> sources, final software.amazon.awscdk.services.s3.BucketAccessControl accessControl, final java.util.List<? extends software.amazon.awscdk.services.s3.deployment.CacheControl> cacheControl, final java.lang.String contentDisposition, final java.lang.String contentEncoding, final java.lang.String contentLanguage, final java.lang.String contentType, final java.lang.String destinationKeyPrefix, final software.amazon.awscdk.services.cloudfront.IDistribution distribution, final java.util.List<java.lang.String> distributionPaths, final java.util.List<java.lang.String> exclude, final software.amazon.awscdk.Expiration expires, final java.util.List<java.lang.String> include, final java.lang.Number memoryLimit, final software.amazon.awscdk.services.s3.deployment.UserDefinedObjectMetadata metadata, final java.lang.Boolean prune, final java.lang.Boolean retainOnDelete, final software.amazon.awscdk.services.iam.IRole role, final software.amazon.awscdk.services.s3.deployment.ServerSideEncryption serverSideEncryption, final java.lang.String serverSideEncryptionAwsKmsKeyId, final java.lang.String serverSideEncryptionCustomerAlgorithm, final software.amazon.awscdk.services.s3.deployment.StorageClass storageClass, final software.amazon.awscdk.services.ec2.IVpc vpc, final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets, final java.lang.String websiteRedirectLocation) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationBucket = java.util.Objects.requireNonNull(destinationBucket, "destinationBucket is required");
            this.sources = (java.util.List<software.amazon.awscdk.services.s3.deployment.ISource>)java.util.Objects.requireNonNull(sources, "sources is required");
            this.accessControl = accessControl;
            this.cacheControl = (java.util.List<software.amazon.awscdk.services.s3.deployment.CacheControl>)cacheControl;
            this.contentDisposition = contentDisposition;
            this.contentEncoding = contentEncoding;
            this.contentLanguage = contentLanguage;
            this.contentType = contentType;
            this.destinationKeyPrefix = destinationKeyPrefix;
            this.distribution = distribution;
            this.distributionPaths = distributionPaths;
            this.exclude = exclude;
            this.expires = expires;
            this.include = include;
            this.memoryLimit = memoryLimit;
            this.metadata = metadata;
            this.prune = prune;
            this.retainOnDelete = retainOnDelete;
            this.role = role;
            this.serverSideEncryption = serverSideEncryption;
            this.serverSideEncryptionAwsKmsKeyId = serverSideEncryptionAwsKmsKeyId;
            this.serverSideEncryptionCustomerAlgorithm = serverSideEncryptionCustomerAlgorithm;
            this.storageClass = storageClass;
            this.vpc = vpc;
            this.vpcSubnets = vpcSubnets;
            this.websiteRedirectLocation = websiteRedirectLocation;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getDestinationBucket() {
            return this.destinationBucket;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.deployment.ISource> getSources() {
            return this.sources;
        }

        @Override
        public final software.amazon.awscdk.services.s3.BucketAccessControl getAccessControl() {
            return this.accessControl;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.deployment.CacheControl> getCacheControl() {
            return this.cacheControl;
        }

        @Override
        public final java.lang.String getContentDisposition() {
            return this.contentDisposition;
        }

        @Override
        public final java.lang.String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public final java.lang.String getContentLanguage() {
            return this.contentLanguage;
        }

        @Override
        public final java.lang.String getContentType() {
            return this.contentType;
        }

        @Override
        public final java.lang.String getDestinationKeyPrefix() {
            return this.destinationKeyPrefix;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IDistribution getDistribution() {
            return this.distribution;
        }

        @Override
        public final java.util.List<java.lang.String> getDistributionPaths() {
            return this.distributionPaths;
        }

        @Override
        public final java.util.List<java.lang.String> getExclude() {
            return this.exclude;
        }

        @Override
        public final software.amazon.awscdk.Expiration getExpires() {
            return this.expires;
        }

        @Override
        public final java.util.List<java.lang.String> getInclude() {
            return this.include;
        }

        @Override
        public final java.lang.Number getMemoryLimit() {
            return this.memoryLimit;
        }

        @Override
        public final software.amazon.awscdk.services.s3.deployment.UserDefinedObjectMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        public final java.lang.Boolean getPrune() {
            return this.prune;
        }

        @Override
        public final java.lang.Boolean getRetainOnDelete() {
            return this.retainOnDelete;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.s3.deployment.ServerSideEncryption getServerSideEncryption() {
            return this.serverSideEncryption;
        }

        @Override
        public final java.lang.String getServerSideEncryptionAwsKmsKeyId() {
            return this.serverSideEncryptionAwsKmsKeyId;
        }

        @Override
        public final java.lang.String getServerSideEncryptionCustomerAlgorithm() {
            return this.serverSideEncryptionCustomerAlgorithm;
        }

        @Override
        public final software.amazon.awscdk.services.s3.deployment.StorageClass getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        public final java.lang.String getWebsiteRedirectLocation() {
            return this.websiteRedirectLocation;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationBucket", om.valueToTree(this.getDestinationBucket()));
            data.set("sources", om.valueToTree(this.getSources()));
            if (this.getAccessControl() != null) {
                data.set("accessControl", om.valueToTree(this.getAccessControl()));
            }
            if (this.getCacheControl() != null) {
                data.set("cacheControl", om.valueToTree(this.getCacheControl()));
            }
            if (this.getContentDisposition() != null) {
                data.set("contentDisposition", om.valueToTree(this.getContentDisposition()));
            }
            if (this.getContentEncoding() != null) {
                data.set("contentEncoding", om.valueToTree(this.getContentEncoding()));
            }
            if (this.getContentLanguage() != null) {
                data.set("contentLanguage", om.valueToTree(this.getContentLanguage()));
            }
            if (this.getContentType() != null) {
                data.set("contentType", om.valueToTree(this.getContentType()));
            }
            if (this.getDestinationKeyPrefix() != null) {
                data.set("destinationKeyPrefix", om.valueToTree(this.getDestinationKeyPrefix()));
            }
            if (this.getDistribution() != null) {
                data.set("distribution", om.valueToTree(this.getDistribution()));
            }
            if (this.getDistributionPaths() != null) {
                data.set("distributionPaths", om.valueToTree(this.getDistributionPaths()));
            }
            if (this.getExclude() != null) {
                data.set("exclude", om.valueToTree(this.getExclude()));
            }
            if (this.getExpires() != null) {
                data.set("expires", om.valueToTree(this.getExpires()));
            }
            if (this.getInclude() != null) {
                data.set("include", om.valueToTree(this.getInclude()));
            }
            if (this.getMemoryLimit() != null) {
                data.set("memoryLimit", om.valueToTree(this.getMemoryLimit()));
            }
            if (this.getMetadata() != null) {
                data.set("metadata", om.valueToTree(this.getMetadata()));
            }
            if (this.getPrune() != null) {
                data.set("prune", om.valueToTree(this.getPrune()));
            }
            if (this.getRetainOnDelete() != null) {
                data.set("retainOnDelete", om.valueToTree(this.getRetainOnDelete()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getServerSideEncryption() != null) {
                data.set("serverSideEncryption", om.valueToTree(this.getServerSideEncryption()));
            }
            if (this.getServerSideEncryptionAwsKmsKeyId() != null) {
                data.set("serverSideEncryptionAwsKmsKeyId", om.valueToTree(this.getServerSideEncryptionAwsKmsKeyId()));
            }
            if (this.getServerSideEncryptionCustomerAlgorithm() != null) {
                data.set("serverSideEncryptionCustomerAlgorithm", om.valueToTree(this.getServerSideEncryptionCustomerAlgorithm()));
            }
            if (this.getStorageClass() != null) {
                data.set("storageClass", om.valueToTree(this.getStorageClass()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }
            if (this.getWebsiteRedirectLocation() != null) {
                data.set("websiteRedirectLocation", om.valueToTree(this.getWebsiteRedirectLocation()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3_deployment.BucketDeploymentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BucketDeploymentProps.Jsii$Proxy that = (BucketDeploymentProps.Jsii$Proxy) o;

            if (!destinationBucket.equals(that.destinationBucket)) return false;
            if (!sources.equals(that.sources)) return false;
            if (this.accessControl != null ? !this.accessControl.equals(that.accessControl) : that.accessControl != null) return false;
            if (this.cacheControl != null ? !this.cacheControl.equals(that.cacheControl) : that.cacheControl != null) return false;
            if (this.contentDisposition != null ? !this.contentDisposition.equals(that.contentDisposition) : that.contentDisposition != null) return false;
            if (this.contentEncoding != null ? !this.contentEncoding.equals(that.contentEncoding) : that.contentEncoding != null) return false;
            if (this.contentLanguage != null ? !this.contentLanguage.equals(that.contentLanguage) : that.contentLanguage != null) return false;
            if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
            if (this.destinationKeyPrefix != null ? !this.destinationKeyPrefix.equals(that.destinationKeyPrefix) : that.destinationKeyPrefix != null) return false;
            if (this.distribution != null ? !this.distribution.equals(that.distribution) : that.distribution != null) return false;
            if (this.distributionPaths != null ? !this.distributionPaths.equals(that.distributionPaths) : that.distributionPaths != null) return false;
            if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
            if (this.expires != null ? !this.expires.equals(that.expires) : that.expires != null) return false;
            if (this.include != null ? !this.include.equals(that.include) : that.include != null) return false;
            if (this.memoryLimit != null ? !this.memoryLimit.equals(that.memoryLimit) : that.memoryLimit != null) return false;
            if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) return false;
            if (this.prune != null ? !this.prune.equals(that.prune) : that.prune != null) return false;
            if (this.retainOnDelete != null ? !this.retainOnDelete.equals(that.retainOnDelete) : that.retainOnDelete != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.serverSideEncryption != null ? !this.serverSideEncryption.equals(that.serverSideEncryption) : that.serverSideEncryption != null) return false;
            if (this.serverSideEncryptionAwsKmsKeyId != null ? !this.serverSideEncryptionAwsKmsKeyId.equals(that.serverSideEncryptionAwsKmsKeyId) : that.serverSideEncryptionAwsKmsKeyId != null) return false;
            if (this.serverSideEncryptionCustomerAlgorithm != null ? !this.serverSideEncryptionCustomerAlgorithm.equals(that.serverSideEncryptionCustomerAlgorithm) : that.serverSideEncryptionCustomerAlgorithm != null) return false;
            if (this.storageClass != null ? !this.storageClass.equals(that.storageClass) : that.storageClass != null) return false;
            if (this.vpc != null ? !this.vpc.equals(that.vpc) : that.vpc != null) return false;
            if (this.vpcSubnets != null ? !this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets != null) return false;
            return this.websiteRedirectLocation != null ? this.websiteRedirectLocation.equals(that.websiteRedirectLocation) : that.websiteRedirectLocation == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destinationBucket.hashCode();
            result = 31 * result + (this.sources.hashCode());
            result = 31 * result + (this.accessControl != null ? this.accessControl.hashCode() : 0);
            result = 31 * result + (this.cacheControl != null ? this.cacheControl.hashCode() : 0);
            result = 31 * result + (this.contentDisposition != null ? this.contentDisposition.hashCode() : 0);
            result = 31 * result + (this.contentEncoding != null ? this.contentEncoding.hashCode() : 0);
            result = 31 * result + (this.contentLanguage != null ? this.contentLanguage.hashCode() : 0);
            result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
            result = 31 * result + (this.destinationKeyPrefix != null ? this.destinationKeyPrefix.hashCode() : 0);
            result = 31 * result + (this.distribution != null ? this.distribution.hashCode() : 0);
            result = 31 * result + (this.distributionPaths != null ? this.distributionPaths.hashCode() : 0);
            result = 31 * result + (this.exclude != null ? this.exclude.hashCode() : 0);
            result = 31 * result + (this.expires != null ? this.expires.hashCode() : 0);
            result = 31 * result + (this.include != null ? this.include.hashCode() : 0);
            result = 31 * result + (this.memoryLimit != null ? this.memoryLimit.hashCode() : 0);
            result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
            result = 31 * result + (this.prune != null ? this.prune.hashCode() : 0);
            result = 31 * result + (this.retainOnDelete != null ? this.retainOnDelete.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.serverSideEncryption != null ? this.serverSideEncryption.hashCode() : 0);
            result = 31 * result + (this.serverSideEncryptionAwsKmsKeyId != null ? this.serverSideEncryptionAwsKmsKeyId.hashCode() : 0);
            result = 31 * result + (this.serverSideEncryptionCustomerAlgorithm != null ? this.serverSideEncryptionCustomerAlgorithm.hashCode() : 0);
            result = 31 * result + (this.storageClass != null ? this.storageClass.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            result = 31 * result + (this.websiteRedirectLocation != null ? this.websiteRedirectLocation.hashCode() : 0);
            return result;
        }
    }
}
