package software.amazon.awscdk.services.secretsmanager;

/**
 * (experimental) Creates a new secret in AWS SecretsManager.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:49.651Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.Secret")
public class Secret extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.secretsmanager.ISecret {

    protected Secret(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Secret(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Secret(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.SecretProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Secret(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Import an existing secret into the Stack.
     * <p>
     * @param scope the scope of the import. This parameter is required.
     * @param id the ID of the imported Secret in the construct tree. This parameter is required.
     * @param attrs the attributes of the imported secret. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret fromSecretAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.secretsmanager.Secret.class, "fromSecretAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) Imports a secret by complete ARN.
     * <p>
     * The complete ARN is the ARN with the Secrets Manager-supplied suffix.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param secretCompleteArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret fromSecretCompleteArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String secretCompleteArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.secretsmanager.Secret.class, "fromSecretCompleteArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(secretCompleteArn, "secretCompleteArn is required") });
    }

    /**
     * (experimental) Imports a secret by secret name.
     * <p>
     * A secret with this name must exist in the same account &amp; region.
     * Replaces the deprecated <code>fromSecretName</code>.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param secretName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret fromSecretNameV2(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String secretName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.secretsmanager.Secret.class, "fromSecretNameV2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(secretName, "secretName is required") });
    }

    /**
     * (experimental) Imports a secret by partial ARN.
     * <p>
     * The partial ARN is the ARN without the Secrets Manager-supplied suffix.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param secretPartialArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret fromSecretPartialArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String secretPartialArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.secretsmanager.Secret.class, "fromSecretPartialArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(secretPartialArn, "secretPartialArn is required") });
    }

    /**
     * (experimental) Adds a replica region for the secret.
     * <p>
     * @param region The name of the region. This parameter is required.
     * @param encryptionKey The customer-managed encryption key to use for encrypting the secret value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addReplicaRegion(final @org.jetbrains.annotations.NotNull java.lang.String region, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey encryptionKey) {
        software.amazon.jsii.Kernel.call(this, "addReplicaRegion", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(region, "region is required"), encryptionKey });
    }

    /**
     * (experimental) Adds a replica region for the secret.
     * <p>
     * @param region The name of the region. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addReplicaRegion(final @org.jetbrains.annotations.NotNull java.lang.String region) {
        software.amazon.jsii.Kernel.call(this, "addReplicaRegion", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(region, "region is required") });
    }

    /**
     * (experimental) Adds a rotation schedule to the secret.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.RotationSchedule addRotationSchedule(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.RotationScheduleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addRotationSchedule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.RotationSchedule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Adds a statement to the IAM resource policy associated with this secret.
     * <p>
     * If this secret was created in this stack, a resource policy will be
     * automatically created upon the first call to <code>addToResourcePolicy</code>. If
     * the secret is imported, then this is a no-op.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToResourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * (experimental) Attach a target to this secret.
     * <p>
     * @return An attached secret
     * @param target The target to attach. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret attach(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecretAttachmentTarget target) {
        return software.amazon.jsii.Kernel.call(this, "attach", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class), new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * (experimental) Denies the `DeleteSecret` action to all principals within the current account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void denyAccountRootDelete() {
        software.amazon.jsii.Kernel.call(this, "denyAccountRootDelete", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * (experimental) Grants reading the secret value to some role.
     * <p>
     * @param grantee This parameter is required.
     * @param versionStages
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> versionStages) {
        return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), versionStages });
    }

    /**
     * (experimental) Grants reading the secret value to some role.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * (experimental) Grants writing and updating the secret value to some role.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * (experimental) Interpret the secret as a JSON object and return a field's value from it as a `SecretValue`.
     * <p>
     * @param jsonField This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue secretValueFromJson(final @org.jetbrains.annotations.NotNull java.lang.String jsonField) {
        return software.amazon.jsii.Kernel.call(this, "secretValueFromJson", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(jsonField, "jsonField is required") });
    }

    /**
     * (experimental) Provides an identifier for this secret for use in IAM policies.
     * <p>
     * If there is a full ARN, this is just the ARN;
     * if we have a partial ARN -- due to either importing by secret name or partial ARN --
     * then we need to add a suffix to capture the full ARN's format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull java.lang.String getArnForPolicies() {
        return software.amazon.jsii.Kernel.get(this, "arnForPolicies", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getAutoCreatePolicy() {
        return software.amazon.jsii.Kernel.get(this, "autoCreatePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) The ARN of the secret in AWS Secrets Manager.
     * <p>
     * Will return the full ARN if available, otherwise a partial arn.
     * For secrets imported by the deprecated <code>fromSecretName</code>, it will return the <code>secretName</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecretArn() {
        return software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the secret.
     * <p>
     * For "owned" secrets, this will be the full resource name (secret name + suffix), unless the
     * '&#64;aws-cdk/aws-secretsmanager:parseOwnedSecretName' feature flag is set.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecretName() {
        return software.amazon.jsii.Kernel.get(this, "secretName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Retrieve the value of the stored secret as a `SecretValue`.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue getSecretValue() {
        return software.amazon.jsii.Kernel.get(this, "secretValue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class));
    }

    /**
     * (experimental) The customer-managed encryption key that is used to encrypt this secret, if any.
     * <p>
     * When not specified, the default
     * KMS key for the account and region is being used.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * (experimental) The full ARN of the secret in AWS Secrets Manager, which is the ARN including the Secrets Manager-supplied 6-character suffix.
     * <p>
     * This is equal to <code>secretArn</code> in most cases, but is undefined when a full ARN is not available (e.g., secrets imported by name).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getSecretFullArn() {
        return software.amazon.jsii.Kernel.get(this, "secretFullArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.secretsmanager.Secret}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.secretsmanager.Secret> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.secretsmanager.SecretProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) An optional, human-friendly description of the secret.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description An optional, human-friendly description of the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * (experimental) The customer-managed encryption key to use for encrypting the secret value.
         * <p>
         * Default: - A default KMS key for the account and region is used.
         * <p>
         * @return {@code this}
         * @param encryptionKey The customer-managed encryption key to use for encrypting the secret value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        /**
         * (experimental) Configuration for how to generate a secret value.
         * <p>
         * Default: - 32 characters with upper-case letters, lower-case letters, punctuation and numbers (at least one from each
         * category), per the default values of ``SecretStringGenerator``.
         * <p>
         * @return {@code this}
         * @param generateSecretString Configuration for how to generate a secret value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder generateSecretString(final software.amazon.awscdk.services.secretsmanager.SecretStringGenerator generateSecretString) {
            this.props().generateSecretString(generateSecretString);
            return this;
        }

        /**
         * (experimental) Policy to apply when the secret is removed from this stack.
         * <p>
         * Default: - Not set.
         * <p>
         * @return {@code this}
         * @param removalPolicy Policy to apply when the secret is removed from this stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        /**
         * (experimental) A list of regions where to replicate this secret.
         * <p>
         * Default: - Secret is not replicated
         * <p>
         * @return {@code this}
         * @param replicaRegions A list of regions where to replicate this secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder replicaRegions(final java.util.List<? extends software.amazon.awscdk.services.secretsmanager.ReplicaRegion> replicaRegions) {
            this.props().replicaRegions(replicaRegions);
            return this;
        }

        /**
         * (experimental) A name for the secret.
         * <p>
         * Note that deleting secrets from SecretsManager does not happen immediately, but after a 7 to
         * 30 days blackout period. During that period, it is not possible to create another secret that shares the same name.
         * <p>
         * Default: - A name is generated by CloudFormation.
         * <p>
         * @return {@code this}
         * @param secretName A name for the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder secretName(final java.lang.String secretName) {
            this.props().secretName(secretName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.secretsmanager.Secret}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.secretsmanager.Secret build() {
            return new software.amazon.awscdk.services.secretsmanager.Secret(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.secretsmanager.SecretProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.secretsmanager.SecretProps.Builder();
            }
            return this.props;
        }
    }
}
