/**
 * <h1>AWS::Signer Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * AWS Signer is a fully managed code-signing service to ensure the trust and integrity of your code. Organizations validate code against
 * a digital signature to confirm that the code is unaltered and from a trusted publisher. For more information, see <a href="https://docs.aws.amazon.com/signer/latest/developerguide/Welcome.html">What Is AWS
 * Signer?</a>
 * <p>
 * <h2>Table of Contents</h2>
 * <p>
 * <ul>
 * <li><a href="#signing-platform">Signing Platform</a></li>
 * <li><a href="#signing-profile">Signing Profile</a></li>
 * </ul>
 * <p>
 * <h2>Signing Platform</h2>
 * <p>
 * A signing platform is a predefined set of instructions that specifies the signature format and signing algorithms that AWS Signer should use
 * to sign a zip file. For more information go to <a href="https://docs.aws.amazon.com/signer/latest/developerguide/gs-platform.html">Signing Platforms in AWS Signer</a>.
 * <p>
 * AWS Signer provides a pre-defined set of signing platforms. They are available in the CDK as -
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Platform.getAWS_IOT_DEVICE_MANAGEMENT_SHA256_ECDSA();
 * Platform.getAWS_LAMBDA_SHA384_ECDSA();
 * Platform.getAMAZON_FREE_RTOS_TI_CC3220SF();
 * Platform.getAMAZON_FREE_RTOS_DEFAULT();
 * </pre></blockquote>
 * <p>
 * <h2>Signing Profile</h2>
 * <p>
 * A signing profile is a code-signing template that can be used to pre-define the signature specifications for a signing job.
 * A signing profile includes a signing platform to designate the file type to be signed, the signature format, and the signature algorithms.
 * For more information, visit <a href="https://docs.aws.amazon.com/signer/latest/developerguide/gs-profile.html">Signing Profiles in AWS Signer</a>.
 * <p>
 * The following code sets up a signing profile for signing lambda code bundles -
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.aws_signer;
 * 
 * 
 * SigningProfile signingProfile = new SigningProfile(this, "SigningProfile", new SigningProfileProps()
 *         .platform(signer.Platform.getAWS_LAMBDA_SHA384_ECDSA()));
 * </pre></blockquote>
 * <p>
 * A signing profile is valid by default for 135 months. This can be modified by specifying the <code>signatureValidityPeriod</code> property.
 */
package software.amazon.awscdk.services.signer;
