package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * (experimental) Properties for invoking a Lambda function with LambdaInvoke.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:55.401Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.LambdaInvokeProps")
@software.amazon.jsii.Jsii.Proxy(LambdaInvokeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface LambdaInvokeProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps {

    /**
     * (experimental) Lambda function to invoke.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getLambdaFunction();

    /**
     * (experimental) Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function.
     * <p>
     * Default: - No context
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getClientContext() {
        return null;
    }

    /**
     * (experimental) Invocation type of the Lambda function.
     * <p>
     * Default: InvocationType.REQUEST_RESPONSE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.LambdaInvocationType getInvocationType() {
        return null;
    }

    /**
     * (experimental) The JSON that will be supplied as input to the Lambda function.
     * <p>
     * Default: - The state input (JSON path '$')
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskInput getPayload() {
        return null;
    }

    /**
     * (experimental) Invoke the Lambda in a way that only returns the payload response without additional metadata.
     * <p>
     * The <code>payloadResponseOnly</code> property cannot be used if <code>integrationPattern</code>, <code>invocationType</code>,
     * <code>clientContext</code>, or <code>qualifier</code> are specified.
     * It always uses the REQUEST_RESPONSE behavior.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPayloadResponseOnly() {
        return null;
    }

    /**
     * (experimental) Version or alias to invoke a published version of the function.
     * <p>
     * You only need to supply this if you want the version of the Lambda Function to depend
     * on data in the state machine state. If not, you can pass the appropriate Alias or Version object
     * directly as the <code>lambdaFunction</code> argument.
     * <p>
     * Default: - Version or alias inherent to the `lambdaFunction` object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getQualifier() {
        return null;
    }

    /**
     * (experimental) Whether to retry on Lambda service exceptions.
     * <p>
     * This handles <code>Lambda.ServiceException</code>, <code>Lambda.AWSLambdaException</code> and
     * <code>Lambda.SdkClientException</code> with an interval of 2 seconds, a back-off rate
     * of 2 and 6 maximum attempts.
     * <p>
     * Default: true
     * <p>
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/bp-lambda-serviceexception.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRetryOnServiceExceptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LambdaInvokeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaInvokeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<LambdaInvokeProps> {
        private software.amazon.awscdk.services.lambda.IFunction lambdaFunction;
        private java.lang.String clientContext;
        private software.amazon.awscdk.services.stepfunctions.tasks.LambdaInvocationType invocationType;
        private software.amazon.awscdk.services.stepfunctions.TaskInput payload;
        private java.lang.Boolean payloadResponseOnly;
        private java.lang.String qualifier;
        private java.lang.Boolean retryOnServiceExceptions;
        private java.lang.String comment;
        private software.amazon.awscdk.Duration heartbeat;
        private java.lang.String inputPath;
        private software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private java.lang.String outputPath;
        private java.lang.String resultPath;
        private java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        private software.amazon.awscdk.Duration timeout;

        /**
         * Sets the value of {@link LambdaInvokeProps#getLambdaFunction}
         * @param lambdaFunction Lambda function to invoke. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lambdaFunction(software.amazon.awscdk.services.lambda.IFunction lambdaFunction) {
            this.lambdaFunction = lambdaFunction;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeProps#getClientContext}
         * @param clientContext Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clientContext(java.lang.String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeProps#getInvocationType}
         * @param invocationType Invocation type of the Lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder invocationType(software.amazon.awscdk.services.stepfunctions.tasks.LambdaInvocationType invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeProps#getPayload}
         * @param payload The JSON that will be supplied as input to the Lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder payload(software.amazon.awscdk.services.stepfunctions.TaskInput payload) {
            this.payload = payload;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeProps#getPayloadResponseOnly}
         * @param payloadResponseOnly Invoke the Lambda in a way that only returns the payload response without additional metadata.
         *                            The <code>payloadResponseOnly</code> property cannot be used if <code>integrationPattern</code>, <code>invocationType</code>,
         *                            <code>clientContext</code>, or <code>qualifier</code> are specified.
         *                            It always uses the REQUEST_RESPONSE behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder payloadResponseOnly(java.lang.Boolean payloadResponseOnly) {
            this.payloadResponseOnly = payloadResponseOnly;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeProps#getQualifier}
         * @param qualifier Version or alias to invoke a published version of the function.
         *                  You only need to supply this if you want the version of the Lambda Function to depend
         *                  on data in the state machine state. If not, you can pass the appropriate Alias or Version object
         *                  directly as the <code>lambdaFunction</code> argument.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder qualifier(java.lang.String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeProps#getRetryOnServiceExceptions}
         * @param retryOnServiceExceptions Whether to retry on Lambda service exceptions.
         *                                 This handles <code>Lambda.ServiceException</code>, <code>Lambda.AWSLambdaException</code> and
         *                                 <code>Lambda.SdkClientException</code> with an interval of 2 seconds, a back-off rate
         *                                 of 2 and 6 maximum attempts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retryOnServiceExceptions(java.lang.Boolean retryOnServiceExceptions) {
            this.retryOnServiceExceptions = retryOnServiceExceptions;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeProps#getComment}
         * @param comment An optional description for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder heartbeat(software.amazon.awscdk.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeProps#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeProps#getOutputPath}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeProps#getResultSelector}
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         *                       You can use ResultSelector to create a payload with values that are static
         *                       or selected from the state's raw result.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder resultSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)resultSelector;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeProps#getTimeout}
         * @param timeout Timeout for the state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaInvokeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public LambdaInvokeProps build() {
            return new Jsii$Proxy(lambdaFunction, clientContext, invocationType, payload, payloadResponseOnly, qualifier, retryOnServiceExceptions, comment, heartbeat, inputPath, integrationPattern, outputPath, resultPath, resultSelector, timeout);
        }
    }

    /**
     * An implementation for {@link LambdaInvokeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaInvokeProps {
        private final software.amazon.awscdk.services.lambda.IFunction lambdaFunction;
        private final java.lang.String clientContext;
        private final software.amazon.awscdk.services.stepfunctions.tasks.LambdaInvocationType invocationType;
        private final software.amazon.awscdk.services.stepfunctions.TaskInput payload;
        private final java.lang.Boolean payloadResponseOnly;
        private final java.lang.String qualifier;
        private final java.lang.Boolean retryOnServiceExceptions;
        private final java.lang.String comment;
        private final software.amazon.awscdk.Duration heartbeat;
        private final java.lang.String inputPath;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final java.lang.String outputPath;
        private final java.lang.String resultPath;
        private final java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        private final software.amazon.awscdk.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.lambdaFunction = software.amazon.jsii.Kernel.get(this, "lambdaFunction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.clientContext = software.amazon.jsii.Kernel.get(this, "clientContext", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.invocationType = software.amazon.jsii.Kernel.get(this, "invocationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.LambdaInvocationType.class));
            this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.payloadResponseOnly = software.amazon.jsii.Kernel.get(this, "payloadResponseOnly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.qualifier = software.amazon.jsii.Kernel.get(this, "qualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.retryOnServiceExceptions = software.amazon.jsii.Kernel.get(this, "retryOnServiceExceptions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.heartbeat = software.amazon.jsii.Kernel.get(this, "heartbeat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultPath = software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultSelector = software.amazon.jsii.Kernel.get(this, "resultSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.lambda.IFunction lambdaFunction, final java.lang.String clientContext, final software.amazon.awscdk.services.stepfunctions.tasks.LambdaInvocationType invocationType, final software.amazon.awscdk.services.stepfunctions.TaskInput payload, final java.lang.Boolean payloadResponseOnly, final java.lang.String qualifier, final java.lang.Boolean retryOnServiceExceptions, final java.lang.String comment, final software.amazon.awscdk.Duration heartbeat, final java.lang.String inputPath, final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern, final java.lang.String outputPath, final java.lang.String resultPath, final java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector, final software.amazon.awscdk.Duration timeout) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.lambdaFunction = java.util.Objects.requireNonNull(lambdaFunction, "lambdaFunction is required");
            this.clientContext = clientContext;
            this.invocationType = invocationType;
            this.payload = payload;
            this.payloadResponseOnly = payloadResponseOnly;
            this.qualifier = qualifier;
            this.retryOnServiceExceptions = retryOnServiceExceptions;
            this.comment = comment;
            this.heartbeat = heartbeat;
            this.inputPath = inputPath;
            this.integrationPattern = integrationPattern;
            this.outputPath = outputPath;
            this.resultPath = resultPath;
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)resultSelector;
            this.timeout = timeout;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getLambdaFunction() {
            return this.lambdaFunction;
        }

        @Override
        public final java.lang.String getClientContext() {
            return this.clientContext;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.LambdaInvocationType getInvocationType() {
            return this.invocationType;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getPayload() {
            return this.payload;
        }

        @Override
        public final java.lang.Boolean getPayloadResponseOnly() {
            return this.payloadResponseOnly;
        }

        @Override
        public final java.lang.String getQualifier() {
            return this.qualifier;
        }

        @Override
        public final java.lang.Boolean getRetryOnServiceExceptions() {
            return this.retryOnServiceExceptions;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public final java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public final java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getResultSelector() {
            return this.resultSelector;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("lambdaFunction", om.valueToTree(this.getLambdaFunction()));
            if (this.getClientContext() != null) {
                data.set("clientContext", om.valueToTree(this.getClientContext()));
            }
            if (this.getInvocationType() != null) {
                data.set("invocationType", om.valueToTree(this.getInvocationType()));
            }
            if (this.getPayload() != null) {
                data.set("payload", om.valueToTree(this.getPayload()));
            }
            if (this.getPayloadResponseOnly() != null) {
                data.set("payloadResponseOnly", om.valueToTree(this.getPayloadResponseOnly()));
            }
            if (this.getQualifier() != null) {
                data.set("qualifier", om.valueToTree(this.getQualifier()));
            }
            if (this.getRetryOnServiceExceptions() != null) {
                data.set("retryOnServiceExceptions", om.valueToTree(this.getRetryOnServiceExceptions()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getResultSelector() != null) {
                data.set("resultSelector", om.valueToTree(this.getResultSelector()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.LambdaInvokeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaInvokeProps.Jsii$Proxy that = (LambdaInvokeProps.Jsii$Proxy) o;

            if (!lambdaFunction.equals(that.lambdaFunction)) return false;
            if (this.clientContext != null ? !this.clientContext.equals(that.clientContext) : that.clientContext != null) return false;
            if (this.invocationType != null ? !this.invocationType.equals(that.invocationType) : that.invocationType != null) return false;
            if (this.payload != null ? !this.payload.equals(that.payload) : that.payload != null) return false;
            if (this.payloadResponseOnly != null ? !this.payloadResponseOnly.equals(that.payloadResponseOnly) : that.payloadResponseOnly != null) return false;
            if (this.qualifier != null ? !this.qualifier.equals(that.qualifier) : that.qualifier != null) return false;
            if (this.retryOnServiceExceptions != null ? !this.retryOnServiceExceptions.equals(that.retryOnServiceExceptions) : that.retryOnServiceExceptions != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            if (this.resultSelector != null ? !this.resultSelector.equals(that.resultSelector) : that.resultSelector != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.lambdaFunction.hashCode();
            result = 31 * result + (this.clientContext != null ? this.clientContext.hashCode() : 0);
            result = 31 * result + (this.invocationType != null ? this.invocationType.hashCode() : 0);
            result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
            result = 31 * result + (this.payloadResponseOnly != null ? this.payloadResponseOnly.hashCode() : 0);
            result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
            result = 31 * result + (this.retryOnServiceExceptions != null ? this.retryOnServiceExceptions.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            result = 31 * result + (this.resultSelector != null ? this.resultSelector.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
