package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * (experimental) Properties for creating an Amazon SageMaker training job.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-09-01T10:26:56.035Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.SageMakerCreateTrainingJobProps")
@software.amazon.jsii.Jsii.Proxy(SageMakerCreateTrainingJobProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SageMakerCreateTrainingJobProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps {

    /**
     * (experimental) Identifies the training algorithm to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification getAlgorithmSpecification();

    /**
     * (experimental) Describes the various datasets (e.g. train, validation, test) and the Amazon S3 location where stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.Channel> getInputDataConfig();

    /**
     * (experimental) Identifies the Amazon S3 location where you want Amazon SageMaker to save the results of model training.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig getOutputDataConfig();

    /**
     * (experimental) Training Job Name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getTrainingJobName();

    /**
     * (experimental) Algorithm-specific parameters that influence the quality of the model.
     * <p>
     * Set hyperparameters before you start the learning process.
     * For a list of hyperparameters provided by Amazon SageMaker
     * <p>
     * Default: - No hyperparameters
     * <p>
     * @see https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getHyperparameters() {
        return null;
    }

    /**
     * (experimental) Specifies the resources, ML compute instances, and ML storage volumes to deploy for model training.
     * <p>
     * Default: - 1 instance of EC2 `M4.XLarge` with `10GB` volume
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig getResourceConfig() {
        return null;
    }

    /**
     * (experimental) Role for the Training Job.
     * <p>
     * The role must be granted all necessary permissions for the SageMaker training job to
     * be able to operate.
     * <p>
     * See https://docs.aws.amazon.com/fr_fr/sagemaker/latest/dg/sagemaker-roles.html#sagemaker-roles-createtrainingjob-perms
     * <p>
     * Default: - a role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * (experimental) Sets a time limit for training.
     * <p>
     * Default: - max runtime of 1 hour
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.StoppingCondition getStoppingCondition() {
        return null;
    }

    /**
     * (experimental) Tags to be applied to the train job.
     * <p>
     * Default: - No tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * (experimental) Specifies the VPC that you want your training job to connect to.
     * <p>
     * Default: - No VPC
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig getVpcConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SageMakerCreateTrainingJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SageMakerCreateTrainingJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<SageMakerCreateTrainingJobProps> {
        private software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification algorithmSpecification;
        private java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.Channel> inputDataConfig;
        private software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig outputDataConfig;
        private java.lang.String trainingJobName;
        private java.util.Map<java.lang.String, java.lang.Object> hyperparameters;
        private software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig resourceConfig;
        private software.amazon.awscdk.services.iam.IRole role;
        private software.amazon.awscdk.services.stepfunctions.tasks.StoppingCondition stoppingCondition;
        private java.util.Map<java.lang.String, java.lang.String> tags;
        private software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig vpcConfig;
        private java.lang.String comment;
        private software.amazon.awscdk.Duration heartbeat;
        private java.lang.String inputPath;
        private software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private java.lang.String outputPath;
        private java.lang.String resultPath;
        private java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        private software.amazon.awscdk.Duration timeout;

        /**
         * Sets the value of {@link SageMakerCreateTrainingJobProps#getAlgorithmSpecification}
         * @param algorithmSpecification Identifies the training algorithm to use. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder algorithmSpecification(software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTrainingJobProps#getInputDataConfig}
         * @param inputDataConfig Describes the various datasets (e.g. train, validation, test) and the Amazon S3 location where stored. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder inputDataConfig(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.Channel> inputDataConfig) {
            this.inputDataConfig = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.Channel>)inputDataConfig;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTrainingJobProps#getOutputDataConfig}
         * @param outputDataConfig Identifies the Amazon S3 location where you want Amazon SageMaker to save the results of model training. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputDataConfig(software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTrainingJobProps#getTrainingJobName}
         * @param trainingJobName Training Job Name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder trainingJobName(java.lang.String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTrainingJobProps#getHyperparameters}
         * @param hyperparameters Algorithm-specific parameters that influence the quality of the model.
         *                        Set hyperparameters before you start the learning process.
         *                        For a list of hyperparameters provided by Amazon SageMaker
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder hyperparameters(java.util.Map<java.lang.String, ? extends java.lang.Object> hyperparameters) {
            this.hyperparameters = (java.util.Map<java.lang.String, java.lang.Object>)hyperparameters;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTrainingJobProps#getResourceConfig}
         * @param resourceConfig Specifies the resources, ML compute instances, and ML storage volumes to deploy for model training.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resourceConfig(software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTrainingJobProps#getRole}
         * @param role Role for the Training Job.
         *             The role must be granted all necessary permissions for the SageMaker training job to
         *             be able to operate.
         *             <p>
         *             See https://docs.aws.amazon.com/fr_fr/sagemaker/latest/dg/sagemaker-roles.html#sagemaker-roles-createtrainingjob-perms
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTrainingJobProps#getStoppingCondition}
         * @param stoppingCondition Sets a time limit for training.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stoppingCondition(software.amazon.awscdk.services.stepfunctions.tasks.StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTrainingJobProps#getTags}
         * @param tags Tags to be applied to the train job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTrainingJobProps#getVpcConfig}
         * @param vpcConfig Specifies the VPC that you want your training job to connect to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcConfig(software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTrainingJobProps#getComment}
         * @param comment An optional description for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTrainingJobProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder heartbeat(software.amazon.awscdk.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTrainingJobProps#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTrainingJobProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTrainingJobProps#getOutputPath}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTrainingJobProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTrainingJobProps#getResultSelector}
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         *                       You can use ResultSelector to create a payload with values that are static
         *                       or selected from the state's raw result.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder resultSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)resultSelector;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTrainingJobProps#getTimeout}
         * @param timeout Timeout for the state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SageMakerCreateTrainingJobProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public SageMakerCreateTrainingJobProps build() {
            return new Jsii$Proxy(algorithmSpecification, inputDataConfig, outputDataConfig, trainingJobName, hyperparameters, resourceConfig, role, stoppingCondition, tags, vpcConfig, comment, heartbeat, inputPath, integrationPattern, outputPath, resultPath, resultSelector, timeout);
        }
    }

    /**
     * An implementation for {@link SageMakerCreateTrainingJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SageMakerCreateTrainingJobProps {
        private final software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification algorithmSpecification;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.Channel> inputDataConfig;
        private final software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig outputDataConfig;
        private final java.lang.String trainingJobName;
        private final java.util.Map<java.lang.String, java.lang.Object> hyperparameters;
        private final software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig resourceConfig;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.stepfunctions.tasks.StoppingCondition stoppingCondition;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig vpcConfig;
        private final java.lang.String comment;
        private final software.amazon.awscdk.Duration heartbeat;
        private final java.lang.String inputPath;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final java.lang.String outputPath;
        private final java.lang.String resultPath;
        private final java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        private final software.amazon.awscdk.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.algorithmSpecification = software.amazon.jsii.Kernel.get(this, "algorithmSpecification", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification.class));
            this.inputDataConfig = software.amazon.jsii.Kernel.get(this, "inputDataConfig", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.Channel.class)));
            this.outputDataConfig = software.amazon.jsii.Kernel.get(this, "outputDataConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig.class));
            this.trainingJobName = software.amazon.jsii.Kernel.get(this, "trainingJobName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hyperparameters = software.amazon.jsii.Kernel.get(this, "hyperparameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.resourceConfig = software.amazon.jsii.Kernel.get(this, "resourceConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.stoppingCondition = software.amazon.jsii.Kernel.get(this, "stoppingCondition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.StoppingCondition.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.vpcConfig = software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.heartbeat = software.amazon.jsii.Kernel.get(this, "heartbeat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultPath = software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultSelector = software.amazon.jsii.Kernel.get(this, "resultSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification algorithmSpecification, final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.Channel> inputDataConfig, final software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig outputDataConfig, final java.lang.String trainingJobName, final java.util.Map<java.lang.String, ? extends java.lang.Object> hyperparameters, final software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig resourceConfig, final software.amazon.awscdk.services.iam.IRole role, final software.amazon.awscdk.services.stepfunctions.tasks.StoppingCondition stoppingCondition, final java.util.Map<java.lang.String, java.lang.String> tags, final software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig vpcConfig, final java.lang.String comment, final software.amazon.awscdk.Duration heartbeat, final java.lang.String inputPath, final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern, final java.lang.String outputPath, final java.lang.String resultPath, final java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector, final software.amazon.awscdk.Duration timeout) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.algorithmSpecification = java.util.Objects.requireNonNull(algorithmSpecification, "algorithmSpecification is required");
            this.inputDataConfig = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.Channel>)java.util.Objects.requireNonNull(inputDataConfig, "inputDataConfig is required");
            this.outputDataConfig = java.util.Objects.requireNonNull(outputDataConfig, "outputDataConfig is required");
            this.trainingJobName = java.util.Objects.requireNonNull(trainingJobName, "trainingJobName is required");
            this.hyperparameters = (java.util.Map<java.lang.String, java.lang.Object>)hyperparameters;
            this.resourceConfig = resourceConfig;
            this.role = role;
            this.stoppingCondition = stoppingCondition;
            this.tags = tags;
            this.vpcConfig = vpcConfig;
            this.comment = comment;
            this.heartbeat = heartbeat;
            this.inputPath = inputPath;
            this.integrationPattern = integrationPattern;
            this.outputPath = outputPath;
            this.resultPath = resultPath;
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)resultSelector;
            this.timeout = timeout;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification getAlgorithmSpecification() {
            return this.algorithmSpecification;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.Channel> getInputDataConfig() {
            return this.inputDataConfig;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig getOutputDataConfig() {
            return this.outputDataConfig;
        }

        @Override
        public final java.lang.String getTrainingJobName() {
            return this.trainingJobName;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getHyperparameters() {
            return this.hyperparameters;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig getResourceConfig() {
            return this.resourceConfig;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.StoppingCondition getStoppingCondition() {
            return this.stoppingCondition;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig getVpcConfig() {
            return this.vpcConfig;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public final java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public final java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getResultSelector() {
            return this.resultSelector;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("algorithmSpecification", om.valueToTree(this.getAlgorithmSpecification()));
            data.set("inputDataConfig", om.valueToTree(this.getInputDataConfig()));
            data.set("outputDataConfig", om.valueToTree(this.getOutputDataConfig()));
            data.set("trainingJobName", om.valueToTree(this.getTrainingJobName()));
            if (this.getHyperparameters() != null) {
                data.set("hyperparameters", om.valueToTree(this.getHyperparameters()));
            }
            if (this.getResourceConfig() != null) {
                data.set("resourceConfig", om.valueToTree(this.getResourceConfig()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getStoppingCondition() != null) {
                data.set("stoppingCondition", om.valueToTree(this.getStoppingCondition()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpcConfig() != null) {
                data.set("vpcConfig", om.valueToTree(this.getVpcConfig()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getResultSelector() != null) {
                data.set("resultSelector", om.valueToTree(this.getResultSelector()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.SageMakerCreateTrainingJobProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SageMakerCreateTrainingJobProps.Jsii$Proxy that = (SageMakerCreateTrainingJobProps.Jsii$Proxy) o;

            if (!algorithmSpecification.equals(that.algorithmSpecification)) return false;
            if (!inputDataConfig.equals(that.inputDataConfig)) return false;
            if (!outputDataConfig.equals(that.outputDataConfig)) return false;
            if (!trainingJobName.equals(that.trainingJobName)) return false;
            if (this.hyperparameters != null ? !this.hyperparameters.equals(that.hyperparameters) : that.hyperparameters != null) return false;
            if (this.resourceConfig != null ? !this.resourceConfig.equals(that.resourceConfig) : that.resourceConfig != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.stoppingCondition != null ? !this.stoppingCondition.equals(that.stoppingCondition) : that.stoppingCondition != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.vpcConfig != null ? !this.vpcConfig.equals(that.vpcConfig) : that.vpcConfig != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            if (this.resultSelector != null ? !this.resultSelector.equals(that.resultSelector) : that.resultSelector != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.algorithmSpecification.hashCode();
            result = 31 * result + (this.inputDataConfig.hashCode());
            result = 31 * result + (this.outputDataConfig.hashCode());
            result = 31 * result + (this.trainingJobName.hashCode());
            result = 31 * result + (this.hyperparameters != null ? this.hyperparameters.hashCode() : 0);
            result = 31 * result + (this.resourceConfig != null ? this.resourceConfig.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.stoppingCondition != null ? this.stoppingCondition.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpcConfig != null ? this.vpcConfig.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            result = 31 * result + (this.resultSelector != null ? this.resultSelector.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
