/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.cxapi;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.cloudassembly.schema.ArtifactManifest;
import software.amazon.awscdk.cloudassembly.schema.ArtifactType;
import software.amazon.awscdk.cloudassembly.schema.AssetManifestProperties;
import software.amazon.awscdk.cloudassembly.schema.AwsCloudFormationStackProperties;
import software.amazon.awscdk.cloudassembly.schema.MetadataEntry;
import software.amazon.awscdk.cloudassembly.schema.NestedCloudAssemblyProperties;
import software.amazon.awscdk.cloudassembly.schema.TreeArtifactProperties;
import software.amazon.awscdk.cxapi.CloudArtifact;
import software.amazon.awscdk.cxapi.CloudAssembly;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.cx_api.AssetManifestArtifact")
public class AssetManifestArtifact
extends CloudArtifact {
    protected AssetManifestArtifact(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetManifestArtifact(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public AssetManifestArtifact(@NotNull CloudAssembly assembly, @NotNull String name, @NotNull ArtifactManifest artifact) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(assembly, "assembly is required"), Objects.requireNonNull(name, "name is required"), Objects.requireNonNull(artifact, "artifact is required")});
    }

    @Nullable
    public String getBootstrapStackVersionSsmParameter() {
        return (String)Kernel.get((Object)((Object)this), (String)"bootstrapStackVersionSsmParameter", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getFile() {
        return (String)Kernel.get((Object)((Object)this), (String)"file", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Number getRequiresBootstrapStackVersion() {
        return (Number)Kernel.get((Object)((Object)this), (String)"requiresBootstrapStackVersion", (NativeType)NativeType.forClass(Number.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<AssetManifestArtifact> {
        private final CloudAssembly assembly;
        private final String name;
        private final ArtifactManifest.Builder artifact;

        public static Builder create(CloudAssembly assembly, String name) {
            return new Builder(assembly, name);
        }

        private Builder(CloudAssembly assembly, String name) {
            this.assembly = assembly;
            this.name = name;
            this.artifact = new ArtifactManifest.Builder();
        }

        public Builder dependencies(List<String> dependencies) {
            this.artifact.dependencies(dependencies);
            return this;
        }

        public Builder displayName(String displayName) {
            this.artifact.displayName(displayName);
            return this;
        }

        public Builder environment(String environment) {
            this.artifact.environment(environment);
            return this;
        }

        public Builder metadata(Map<String, ? extends List<? extends MetadataEntry>> metadata) {
            this.artifact.metadata(metadata);
            return this;
        }

        public Builder properties(AwsCloudFormationStackProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        public Builder properties(AssetManifestProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        public Builder properties(TreeArtifactProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        public Builder properties(NestedCloudAssemblyProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        public Builder type(ArtifactType type) {
            this.artifact.type(type);
            return this;
        }

        public AssetManifestArtifact build() {
            return new AssetManifestArtifact(this.assembly, this.name, this.artifact.build());
        }
    }
}

