/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudfront;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.certificatemanager.ICertificate;
import software.amazon.awscdk.services.cloudfront.AddBehaviorOptions;
import software.amazon.awscdk.services.cloudfront.BehaviorOptions;
import software.amazon.awscdk.services.cloudfront.DistributionAttributes;
import software.amazon.awscdk.services.cloudfront.DistributionProps;
import software.amazon.awscdk.services.cloudfront.ErrorResponse;
import software.amazon.awscdk.services.cloudfront.GeoRestriction;
import software.amazon.awscdk.services.cloudfront.HttpVersion;
import software.amazon.awscdk.services.cloudfront.IDistribution;
import software.amazon.awscdk.services.cloudfront.IOrigin;
import software.amazon.awscdk.services.cloudfront.PriceClass;
import software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_cloudfront.Distribution")
public class Distribution
extends Resource
implements IDistribution {
    protected Distribution(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Distribution(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Distribution(@NotNull Construct scope, @NotNull String id, @NotNull DistributionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IDistribution fromDistributionAttributes(@NotNull Construct scope, @NotNull String id, @NotNull DistributionAttributes attrs) {
        return (IDistribution)JsiiObject.jsiiStaticCall(Distribution.class, (String)"fromDistributionAttributes", (NativeType)NativeType.forClass(IDistribution.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    public void addBehavior(@NotNull String pathPattern, @NotNull IOrigin origin, @Nullable AddBehaviorOptions behaviorOptions) {
        Kernel.call((Object)this, (String)"addBehavior", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(pathPattern, "pathPattern is required"), Objects.requireNonNull(origin, "origin is required"), behaviorOptions});
    }

    public void addBehavior(@NotNull String pathPattern, @NotNull IOrigin origin) {
        Kernel.call((Object)this, (String)"addBehavior", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(pathPattern, "pathPattern is required"), Objects.requireNonNull(origin, "origin is required")});
    }

    @Override
    @NotNull
    public String getDistributionDomainName() {
        return (String)Kernel.get((Object)this, (String)"distributionDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getDistributionId() {
        return (String)Kernel.get((Object)this, (String)"distributionId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getDomainName() {
        return (String)Kernel.get((Object)this, (String)"domainName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Distribution> {
        private final Construct scope;
        private final String id;
        private final DistributionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new DistributionProps.Builder();
        }

        public Builder defaultBehavior(BehaviorOptions defaultBehavior) {
            this.props.defaultBehavior(defaultBehavior);
            return this;
        }

        public Builder additionalBehaviors(Map<String, ? extends BehaviorOptions> additionalBehaviors) {
            this.props.additionalBehaviors(additionalBehaviors);
            return this;
        }

        public Builder certificate(ICertificate certificate) {
            this.props.certificate(certificate);
            return this;
        }

        public Builder comment(String comment) {
            this.props.comment(comment);
            return this;
        }

        public Builder defaultRootObject(String defaultRootObject) {
            this.props.defaultRootObject(defaultRootObject);
            return this;
        }

        public Builder domainNames(List<String> domainNames) {
            this.props.domainNames(domainNames);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        public Builder enableIpv6(Boolean enableIpv6) {
            this.props.enableIpv6(enableIpv6);
            return this;
        }

        public Builder enableLogging(Boolean enableLogging) {
            this.props.enableLogging(enableLogging);
            return this;
        }

        public Builder errorResponses(List<? extends ErrorResponse> errorResponses) {
            this.props.errorResponses(errorResponses);
            return this;
        }

        public Builder geoRestriction(GeoRestriction geoRestriction) {
            this.props.geoRestriction(geoRestriction);
            return this;
        }

        public Builder httpVersion(HttpVersion httpVersion) {
            this.props.httpVersion(httpVersion);
            return this;
        }

        public Builder logBucket(IBucket logBucket) {
            this.props.logBucket(logBucket);
            return this;
        }

        public Builder logFilePrefix(String logFilePrefix) {
            this.props.logFilePrefix(logFilePrefix);
            return this;
        }

        public Builder logIncludesCookies(Boolean logIncludesCookies) {
            this.props.logIncludesCookies(logIncludesCookies);
            return this;
        }

        public Builder minimumProtocolVersion(SecurityPolicyProtocol minimumProtocolVersion) {
            this.props.minimumProtocolVersion(minimumProtocolVersion);
            return this;
        }

        public Builder priceClass(PriceClass priceClass) {
            this.props.priceClass(priceClass);
            return this;
        }

        public Builder webAclId(String webAclId) {
            this.props.webAclId(webAclId);
            return this;
        }

        public Distribution build() {
            return new Distribution(this.scope, this.id, this.props.build());
        }
    }
}

