/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IPeer;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.Port;
import software.amazon.awscdk.services.ec2.SecurityGroupImportOptions;
import software.amazon.awscdk.services.ec2.SecurityGroupProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.SecurityGroup")
public class SecurityGroup
extends Resource
implements ISecurityGroup {
    protected SecurityGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SecurityGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public SecurityGroup(@NotNull Construct scope, @NotNull String id, @NotNull SecurityGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ISecurityGroup fromLookupById(@NotNull Construct scope, @NotNull String id, @NotNull String securityGroupId) {
        return (ISecurityGroup)JsiiObject.jsiiStaticCall(SecurityGroup.class, (String)"fromLookupById", (NativeType)NativeType.forClass(ISecurityGroup.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(securityGroupId, "securityGroupId is required")});
    }

    @NotNull
    public static ISecurityGroup fromLookupByName(@NotNull Construct scope, @NotNull String id, @NotNull String securityGroupName, @NotNull IVpc vpc) {
        return (ISecurityGroup)JsiiObject.jsiiStaticCall(SecurityGroup.class, (String)"fromLookupByName", (NativeType)NativeType.forClass(ISecurityGroup.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(securityGroupName, "securityGroupName is required"), Objects.requireNonNull(vpc, "vpc is required")});
    }

    @NotNull
    public static ISecurityGroup fromSecurityGroupId(@NotNull Construct scope, @NotNull String id, @NotNull String securityGroupId, @Nullable SecurityGroupImportOptions options) {
        return (ISecurityGroup)JsiiObject.jsiiStaticCall(SecurityGroup.class, (String)"fromSecurityGroupId", (NativeType)NativeType.forClass(ISecurityGroup.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(securityGroupId, "securityGroupId is required"), options});
    }

    @NotNull
    public static ISecurityGroup fromSecurityGroupId(@NotNull Construct scope, @NotNull String id, @NotNull String securityGroupId) {
        return (ISecurityGroup)JsiiObject.jsiiStaticCall(SecurityGroup.class, (String)"fromSecurityGroupId", (NativeType)NativeType.forClass(ISecurityGroup.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(securityGroupId, "securityGroupId is required")});
    }

    @NotNull
    public static Boolean isSecurityGroup(@NotNull Object x) {
        return (Boolean)JsiiObject.jsiiStaticCall(SecurityGroup.class, (String)"isSecurityGroup", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{x});
    }

    @Override
    public void addEgressRule(@NotNull IPeer peer, @NotNull Port connection, @Nullable String description, @Nullable Boolean remoteRule) {
        Kernel.call((Object)this, (String)"addEgressRule", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(peer, "peer is required"), Objects.requireNonNull(connection, "connection is required"), description, remoteRule});
    }

    @Override
    public void addEgressRule(@NotNull IPeer peer, @NotNull Port connection, @Nullable String description) {
        Kernel.call((Object)this, (String)"addEgressRule", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(peer, "peer is required"), Objects.requireNonNull(connection, "connection is required"), description});
    }

    @Override
    public void addEgressRule(@NotNull IPeer peer, @NotNull Port connection) {
        Kernel.call((Object)this, (String)"addEgressRule", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(peer, "peer is required"), Objects.requireNonNull(connection, "connection is required")});
    }

    @Override
    public void addIngressRule(@NotNull IPeer peer, @NotNull Port connection, @Nullable String description, @Nullable Boolean remoteRule) {
        Kernel.call((Object)this, (String)"addIngressRule", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(peer, "peer is required"), Objects.requireNonNull(connection, "connection is required"), description, remoteRule});
    }

    @Override
    public void addIngressRule(@NotNull IPeer peer, @NotNull Port connection, @Nullable String description) {
        Kernel.call((Object)this, (String)"addIngressRule", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(peer, "peer is required"), Objects.requireNonNull(connection, "connection is required"), description});
    }

    @Override
    public void addIngressRule(@NotNull IPeer peer, @NotNull Port connection) {
        Kernel.call((Object)this, (String)"addIngressRule", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(peer, "peer is required"), Objects.requireNonNull(connection, "connection is required")});
    }

    @NotNull
    protected ObjectNode determineRuleScope(@NotNull IPeer peer, @NotNull Port connection, @NotNull String fromTo, @Nullable Boolean remoteRule) {
        return (ObjectNode)Kernel.call((Object)this, (String)"determineRuleScope", (NativeType)NativeType.forClass(ObjectNode.class), (Object[])new Object[]{Objects.requireNonNull(peer, "peer is required"), Objects.requireNonNull(connection, "connection is required"), Objects.requireNonNull(fromTo, "fromTo is required"), remoteRule});
    }

    @NotNull
    protected ObjectNode determineRuleScope(@NotNull IPeer peer, @NotNull Port connection, @NotNull String fromTo) {
        return (ObjectNode)Kernel.call((Object)this, (String)"determineRuleScope", (NativeType)NativeType.forClass(ObjectNode.class), (Object[])new Object[]{Objects.requireNonNull(peer, "peer is required"), Objects.requireNonNull(connection, "connection is required"), Objects.requireNonNull(fromTo, "fromTo is required")});
    }

    @Override
    @NotNull
    public Object toEgressRuleConfig() {
        return Kernel.call((Object)this, (String)"toEgressRuleConfig", (NativeType)NativeType.forClass(Object.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Object toIngressRuleConfig() {
        return Kernel.call((Object)this, (String)"toIngressRuleConfig", (NativeType)NativeType.forClass(Object.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Boolean getAllowAllOutbound() {
        return (Boolean)Kernel.get((Object)this, (String)"allowAllOutbound", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @NotNull
    public Boolean getCanInlineRule() {
        return (Boolean)Kernel.get((Object)this, (String)"canInlineRule", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public String getSecurityGroupId() {
        return (String)Kernel.get((Object)this, (String)"securityGroupId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getSecurityGroupVpcId() {
        return (String)Kernel.get((Object)this, (String)"securityGroupVpcId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getUniqueId() {
        return (String)Kernel.get((Object)this, (String)"uniqueId", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public Port getDefaultPort() {
        return (Port)((Object)Kernel.get((Object)this, (String)"defaultPort", (NativeType)NativeType.forClass(Port.class)));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<SecurityGroup> {
        private final Construct scope;
        private final String id;
        private final SecurityGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new SecurityGroupProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder allowAllOutbound(Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder disableInlineRules(Boolean disableInlineRules) {
            this.props.disableInlineRules(disableInlineRules);
            return this;
        }

        public Builder securityGroupName(String securityGroupName) {
            this.props.securityGroupName(securityGroupName);
            return this;
        }

        public SecurityGroup build() {
            return new SecurityGroup(this.scope, this.id, this.props.build());
        }
    }
}

