/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.BaseService;
import software.amazon.awscdk.services.ecs.CapacityProviderStrategy;
import software.amazon.awscdk.services.ecs.CloudMapOptions;
import software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker;
import software.amazon.awscdk.services.ecs.DeploymentController;
import software.amazon.awscdk.services.ecs.Ec2ServiceAttributes;
import software.amazon.awscdk.services.ecs.Ec2ServiceProps;
import software.amazon.awscdk.services.ecs.IBaseService;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.IEc2Service;
import software.amazon.awscdk.services.ecs.PlacementConstraint;
import software.amazon.awscdk.services.ecs.PlacementStrategy;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.Ec2Service")
public class Ec2Service
extends BaseService
implements IEc2Service {
    protected Ec2Service(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Ec2Service(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Ec2Service(@NotNull Construct scope, @NotNull String id, @NotNull Ec2ServiceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IEc2Service fromEc2ServiceArn(@NotNull Construct scope, @NotNull String id, @NotNull String ec2ServiceArn) {
        return (IEc2Service)JsiiObject.jsiiStaticCall(Ec2Service.class, (String)"fromEc2ServiceArn", (NativeType)NativeType.forClass(IEc2Service.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(ec2ServiceArn, "ec2ServiceArn is required")});
    }

    @NotNull
    public static IBaseService fromEc2ServiceAttributes(@NotNull Construct scope, @NotNull String id, @NotNull Ec2ServiceAttributes attrs) {
        return (IBaseService)JsiiObject.jsiiStaticCall(Ec2Service.class, (String)"fromEc2ServiceAttributes", (NativeType)NativeType.forClass(IBaseService.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    public void addPlacementConstraints(PlacementConstraint ... constraints) {
        Kernel.call((Object)this, (String)"addPlacementConstraints", (NativeType)NativeType.VOID, (Object[])Arrays.stream(constraints).toArray(Object[]::new));
    }

    public void addPlacementStrategies(PlacementStrategy ... strategies) {
        Kernel.call((Object)this, (String)"addPlacementStrategies", (NativeType)NativeType.VOID, (Object[])Arrays.stream(strategies).toArray(Object[]::new));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Ec2Service> {
        private final Construct scope;
        private final String id;
        private final Ec2ServiceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new Ec2ServiceProps.Builder();
        }

        public Builder capacityProviderStrategies(List<? extends CapacityProviderStrategy> capacityProviderStrategies) {
            this.props.capacityProviderStrategies(capacityProviderStrategies);
            return this;
        }

        public Builder circuitBreaker(DeploymentCircuitBreaker circuitBreaker) {
            this.props.circuitBreaker(circuitBreaker);
            return this;
        }

        public Builder cloudMapOptions(CloudMapOptions cloudMapOptions) {
            this.props.cloudMapOptions(cloudMapOptions);
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        public Builder deploymentController(DeploymentController deploymentController) {
            this.props.deploymentController(deploymentController);
            return this;
        }

        public Builder desiredCount(Number desiredCount) {
            this.props.desiredCount(desiredCount);
            return this;
        }

        public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.props.enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        public Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.props.enableExecuteCommand(enableExecuteCommand);
            return this;
        }

        public Builder healthCheckGracePeriod(Duration healthCheckGracePeriod) {
            this.props.healthCheckGracePeriod(healthCheckGracePeriod);
            return this;
        }

        public Builder maxHealthyPercent(Number maxHealthyPercent) {
            this.props.maxHealthyPercent(maxHealthyPercent);
            return this;
        }

        public Builder minHealthyPercent(Number minHealthyPercent) {
            this.props.minHealthyPercent(minHealthyPercent);
            return this;
        }

        public Builder propagateTags(PropagatedTagSource propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.props.serviceName(serviceName);
            return this;
        }

        public Builder taskDefinition(TaskDefinition taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        public Builder assignPublicIp(Boolean assignPublicIp) {
            this.props.assignPublicIp(assignPublicIp);
            return this;
        }

        public Builder daemon(Boolean daemon) {
            this.props.daemon(daemon);
            return this;
        }

        public Builder placementConstraints(List<? extends PlacementConstraint> placementConstraints) {
            this.props.placementConstraints(placementConstraints);
            return this;
        }

        public Builder placementStrategies(List<? extends PlacementStrategy> placementStrategies) {
            this.props.placementStrategies(placementStrategies);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Ec2Service build() {
            return new Ec2Service(this.scope, this.id, this.props.build());
        }
    }
}

