/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.ecs.ContainerDefinitionOptions;
import software.amazon.awscdk.services.ecs.ContainerImage;
import software.amazon.awscdk.services.ecs.EnvironmentFile;
import software.amazon.awscdk.services.ecs.FirelensConfig;
import software.amazon.awscdk.services.ecs.FirelensLogRouterDefinitionOptions;
import software.amazon.awscdk.services.ecs.HealthCheck;
import software.amazon.awscdk.services.ecs.LinuxParameters;
import software.amazon.awscdk.services.ecs.LogDriver;
import software.amazon.awscdk.services.ecs.PortMapping;
import software.amazon.awscdk.services.ecs.Secret;
import software.amazon.awscdk.services.ecs.SystemControl;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.FirelensLogRouterDefinitionOptions")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface FirelensLogRouterDefinitionOptions
extends JsiiSerializable,
ContainerDefinitionOptions {
    @NotNull
    public FirelensConfig getFirelensConfig();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<FirelensLogRouterDefinitionOptions> {
        FirelensConfig firelensConfig;
        List<String> command;
        String containerName;
        Number cpu;
        Boolean disableNetworking;
        List<String> dnsSearchDomains;
        List<String> dnsServers;
        Map<String, String> dockerLabels;
        List<String> dockerSecurityOptions;
        List<String> entryPoint;
        Map<String, String> environment;
        List<EnvironmentFile> environmentFiles;
        Boolean essential;
        Map<String, String> extraHosts;
        Number gpuCount;
        HealthCheck healthCheck;
        String hostname;
        ContainerImage image;
        List<String> inferenceAcceleratorResources;
        LinuxParameters linuxParameters;
        LogDriver logging;
        Number memoryLimitMiB;
        Number memoryReservationMiB;
        List<PortMapping> portMappings;
        Boolean privileged;
        Boolean readonlyRootFilesystem;
        Map<String, Secret> secrets;
        Duration startTimeout;
        Duration stopTimeout;
        List<SystemControl> systemControls;
        String user;
        String workingDirectory;

        public Builder firelensConfig(FirelensConfig firelensConfig) {
            this.firelensConfig = firelensConfig;
            return this;
        }

        public Builder command(List<String> command) {
            this.command = command;
            return this;
        }

        public Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public Builder cpu(Number cpu) {
            this.cpu = cpu;
            return this;
        }

        public Builder disableNetworking(Boolean disableNetworking) {
            this.disableNetworking = disableNetworking;
            return this;
        }

        public Builder dnsSearchDomains(List<String> dnsSearchDomains) {
            this.dnsSearchDomains = dnsSearchDomains;
            return this;
        }

        public Builder dnsServers(List<String> dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        public Builder dockerLabels(Map<String, String> dockerLabels) {
            this.dockerLabels = dockerLabels;
            return this;
        }

        public Builder dockerSecurityOptions(List<String> dockerSecurityOptions) {
            this.dockerSecurityOptions = dockerSecurityOptions;
            return this;
        }

        public Builder entryPoint(List<String> entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.environment = environment;
            return this;
        }

        public Builder environmentFiles(List<? extends EnvironmentFile> environmentFiles) {
            this.environmentFiles = environmentFiles;
            return this;
        }

        public Builder essential(Boolean essential) {
            this.essential = essential;
            return this;
        }

        public Builder extraHosts(Map<String, String> extraHosts) {
            this.extraHosts = extraHosts;
            return this;
        }

        public Builder gpuCount(Number gpuCount) {
            this.gpuCount = gpuCount;
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder image(ContainerImage image) {
            this.image = image;
            return this;
        }

        public Builder inferenceAcceleratorResources(List<String> inferenceAcceleratorResources) {
            this.inferenceAcceleratorResources = inferenceAcceleratorResources;
            return this;
        }

        public Builder linuxParameters(LinuxParameters linuxParameters) {
            this.linuxParameters = linuxParameters;
            return this;
        }

        public Builder logging(LogDriver logging) {
            this.logging = logging;
            return this;
        }

        public Builder memoryLimitMiB(Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        public Builder memoryReservationMiB(Number memoryReservationMiB) {
            this.memoryReservationMiB = memoryReservationMiB;
            return this;
        }

        public Builder portMappings(List<? extends PortMapping> portMappings) {
            this.portMappings = portMappings;
            return this;
        }

        public Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            return this;
        }

        public Builder secrets(Map<String, ? extends Secret> secrets) {
            this.secrets = secrets;
            return this;
        }

        public Builder startTimeout(Duration startTimeout) {
            this.startTimeout = startTimeout;
            return this;
        }

        public Builder stopTimeout(Duration stopTimeout) {
            this.stopTimeout = stopTimeout;
            return this;
        }

        public Builder systemControls(List<? extends SystemControl> systemControls) {
            this.systemControls = systemControls;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public FirelensLogRouterDefinitionOptions build() {
            return new Jsii.Proxy(this);
        }
    }
}

