/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IConnectable;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.rds.DatabaseProxyAttributes;
import software.amazon.awscdk.services.rds.DatabaseProxyProps;
import software.amazon.awscdk.services.rds.IDatabaseProxy;
import software.amazon.awscdk.services.rds.ProxyTarget;
import software.amazon.awscdk.services.rds.SessionPinningFilter;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.awscdk.services.secretsmanager.ISecretAttachmentTarget;
import software.amazon.awscdk.services.secretsmanager.SecretAttachmentTargetProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.DatabaseProxy")
public class DatabaseProxy
extends Resource
implements IConnectable,
ISecretAttachmentTarget,
IDatabaseProxy {
    protected DatabaseProxy(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseProxy(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public DatabaseProxy(@NotNull Construct scope, @NotNull String id, @NotNull DatabaseProxyProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public SecretAttachmentTargetProps asSecretAttachmentTarget() {
        return (SecretAttachmentTargetProps)Kernel.call((Object)this, (String)"asSecretAttachmentTarget", (NativeType)NativeType.forClass(SecretAttachmentTargetProps.class), (Object[])new Object[0]);
    }

    @NotNull
    public static IDatabaseProxy fromDatabaseProxyAttributes(@NotNull Construct scope, @NotNull String id, @NotNull DatabaseProxyAttributes attrs) {
        return (IDatabaseProxy)JsiiObject.jsiiStaticCall(DatabaseProxy.class, (String)"fromDatabaseProxyAttributes", (NativeType)NativeType.forClass(IDatabaseProxy.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public Grant grantConnect(@NotNull IGrantable grantee, @Nullable String dbUser) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantConnect", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required"), dbUser}));
    }

    @Override
    @NotNull
    public Grant grantConnect(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantConnect", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public String getDbProxyArn() {
        return (String)Kernel.get((Object)this, (String)"dbProxyArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getDbProxyName() {
        return (String)Kernel.get((Object)this, (String)"dbProxyName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getEndpoint() {
        return (String)Kernel.get((Object)this, (String)"endpoint", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DatabaseProxy> {
        private final Construct scope;
        private final String id;
        private final DatabaseProxyProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new DatabaseProxyProps.Builder();
        }

        public Builder borrowTimeout(Duration borrowTimeout) {
            this.props.borrowTimeout(borrowTimeout);
            return this;
        }

        public Builder dbProxyName(String dbProxyName) {
            this.props.dbProxyName(dbProxyName);
            return this;
        }

        public Builder debugLogging(Boolean debugLogging) {
            this.props.debugLogging(debugLogging);
            return this;
        }

        public Builder iamAuth(Boolean iamAuth) {
            this.props.iamAuth(iamAuth);
            return this;
        }

        public Builder idleClientTimeout(Duration idleClientTimeout) {
            this.props.idleClientTimeout(idleClientTimeout);
            return this;
        }

        public Builder initQuery(String initQuery) {
            this.props.initQuery(initQuery);
            return this;
        }

        public Builder maxConnectionsPercent(Number maxConnectionsPercent) {
            this.props.maxConnectionsPercent(maxConnectionsPercent);
            return this;
        }

        public Builder maxIdleConnectionsPercent(Number maxIdleConnectionsPercent) {
            this.props.maxIdleConnectionsPercent(maxIdleConnectionsPercent);
            return this;
        }

        public Builder requireTls(Boolean requireTls) {
            this.props.requireTls(requireTls);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder secrets(List<? extends ISecret> secrets) {
            this.props.secrets(secrets);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder sessionPinningFilters(List<? extends SessionPinningFilter> sessionPinningFilters) {
            this.props.sessionPinningFilters(sessionPinningFilters);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Builder proxyTarget(ProxyTarget proxyTarget) {
            this.props.proxyTarget(proxyTarget);
            return this;
        }

        public DatabaseProxy build() {
            return new DatabaseProxy(this.scope, this.id, this.props.build());
        }
    }
}

