/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.autoscaling;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.autoscaling.ApplyCloudFormationInitOptions;
import software.amazon.awscdk.services.autoscaling.AutoScalingGroupProps;
import software.amazon.awscdk.services.autoscaling.BlockDevice;
import software.amazon.awscdk.services.autoscaling.CommonAutoScalingGroupProps;
import software.amazon.awscdk.services.autoscaling.GroupMetrics;
import software.amazon.awscdk.services.autoscaling.HealthCheck;
import software.amazon.awscdk.services.autoscaling.Monitoring;
import software.amazon.awscdk.services.autoscaling.NotificationConfiguration;
import software.amazon.awscdk.services.autoscaling.Signals;
import software.amazon.awscdk.services.autoscaling.UpdatePolicy;
import software.amazon.awscdk.services.ec2.CloudFormationInit;
import software.amazon.awscdk.services.ec2.IMachineImage;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ec2.UserData;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_autoscaling.AutoScalingGroupProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface AutoScalingGroupProps
extends JsiiSerializable,
CommonAutoScalingGroupProps {
    @NotNull
    public InstanceType getInstanceType();

    @NotNull
    public IMachineImage getMachineImage();

    @NotNull
    public IVpc getVpc();

    @Nullable
    default public CloudFormationInit getInit() {
        return null;
    }

    @Nullable
    default public ApplyCloudFormationInitOptions getInitOptions() {
        return null;
    }

    @Nullable
    default public IRole getRole() {
        return null;
    }

    @Nullable
    default public ISecurityGroup getSecurityGroup() {
        return null;
    }

    @Nullable
    default public UserData getUserData() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<AutoScalingGroupProps> {
        private InstanceType instanceType;
        private IMachineImage machineImage;
        private IVpc vpc;
        private CloudFormationInit init;
        private ApplyCloudFormationInitOptions initOptions;
        private IRole role;
        private ISecurityGroup securityGroup;
        private UserData userData;
        private Boolean allowAllOutbound;
        private Boolean associatePublicIpAddress;
        private String autoScalingGroupName;
        private List<BlockDevice> blockDevices;
        private Duration cooldown;
        private Number desiredCapacity;
        private List<GroupMetrics> groupMetrics;
        private HealthCheck healthCheck;
        private Boolean ignoreUnmodifiedSizeProperties;
        private Monitoring instanceMonitoring;
        private String keyName;
        private Number maxCapacity;
        private Duration maxInstanceLifetime;
        private Number minCapacity;
        private Boolean newInstancesProtectedFromScaleIn;
        private List<NotificationConfiguration> notifications;
        private Signals signals;
        private String spotPrice;
        private UpdatePolicy updatePolicy;
        private SubnetSelection vpcSubnets;

        public Builder instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder machineImage(IMachineImage machineImage) {
            this.machineImage = machineImage;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder init(CloudFormationInit init) {
            this.init = init;
            return this;
        }

        public Builder initOptions(ApplyCloudFormationInitOptions initOptions) {
            this.initOptions = initOptions;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public Builder userData(UserData userData) {
            this.userData = userData;
            return this;
        }

        public Builder allowAllOutbound(Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        public Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public Builder blockDevices(List<? extends BlockDevice> blockDevices) {
            this.blockDevices = blockDevices;
            return this;
        }

        public Builder cooldown(Duration cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder desiredCapacity(Number desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public Builder groupMetrics(List<? extends GroupMetrics> groupMetrics) {
            this.groupMetrics = groupMetrics;
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder ignoreUnmodifiedSizeProperties(Boolean ignoreUnmodifiedSizeProperties) {
            this.ignoreUnmodifiedSizeProperties = ignoreUnmodifiedSizeProperties;
            return this;
        }

        public Builder instanceMonitoring(Monitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        public Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public Builder maxCapacity(Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public Builder maxInstanceLifetime(Duration maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
            return this;
        }

        public Builder minCapacity(Number minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public Builder notifications(List<? extends NotificationConfiguration> notifications) {
            this.notifications = notifications;
            return this;
        }

        public Builder signals(Signals signals) {
            this.signals = signals;
            return this;
        }

        public Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public Builder updatePolicy(UpdatePolicy updatePolicy) {
            this.updatePolicy = updatePolicy;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public AutoScalingGroupProps build() {
            return new Jsii.Proxy(this.instanceType, this.machineImage, this.vpc, this.init, this.initOptions, this.role, this.securityGroup, this.userData, this.allowAllOutbound, this.associatePublicIpAddress, this.autoScalingGroupName, this.blockDevices, this.cooldown, this.desiredCapacity, this.groupMetrics, this.healthCheck, this.ignoreUnmodifiedSizeProperties, this.instanceMonitoring, this.keyName, this.maxCapacity, this.maxInstanceLifetime, this.minCapacity, this.newInstancesProtectedFromScaleIn, this.notifications, this.signals, this.spotPrice, this.updatePolicy, this.vpcSubnets);
        }
    }
}

