/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudwatch;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.services.cloudwatch.ConcreteWidget;
import software.amazon.awscdk.services.cloudwatch.GraphWidgetProps;
import software.amazon.awscdk.services.cloudwatch.GraphWidgetView;
import software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation;
import software.amazon.awscdk.services.cloudwatch.IMetric;
import software.amazon.awscdk.services.cloudwatch.LegendPosition;
import software.amazon.awscdk.services.cloudwatch.YAxisProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_cloudwatch.GraphWidget")
public class GraphWidget
extends ConcreteWidget {
    protected GraphWidget(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GraphWidget(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public GraphWidget(@NotNull GraphWidgetProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public void addLeftMetric(@NotNull IMetric metric) {
        Kernel.call((Object)this, (String)"addLeftMetric", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(metric, "metric is required")});
    }

    public void addRightMetric(@NotNull IMetric metric) {
        Kernel.call((Object)this, (String)"addRightMetric", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(metric, "metric is required")});
    }

    @Override
    @NotNull
    public List<Object> toJson() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"toJson", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[0]));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<GraphWidget> {
        private final GraphWidgetProps.Builder props = new GraphWidgetProps.Builder();

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder height(Number height) {
            this.props.height(height);
            return this;
        }

        public Builder region(String region) {
            this.props.region(region);
            return this;
        }

        public Builder title(String title) {
            this.props.title(title);
            return this;
        }

        public Builder width(Number width) {
            this.props.width(width);
            return this;
        }

        public Builder left(List<? extends IMetric> left) {
            this.props.left(left);
            return this;
        }

        public Builder leftAnnotations(List<? extends HorizontalAnnotation> leftAnnotations) {
            this.props.leftAnnotations(leftAnnotations);
            return this;
        }

        public Builder leftYAxis(YAxisProps leftYAxis) {
            this.props.leftYAxis(leftYAxis);
            return this;
        }

        public Builder legendPosition(LegendPosition legendPosition) {
            this.props.legendPosition(legendPosition);
            return this;
        }

        public Builder liveData(Boolean liveData) {
            this.props.liveData(liveData);
            return this;
        }

        public Builder right(List<? extends IMetric> right) {
            this.props.right(right);
            return this;
        }

        public Builder rightAnnotations(List<? extends HorizontalAnnotation> rightAnnotations) {
            this.props.rightAnnotations(rightAnnotations);
            return this;
        }

        public Builder rightYAxis(YAxisProps rightYAxis) {
            this.props.rightYAxis(rightYAxis);
            return this;
        }

        public Builder setPeriodToTimeRange(Boolean setPeriodToTimeRange) {
            this.props.setPeriodToTimeRange(setPeriodToTimeRange);
            return this;
        }

        public Builder stacked(Boolean stacked) {
            this.props.stacked(stacked);
            return this;
        }

        public Builder view(GraphWidgetView view) {
            this.props.view(view);
            return this;
        }

        public GraphWidget build() {
            return new GraphWidget(this.props.build());
        }
    }
}

