/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.IResource;
import software.amazon.awscdk.services.codepipeline.ActionArtifactBounds;
import software.amazon.awscdk.services.codepipeline.ActionCategory;
import software.amazon.awscdk.services.codepipeline.ActionProperties;
import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codepipeline.ActionProperties")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface ActionProperties
extends JsiiSerializable {
    @NotNull
    public String getActionName();

    @NotNull
    public ActionArtifactBounds getArtifactBounds();

    @NotNull
    public ActionCategory getCategory();

    @NotNull
    public String getProvider();

    @Nullable
    default public String getAccount() {
        return null;
    }

    @Nullable
    default public List<Artifact> getInputs() {
        return null;
    }

    @Nullable
    default public List<Artifact> getOutputs() {
        return null;
    }

    @Nullable
    default public String getOwner() {
        return null;
    }

    @Nullable
    default public String getRegion() {
        return null;
    }

    @Nullable
    default public IResource getResource() {
        return null;
    }

    @Nullable
    default public IRole getRole() {
        return null;
    }

    @Nullable
    default public Number getRunOrder() {
        return null;
    }

    @Nullable
    default public String getVariablesNamespace() {
        return null;
    }

    @Nullable
    default public String getVersion() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ActionProperties> {
        private String actionName;
        private ActionArtifactBounds artifactBounds;
        private ActionCategory category;
        private String provider;
        private String account;
        private List<Artifact> inputs;
        private List<Artifact> outputs;
        private String owner;
        private String region;
        private IResource resource;
        private IRole role;
        private Number runOrder;
        private String variablesNamespace;
        private String version;

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public Builder artifactBounds(ActionArtifactBounds artifactBounds) {
            this.artifactBounds = artifactBounds;
            return this;
        }

        public Builder category(ActionCategory category) {
            this.category = category;
            return this;
        }

        public Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder inputs(List<? extends Artifact> inputs) {
            this.inputs = inputs;
            return this;
        }

        public Builder outputs(List<? extends Artifact> outputs) {
            this.outputs = outputs;
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder resource(IResource resource) {
            this.resource = resource;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder runOrder(Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        public Builder variablesNamespace(String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public ActionProperties build() {
            return new Jsii.Proxy(this.actionName, this.artifactBounds, this.category, this.provider, this.account, this.inputs, this.outputs, this.owner, this.region, this.resource, this.role, this.runOrder, this.variablesNamespace, this.version);
        }
    }
}

