/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.databrew;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.databrew.CfnDataset;
import software.amazon.awscdk.services.databrew.CfnDatasetProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_databrew.CfnDataset")
public class CfnDataset
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDataset.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDataset(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataset(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDataset(@NotNull Construct scope, @NotNull String id, @NotNull CfnDatasetProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getInput() {
        return Kernel.get((Object)this, (String)"input", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInput(@NotNull InputProperty value) {
        Kernel.set((Object)this, (String)"input", (Object)Objects.requireNonNull(value, "input is required"));
    }

    public void setInput(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"input", (Object)Objects.requireNonNull(value, "input is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public String getFormat() {
        return (String)Kernel.get((Object)this, (String)"format", (NativeType)NativeType.forClass(String.class));
    }

    public void setFormat(@Nullable String value) {
        Kernel.set((Object)this, (String)"format", (Object)value);
    }

    @Nullable
    public Object getFormatOptions() {
        return Kernel.get((Object)this, (String)"formatOptions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setFormatOptions(@Nullable FormatOptionsProperty value) {
        Kernel.set((Object)this, (String)"formatOptions", (Object)value);
    }

    public void setFormatOptions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"formatOptions", (Object)value);
    }

    @Nullable
    public Object getPathOptions() {
        return Kernel.get((Object)this, (String)"pathOptions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPathOptions(@Nullable PathOptionsProperty value) {
        Kernel.set((Object)this, (String)"pathOptions", (Object)value);
    }

    public void setPathOptions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"pathOptions", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDataset> {
        private final Construct scope;
        private final String id;
        private final CfnDatasetProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDatasetProps.Builder();
        }

        public Builder input(InputProperty input) {
            this.props.input(input);
            return this;
        }

        public Builder input(IResolvable input) {
            this.props.input(input);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder format(String format) {
            this.props.format(format);
            return this;
        }

        public Builder formatOptions(FormatOptionsProperty formatOptions) {
            this.props.formatOptions(formatOptions);
            return this;
        }

        public Builder formatOptions(IResolvable formatOptions) {
            this.props.formatOptions(formatOptions);
            return this;
        }

        public Builder pathOptions(PathOptionsProperty pathOptions) {
            this.props.pathOptions(pathOptions);
            return this;
        }

        public Builder pathOptions(IResolvable pathOptions) {
            this.props.pathOptions(pathOptions);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnDataset build() {
            return new CfnDataset(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_databrew.CfnDataset.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @Nullable
        default public String getKey() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LocationProperty> {
            private String bucket;
            private String key;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this.bucket, this.key);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_databrew.CfnDataset.PathParameterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PathParameterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDatasetParameter();

        @NotNull
        public String getPathParameterName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PathParameterProperty> {
            private Object datasetParameter;
            private String pathParameterName;

            public Builder datasetParameter(DatasetParameterProperty datasetParameter) {
                this.datasetParameter = datasetParameter;
                return this;
            }

            public Builder datasetParameter(IResolvable datasetParameter) {
                this.datasetParameter = datasetParameter;
                return this;
            }

            public Builder pathParameterName(String pathParameterName) {
                this.pathParameterName = pathParameterName;
                return this;
            }

            public PathParameterProperty build() {
                return new Jsii.Proxy(this.datasetParameter, this.pathParameterName);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_databrew.CfnDataset.PathOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PathOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFilesLimit() {
            return null;
        }

        @Nullable
        default public Object getLastModifiedDateCondition() {
            return null;
        }

        @Nullable
        default public Object getParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PathOptionsProperty> {
            private Object filesLimit;
            private Object lastModifiedDateCondition;
            private Object parameters;

            public Builder filesLimit(FilesLimitProperty filesLimit) {
                this.filesLimit = filesLimit;
                return this;
            }

            public Builder filesLimit(IResolvable filesLimit) {
                this.filesLimit = filesLimit;
                return this;
            }

            public Builder lastModifiedDateCondition(FilterExpressionProperty lastModifiedDateCondition) {
                this.lastModifiedDateCondition = lastModifiedDateCondition;
                return this;
            }

            public Builder lastModifiedDateCondition(IResolvable lastModifiedDateCondition) {
                this.lastModifiedDateCondition = lastModifiedDateCondition;
                return this;
            }

            public Builder parameters(IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            public Builder parameters(List<? extends Object> parameters) {
                this.parameters = parameters;
                return this;
            }

            public PathOptionsProperty build() {
                return new Jsii.Proxy(this.filesLimit, this.lastModifiedDateCondition, this.parameters);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_databrew.CfnDataset.JsonOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JsonOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getMultiLine() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JsonOptionsProperty> {
            private Object multiLine;

            public Builder multiLine(Boolean multiLine) {
                this.multiLine = multiLine;
                return this;
            }

            public Builder multiLine(IResolvable multiLine) {
                this.multiLine = multiLine;
                return this;
            }

            public JsonOptionsProperty build() {
                return new Jsii.Proxy(this.multiLine);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_databrew.CfnDataset.InputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDatabaseInputDefinition() {
            return null;
        }

        @Nullable
        default public Object getDataCatalogInputDefinition() {
            return null;
        }

        @Nullable
        default public Object getS3InputDefinition() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputProperty> {
            private Object databaseInputDefinition;
            private Object dataCatalogInputDefinition;
            private Object s3InputDefinition;

            public Builder databaseInputDefinition(DatabaseInputDefinitionProperty databaseInputDefinition) {
                this.databaseInputDefinition = databaseInputDefinition;
                return this;
            }

            public Builder databaseInputDefinition(IResolvable databaseInputDefinition) {
                this.databaseInputDefinition = databaseInputDefinition;
                return this;
            }

            public Builder dataCatalogInputDefinition(DataCatalogInputDefinitionProperty dataCatalogInputDefinition) {
                this.dataCatalogInputDefinition = dataCatalogInputDefinition;
                return this;
            }

            public Builder dataCatalogInputDefinition(IResolvable dataCatalogInputDefinition) {
                this.dataCatalogInputDefinition = dataCatalogInputDefinition;
                return this;
            }

            public Builder s3InputDefinition(S3LocationProperty s3InputDefinition) {
                this.s3InputDefinition = s3InputDefinition;
                return this;
            }

            public Builder s3InputDefinition(IResolvable s3InputDefinition) {
                this.s3InputDefinition = s3InputDefinition;
                return this;
            }

            public InputProperty build() {
                return new Jsii.Proxy(this.databaseInputDefinition, this.dataCatalogInputDefinition, this.s3InputDefinition);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_databrew.CfnDataset.FormatOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FormatOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCsv() {
            return null;
        }

        @Nullable
        default public Object getExcel() {
            return null;
        }

        @Nullable
        default public Object getJson() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FormatOptionsProperty> {
            private Object csv;
            private Object excel;
            private Object json;

            public Builder csv(CsvOptionsProperty csv) {
                this.csv = csv;
                return this;
            }

            public Builder csv(IResolvable csv) {
                this.csv = csv;
                return this;
            }

            public Builder excel(ExcelOptionsProperty excel) {
                this.excel = excel;
                return this;
            }

            public Builder excel(IResolvable excel) {
                this.excel = excel;
                return this;
            }

            public Builder json(JsonOptionsProperty json) {
                this.json = json;
                return this;
            }

            public Builder json(IResolvable json) {
                this.json = json;
                return this;
            }

            public FormatOptionsProperty build() {
                return new Jsii.Proxy(this.csv, this.excel, this.json);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_databrew.CfnDataset.FilterValueProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterValueProperty
    extends JsiiSerializable {
        @NotNull
        public String getValue();

        @NotNull
        public String getValueReference();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterValueProperty> {
            private String value;
            private String valueReference;

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Builder valueReference(String valueReference) {
                this.valueReference = valueReference;
                return this;
            }

            public FilterValueProperty build() {
                return new Jsii.Proxy(this.value, this.valueReference);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_databrew.CfnDataset.FilterExpressionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterExpressionProperty
    extends JsiiSerializable {
        @NotNull
        public String getExpression();

        @NotNull
        public Object getValuesMap();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterExpressionProperty> {
            private String expression;
            private Object valuesMap;

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public Builder valuesMap(IResolvable valuesMap) {
                this.valuesMap = valuesMap;
                return this;
            }

            public Builder valuesMap(List<? extends Object> valuesMap) {
                this.valuesMap = valuesMap;
                return this;
            }

            public FilterExpressionProperty build() {
                return new Jsii.Proxy(this.expression, this.valuesMap);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_databrew.CfnDataset.FilesLimitProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilesLimitProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaxFiles();

        @Nullable
        default public String getOrder() {
            return null;
        }

        @Nullable
        default public String getOrderedBy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilesLimitProperty> {
            private Number maxFiles;
            private String order;
            private String orderedBy;

            public Builder maxFiles(Number maxFiles) {
                this.maxFiles = maxFiles;
                return this;
            }

            public Builder order(String order) {
                this.order = order;
                return this;
            }

            public Builder orderedBy(String orderedBy) {
                this.orderedBy = orderedBy;
                return this;
            }

            public FilesLimitProperty build() {
                return new Jsii.Proxy(this.maxFiles, this.order, this.orderedBy);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_databrew.CfnDataset.ExcelOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ExcelOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getHeaderRow() {
            return null;
        }

        @Nullable
        default public Object getSheetIndexes() {
            return null;
        }

        @Nullable
        default public List<String> getSheetNames() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ExcelOptionsProperty> {
            private Object headerRow;
            private Object sheetIndexes;
            private List<String> sheetNames;

            public Builder headerRow(Boolean headerRow) {
                this.headerRow = headerRow;
                return this;
            }

            public Builder headerRow(IResolvable headerRow) {
                this.headerRow = headerRow;
                return this;
            }

            public Builder sheetIndexes(IResolvable sheetIndexes) {
                this.sheetIndexes = sheetIndexes;
                return this;
            }

            public Builder sheetIndexes(List<? extends Number> sheetIndexes) {
                this.sheetIndexes = sheetIndexes;
                return this;
            }

            public Builder sheetNames(List<String> sheetNames) {
                this.sheetNames = sheetNames;
                return this;
            }

            public ExcelOptionsProperty build() {
                return new Jsii.Proxy(this.headerRow, this.sheetIndexes, this.sheetNames);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_databrew.CfnDataset.DatetimeOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DatetimeOptionsProperty
    extends JsiiSerializable {
        @NotNull
        public String getFormat();

        @Nullable
        default public String getLocaleCode() {
            return null;
        }

        @Nullable
        default public String getTimezoneOffset() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DatetimeOptionsProperty> {
            private String format;
            private String localeCode;
            private String timezoneOffset;

            public Builder format(String format) {
                this.format = format;
                return this;
            }

            public Builder localeCode(String localeCode) {
                this.localeCode = localeCode;
                return this;
            }

            public Builder timezoneOffset(String timezoneOffset) {
                this.timezoneOffset = timezoneOffset;
                return this;
            }

            public DatetimeOptionsProperty build() {
                return new Jsii.Proxy(this.format, this.localeCode, this.timezoneOffset);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_databrew.CfnDataset.DatasetParameterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DatasetParameterProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getType();

        @Nullable
        default public Object getCreateColumn() {
            return null;
        }

        @Nullable
        default public Object getDatetimeOptions() {
            return null;
        }

        @Nullable
        default public Object getFilter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DatasetParameterProperty> {
            private String name;
            private String type;
            private Object createColumn;
            private Object datetimeOptions;
            private Object filter;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder createColumn(Boolean createColumn) {
                this.createColumn = createColumn;
                return this;
            }

            public Builder createColumn(IResolvable createColumn) {
                this.createColumn = createColumn;
                return this;
            }

            public Builder datetimeOptions(DatetimeOptionsProperty datetimeOptions) {
                this.datetimeOptions = datetimeOptions;
                return this;
            }

            public Builder datetimeOptions(IResolvable datetimeOptions) {
                this.datetimeOptions = datetimeOptions;
                return this;
            }

            public Builder filter(FilterExpressionProperty filter) {
                this.filter = filter;
                return this;
            }

            public Builder filter(IResolvable filter) {
                this.filter = filter;
                return this;
            }

            public DatasetParameterProperty build() {
                return new Jsii.Proxy(this.name, this.type, this.createColumn, this.datetimeOptions, this.filter);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_databrew.CfnDataset.DatabaseInputDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DatabaseInputDefinitionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDatabaseTableName() {
            return null;
        }

        @Nullable
        default public String getGlueConnectionName() {
            return null;
        }

        @Nullable
        default public Object getTempDirectory() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DatabaseInputDefinitionProperty> {
            private String databaseTableName;
            private String glueConnectionName;
            private Object tempDirectory;

            public Builder databaseTableName(String databaseTableName) {
                this.databaseTableName = databaseTableName;
                return this;
            }

            public Builder glueConnectionName(String glueConnectionName) {
                this.glueConnectionName = glueConnectionName;
                return this;
            }

            public Builder tempDirectory(S3LocationProperty tempDirectory) {
                this.tempDirectory = tempDirectory;
                return this;
            }

            public Builder tempDirectory(IResolvable tempDirectory) {
                this.tempDirectory = tempDirectory;
                return this;
            }

            public DatabaseInputDefinitionProperty build() {
                return new Jsii.Proxy(this.databaseTableName, this.glueConnectionName, this.tempDirectory);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_databrew.CfnDataset.DataCatalogInputDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataCatalogInputDefinitionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCatalogId() {
            return null;
        }

        @Nullable
        default public String getDatabaseName() {
            return null;
        }

        @Nullable
        default public String getTableName() {
            return null;
        }

        @Nullable
        default public Object getTempDirectory() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataCatalogInputDefinitionProperty> {
            private String catalogId;
            private String databaseName;
            private String tableName;
            private Object tempDirectory;

            public Builder catalogId(String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public Builder tempDirectory(S3LocationProperty tempDirectory) {
                this.tempDirectory = tempDirectory;
                return this;
            }

            public Builder tempDirectory(IResolvable tempDirectory) {
                this.tempDirectory = tempDirectory;
                return this;
            }

            public DataCatalogInputDefinitionProperty build() {
                return new Jsii.Proxy(this.catalogId, this.databaseName, this.tableName, this.tempDirectory);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_databrew.CfnDataset.CsvOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CsvOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDelimiter() {
            return null;
        }

        @Nullable
        default public Object getHeaderRow() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CsvOptionsProperty> {
            private String delimiter;
            private Object headerRow;

            public Builder delimiter(String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            public Builder headerRow(Boolean headerRow) {
                this.headerRow = headerRow;
                return this;
            }

            public Builder headerRow(IResolvable headerRow) {
                this.headerRow = headerRow;
                return this;
            }

            public CsvOptionsProperty build() {
                return new Jsii.Proxy(this.delimiter, this.headerRow);
            }
        }
    }
}

