/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.ec2.CfnSpotFleet;
import software.amazon.awscdk.services.ec2.CfnSpotFleetProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet")
public class CfnSpotFleet
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnSpotFleet.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnSpotFleet(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSpotFleet(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnSpotFleet(@NotNull Construct scope, @NotNull String id, @NotNull CfnSpotFleetProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getSpotFleetRequestConfigData() {
        return Kernel.get((Object)this, (String)"spotFleetRequestConfigData", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSpotFleetRequestConfigData(@NotNull SpotFleetRequestConfigDataProperty value) {
        Kernel.set((Object)this, (String)"spotFleetRequestConfigData", (Object)Objects.requireNonNull(value, "spotFleetRequestConfigData is required"));
    }

    public void setSpotFleetRequestConfigData(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"spotFleetRequestConfigData", (Object)Objects.requireNonNull(value, "spotFleetRequestConfigData is required"));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnSpotFleet> {
        private final Construct scope;
        private final String id;
        private final CfnSpotFleetProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnSpotFleetProps.Builder();
        }

        public Builder spotFleetRequestConfigData(SpotFleetRequestConfigDataProperty spotFleetRequestConfigData) {
            this.props.spotFleetRequestConfigData(spotFleetRequestConfigData);
            return this;
        }

        public Builder spotFleetRequestConfigData(IResolvable spotFleetRequestConfigData) {
            this.props.spotFleetRequestConfigData(spotFleetRequestConfigData);
            return this;
        }

        public CfnSpotFleet build() {
            return new CfnSpotFleet(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.TargetGroupsConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TargetGroupsConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getTargetGroups();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TargetGroupsConfigProperty> {
            private Object targetGroups;

            public Builder targetGroups(IResolvable targetGroups) {
                this.targetGroups = targetGroups;
                return this;
            }

            public Builder targetGroups(List<? extends Object> targetGroups) {
                this.targetGroups = targetGroups;
                return this;
            }

            public TargetGroupsConfigProperty build() {
                return new Jsii.Proxy(this.targetGroups);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.TargetGroupProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TargetGroupProperty
    extends JsiiSerializable {
        @NotNull
        public String getArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TargetGroupProperty> {
            private String arn;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public TargetGroupProperty build() {
                return new Jsii.Proxy(this.arn);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.SpotPlacementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpotPlacementProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAvailabilityZone() {
            return null;
        }

        @Nullable
        default public String getGroupName() {
            return null;
        }

        @Nullable
        default public String getTenancy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpotPlacementProperty> {
            private String availabilityZone;
            private String groupName;
            private String tenancy;

            public Builder availabilityZone(String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            public Builder groupName(String groupName) {
                this.groupName = groupName;
                return this;
            }

            public Builder tenancy(String tenancy) {
                this.tenancy = tenancy;
                return this;
            }

            public SpotPlacementProperty build() {
                return new Jsii.Proxy(this.availabilityZone, this.groupName, this.tenancy);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.SpotMaintenanceStrategiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpotMaintenanceStrategiesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCapacityRebalance() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpotMaintenanceStrategiesProperty> {
            private Object capacityRebalance;

            public Builder capacityRebalance(SpotCapacityRebalanceProperty capacityRebalance) {
                this.capacityRebalance = capacityRebalance;
                return this;
            }

            public Builder capacityRebalance(IResolvable capacityRebalance) {
                this.capacityRebalance = capacityRebalance;
                return this;
            }

            public SpotMaintenanceStrategiesProperty build() {
                return new Jsii.Proxy(this.capacityRebalance);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.SpotFleetTagSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpotFleetTagSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getResourceType() {
            return null;
        }

        @Nullable
        default public List<CfnTag> getTags() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpotFleetTagSpecificationProperty> {
            private String resourceType;
            private List<CfnTag> tags;

            public Builder resourceType(String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            public Builder tags(List<? extends CfnTag> tags) {
                this.tags = tags;
                return this;
            }

            public SpotFleetTagSpecificationProperty build() {
                return new Jsii.Proxy(this.resourceType, this.tags);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpotFleetRequestConfigDataProperty
    extends JsiiSerializable {
        @NotNull
        public String getIamFleetRole();

        @NotNull
        public Number getTargetCapacity();

        @Nullable
        default public String getAllocationStrategy() {
            return null;
        }

        @Nullable
        default public String getExcessCapacityTerminationPolicy() {
            return null;
        }

        @Nullable
        default public String getInstanceInterruptionBehavior() {
            return null;
        }

        @Nullable
        default public Number getInstancePoolsToUseCount() {
            return null;
        }

        @Nullable
        default public Object getLaunchSpecifications() {
            return null;
        }

        @Nullable
        default public Object getLaunchTemplateConfigs() {
            return null;
        }

        @Nullable
        default public Object getLoadBalancersConfig() {
            return null;
        }

        @Nullable
        default public String getOnDemandAllocationStrategy() {
            return null;
        }

        @Nullable
        default public String getOnDemandMaxTotalPrice() {
            return null;
        }

        @Nullable
        default public Number getOnDemandTargetCapacity() {
            return null;
        }

        @Nullable
        default public Object getReplaceUnhealthyInstances() {
            return null;
        }

        @Nullable
        default public Object getSpotMaintenanceStrategies() {
            return null;
        }

        @Nullable
        default public String getSpotMaxTotalPrice() {
            return null;
        }

        @Nullable
        default public String getSpotPrice() {
            return null;
        }

        @Nullable
        default public Object getTerminateInstancesWithExpiration() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        @Nullable
        default public String getValidFrom() {
            return null;
        }

        @Nullable
        default public String getValidUntil() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpotFleetRequestConfigDataProperty> {
            private String iamFleetRole;
            private Number targetCapacity;
            private String allocationStrategy;
            private String excessCapacityTerminationPolicy;
            private String instanceInterruptionBehavior;
            private Number instancePoolsToUseCount;
            private Object launchSpecifications;
            private Object launchTemplateConfigs;
            private Object loadBalancersConfig;
            private String onDemandAllocationStrategy;
            private String onDemandMaxTotalPrice;
            private Number onDemandTargetCapacity;
            private Object replaceUnhealthyInstances;
            private Object spotMaintenanceStrategies;
            private String spotMaxTotalPrice;
            private String spotPrice;
            private Object terminateInstancesWithExpiration;
            private String type;
            private String validFrom;
            private String validUntil;

            public Builder iamFleetRole(String iamFleetRole) {
                this.iamFleetRole = iamFleetRole;
                return this;
            }

            public Builder targetCapacity(Number targetCapacity) {
                this.targetCapacity = targetCapacity;
                return this;
            }

            public Builder allocationStrategy(String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            public Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
                this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
                return this;
            }

            public Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                return this;
            }

            public Builder instancePoolsToUseCount(Number instancePoolsToUseCount) {
                this.instancePoolsToUseCount = instancePoolsToUseCount;
                return this;
            }

            public Builder launchSpecifications(IResolvable launchSpecifications) {
                this.launchSpecifications = launchSpecifications;
                return this;
            }

            public Builder launchSpecifications(List<? extends Object> launchSpecifications) {
                this.launchSpecifications = launchSpecifications;
                return this;
            }

            public Builder launchTemplateConfigs(IResolvable launchTemplateConfigs) {
                this.launchTemplateConfigs = launchTemplateConfigs;
                return this;
            }

            public Builder launchTemplateConfigs(List<? extends Object> launchTemplateConfigs) {
                this.launchTemplateConfigs = launchTemplateConfigs;
                return this;
            }

            public Builder loadBalancersConfig(LoadBalancersConfigProperty loadBalancersConfig) {
                this.loadBalancersConfig = loadBalancersConfig;
                return this;
            }

            public Builder loadBalancersConfig(IResolvable loadBalancersConfig) {
                this.loadBalancersConfig = loadBalancersConfig;
                return this;
            }

            public Builder onDemandAllocationStrategy(String onDemandAllocationStrategy) {
                this.onDemandAllocationStrategy = onDemandAllocationStrategy;
                return this;
            }

            public Builder onDemandMaxTotalPrice(String onDemandMaxTotalPrice) {
                this.onDemandMaxTotalPrice = onDemandMaxTotalPrice;
                return this;
            }

            public Builder onDemandTargetCapacity(Number onDemandTargetCapacity) {
                this.onDemandTargetCapacity = onDemandTargetCapacity;
                return this;
            }

            public Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
                this.replaceUnhealthyInstances = replaceUnhealthyInstances;
                return this;
            }

            public Builder replaceUnhealthyInstances(IResolvable replaceUnhealthyInstances) {
                this.replaceUnhealthyInstances = replaceUnhealthyInstances;
                return this;
            }

            public Builder spotMaintenanceStrategies(SpotMaintenanceStrategiesProperty spotMaintenanceStrategies) {
                this.spotMaintenanceStrategies = spotMaintenanceStrategies;
                return this;
            }

            public Builder spotMaintenanceStrategies(IResolvable spotMaintenanceStrategies) {
                this.spotMaintenanceStrategies = spotMaintenanceStrategies;
                return this;
            }

            public Builder spotMaxTotalPrice(String spotMaxTotalPrice) {
                this.spotMaxTotalPrice = spotMaxTotalPrice;
                return this;
            }

            public Builder spotPrice(String spotPrice) {
                this.spotPrice = spotPrice;
                return this;
            }

            public Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
                this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
                return this;
            }

            public Builder terminateInstancesWithExpiration(IResolvable terminateInstancesWithExpiration) {
                this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder validFrom(String validFrom) {
                this.validFrom = validFrom;
                return this;
            }

            public Builder validUntil(String validUntil) {
                this.validUntil = validUntil;
                return this;
            }

            public SpotFleetRequestConfigDataProperty build() {
                return new Jsii.Proxy(this.iamFleetRole, this.targetCapacity, this.allocationStrategy, this.excessCapacityTerminationPolicy, this.instanceInterruptionBehavior, this.instancePoolsToUseCount, this.launchSpecifications, this.launchTemplateConfigs, this.loadBalancersConfig, this.onDemandAllocationStrategy, this.onDemandMaxTotalPrice, this.onDemandTargetCapacity, this.replaceUnhealthyInstances, this.spotMaintenanceStrategies, this.spotMaxTotalPrice, this.spotPrice, this.terminateInstancesWithExpiration, this.type, this.validFrom, this.validUntil);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.SpotFleetMonitoringProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpotFleetMonitoringProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpotFleetMonitoringProperty> {
            private Object enabled;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public SpotFleetMonitoringProperty build() {
                return new Jsii.Proxy(this.enabled);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.SpotFleetLaunchSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpotFleetLaunchSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getImageId();

        @NotNull
        public String getInstanceType();

        @Nullable
        default public Object getBlockDeviceMappings() {
            return null;
        }

        @Nullable
        default public Object getEbsOptimized() {
            return null;
        }

        @Nullable
        default public Object getIamInstanceProfile() {
            return null;
        }

        @Nullable
        default public String getKernelId() {
            return null;
        }

        @Nullable
        default public String getKeyName() {
            return null;
        }

        @Nullable
        default public Object getMonitoring() {
            return null;
        }

        @Nullable
        default public Object getNetworkInterfaces() {
            return null;
        }

        @Nullable
        default public Object getPlacement() {
            return null;
        }

        @Nullable
        default public String getRamdiskId() {
            return null;
        }

        @Nullable
        default public Object getSecurityGroups() {
            return null;
        }

        @Nullable
        default public String getSpotPrice() {
            return null;
        }

        @Nullable
        default public String getSubnetId() {
            return null;
        }

        @Nullable
        default public Object getTagSpecifications() {
            return null;
        }

        @Nullable
        default public String getUserData() {
            return null;
        }

        @Nullable
        default public Number getWeightedCapacity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpotFleetLaunchSpecificationProperty> {
            private String imageId;
            private String instanceType;
            private Object blockDeviceMappings;
            private Object ebsOptimized;
            private Object iamInstanceProfile;
            private String kernelId;
            private String keyName;
            private Object monitoring;
            private Object networkInterfaces;
            private Object placement;
            private String ramdiskId;
            private Object securityGroups;
            private String spotPrice;
            private String subnetId;
            private Object tagSpecifications;
            private String userData;
            private Number weightedCapacity;

            public Builder imageId(String imageId) {
                this.imageId = imageId;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder blockDeviceMappings(IResolvable blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            public Builder blockDeviceMappings(List<? extends Object> blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            public Builder ebsOptimized(Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            public Builder ebsOptimized(IResolvable ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            public Builder iamInstanceProfile(IamInstanceProfileSpecificationProperty iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            public Builder iamInstanceProfile(IResolvable iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            public Builder kernelId(String kernelId) {
                this.kernelId = kernelId;
                return this;
            }

            public Builder keyName(String keyName) {
                this.keyName = keyName;
                return this;
            }

            public Builder monitoring(SpotFleetMonitoringProperty monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            public Builder monitoring(IResolvable monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            public Builder networkInterfaces(IResolvable networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            public Builder networkInterfaces(List<? extends Object> networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            public Builder placement(SpotPlacementProperty placement) {
                this.placement = placement;
                return this;
            }

            public Builder placement(IResolvable placement) {
                this.placement = placement;
                return this;
            }

            public Builder ramdiskId(String ramdiskId) {
                this.ramdiskId = ramdiskId;
                return this;
            }

            public Builder securityGroups(IResolvable securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public Builder securityGroups(List<? extends Object> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public Builder spotPrice(String spotPrice) {
                this.spotPrice = spotPrice;
                return this;
            }

            public Builder subnetId(String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            public Builder tagSpecifications(IResolvable tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            public Builder tagSpecifications(List<? extends Object> tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            public Builder userData(String userData) {
                this.userData = userData;
                return this;
            }

            public Builder weightedCapacity(Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            public SpotFleetLaunchSpecificationProperty build() {
                return new Jsii.Proxy(this.imageId, this.instanceType, this.blockDeviceMappings, this.ebsOptimized, this.iamInstanceProfile, this.kernelId, this.keyName, this.monitoring, this.networkInterfaces, this.placement, this.ramdiskId, this.securityGroups, this.spotPrice, this.subnetId, this.tagSpecifications, this.userData, this.weightedCapacity);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.SpotCapacityRebalanceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpotCapacityRebalanceProperty
    extends JsiiSerializable {
        @Nullable
        default public String getReplacementStrategy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpotCapacityRebalanceProperty> {
            private String replacementStrategy;

            public Builder replacementStrategy(String replacementStrategy) {
                this.replacementStrategy = replacementStrategy;
                return this;
            }

            public SpotCapacityRebalanceProperty build() {
                return new Jsii.Proxy(this.replacementStrategy);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.PrivateIpAddressSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PrivateIpAddressSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getPrivateIpAddress();

        @Nullable
        default public Object getPrimary() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PrivateIpAddressSpecificationProperty> {
            private String privateIpAddress;
            private Object primary;

            public Builder privateIpAddress(String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            public Builder primary(Boolean primary) {
                this.primary = primary;
                return this;
            }

            public Builder primary(IResolvable primary) {
                this.primary = primary;
                return this;
            }

            public PrivateIpAddressSpecificationProperty build() {
                return new Jsii.Proxy(this.privateIpAddress, this.primary);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.LoadBalancersConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoadBalancersConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getClassicLoadBalancersConfig() {
            return null;
        }

        @Nullable
        default public Object getTargetGroupsConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoadBalancersConfigProperty> {
            private Object classicLoadBalancersConfig;
            private Object targetGroupsConfig;

            public Builder classicLoadBalancersConfig(ClassicLoadBalancersConfigProperty classicLoadBalancersConfig) {
                this.classicLoadBalancersConfig = classicLoadBalancersConfig;
                return this;
            }

            public Builder classicLoadBalancersConfig(IResolvable classicLoadBalancersConfig) {
                this.classicLoadBalancersConfig = classicLoadBalancersConfig;
                return this;
            }

            public Builder targetGroupsConfig(TargetGroupsConfigProperty targetGroupsConfig) {
                this.targetGroupsConfig = targetGroupsConfig;
                return this;
            }

            public Builder targetGroupsConfig(IResolvable targetGroupsConfig) {
                this.targetGroupsConfig = targetGroupsConfig;
                return this;
            }

            public LoadBalancersConfigProperty build() {
                return new Jsii.Proxy(this.classicLoadBalancersConfig, this.targetGroupsConfig);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.LaunchTemplateOverridesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateOverridesProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAvailabilityZone() {
            return null;
        }

        @Nullable
        default public String getInstanceType() {
            return null;
        }

        @Nullable
        default public Number getPriority() {
            return null;
        }

        @Nullable
        default public String getSpotPrice() {
            return null;
        }

        @Nullable
        default public String getSubnetId() {
            return null;
        }

        @Nullable
        default public Number getWeightedCapacity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchTemplateOverridesProperty> {
            private String availabilityZone;
            private String instanceType;
            private Number priority;
            private String spotPrice;
            private String subnetId;
            private Number weightedCapacity;

            public Builder availabilityZone(String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder priority(Number priority) {
                this.priority = priority;
                return this;
            }

            public Builder spotPrice(String spotPrice) {
                this.spotPrice = spotPrice;
                return this;
            }

            public Builder subnetId(String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            public Builder weightedCapacity(Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            public LaunchTemplateOverridesProperty build() {
                return new Jsii.Proxy(this.availabilityZone, this.instanceType, this.priority, this.spotPrice, this.subnetId, this.weightedCapacity);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.LaunchTemplateConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getLaunchTemplateSpecification() {
            return null;
        }

        @Nullable
        default public Object getOverrides() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchTemplateConfigProperty> {
            private Object launchTemplateSpecification;
            private Object overrides;

            public Builder launchTemplateSpecification(FleetLaunchTemplateSpecificationProperty launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            public Builder launchTemplateSpecification(IResolvable launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            public Builder overrides(IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            public Builder overrides(List<? extends Object> overrides) {
                this.overrides = overrides;
                return this;
            }

            public LaunchTemplateConfigProperty build() {
                return new Jsii.Proxy(this.launchTemplateSpecification, this.overrides);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceNetworkInterfaceSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAssociatePublicIpAddress() {
            return null;
        }

        @Nullable
        default public Object getDeleteOnTermination() {
            return null;
        }

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public Number getDeviceIndex() {
            return null;
        }

        @Nullable
        default public List<String> getGroups() {
            return null;
        }

        @Nullable
        default public Number getIpv6AddressCount() {
            return null;
        }

        @Nullable
        default public Object getIpv6Addresses() {
            return null;
        }

        @Nullable
        default public String getNetworkInterfaceId() {
            return null;
        }

        @Nullable
        default public Object getPrivateIpAddresses() {
            return null;
        }

        @Nullable
        default public Number getSecondaryPrivateIpAddressCount() {
            return null;
        }

        @Nullable
        default public String getSubnetId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceNetworkInterfaceSpecificationProperty> {
            private Object associatePublicIpAddress;
            private Object deleteOnTermination;
            private String description;
            private Number deviceIndex;
            private List<String> groups;
            private Number ipv6AddressCount;
            private Object ipv6Addresses;
            private String networkInterfaceId;
            private Object privateIpAddresses;
            private Number secondaryPrivateIpAddressCount;
            private String subnetId;

            public Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            public Builder associatePublicIpAddress(IResolvable associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            public Builder deleteOnTermination(Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder deleteOnTermination(IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder deviceIndex(Number deviceIndex) {
                this.deviceIndex = deviceIndex;
                return this;
            }

            public Builder groups(List<String> groups) {
                this.groups = groups;
                return this;
            }

            public Builder ipv6AddressCount(Number ipv6AddressCount) {
                this.ipv6AddressCount = ipv6AddressCount;
                return this;
            }

            public Builder ipv6Addresses(IResolvable ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            public Builder ipv6Addresses(List<? extends Object> ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            public Builder networkInterfaceId(String networkInterfaceId) {
                this.networkInterfaceId = networkInterfaceId;
                return this;
            }

            public Builder privateIpAddresses(IResolvable privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            public Builder privateIpAddresses(List<? extends Object> privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            public Builder secondaryPrivateIpAddressCount(Number secondaryPrivateIpAddressCount) {
                this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
                return this;
            }

            public Builder subnetId(String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            public InstanceNetworkInterfaceSpecificationProperty build() {
                return new Jsii.Proxy(this.associatePublicIpAddress, this.deleteOnTermination, this.description, this.deviceIndex, this.groups, this.ipv6AddressCount, this.ipv6Addresses, this.networkInterfaceId, this.privateIpAddresses, this.secondaryPrivateIpAddressCount, this.subnetId);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.InstanceIpv6AddressProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceIpv6AddressProperty
    extends JsiiSerializable {
        @NotNull
        public String getIpv6Address();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceIpv6AddressProperty> {
            private String ipv6Address;

            public Builder ipv6Address(String ipv6Address) {
                this.ipv6Address = ipv6Address;
                return this;
            }

            public InstanceIpv6AddressProperty build() {
                return new Jsii.Proxy(this.ipv6Address);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IamInstanceProfileSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IamInstanceProfileSpecificationProperty> {
            private String arn;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public IamInstanceProfileSpecificationProperty build() {
                return new Jsii.Proxy(this.arn);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.GroupIdentifierProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GroupIdentifierProperty
    extends JsiiSerializable {
        @NotNull
        public String getGroupId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GroupIdentifierProperty> {
            private String groupId;

            public Builder groupId(String groupId) {
                this.groupId = groupId;
                return this;
            }

            public GroupIdentifierProperty build() {
                return new Jsii.Proxy(this.groupId);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FleetLaunchTemplateSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getVersion();

        @Nullable
        default public String getLaunchTemplateId() {
            return null;
        }

        @Nullable
        default public String getLaunchTemplateName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FleetLaunchTemplateSpecificationProperty> {
            private String version;
            private String launchTemplateId;
            private String launchTemplateName;

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public Builder launchTemplateId(String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            public Builder launchTemplateName(String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            public FleetLaunchTemplateSpecificationProperty build() {
                return new Jsii.Proxy(this.version, this.launchTemplateId, this.launchTemplateName);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.EbsBlockDeviceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EbsBlockDeviceProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDeleteOnTermination() {
            return null;
        }

        @Nullable
        default public Object getEncrypted() {
            return null;
        }

        @Nullable
        default public Number getIops() {
            return null;
        }

        @Nullable
        default public String getSnapshotId() {
            return null;
        }

        @Nullable
        default public Number getVolumeSize() {
            return null;
        }

        @Nullable
        default public String getVolumeType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EbsBlockDeviceProperty> {
            private Object deleteOnTermination;
            private Object encrypted;
            private Number iops;
            private String snapshotId;
            private Number volumeSize;
            private String volumeType;

            public Builder deleteOnTermination(Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder deleteOnTermination(IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder encrypted(Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder encrypted(IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder iops(Number iops) {
                this.iops = iops;
                return this;
            }

            public Builder snapshotId(String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            public Builder volumeSize(Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            public Builder volumeType(String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            public EbsBlockDeviceProperty build() {
                return new Jsii.Proxy(this.deleteOnTermination, this.encrypted, this.iops, this.snapshotId, this.volumeSize, this.volumeType);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClassicLoadBalancersConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getClassicLoadBalancers();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClassicLoadBalancersConfigProperty> {
            private Object classicLoadBalancers;

            public Builder classicLoadBalancers(IResolvable classicLoadBalancers) {
                this.classicLoadBalancers = classicLoadBalancers;
                return this;
            }

            public Builder classicLoadBalancers(List<? extends Object> classicLoadBalancers) {
                this.classicLoadBalancers = classicLoadBalancers;
                return this;
            }

            public ClassicLoadBalancersConfigProperty build() {
                return new Jsii.Proxy(this.classicLoadBalancers);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.ClassicLoadBalancerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClassicLoadBalancerProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClassicLoadBalancerProperty> {
            private String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public ClassicLoadBalancerProperty build() {
                return new Jsii.Proxy(this.name);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.CfnSpotFleet.BlockDeviceMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BlockDeviceMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getDeviceName();

        @Nullable
        default public Object getEbs() {
            return null;
        }

        @Nullable
        default public String getNoDevice() {
            return null;
        }

        @Nullable
        default public String getVirtualName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BlockDeviceMappingProperty> {
            private String deviceName;
            private Object ebs;
            private String noDevice;
            private String virtualName;

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder ebs(EbsBlockDeviceProperty ebs) {
                this.ebs = ebs;
                return this;
            }

            public Builder ebs(IResolvable ebs) {
                this.ebs = ebs;
                return this;
            }

            public Builder noDevice(String noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            public Builder virtualName(String virtualName) {
                this.virtualName = virtualName;
                return this;
            }

            public BlockDeviceMappingProperty build() {
                return new Jsii.Proxy(this.deviceName, this.ebs, this.noDevice, this.virtualName);
            }
        }
    }
}

