/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.services.ec2.ClientVpnEndpointOptions;
import software.amazon.awscdk.services.ec2.ClientVpnEndpointProps;
import software.amazon.awscdk.services.ec2.ClientVpnUserBasedAuthentication;
import software.amazon.awscdk.services.ec2.IClientVpnConnectionHandler;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ec2.TransportProtocol;
import software.amazon.awscdk.services.ec2.VpnPort;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.awscdk.services.logs.ILogStream;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.ClientVpnEndpointProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface ClientVpnEndpointProps
extends JsiiSerializable,
ClientVpnEndpointOptions {
    @NotNull
    public IVpc getVpc();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ClientVpnEndpointProps> {
        private IVpc vpc;
        private String cidr;
        private String serverCertificateArn;
        private Boolean authorizeAllUsersToVpcCidr;
        private String clientCertificateArn;
        private IClientVpnConnectionHandler clientConnectionHandler;
        private String description;
        private List<String> dnsServers;
        private Boolean logging;
        private ILogGroup logGroup;
        private ILogStream logStream;
        private VpnPort port;
        private List<ISecurityGroup> securityGroups;
        private Boolean selfServicePortal;
        private Boolean splitTunnel;
        private TransportProtocol transportProtocol;
        private ClientVpnUserBasedAuthentication userBasedAuthentication;
        private SubnetSelection vpcSubnets;

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public Builder serverCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
            return this;
        }

        public Builder authorizeAllUsersToVpcCidr(Boolean authorizeAllUsersToVpcCidr) {
            this.authorizeAllUsersToVpcCidr = authorizeAllUsersToVpcCidr;
            return this;
        }

        public Builder clientCertificateArn(String clientCertificateArn) {
            this.clientCertificateArn = clientCertificateArn;
            return this;
        }

        public Builder clientConnectionHandler(IClientVpnConnectionHandler clientConnectionHandler) {
            this.clientConnectionHandler = clientConnectionHandler;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder dnsServers(List<String> dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        public Builder logging(Boolean logging) {
            this.logging = logging;
            return this;
        }

        public Builder logGroup(ILogGroup logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        public Builder logStream(ILogStream logStream) {
            this.logStream = logStream;
            return this;
        }

        public Builder port(VpnPort port) {
            this.port = port;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder selfServicePortal(Boolean selfServicePortal) {
            this.selfServicePortal = selfServicePortal;
            return this;
        }

        public Builder splitTunnel(Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
            return this;
        }

        public Builder transportProtocol(TransportProtocol transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        public Builder userBasedAuthentication(ClientVpnUserBasedAuthentication userBasedAuthentication) {
            this.userBasedAuthentication = userBasedAuthentication;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public ClientVpnEndpointProps build() {
            return new Jsii.Proxy(this.vpc, this.cidr, this.serverCertificateArn, this.authorizeAllUsersToVpcCidr, this.clientCertificateArn, this.clientConnectionHandler, this.description, this.dnsServers, this.logging, this.logGroup, this.logStream, this.port, this.securityGroups, this.selfServicePortal, this.splitTunnel, this.transportProtocol, this.userBasedAuthentication, this.vpcSubnets);
        }
    }
}

