/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.services.autoscaling.IAutoScalingGroup;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ecs.ClusterAttributes;
import software.amazon.awscdk.services.servicediscovery.INamespace;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.ClusterAttributes")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface ClusterAttributes
extends JsiiSerializable {
    @NotNull
    public String getClusterName();

    @NotNull
    public List<ISecurityGroup> getSecurityGroups();

    @NotNull
    public IVpc getVpc();

    @Nullable
    default public IAutoScalingGroup getAutoscalingGroup() {
        return null;
    }

    @Nullable
    default public String getClusterArn() {
        return null;
    }

    @Nullable
    default public INamespace getDefaultCloudMapNamespace() {
        return null;
    }

    @Nullable
    default public Boolean getHasEc2Capacity() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ClusterAttributes> {
        private String clusterName;
        private List<ISecurityGroup> securityGroups;
        private IVpc vpc;
        private IAutoScalingGroup autoscalingGroup;
        private String clusterArn;
        private INamespace defaultCloudMapNamespace;
        private Boolean hasEc2Capacity;

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder autoscalingGroup(IAutoScalingGroup autoscalingGroup) {
            this.autoscalingGroup = autoscalingGroup;
            return this;
        }

        public Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public Builder defaultCloudMapNamespace(INamespace defaultCloudMapNamespace) {
            this.defaultCloudMapNamespace = defaultCloudMapNamespace;
            return this;
        }

        public Builder hasEc2Capacity(Boolean hasEc2Capacity) {
            this.hasEc2Capacity = hasEc2Capacity;
            return this;
        }

        public ClusterAttributes build() {
            return new Jsii.Proxy(this.clusterName, this.securityGroups, this.vpc, this.autoscalingGroup, this.clusterArn, this.defaultCloudMapNamespace, this.hasEc2Capacity);
        }
    }
}

