/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.ecs.Compatibility;
import software.amazon.awscdk.services.ecs.ContainerDefinition;
import software.amazon.awscdk.services.ecs.ContainerDefinitionOptions;
import software.amazon.awscdk.services.ecs.FirelensLogRouter;
import software.amazon.awscdk.services.ecs.FirelensLogRouterDefinitionOptions;
import software.amazon.awscdk.services.ecs.ITaskDefinition;
import software.amazon.awscdk.services.ecs.ITaskDefinitionExtension;
import software.amazon.awscdk.services.ecs.InferenceAccelerator;
import software.amazon.awscdk.services.ecs.IpcMode;
import software.amazon.awscdk.services.ecs.NetworkMode;
import software.amazon.awscdk.services.ecs.PidMode;
import software.amazon.awscdk.services.ecs.PlacementConstraint;
import software.amazon.awscdk.services.ecs.ProxyConfiguration;
import software.amazon.awscdk.services.ecs.TaskDefinitionAttributes;
import software.amazon.awscdk.services.ecs.TaskDefinitionProps;
import software.amazon.awscdk.services.ecs.Volume;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.TaskDefinition")
public class TaskDefinition
extends Resource
implements ITaskDefinition {
    protected TaskDefinition(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TaskDefinition(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public TaskDefinition(@NotNull Construct scope, @NotNull String id, @NotNull TaskDefinitionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ITaskDefinition fromTaskDefinitionArn(@NotNull Construct scope, @NotNull String id, @NotNull String taskDefinitionArn) {
        return (ITaskDefinition)JsiiObject.jsiiStaticCall(TaskDefinition.class, (String)"fromTaskDefinitionArn", (NativeType)NativeType.forClass(ITaskDefinition.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(taskDefinitionArn, "taskDefinitionArn is required")});
    }

    @NotNull
    public static ITaskDefinition fromTaskDefinitionAttributes(@NotNull Construct scope, @NotNull String id, @NotNull TaskDefinitionAttributes attrs) {
        return (ITaskDefinition)JsiiObject.jsiiStaticCall(TaskDefinition.class, (String)"fromTaskDefinitionAttributes", (NativeType)NativeType.forClass(ITaskDefinition.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public ContainerDefinition addContainer(@NotNull String id, @NotNull ContainerDefinitionOptions props) {
        return (ContainerDefinition)((Object)Kernel.call((Object)this, (String)"addContainer", (NativeType)NativeType.forClass(ContainerDefinition.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    public void addExtension(@NotNull ITaskDefinitionExtension extension) {
        Kernel.call((Object)this, (String)"addExtension", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(extension, "extension is required")});
    }

    @NotNull
    public FirelensLogRouter addFirelensLogRouter(@NotNull String id, @NotNull FirelensLogRouterDefinitionOptions props) {
        return (FirelensLogRouter)((Object)Kernel.call((Object)this, (String)"addFirelensLogRouter", (NativeType)NativeType.forClass(FirelensLogRouter.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    public void addInferenceAccelerator(@NotNull InferenceAccelerator inferenceAccelerator) {
        Kernel.call((Object)this, (String)"addInferenceAccelerator", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inferenceAccelerator, "inferenceAccelerator is required")});
    }

    public void addPlacementConstraint(@NotNull PlacementConstraint constraint) {
        Kernel.call((Object)this, (String)"addPlacementConstraint", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(constraint, "constraint is required")});
    }

    public void addToExecutionRolePolicy(@NotNull PolicyStatement statement) {
        Kernel.call((Object)this, (String)"addToExecutionRolePolicy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    public void addToTaskRolePolicy(@NotNull PolicyStatement statement) {
        Kernel.call((Object)this, (String)"addToTaskRolePolicy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    public void addVolume(@NotNull Volume volume) {
        Kernel.call((Object)this, (String)"addVolume", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(volume, "volume is required")});
    }

    @NotNull
    public IRole obtainExecutionRole() {
        return (IRole)Kernel.call((Object)this, (String)"obtainExecutionRole", (NativeType)NativeType.forClass(IRole.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Compatibility getCompatibility() {
        return (Compatibility)((Object)Kernel.get((Object)this, (String)"compatibility", (NativeType)NativeType.forClass(Compatibility.class)));
    }

    @NotNull
    protected List<ContainerDefinition> getContainers() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"containers", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ContainerDefinition.class))));
    }

    @NotNull
    public String getFamily() {
        return (String)Kernel.get((Object)this, (String)"family", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<InferenceAccelerator> getInferenceAccelerators() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"inferenceAccelerators", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(InferenceAccelerator.class))));
    }

    @Override
    @NotNull
    public Boolean getIsEc2Compatible() {
        return (Boolean)Kernel.get((Object)this, (String)"isEc2Compatible", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @NotNull
    public Boolean getIsFargateCompatible() {
        return (Boolean)Kernel.get((Object)this, (String)"isFargateCompatible", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @NotNull
    public NetworkMode getNetworkMode() {
        return (NetworkMode)((Object)Kernel.get((Object)this, (String)"networkMode", (NativeType)NativeType.forClass(NetworkMode.class)));
    }

    @Override
    @NotNull
    public String getTaskDefinitionArn() {
        return (String)Kernel.get((Object)this, (String)"taskDefinitionArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public IRole getTaskRole() {
        return (IRole)Kernel.get((Object)this, (String)"taskRole", (NativeType)NativeType.forClass(IRole.class));
    }

    @Override
    @Nullable
    public IRole getExecutionRole() {
        return (IRole)Kernel.get((Object)this, (String)"executionRole", (NativeType)NativeType.forClass(IRole.class));
    }

    @Nullable
    public Boolean getReferencesSecretJsonField() {
        return (Boolean)Kernel.get((Object)this, (String)"referencesSecretJsonField", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Nullable
    public ContainerDefinition getDefaultContainer() {
        return (ContainerDefinition)((Object)Kernel.get((Object)this, (String)"defaultContainer", (NativeType)NativeType.forClass(ContainerDefinition.class)));
    }

    public void setDefaultContainer(@Nullable ContainerDefinition value) {
        Kernel.set((Object)this, (String)"defaultContainer", (Object)((Object)value));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<TaskDefinition> {
        private final Construct scope;
        private final String id;
        private final TaskDefinitionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new TaskDefinitionProps.Builder();
        }

        public Builder executionRole(IRole executionRole) {
            this.props.executionRole(executionRole);
            return this;
        }

        public Builder family(String family) {
            this.props.family(family);
            return this;
        }

        public Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.props.proxyConfiguration(proxyConfiguration);
            return this;
        }

        public Builder taskRole(IRole taskRole) {
            this.props.taskRole(taskRole);
            return this;
        }

        public Builder volumes(List<? extends Volume> volumes) {
            this.props.volumes(volumes);
            return this;
        }

        public Builder compatibility(Compatibility compatibility) {
            this.props.compatibility(compatibility);
            return this;
        }

        public Builder cpu(String cpu) {
            this.props.cpu(cpu);
            return this;
        }

        public Builder inferenceAccelerators(List<? extends InferenceAccelerator> inferenceAccelerators) {
            this.props.inferenceAccelerators(inferenceAccelerators);
            return this;
        }

        public Builder ipcMode(IpcMode ipcMode) {
            this.props.ipcMode(ipcMode);
            return this;
        }

        public Builder memoryMiB(String memoryMiB) {
            this.props.memoryMiB(memoryMiB);
            return this;
        }

        public Builder networkMode(NetworkMode networkMode) {
            this.props.networkMode(networkMode);
            return this;
        }

        public Builder pidMode(PidMode pidMode) {
            this.props.pidMode(pidMode);
            return this;
        }

        public Builder placementConstraints(List<? extends PlacementConstraint> placementConstraints) {
            this.props.placementConstraints(placementConstraints);
            return this;
        }

        public TaskDefinition build() {
            return new TaskDefinition(this.scope, this.id, this.props.build());
        }
    }
}

