/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.eks;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.eks.CommonClusterOptions;
import software.amazon.awscdk.services.eks.KubernetesVersion;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_eks.CommonClusterOptions")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface CommonClusterOptions
extends JsiiSerializable {
    @NotNull
    public KubernetesVersion getVersion();

    @Nullable
    default public String getClusterName() {
        return null;
    }

    @Nullable
    default public Boolean getOutputClusterName() {
        return null;
    }

    @Nullable
    default public Boolean getOutputConfigCommand() {
        return null;
    }

    @Nullable
    default public IRole getRole() {
        return null;
    }

    @Nullable
    default public ISecurityGroup getSecurityGroup() {
        return null;
    }

    @Nullable
    default public IVpc getVpc() {
        return null;
    }

    @Nullable
    default public List<SubnetSelection> getVpcSubnets() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CommonClusterOptions> {
        private KubernetesVersion version;
        private String clusterName;
        private Boolean outputClusterName;
        private Boolean outputConfigCommand;
        private IRole role;
        private ISecurityGroup securityGroup;
        private IVpc vpc;
        private List<SubnetSelection> vpcSubnets;

        public Builder version(KubernetesVersion version) {
            this.version = version;
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder outputClusterName(Boolean outputClusterName) {
            this.outputClusterName = outputClusterName;
            return this;
        }

        public Builder outputConfigCommand(Boolean outputConfigCommand) {
            this.outputConfigCommand = outputConfigCommand;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder vpcSubnets(List<? extends SubnetSelection> vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public CommonClusterOptions build() {
            return new Jsii.Proxy(this.version, this.clusterName, this.outputClusterName, this.outputConfigCommand, this.role, this.securityGroup, this.vpc, this.vpcSubnets);
        }
    }
}

