/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticache;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.elasticache.CfnCacheCluster;
import software.amazon.awscdk.services.elasticache.CfnCacheClusterProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_elasticache.CfnCacheCluster")
public class CfnCacheCluster
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnCacheCluster.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnCacheCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCacheCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnCacheCluster(@NotNull Construct scope, @NotNull String id, @NotNull CfnCacheClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrConfigurationEndpointAddress() {
        return (String)Kernel.get((Object)this, (String)"attrConfigurationEndpointAddress", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrConfigurationEndpointPort() {
        return (String)Kernel.get((Object)this, (String)"attrConfigurationEndpointPort", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrRedisEndpointAddress() {
        return (String)Kernel.get((Object)this, (String)"attrRedisEndpointAddress", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrRedisEndpointPort() {
        return (String)Kernel.get((Object)this, (String)"attrRedisEndpointPort", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getCacheNodeType() {
        return (String)Kernel.get((Object)this, (String)"cacheNodeType", (NativeType)NativeType.forClass(String.class));
    }

    public void setCacheNodeType(@NotNull String value) {
        Kernel.set((Object)this, (String)"cacheNodeType", (Object)Objects.requireNonNull(value, "cacheNodeType is required"));
    }

    @NotNull
    public String getEngine() {
        return (String)Kernel.get((Object)this, (String)"engine", (NativeType)NativeType.forClass(String.class));
    }

    public void setEngine(@NotNull String value) {
        Kernel.set((Object)this, (String)"engine", (Object)Objects.requireNonNull(value, "engine is required"));
    }

    @NotNull
    public Number getNumCacheNodes() {
        return (Number)Kernel.get((Object)this, (String)"numCacheNodes", (NativeType)NativeType.forClass(Number.class));
    }

    public void setNumCacheNodes(@NotNull Number value) {
        Kernel.set((Object)this, (String)"numCacheNodes", (Object)Objects.requireNonNull(value, "numCacheNodes is required"));
    }

    @Nullable
    public Object getAutoMinorVersionUpgrade() {
        return Kernel.get((Object)this, (String)"autoMinorVersionUpgrade", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAutoMinorVersionUpgrade(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"autoMinorVersionUpgrade", (Object)value);
    }

    public void setAutoMinorVersionUpgrade(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"autoMinorVersionUpgrade", (Object)value);
    }

    @Nullable
    public String getAzMode() {
        return (String)Kernel.get((Object)this, (String)"azMode", (NativeType)NativeType.forClass(String.class));
    }

    public void setAzMode(@Nullable String value) {
        Kernel.set((Object)this, (String)"azMode", (Object)value);
    }

    @Nullable
    public String getCacheParameterGroupName() {
        return (String)Kernel.get((Object)this, (String)"cacheParameterGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setCacheParameterGroupName(@Nullable String value) {
        Kernel.set((Object)this, (String)"cacheParameterGroupName", (Object)value);
    }

    @Nullable
    public List<String> getCacheSecurityGroupNames() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"cacheSecurityGroupNames", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setCacheSecurityGroupNames(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"cacheSecurityGroupNames", value);
    }

    @Nullable
    public String getCacheSubnetGroupName() {
        return (String)Kernel.get((Object)this, (String)"cacheSubnetGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setCacheSubnetGroupName(@Nullable String value) {
        Kernel.set((Object)this, (String)"cacheSubnetGroupName", (Object)value);
    }

    @Nullable
    public String getClusterName() {
        return (String)Kernel.get((Object)this, (String)"clusterName", (NativeType)NativeType.forClass(String.class));
    }

    public void setClusterName(@Nullable String value) {
        Kernel.set((Object)this, (String)"clusterName", (Object)value);
    }

    @Nullable
    public String getEngineVersion() {
        return (String)Kernel.get((Object)this, (String)"engineVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setEngineVersion(@Nullable String value) {
        Kernel.set((Object)this, (String)"engineVersion", (Object)value);
    }

    @Nullable
    public Object getLogDeliveryConfigurations() {
        return Kernel.get((Object)this, (String)"logDeliveryConfigurations", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLogDeliveryConfigurations(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"logDeliveryConfigurations", (Object)value);
    }

    public void setLogDeliveryConfigurations(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"logDeliveryConfigurations", value);
    }

    @Nullable
    public String getNotificationTopicArn() {
        return (String)Kernel.get((Object)this, (String)"notificationTopicArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setNotificationTopicArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"notificationTopicArn", (Object)value);
    }

    @Nullable
    public Number getPort() {
        return (Number)Kernel.get((Object)this, (String)"port", (NativeType)NativeType.forClass(Number.class));
    }

    public void setPort(@Nullable Number value) {
        Kernel.set((Object)this, (String)"port", (Object)value);
    }

    @Nullable
    public String getPreferredAvailabilityZone() {
        return (String)Kernel.get((Object)this, (String)"preferredAvailabilityZone", (NativeType)NativeType.forClass(String.class));
    }

    public void setPreferredAvailabilityZone(@Nullable String value) {
        Kernel.set((Object)this, (String)"preferredAvailabilityZone", (Object)value);
    }

    @Nullable
    public List<String> getPreferredAvailabilityZones() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"preferredAvailabilityZones", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setPreferredAvailabilityZones(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"preferredAvailabilityZones", value);
    }

    @Nullable
    public String getPreferredMaintenanceWindow() {
        return (String)Kernel.get((Object)this, (String)"preferredMaintenanceWindow", (NativeType)NativeType.forClass(String.class));
    }

    public void setPreferredMaintenanceWindow(@Nullable String value) {
        Kernel.set((Object)this, (String)"preferredMaintenanceWindow", (Object)value);
    }

    @Nullable
    public List<String> getSnapshotArns() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"snapshotArns", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSnapshotArns(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"snapshotArns", value);
    }

    @Nullable
    public String getSnapshotName() {
        return (String)Kernel.get((Object)this, (String)"snapshotName", (NativeType)NativeType.forClass(String.class));
    }

    public void setSnapshotName(@Nullable String value) {
        Kernel.set((Object)this, (String)"snapshotName", (Object)value);
    }

    @Nullable
    public Number getSnapshotRetentionLimit() {
        return (Number)Kernel.get((Object)this, (String)"snapshotRetentionLimit", (NativeType)NativeType.forClass(Number.class));
    }

    public void setSnapshotRetentionLimit(@Nullable Number value) {
        Kernel.set((Object)this, (String)"snapshotRetentionLimit", (Object)value);
    }

    @Nullable
    public String getSnapshotWindow() {
        return (String)Kernel.get((Object)this, (String)"snapshotWindow", (NativeType)NativeType.forClass(String.class));
    }

    public void setSnapshotWindow(@Nullable String value) {
        Kernel.set((Object)this, (String)"snapshotWindow", (Object)value);
    }

    @Nullable
    public List<String> getVpcSecurityGroupIds() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"vpcSecurityGroupIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setVpcSecurityGroupIds(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"vpcSecurityGroupIds", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnCacheCluster> {
        private final Construct scope;
        private final String id;
        private final CfnCacheClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnCacheClusterProps.Builder();
        }

        public Builder cacheNodeType(String cacheNodeType) {
            this.props.cacheNodeType(cacheNodeType);
            return this;
        }

        public Builder engine(String engine) {
            this.props.engine(engine);
            return this;
        }

        public Builder numCacheNodes(Number numCacheNodes) {
            this.props.numCacheNodes(numCacheNodes);
            return this;
        }

        public Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.props.autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        public Builder autoMinorVersionUpgrade(IResolvable autoMinorVersionUpgrade) {
            this.props.autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        public Builder azMode(String azMode) {
            this.props.azMode(azMode);
            return this;
        }

        public Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.props.cacheParameterGroupName(cacheParameterGroupName);
            return this;
        }

        public Builder cacheSecurityGroupNames(List<String> cacheSecurityGroupNames) {
            this.props.cacheSecurityGroupNames(cacheSecurityGroupNames);
            return this;
        }

        public Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.props.cacheSubnetGroupName(cacheSubnetGroupName);
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        public Builder engineVersion(String engineVersion) {
            this.props.engineVersion(engineVersion);
            return this;
        }

        public Builder logDeliveryConfigurations(IResolvable logDeliveryConfigurations) {
            this.props.logDeliveryConfigurations(logDeliveryConfigurations);
            return this;
        }

        public Builder logDeliveryConfigurations(List<? extends Object> logDeliveryConfigurations) {
            this.props.logDeliveryConfigurations(logDeliveryConfigurations);
            return this;
        }

        public Builder notificationTopicArn(String notificationTopicArn) {
            this.props.notificationTopicArn(notificationTopicArn);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder preferredAvailabilityZone(String preferredAvailabilityZone) {
            this.props.preferredAvailabilityZone(preferredAvailabilityZone);
            return this;
        }

        public Builder preferredAvailabilityZones(List<String> preferredAvailabilityZones) {
            this.props.preferredAvailabilityZones(preferredAvailabilityZones);
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        public Builder snapshotArns(List<String> snapshotArns) {
            this.props.snapshotArns(snapshotArns);
            return this;
        }

        public Builder snapshotName(String snapshotName) {
            this.props.snapshotName(snapshotName);
            return this;
        }

        public Builder snapshotRetentionLimit(Number snapshotRetentionLimit) {
            this.props.snapshotRetentionLimit(snapshotRetentionLimit);
            return this;
        }

        public Builder snapshotWindow(String snapshotWindow) {
            this.props.snapshotWindow(snapshotWindow);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            this.props.vpcSecurityGroupIds(vpcSecurityGroupIds);
            return this;
        }

        public CfnCacheCluster build() {
            return new CfnCacheCluster(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_elasticache.CfnCacheCluster.LogDeliveryConfigurationRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LogDeliveryConfigurationRequestProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDestinationDetails() {
            return null;
        }

        @Nullable
        default public String getDestinationType() {
            return null;
        }

        @Nullable
        default public String getLogFormat() {
            return null;
        }

        @Nullable
        default public String getLogType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LogDeliveryConfigurationRequestProperty> {
            private Object destinationDetails;
            private String destinationType;
            private String logFormat;
            private String logType;

            public Builder destinationDetails(DestinationDetailsProperty destinationDetails) {
                this.destinationDetails = destinationDetails;
                return this;
            }

            public Builder destinationDetails(IResolvable destinationDetails) {
                this.destinationDetails = destinationDetails;
                return this;
            }

            public Builder destinationType(String destinationType) {
                this.destinationType = destinationType;
                return this;
            }

            public Builder logFormat(String logFormat) {
                this.logFormat = logFormat;
                return this;
            }

            public Builder logType(String logType) {
                this.logType = logType;
                return this;
            }

            public LogDeliveryConfigurationRequestProperty build() {
                return new Jsii.Proxy(this.destinationDetails, this.destinationType, this.logFormat, this.logType);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_elasticache.CfnCacheCluster.KinesisFirehoseDestinationDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisFirehoseDestinationDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDeliveryStream() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KinesisFirehoseDestinationDetailsProperty> {
            private String deliveryStream;

            public Builder deliveryStream(String deliveryStream) {
                this.deliveryStream = deliveryStream;
                return this;
            }

            public KinesisFirehoseDestinationDetailsProperty build() {
                return new Jsii.Proxy(this.deliveryStream);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_elasticache.CfnCacheCluster.DestinationDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DestinationDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCloudWatchLogsDetails() {
            return null;
        }

        @Nullable
        default public Object getKinesisFirehoseDetails() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DestinationDetailsProperty> {
            private Object cloudWatchLogsDetails;
            private Object kinesisFirehoseDetails;

            public Builder cloudWatchLogsDetails(CloudWatchLogsDestinationDetailsProperty cloudWatchLogsDetails) {
                this.cloudWatchLogsDetails = cloudWatchLogsDetails;
                return this;
            }

            public Builder cloudWatchLogsDetails(IResolvable cloudWatchLogsDetails) {
                this.cloudWatchLogsDetails = cloudWatchLogsDetails;
                return this;
            }

            public Builder kinesisFirehoseDetails(KinesisFirehoseDestinationDetailsProperty kinesisFirehoseDetails) {
                this.kinesisFirehoseDetails = kinesisFirehoseDetails;
                return this;
            }

            public Builder kinesisFirehoseDetails(IResolvable kinesisFirehoseDetails) {
                this.kinesisFirehoseDetails = kinesisFirehoseDetails;
                return this;
            }

            public DestinationDetailsProperty build() {
                return new Jsii.Proxy(this.cloudWatchLogsDetails, this.kinesisFirehoseDetails);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_elasticache.CfnCacheCluster.CloudWatchLogsDestinationDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudWatchLogsDestinationDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLogGroup() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudWatchLogsDestinationDetailsProperty> {
            private String logGroup;

            public Builder logGroup(String logGroup) {
                this.logGroup = logGroup;
                return this;
            }

            public CloudWatchLogsDestinationDetailsProperty build() {
                return new Jsii.Proxy(this.logGroup);
            }
        }
    }
}

