/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.gamelift;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.gamelift.CfnGameServerGroup;
import software.amazon.awscdk.services.gamelift.CfnGameServerGroupProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_gamelift.CfnGameServerGroup")
public class CfnGameServerGroup
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnGameServerGroup.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnGameServerGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGameServerGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnGameServerGroup(@NotNull Construct scope, @NotNull String id, @NotNull CfnGameServerGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrAutoScalingGroupArn() {
        return (String)Kernel.get((Object)this, (String)"attrAutoScalingGroupArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrGameServerGroupArn() {
        return (String)Kernel.get((Object)this, (String)"attrGameServerGroupArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getGameServerGroupName() {
        return (String)Kernel.get((Object)this, (String)"gameServerGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setGameServerGroupName(@NotNull String value) {
        Kernel.set((Object)this, (String)"gameServerGroupName", (Object)Objects.requireNonNull(value, "gameServerGroupName is required"));
    }

    @NotNull
    public Object getInstanceDefinitions() {
        return Kernel.get((Object)this, (String)"instanceDefinitions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInstanceDefinitions(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"instanceDefinitions", (Object)Objects.requireNonNull(value, "instanceDefinitions is required"));
    }

    public void setInstanceDefinitions(@NotNull List<Object> value) {
        Kernel.set((Object)this, (String)"instanceDefinitions", Objects.requireNonNull(value, "instanceDefinitions is required"));
    }

    @NotNull
    public Object getLaunchTemplate() {
        return Kernel.get((Object)this, (String)"launchTemplate", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLaunchTemplate(@NotNull LaunchTemplateProperty value) {
        Kernel.set((Object)this, (String)"launchTemplate", (Object)Objects.requireNonNull(value, "launchTemplate is required"));
    }

    public void setLaunchTemplate(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"launchTemplate", (Object)Objects.requireNonNull(value, "launchTemplate is required"));
    }

    @NotNull
    public String getRoleArn() {
        return (String)Kernel.get((Object)this, (String)"roleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setRoleArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"roleArn", (Object)Objects.requireNonNull(value, "roleArn is required"));
    }

    @Nullable
    public Object getAutoScalingPolicy() {
        return Kernel.get((Object)this, (String)"autoScalingPolicy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAutoScalingPolicy(@Nullable AutoScalingPolicyProperty value) {
        Kernel.set((Object)this, (String)"autoScalingPolicy", (Object)value);
    }

    public void setAutoScalingPolicy(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"autoScalingPolicy", (Object)value);
    }

    @Nullable
    public String getBalancingStrategy() {
        return (String)Kernel.get((Object)this, (String)"balancingStrategy", (NativeType)NativeType.forClass(String.class));
    }

    public void setBalancingStrategy(@Nullable String value) {
        Kernel.set((Object)this, (String)"balancingStrategy", (Object)value);
    }

    @Nullable
    public String getDeleteOption() {
        return (String)Kernel.get((Object)this, (String)"deleteOption", (NativeType)NativeType.forClass(String.class));
    }

    public void setDeleteOption(@Nullable String value) {
        Kernel.set((Object)this, (String)"deleteOption", (Object)value);
    }

    @Nullable
    public String getGameServerProtectionPolicy() {
        return (String)Kernel.get((Object)this, (String)"gameServerProtectionPolicy", (NativeType)NativeType.forClass(String.class));
    }

    public void setGameServerProtectionPolicy(@Nullable String value) {
        Kernel.set((Object)this, (String)"gameServerProtectionPolicy", (Object)value);
    }

    @Nullable
    public Number getMaxSize() {
        return (Number)Kernel.get((Object)this, (String)"maxSize", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaxSize(@Nullable Number value) {
        Kernel.set((Object)this, (String)"maxSize", (Object)value);
    }

    @Nullable
    public Number getMinSize() {
        return (Number)Kernel.get((Object)this, (String)"minSize", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMinSize(@Nullable Number value) {
        Kernel.set((Object)this, (String)"minSize", (Object)value);
    }

    @Nullable
    public List<String> getVpcSubnets() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"vpcSubnets", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setVpcSubnets(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"vpcSubnets", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnGameServerGroup> {
        private final Construct scope;
        private final String id;
        private final CfnGameServerGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnGameServerGroupProps.Builder();
        }

        public Builder gameServerGroupName(String gameServerGroupName) {
            this.props.gameServerGroupName(gameServerGroupName);
            return this;
        }

        public Builder instanceDefinitions(IResolvable instanceDefinitions) {
            this.props.instanceDefinitions(instanceDefinitions);
            return this;
        }

        public Builder instanceDefinitions(List<? extends Object> instanceDefinitions) {
            this.props.instanceDefinitions(instanceDefinitions);
            return this;
        }

        public Builder launchTemplate(LaunchTemplateProperty launchTemplate) {
            this.props.launchTemplate(launchTemplate);
            return this;
        }

        public Builder launchTemplate(IResolvable launchTemplate) {
            this.props.launchTemplate(launchTemplate);
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder autoScalingPolicy(AutoScalingPolicyProperty autoScalingPolicy) {
            this.props.autoScalingPolicy(autoScalingPolicy);
            return this;
        }

        public Builder autoScalingPolicy(IResolvable autoScalingPolicy) {
            this.props.autoScalingPolicy(autoScalingPolicy);
            return this;
        }

        public Builder balancingStrategy(String balancingStrategy) {
            this.props.balancingStrategy(balancingStrategy);
            return this;
        }

        public Builder deleteOption(String deleteOption) {
            this.props.deleteOption(deleteOption);
            return this;
        }

        public Builder gameServerProtectionPolicy(String gameServerProtectionPolicy) {
            this.props.gameServerProtectionPolicy(gameServerProtectionPolicy);
            return this;
        }

        public Builder maxSize(Number maxSize) {
            this.props.maxSize(maxSize);
            return this;
        }

        public Builder minSize(Number minSize) {
            this.props.minSize(minSize);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder vpcSubnets(List<String> vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public CfnGameServerGroup build() {
            return new CfnGameServerGroup(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_gamelift.CfnGameServerGroup.TargetTrackingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TargetTrackingConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getTargetValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TargetTrackingConfigurationProperty> {
            private Number targetValue;

            public Builder targetValue(Number targetValue) {
                this.targetValue = targetValue;
                return this;
            }

            public TargetTrackingConfigurationProperty build() {
                return new Jsii.Proxy(this.targetValue);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_gamelift.CfnGameServerGroup.LaunchTemplateProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLaunchTemplateId() {
            return null;
        }

        @Nullable
        default public String getLaunchTemplateName() {
            return null;
        }

        @Nullable
        default public String getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchTemplateProperty> {
            private String launchTemplateId;
            private String launchTemplateName;
            private String version;

            public Builder launchTemplateId(String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            public Builder launchTemplateName(String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public LaunchTemplateProperty build() {
                return new Jsii.Proxy(this.launchTemplateId, this.launchTemplateName, this.version);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_gamelift.CfnGameServerGroup.InstanceDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceDefinitionProperty
    extends JsiiSerializable {
        @NotNull
        public String getInstanceType();

        @Nullable
        default public String getWeightedCapacity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceDefinitionProperty> {
            private String instanceType;
            private String weightedCapacity;

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder weightedCapacity(String weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            public InstanceDefinitionProperty build() {
                return new Jsii.Proxy(this.instanceType, this.weightedCapacity);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_gamelift.CfnGameServerGroup.AutoScalingPolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AutoScalingPolicyProperty
    extends JsiiSerializable {
        @NotNull
        public Object getTargetTrackingConfiguration();

        @Nullable
        default public Number getEstimatedInstanceWarmup() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AutoScalingPolicyProperty> {
            private Object targetTrackingConfiguration;
            private Number estimatedInstanceWarmup;

            public Builder targetTrackingConfiguration(TargetTrackingConfigurationProperty targetTrackingConfiguration) {
                this.targetTrackingConfiguration = targetTrackingConfiguration;
                return this;
            }

            public Builder targetTrackingConfiguration(IResolvable targetTrackingConfiguration) {
                this.targetTrackingConfiguration = targetTrackingConfiguration;
                return this;
            }

            public Builder estimatedInstanceWarmup(Number estimatedInstanceWarmup) {
                this.estimatedInstanceWarmup = estimatedInstanceWarmup;
                return this;
            }

            public AutoScalingPolicyProperty build() {
                return new Jsii.Proxy(this.targetTrackingConfiguration, this.estimatedInstanceWarmup);
            }
        }
    }
}

