/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.groundstation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.groundstation.CfnConfig;
import software.amazon.awscdk.services.groundstation.CfnConfigProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_groundstation.CfnConfig")
public class CfnConfig
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnConfig.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnConfig(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfig(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnConfig(@NotNull Construct scope, @NotNull String id, @NotNull CfnConfigProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrType() {
        return (String)Kernel.get((Object)this, (String)"attrType", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getConfigData() {
        return Kernel.get((Object)this, (String)"configData", (NativeType)NativeType.forClass(Object.class));
    }

    public void setConfigData(@NotNull ConfigDataProperty value) {
        Kernel.set((Object)this, (String)"configData", (Object)Objects.requireNonNull(value, "configData is required"));
    }

    public void setConfigData(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"configData", (Object)Objects.requireNonNull(value, "configData is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnConfig> {
        private final Construct scope;
        private final String id;
        private final CfnConfigProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnConfigProps.Builder();
        }

        public Builder configData(ConfigDataProperty configData) {
            this.props.configData(configData);
            return this;
        }

        public Builder configData(IResolvable configData) {
            this.props.configData(configData);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnConfig build() {
            return new CfnConfig(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_groundstation.CfnConfig.UplinkSpectrumConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UplinkSpectrumConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCenterFrequency() {
            return null;
        }

        @Nullable
        default public String getPolarization() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UplinkSpectrumConfigProperty> {
            private Object centerFrequency;
            private String polarization;

            public Builder centerFrequency(FrequencyProperty centerFrequency) {
                this.centerFrequency = centerFrequency;
                return this;
            }

            public Builder centerFrequency(IResolvable centerFrequency) {
                this.centerFrequency = centerFrequency;
                return this;
            }

            public Builder polarization(String polarization) {
                this.polarization = polarization;
                return this;
            }

            public UplinkSpectrumConfigProperty build() {
                return new Jsii.Proxy(this.centerFrequency, this.polarization);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_groundstation.CfnConfig.UplinkEchoConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UplinkEchoConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAntennaUplinkConfigArn() {
            return null;
        }

        @Nullable
        default public Object getEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UplinkEchoConfigProperty> {
            private String antennaUplinkConfigArn;
            private Object enabled;

            public Builder antennaUplinkConfigArn(String antennaUplinkConfigArn) {
                this.antennaUplinkConfigArn = antennaUplinkConfigArn;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public UplinkEchoConfigProperty build() {
                return new Jsii.Proxy(this.antennaUplinkConfigArn, this.enabled);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_groundstation.CfnConfig.TrackingConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TrackingConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAutotrack() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TrackingConfigProperty> {
            private String autotrack;

            public Builder autotrack(String autotrack) {
                this.autotrack = autotrack;
                return this;
            }

            public TrackingConfigProperty build() {
                return new Jsii.Proxy(this.autotrack);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_groundstation.CfnConfig.SpectrumConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpectrumConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBandwidth() {
            return null;
        }

        @Nullable
        default public Object getCenterFrequency() {
            return null;
        }

        @Nullable
        default public String getPolarization() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpectrumConfigProperty> {
            private Object bandwidth;
            private Object centerFrequency;
            private String polarization;

            public Builder bandwidth(FrequencyBandwidthProperty bandwidth) {
                this.bandwidth = bandwidth;
                return this;
            }

            public Builder bandwidth(IResolvable bandwidth) {
                this.bandwidth = bandwidth;
                return this;
            }

            public Builder centerFrequency(FrequencyProperty centerFrequency) {
                this.centerFrequency = centerFrequency;
                return this;
            }

            public Builder centerFrequency(IResolvable centerFrequency) {
                this.centerFrequency = centerFrequency;
                return this;
            }

            public Builder polarization(String polarization) {
                this.polarization = polarization;
                return this;
            }

            public SpectrumConfigProperty build() {
                return new Jsii.Proxy(this.bandwidth, this.centerFrequency, this.polarization);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_groundstation.CfnConfig.S3RecordingConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3RecordingConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBucketArn() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        @Nullable
        default public String getRoleArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3RecordingConfigProperty> {
            private String bucketArn;
            private String prefix;
            private String roleArn;

            public Builder bucketArn(String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public S3RecordingConfigProperty build() {
                return new Jsii.Proxy(this.bucketArn, this.prefix, this.roleArn);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_groundstation.CfnConfig.FrequencyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FrequencyProperty
    extends JsiiSerializable {
        @Nullable
        default public String getUnits() {
            return null;
        }

        @Nullable
        default public Number getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FrequencyProperty> {
            private String units;
            private Number value;

            public Builder units(String units) {
                this.units = units;
                return this;
            }

            public Builder value(Number value) {
                this.value = value;
                return this;
            }

            public FrequencyProperty build() {
                return new Jsii.Proxy(this.units, this.value);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_groundstation.CfnConfig.FrequencyBandwidthProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FrequencyBandwidthProperty
    extends JsiiSerializable {
        @Nullable
        default public String getUnits() {
            return null;
        }

        @Nullable
        default public Number getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FrequencyBandwidthProperty> {
            private String units;
            private Number value;

            public Builder units(String units) {
                this.units = units;
                return this;
            }

            public Builder value(Number value) {
                this.value = value;
                return this;
            }

            public FrequencyBandwidthProperty build() {
                return new Jsii.Proxy(this.units, this.value);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_groundstation.CfnConfig.EirpProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EirpProperty
    extends JsiiSerializable {
        @Nullable
        default public String getUnits() {
            return null;
        }

        @Nullable
        default public Number getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EirpProperty> {
            private String units;
            private Number value;

            public Builder units(String units) {
                this.units = units;
                return this;
            }

            public Builder value(Number value) {
                this.value = value;
                return this;
            }

            public EirpProperty build() {
                return new Jsii.Proxy(this.units, this.value);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_groundstation.CfnConfig.DemodulationConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DemodulationConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getUnvalidatedJson() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DemodulationConfigProperty> {
            private String unvalidatedJson;

            public Builder unvalidatedJson(String unvalidatedJson) {
                this.unvalidatedJson = unvalidatedJson;
                return this;
            }

            public DemodulationConfigProperty build() {
                return new Jsii.Proxy(this.unvalidatedJson);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_groundstation.CfnConfig.DecodeConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DecodeConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getUnvalidatedJson() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DecodeConfigProperty> {
            private String unvalidatedJson;

            public Builder unvalidatedJson(String unvalidatedJson) {
                this.unvalidatedJson = unvalidatedJson;
                return this;
            }

            public DecodeConfigProperty build() {
                return new Jsii.Proxy(this.unvalidatedJson);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_groundstation.CfnConfig.DataflowEndpointConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataflowEndpointConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDataflowEndpointName() {
            return null;
        }

        @Nullable
        default public String getDataflowEndpointRegion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataflowEndpointConfigProperty> {
            private String dataflowEndpointName;
            private String dataflowEndpointRegion;

            public Builder dataflowEndpointName(String dataflowEndpointName) {
                this.dataflowEndpointName = dataflowEndpointName;
                return this;
            }

            public Builder dataflowEndpointRegion(String dataflowEndpointRegion) {
                this.dataflowEndpointRegion = dataflowEndpointRegion;
                return this;
            }

            public DataflowEndpointConfigProperty build() {
                return new Jsii.Proxy(this.dataflowEndpointName, this.dataflowEndpointRegion);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_groundstation.CfnConfig.ConfigDataProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfigDataProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAntennaDownlinkConfig() {
            return null;
        }

        @Nullable
        default public Object getAntennaDownlinkDemodDecodeConfig() {
            return null;
        }

        @Nullable
        default public Object getAntennaUplinkConfig() {
            return null;
        }

        @Nullable
        default public Object getDataflowEndpointConfig() {
            return null;
        }

        @Nullable
        default public Object getS3RecordingConfig() {
            return null;
        }

        @Nullable
        default public Object getTrackingConfig() {
            return null;
        }

        @Nullable
        default public Object getUplinkEchoConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfigDataProperty> {
            private Object antennaDownlinkConfig;
            private Object antennaDownlinkDemodDecodeConfig;
            private Object antennaUplinkConfig;
            private Object dataflowEndpointConfig;
            private Object s3RecordingConfig;
            private Object trackingConfig;
            private Object uplinkEchoConfig;

            public Builder antennaDownlinkConfig(AntennaDownlinkConfigProperty antennaDownlinkConfig) {
                this.antennaDownlinkConfig = antennaDownlinkConfig;
                return this;
            }

            public Builder antennaDownlinkConfig(IResolvable antennaDownlinkConfig) {
                this.antennaDownlinkConfig = antennaDownlinkConfig;
                return this;
            }

            public Builder antennaDownlinkDemodDecodeConfig(AntennaDownlinkDemodDecodeConfigProperty antennaDownlinkDemodDecodeConfig) {
                this.antennaDownlinkDemodDecodeConfig = antennaDownlinkDemodDecodeConfig;
                return this;
            }

            public Builder antennaDownlinkDemodDecodeConfig(IResolvable antennaDownlinkDemodDecodeConfig) {
                this.antennaDownlinkDemodDecodeConfig = antennaDownlinkDemodDecodeConfig;
                return this;
            }

            public Builder antennaUplinkConfig(AntennaUplinkConfigProperty antennaUplinkConfig) {
                this.antennaUplinkConfig = antennaUplinkConfig;
                return this;
            }

            public Builder antennaUplinkConfig(IResolvable antennaUplinkConfig) {
                this.antennaUplinkConfig = antennaUplinkConfig;
                return this;
            }

            public Builder dataflowEndpointConfig(DataflowEndpointConfigProperty dataflowEndpointConfig) {
                this.dataflowEndpointConfig = dataflowEndpointConfig;
                return this;
            }

            public Builder dataflowEndpointConfig(IResolvable dataflowEndpointConfig) {
                this.dataflowEndpointConfig = dataflowEndpointConfig;
                return this;
            }

            public Builder s3RecordingConfig(S3RecordingConfigProperty s3RecordingConfig) {
                this.s3RecordingConfig = s3RecordingConfig;
                return this;
            }

            public Builder s3RecordingConfig(IResolvable s3RecordingConfig) {
                this.s3RecordingConfig = s3RecordingConfig;
                return this;
            }

            public Builder trackingConfig(TrackingConfigProperty trackingConfig) {
                this.trackingConfig = trackingConfig;
                return this;
            }

            public Builder trackingConfig(IResolvable trackingConfig) {
                this.trackingConfig = trackingConfig;
                return this;
            }

            public Builder uplinkEchoConfig(UplinkEchoConfigProperty uplinkEchoConfig) {
                this.uplinkEchoConfig = uplinkEchoConfig;
                return this;
            }

            public Builder uplinkEchoConfig(IResolvable uplinkEchoConfig) {
                this.uplinkEchoConfig = uplinkEchoConfig;
                return this;
            }

            public ConfigDataProperty build() {
                return new Jsii.Proxy(this.antennaDownlinkConfig, this.antennaDownlinkDemodDecodeConfig, this.antennaUplinkConfig, this.dataflowEndpointConfig, this.s3RecordingConfig, this.trackingConfig, this.uplinkEchoConfig);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_groundstation.CfnConfig.AntennaUplinkConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AntennaUplinkConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSpectrumConfig() {
            return null;
        }

        @Nullable
        default public Object getTargetEirp() {
            return null;
        }

        @Nullable
        default public Object getTransmitDisabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AntennaUplinkConfigProperty> {
            private Object spectrumConfig;
            private Object targetEirp;
            private Object transmitDisabled;

            public Builder spectrumConfig(UplinkSpectrumConfigProperty spectrumConfig) {
                this.spectrumConfig = spectrumConfig;
                return this;
            }

            public Builder spectrumConfig(IResolvable spectrumConfig) {
                this.spectrumConfig = spectrumConfig;
                return this;
            }

            public Builder targetEirp(EirpProperty targetEirp) {
                this.targetEirp = targetEirp;
                return this;
            }

            public Builder targetEirp(IResolvable targetEirp) {
                this.targetEirp = targetEirp;
                return this;
            }

            public Builder transmitDisabled(Boolean transmitDisabled) {
                this.transmitDisabled = transmitDisabled;
                return this;
            }

            public Builder transmitDisabled(IResolvable transmitDisabled) {
                this.transmitDisabled = transmitDisabled;
                return this;
            }

            public AntennaUplinkConfigProperty build() {
                return new Jsii.Proxy(this.spectrumConfig, this.targetEirp, this.transmitDisabled);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_groundstation.CfnConfig.AntennaDownlinkDemodDecodeConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AntennaDownlinkDemodDecodeConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDecodeConfig() {
            return null;
        }

        @Nullable
        default public Object getDemodulationConfig() {
            return null;
        }

        @Nullable
        default public Object getSpectrumConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AntennaDownlinkDemodDecodeConfigProperty> {
            private Object decodeConfig;
            private Object demodulationConfig;
            private Object spectrumConfig;

            public Builder decodeConfig(DecodeConfigProperty decodeConfig) {
                this.decodeConfig = decodeConfig;
                return this;
            }

            public Builder decodeConfig(IResolvable decodeConfig) {
                this.decodeConfig = decodeConfig;
                return this;
            }

            public Builder demodulationConfig(DemodulationConfigProperty demodulationConfig) {
                this.demodulationConfig = demodulationConfig;
                return this;
            }

            public Builder demodulationConfig(IResolvable demodulationConfig) {
                this.demodulationConfig = demodulationConfig;
                return this;
            }

            public Builder spectrumConfig(SpectrumConfigProperty spectrumConfig) {
                this.spectrumConfig = spectrumConfig;
                return this;
            }

            public Builder spectrumConfig(IResolvable spectrumConfig) {
                this.spectrumConfig = spectrumConfig;
                return this;
            }

            public AntennaDownlinkDemodDecodeConfigProperty build() {
                return new Jsii.Proxy(this.decodeConfig, this.demodulationConfig, this.spectrumConfig);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_groundstation.CfnConfig.AntennaDownlinkConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AntennaDownlinkConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSpectrumConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AntennaDownlinkConfigProperty> {
            private Object spectrumConfig;

            public Builder spectrumConfig(SpectrumConfigProperty spectrumConfig) {
                this.spectrumConfig = spectrumConfig;
                return this;
            }

            public Builder spectrumConfig(IResolvable spectrumConfig) {
                this.spectrumConfig = spectrumConfig;
                return this;
            }

            public AntennaDownlinkConfigProperty build() {
                return new Jsii.Proxy(this.spectrumConfig);
            }
        }
    }
}

