/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesisfirehose;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream;
import software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStreamProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream")
public class CfnDeliveryStream
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDeliveryStream.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDeliveryStream(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDeliveryStream(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDeliveryStream(@NotNull Construct scope, @NotNull String id, @Nullable CfnDeliveryStreamProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnDeliveryStream(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Nullable
    public Object getDeliveryStreamEncryptionConfigurationInput() {
        return Kernel.get((Object)this, (String)"deliveryStreamEncryptionConfigurationInput", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDeliveryStreamEncryptionConfigurationInput(@Nullable DeliveryStreamEncryptionConfigurationInputProperty value) {
        Kernel.set((Object)this, (String)"deliveryStreamEncryptionConfigurationInput", (Object)value);
    }

    public void setDeliveryStreamEncryptionConfigurationInput(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"deliveryStreamEncryptionConfigurationInput", (Object)value);
    }

    @Nullable
    public String getDeliveryStreamName() {
        return (String)Kernel.get((Object)this, (String)"deliveryStreamName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDeliveryStreamName(@Nullable String value) {
        Kernel.set((Object)this, (String)"deliveryStreamName", (Object)value);
    }

    @Nullable
    public String getDeliveryStreamType() {
        return (String)Kernel.get((Object)this, (String)"deliveryStreamType", (NativeType)NativeType.forClass(String.class));
    }

    public void setDeliveryStreamType(@Nullable String value) {
        Kernel.set((Object)this, (String)"deliveryStreamType", (Object)value);
    }

    @Nullable
    public Object getElasticsearchDestinationConfiguration() {
        return Kernel.get((Object)this, (String)"elasticsearchDestinationConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setElasticsearchDestinationConfiguration(@Nullable ElasticsearchDestinationConfigurationProperty value) {
        Kernel.set((Object)this, (String)"elasticsearchDestinationConfiguration", (Object)value);
    }

    public void setElasticsearchDestinationConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"elasticsearchDestinationConfiguration", (Object)value);
    }

    @Nullable
    public Object getExtendedS3DestinationConfiguration() {
        return Kernel.get((Object)this, (String)"extendedS3DestinationConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setExtendedS3DestinationConfiguration(@Nullable ExtendedS3DestinationConfigurationProperty value) {
        Kernel.set((Object)this, (String)"extendedS3DestinationConfiguration", (Object)value);
    }

    public void setExtendedS3DestinationConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"extendedS3DestinationConfiguration", (Object)value);
    }

    @Nullable
    public Object getHttpEndpointDestinationConfiguration() {
        return Kernel.get((Object)this, (String)"httpEndpointDestinationConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setHttpEndpointDestinationConfiguration(@Nullable HttpEndpointDestinationConfigurationProperty value) {
        Kernel.set((Object)this, (String)"httpEndpointDestinationConfiguration", (Object)value);
    }

    public void setHttpEndpointDestinationConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"httpEndpointDestinationConfiguration", (Object)value);
    }

    @Nullable
    public Object getKinesisStreamSourceConfiguration() {
        return Kernel.get((Object)this, (String)"kinesisStreamSourceConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setKinesisStreamSourceConfiguration(@Nullable KinesisStreamSourceConfigurationProperty value) {
        Kernel.set((Object)this, (String)"kinesisStreamSourceConfiguration", (Object)value);
    }

    public void setKinesisStreamSourceConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"kinesisStreamSourceConfiguration", (Object)value);
    }

    @Nullable
    public Object getRedshiftDestinationConfiguration() {
        return Kernel.get((Object)this, (String)"redshiftDestinationConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRedshiftDestinationConfiguration(@Nullable RedshiftDestinationConfigurationProperty value) {
        Kernel.set((Object)this, (String)"redshiftDestinationConfiguration", (Object)value);
    }

    public void setRedshiftDestinationConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"redshiftDestinationConfiguration", (Object)value);
    }

    @Nullable
    public Object getS3DestinationConfiguration() {
        return Kernel.get((Object)this, (String)"s3DestinationConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setS3DestinationConfiguration(@Nullable S3DestinationConfigurationProperty value) {
        Kernel.set((Object)this, (String)"s3DestinationConfiguration", (Object)value);
    }

    public void setS3DestinationConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"s3DestinationConfiguration", (Object)value);
    }

    @Nullable
    public Object getSplunkDestinationConfiguration() {
        return Kernel.get((Object)this, (String)"splunkDestinationConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSplunkDestinationConfiguration(@Nullable SplunkDestinationConfigurationProperty value) {
        Kernel.set((Object)this, (String)"splunkDestinationConfiguration", (Object)value);
    }

    public void setSplunkDestinationConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"splunkDestinationConfiguration", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDeliveryStream> {
        private final Construct scope;
        private final String id;
        private CfnDeliveryStreamProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder deliveryStreamEncryptionConfigurationInput(DeliveryStreamEncryptionConfigurationInputProperty deliveryStreamEncryptionConfigurationInput) {
            this.props().deliveryStreamEncryptionConfigurationInput(deliveryStreamEncryptionConfigurationInput);
            return this;
        }

        public Builder deliveryStreamEncryptionConfigurationInput(IResolvable deliveryStreamEncryptionConfigurationInput) {
            this.props().deliveryStreamEncryptionConfigurationInput(deliveryStreamEncryptionConfigurationInput);
            return this;
        }

        public Builder deliveryStreamName(String deliveryStreamName) {
            this.props().deliveryStreamName(deliveryStreamName);
            return this;
        }

        public Builder deliveryStreamType(String deliveryStreamType) {
            this.props().deliveryStreamType(deliveryStreamType);
            return this;
        }

        public Builder elasticsearchDestinationConfiguration(ElasticsearchDestinationConfigurationProperty elasticsearchDestinationConfiguration) {
            this.props().elasticsearchDestinationConfiguration(elasticsearchDestinationConfiguration);
            return this;
        }

        public Builder elasticsearchDestinationConfiguration(IResolvable elasticsearchDestinationConfiguration) {
            this.props().elasticsearchDestinationConfiguration(elasticsearchDestinationConfiguration);
            return this;
        }

        public Builder extendedS3DestinationConfiguration(ExtendedS3DestinationConfigurationProperty extendedS3DestinationConfiguration) {
            this.props().extendedS3DestinationConfiguration(extendedS3DestinationConfiguration);
            return this;
        }

        public Builder extendedS3DestinationConfiguration(IResolvable extendedS3DestinationConfiguration) {
            this.props().extendedS3DestinationConfiguration(extendedS3DestinationConfiguration);
            return this;
        }

        public Builder httpEndpointDestinationConfiguration(HttpEndpointDestinationConfigurationProperty httpEndpointDestinationConfiguration) {
            this.props().httpEndpointDestinationConfiguration(httpEndpointDestinationConfiguration);
            return this;
        }

        public Builder httpEndpointDestinationConfiguration(IResolvable httpEndpointDestinationConfiguration) {
            this.props().httpEndpointDestinationConfiguration(httpEndpointDestinationConfiguration);
            return this;
        }

        public Builder kinesisStreamSourceConfiguration(KinesisStreamSourceConfigurationProperty kinesisStreamSourceConfiguration) {
            this.props().kinesisStreamSourceConfiguration(kinesisStreamSourceConfiguration);
            return this;
        }

        public Builder kinesisStreamSourceConfiguration(IResolvable kinesisStreamSourceConfiguration) {
            this.props().kinesisStreamSourceConfiguration(kinesisStreamSourceConfiguration);
            return this;
        }

        public Builder redshiftDestinationConfiguration(RedshiftDestinationConfigurationProperty redshiftDestinationConfiguration) {
            this.props().redshiftDestinationConfiguration(redshiftDestinationConfiguration);
            return this;
        }

        public Builder redshiftDestinationConfiguration(IResolvable redshiftDestinationConfiguration) {
            this.props().redshiftDestinationConfiguration(redshiftDestinationConfiguration);
            return this;
        }

        public Builder s3DestinationConfiguration(S3DestinationConfigurationProperty s3DestinationConfiguration) {
            this.props().s3DestinationConfiguration(s3DestinationConfiguration);
            return this;
        }

        public Builder s3DestinationConfiguration(IResolvable s3DestinationConfiguration) {
            this.props().s3DestinationConfiguration(s3DestinationConfiguration);
            return this;
        }

        public Builder splunkDestinationConfiguration(SplunkDestinationConfigurationProperty splunkDestinationConfiguration) {
            this.props().splunkDestinationConfiguration(splunkDestinationConfiguration);
            return this;
        }

        public Builder splunkDestinationConfiguration(IResolvable splunkDestinationConfiguration) {
            this.props().splunkDestinationConfiguration(splunkDestinationConfiguration);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public CfnDeliveryStream build() {
            return new CfnDeliveryStream(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnDeliveryStreamProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnDeliveryStreamProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.VpcConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getRoleArn();

        @NotNull
        public List<String> getSecurityGroupIds();

        @NotNull
        public List<String> getSubnetIds();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcConfigurationProperty> {
            private String roleArn;
            private List<String> securityGroupIds;
            private List<String> subnetIds;

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public VpcConfigurationProperty build() {
                return new Jsii.Proxy(this.roleArn, this.securityGroupIds, this.subnetIds);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SplunkRetryOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SplunkRetryOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getDurationInSeconds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SplunkRetryOptionsProperty> {
            private Number durationInSeconds;

            public Builder durationInSeconds(Number durationInSeconds) {
                this.durationInSeconds = durationInSeconds;
                return this;
            }

            public SplunkRetryOptionsProperty build() {
                return new Jsii.Proxy(this.durationInSeconds);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SplunkDestinationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SplunkDestinationConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getHecEndpoint();

        @NotNull
        public String getHecEndpointType();

        @NotNull
        public String getHecToken();

        @NotNull
        public Object getS3Configuration();

        @Nullable
        default public Object getCloudWatchLoggingOptions() {
            return null;
        }

        @Nullable
        default public Number getHecAcknowledgmentTimeoutInSeconds() {
            return null;
        }

        @Nullable
        default public Object getProcessingConfiguration() {
            return null;
        }

        @Nullable
        default public Object getRetryOptions() {
            return null;
        }

        @Nullable
        default public String getS3BackupMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SplunkDestinationConfigurationProperty> {
            private String hecEndpoint;
            private String hecEndpointType;
            private String hecToken;
            private Object s3Configuration;
            private Object cloudWatchLoggingOptions;
            private Number hecAcknowledgmentTimeoutInSeconds;
            private Object processingConfiguration;
            private Object retryOptions;
            private String s3BackupMode;

            public Builder hecEndpoint(String hecEndpoint) {
                this.hecEndpoint = hecEndpoint;
                return this;
            }

            public Builder hecEndpointType(String hecEndpointType) {
                this.hecEndpointType = hecEndpointType;
                return this;
            }

            public Builder hecToken(String hecToken) {
                this.hecToken = hecToken;
                return this;
            }

            public Builder s3Configuration(S3DestinationConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            public Builder s3Configuration(IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            public Builder cloudWatchLoggingOptions(IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            public Builder hecAcknowledgmentTimeoutInSeconds(Number hecAcknowledgmentTimeoutInSeconds) {
                this.hecAcknowledgmentTimeoutInSeconds = hecAcknowledgmentTimeoutInSeconds;
                return this;
            }

            public Builder processingConfiguration(ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            public Builder processingConfiguration(IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            public Builder retryOptions(SplunkRetryOptionsProperty retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            public Builder retryOptions(IResolvable retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            public Builder s3BackupMode(String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            public SplunkDestinationConfigurationProperty build() {
                return new Jsii.Proxy(this.hecEndpoint, this.hecEndpointType, this.hecToken, this.s3Configuration, this.cloudWatchLoggingOptions, this.hecAcknowledgmentTimeoutInSeconds, this.processingConfiguration, this.retryOptions, this.s3BackupMode);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SerializerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SerializerProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getOrcSerDe() {
            return null;
        }

        @Nullable
        default public Object getParquetSerDe() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SerializerProperty> {
            private Object orcSerDe;
            private Object parquetSerDe;

            public Builder orcSerDe(OrcSerDeProperty orcSerDe) {
                this.orcSerDe = orcSerDe;
                return this;
            }

            public Builder orcSerDe(IResolvable orcSerDe) {
                this.orcSerDe = orcSerDe;
                return this;
            }

            public Builder parquetSerDe(ParquetSerDeProperty parquetSerDe) {
                this.parquetSerDe = parquetSerDe;
                return this;
            }

            public Builder parquetSerDe(IResolvable parquetSerDe) {
                this.parquetSerDe = parquetSerDe;
                return this;
            }

            public SerializerProperty build() {
                return new Jsii.Proxy(this.orcSerDe, this.parquetSerDe);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SchemaConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SchemaConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCatalogId() {
            return null;
        }

        @Nullable
        default public String getDatabaseName() {
            return null;
        }

        @Nullable
        default public String getRegion() {
            return null;
        }

        @Nullable
        default public String getRoleArn() {
            return null;
        }

        @Nullable
        default public String getTableName() {
            return null;
        }

        @Nullable
        default public String getVersionId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SchemaConfigurationProperty> {
            private String catalogId;
            private String databaseName;
            private String region;
            private String roleArn;
            private String tableName;
            private String versionId;

            public Builder catalogId(String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public Builder versionId(String versionId) {
                this.versionId = versionId;
                return this;
            }

            public SchemaConfigurationProperty build() {
                return new Jsii.Proxy(this.catalogId, this.databaseName, this.region, this.roleArn, this.tableName, this.versionId);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3DestinationConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketArn();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public Object getBufferingHints() {
            return null;
        }

        @Nullable
        default public Object getCloudWatchLoggingOptions() {
            return null;
        }

        @Nullable
        default public String getCompressionFormat() {
            return null;
        }

        @Nullable
        default public Object getEncryptionConfiguration() {
            return null;
        }

        @Nullable
        default public String getErrorOutputPrefix() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3DestinationConfigurationProperty> {
            private String bucketArn;
            private String roleArn;
            private Object bufferingHints;
            private Object cloudWatchLoggingOptions;
            private String compressionFormat;
            private Object encryptionConfiguration;
            private String errorOutputPrefix;
            private String prefix;

            public Builder bucketArn(String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder bufferingHints(BufferingHintsProperty bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            public Builder bufferingHints(IResolvable bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            public Builder cloudWatchLoggingOptions(IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            public Builder compressionFormat(String compressionFormat) {
                this.compressionFormat = compressionFormat;
                return this;
            }

            public Builder encryptionConfiguration(EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            public Builder encryptionConfiguration(IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            public Builder errorOutputPrefix(String errorOutputPrefix) {
                this.errorOutputPrefix = errorOutputPrefix;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public S3DestinationConfigurationProperty build() {
                return new Jsii.Proxy(this.bucketArn, this.roleArn, this.bufferingHints, this.cloudWatchLoggingOptions, this.compressionFormat, this.encryptionConfiguration, this.errorOutputPrefix, this.prefix);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.RetryOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RetryOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getDurationInSeconds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RetryOptionsProperty> {
            private Number durationInSeconds;

            public Builder durationInSeconds(Number durationInSeconds) {
                this.durationInSeconds = durationInSeconds;
                return this;
            }

            public RetryOptionsProperty build() {
                return new Jsii.Proxy(this.durationInSeconds);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.RedshiftRetryOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedshiftRetryOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getDurationInSeconds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedshiftRetryOptionsProperty> {
            private Number durationInSeconds;

            public Builder durationInSeconds(Number durationInSeconds) {
                this.durationInSeconds = durationInSeconds;
                return this;
            }

            public RedshiftRetryOptionsProperty build() {
                return new Jsii.Proxy(this.durationInSeconds);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.RedshiftDestinationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedshiftDestinationConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getClusterJdbcurl();

        @NotNull
        public Object getCopyCommand();

        @NotNull
        public String getPassword();

        @NotNull
        public String getRoleArn();

        @NotNull
        public Object getS3Configuration();

        @NotNull
        public String getUsername();

        @Nullable
        default public Object getCloudWatchLoggingOptions() {
            return null;
        }

        @Nullable
        default public Object getProcessingConfiguration() {
            return null;
        }

        @Nullable
        default public Object getRetryOptions() {
            return null;
        }

        @Nullable
        default public Object getS3BackupConfiguration() {
            return null;
        }

        @Nullable
        default public String getS3BackupMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedshiftDestinationConfigurationProperty> {
            private String clusterJdbcurl;
            private Object copyCommand;
            private String password;
            private String roleArn;
            private Object s3Configuration;
            private String username;
            private Object cloudWatchLoggingOptions;
            private Object processingConfiguration;
            private Object retryOptions;
            private Object s3BackupConfiguration;
            private String s3BackupMode;

            public Builder clusterJdbcurl(String clusterJdbcurl) {
                this.clusterJdbcurl = clusterJdbcurl;
                return this;
            }

            public Builder copyCommand(CopyCommandProperty copyCommand) {
                this.copyCommand = copyCommand;
                return this;
            }

            public Builder copyCommand(IResolvable copyCommand) {
                this.copyCommand = copyCommand;
                return this;
            }

            public Builder password(String password) {
                this.password = password;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder s3Configuration(S3DestinationConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            public Builder s3Configuration(IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            public Builder username(String username) {
                this.username = username;
                return this;
            }

            public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            public Builder cloudWatchLoggingOptions(IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            public Builder processingConfiguration(ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            public Builder processingConfiguration(IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            public Builder retryOptions(RedshiftRetryOptionsProperty retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            public Builder retryOptions(IResolvable retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            public Builder s3BackupConfiguration(S3DestinationConfigurationProperty s3BackupConfiguration) {
                this.s3BackupConfiguration = s3BackupConfiguration;
                return this;
            }

            public Builder s3BackupConfiguration(IResolvable s3BackupConfiguration) {
                this.s3BackupConfiguration = s3BackupConfiguration;
                return this;
            }

            public Builder s3BackupMode(String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            public RedshiftDestinationConfigurationProperty build() {
                return new Jsii.Proxy(this.clusterJdbcurl, this.copyCommand, this.password, this.roleArn, this.s3Configuration, this.username, this.cloudWatchLoggingOptions, this.processingConfiguration, this.retryOptions, this.s3BackupConfiguration, this.s3BackupMode);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ProcessorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProcessorProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public Object getParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProcessorProperty> {
            private String type;
            private Object parameters;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder parameters(IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            public Builder parameters(List<? extends Object> parameters) {
                this.parameters = parameters;
                return this;
            }

            public ProcessorProperty build() {
                return new Jsii.Proxy(this.type, this.parameters);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ProcessorParameterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProcessorParameterProperty
    extends JsiiSerializable {
        @NotNull
        public String getParameterName();

        @NotNull
        public String getParameterValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProcessorParameterProperty> {
            private String parameterName;
            private String parameterValue;

            public Builder parameterName(String parameterName) {
                this.parameterName = parameterName;
                return this;
            }

            public Builder parameterValue(String parameterValue) {
                this.parameterValue = parameterValue;
                return this;
            }

            public ProcessorParameterProperty build() {
                return new Jsii.Proxy(this.parameterName, this.parameterValue);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProcessingConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public Object getProcessors() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProcessingConfigurationProperty> {
            private Object enabled;
            private Object processors;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder processors(IResolvable processors) {
                this.processors = processors;
                return this;
            }

            public Builder processors(List<? extends Object> processors) {
                this.processors = processors;
                return this;
            }

            public ProcessingConfigurationProperty build() {
                return new Jsii.Proxy(this.enabled, this.processors);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ParquetSerDeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParquetSerDeProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBlockSizeBytes() {
            return null;
        }

        @Nullable
        default public String getCompression() {
            return null;
        }

        @Nullable
        default public Object getEnableDictionaryCompression() {
            return null;
        }

        @Nullable
        default public Number getMaxPaddingBytes() {
            return null;
        }

        @Nullable
        default public Number getPageSizeBytes() {
            return null;
        }

        @Nullable
        default public String getWriterVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParquetSerDeProperty> {
            private Number blockSizeBytes;
            private String compression;
            private Object enableDictionaryCompression;
            private Number maxPaddingBytes;
            private Number pageSizeBytes;
            private String writerVersion;

            public Builder blockSizeBytes(Number blockSizeBytes) {
                this.blockSizeBytes = blockSizeBytes;
                return this;
            }

            public Builder compression(String compression) {
                this.compression = compression;
                return this;
            }

            public Builder enableDictionaryCompression(Boolean enableDictionaryCompression) {
                this.enableDictionaryCompression = enableDictionaryCompression;
                return this;
            }

            public Builder enableDictionaryCompression(IResolvable enableDictionaryCompression) {
                this.enableDictionaryCompression = enableDictionaryCompression;
                return this;
            }

            public Builder maxPaddingBytes(Number maxPaddingBytes) {
                this.maxPaddingBytes = maxPaddingBytes;
                return this;
            }

            public Builder pageSizeBytes(Number pageSizeBytes) {
                this.pageSizeBytes = pageSizeBytes;
                return this;
            }

            public Builder writerVersion(String writerVersion) {
                this.writerVersion = writerVersion;
                return this;
            }

            public ParquetSerDeProperty build() {
                return new Jsii.Proxy(this.blockSizeBytes, this.compression, this.enableDictionaryCompression, this.maxPaddingBytes, this.pageSizeBytes, this.writerVersion);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.OutputFormatConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OutputFormatConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSerializer() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OutputFormatConfigurationProperty> {
            private Object serializer;

            public Builder serializer(SerializerProperty serializer) {
                this.serializer = serializer;
                return this;
            }

            public Builder serializer(IResolvable serializer) {
                this.serializer = serializer;
                return this;
            }

            public OutputFormatConfigurationProperty build() {
                return new Jsii.Proxy(this.serializer);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.OrcSerDeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OrcSerDeProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBlockSizeBytes() {
            return null;
        }

        @Nullable
        default public List<String> getBloomFilterColumns() {
            return null;
        }

        @Nullable
        default public Number getBloomFilterFalsePositiveProbability() {
            return null;
        }

        @Nullable
        default public String getCompression() {
            return null;
        }

        @Nullable
        default public Number getDictionaryKeyThreshold() {
            return null;
        }

        @Nullable
        default public Object getEnablePadding() {
            return null;
        }

        @Nullable
        default public String getFormatVersion() {
            return null;
        }

        @Nullable
        default public Number getPaddingTolerance() {
            return null;
        }

        @Nullable
        default public Number getRowIndexStride() {
            return null;
        }

        @Nullable
        default public Number getStripeSizeBytes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OrcSerDeProperty> {
            private Number blockSizeBytes;
            private List<String> bloomFilterColumns;
            private Number bloomFilterFalsePositiveProbability;
            private String compression;
            private Number dictionaryKeyThreshold;
            private Object enablePadding;
            private String formatVersion;
            private Number paddingTolerance;
            private Number rowIndexStride;
            private Number stripeSizeBytes;

            public Builder blockSizeBytes(Number blockSizeBytes) {
                this.blockSizeBytes = blockSizeBytes;
                return this;
            }

            public Builder bloomFilterColumns(List<String> bloomFilterColumns) {
                this.bloomFilterColumns = bloomFilterColumns;
                return this;
            }

            public Builder bloomFilterFalsePositiveProbability(Number bloomFilterFalsePositiveProbability) {
                this.bloomFilterFalsePositiveProbability = bloomFilterFalsePositiveProbability;
                return this;
            }

            public Builder compression(String compression) {
                this.compression = compression;
                return this;
            }

            public Builder dictionaryKeyThreshold(Number dictionaryKeyThreshold) {
                this.dictionaryKeyThreshold = dictionaryKeyThreshold;
                return this;
            }

            public Builder enablePadding(Boolean enablePadding) {
                this.enablePadding = enablePadding;
                return this;
            }

            public Builder enablePadding(IResolvable enablePadding) {
                this.enablePadding = enablePadding;
                return this;
            }

            public Builder formatVersion(String formatVersion) {
                this.formatVersion = formatVersion;
                return this;
            }

            public Builder paddingTolerance(Number paddingTolerance) {
                this.paddingTolerance = paddingTolerance;
                return this;
            }

            public Builder rowIndexStride(Number rowIndexStride) {
                this.rowIndexStride = rowIndexStride;
                return this;
            }

            public Builder stripeSizeBytes(Number stripeSizeBytes) {
                this.stripeSizeBytes = stripeSizeBytes;
                return this;
            }

            public OrcSerDeProperty build() {
                return new Jsii.Proxy(this.blockSizeBytes, this.bloomFilterColumns, this.bloomFilterFalsePositiveProbability, this.compression, this.dictionaryKeyThreshold, this.enablePadding, this.formatVersion, this.paddingTolerance, this.rowIndexStride, this.stripeSizeBytes);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.OpenXJsonSerDeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OpenXJsonSerDeProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCaseInsensitive() {
            return null;
        }

        @Nullable
        default public Object getColumnToJsonKeyMappings() {
            return null;
        }

        @Nullable
        default public Object getConvertDotsInJsonKeysToUnderscores() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OpenXJsonSerDeProperty> {
            private Object caseInsensitive;
            private Object columnToJsonKeyMappings;
            private Object convertDotsInJsonKeysToUnderscores;

            public Builder caseInsensitive(Boolean caseInsensitive) {
                this.caseInsensitive = caseInsensitive;
                return this;
            }

            public Builder caseInsensitive(IResolvable caseInsensitive) {
                this.caseInsensitive = caseInsensitive;
                return this;
            }

            public Builder columnToJsonKeyMappings(IResolvable columnToJsonKeyMappings) {
                this.columnToJsonKeyMappings = columnToJsonKeyMappings;
                return this;
            }

            public Builder columnToJsonKeyMappings(Map<String, String> columnToJsonKeyMappings) {
                this.columnToJsonKeyMappings = columnToJsonKeyMappings;
                return this;
            }

            public Builder convertDotsInJsonKeysToUnderscores(Boolean convertDotsInJsonKeysToUnderscores) {
                this.convertDotsInJsonKeysToUnderscores = convertDotsInJsonKeysToUnderscores;
                return this;
            }

            public Builder convertDotsInJsonKeysToUnderscores(IResolvable convertDotsInJsonKeysToUnderscores) {
                this.convertDotsInJsonKeysToUnderscores = convertDotsInJsonKeysToUnderscores;
                return this;
            }

            public OpenXJsonSerDeProperty build() {
                return new Jsii.Proxy(this.caseInsensitive, this.columnToJsonKeyMappings, this.convertDotsInJsonKeysToUnderscores);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.KinesisStreamSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisStreamSourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getKinesisStreamArn();

        @NotNull
        public String getRoleArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KinesisStreamSourceConfigurationProperty> {
            private String kinesisStreamArn;
            private String roleArn;

            public Builder kinesisStreamArn(String kinesisStreamArn) {
                this.kinesisStreamArn = kinesisStreamArn;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public KinesisStreamSourceConfigurationProperty build() {
                return new Jsii.Proxy(this.kinesisStreamArn, this.roleArn);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.KMSEncryptionConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KMSEncryptionConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getAwskmsKeyArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KMSEncryptionConfigProperty> {
            private String awskmsKeyArn;

            public Builder awskmsKeyArn(String awskmsKeyArn) {
                this.awskmsKeyArn = awskmsKeyArn;
                return this;
            }

            public KMSEncryptionConfigProperty build() {
                return new Jsii.Proxy(this.awskmsKeyArn);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.InputFormatConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputFormatConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDeserializer() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputFormatConfigurationProperty> {
            private Object deserializer;

            public Builder deserializer(DeserializerProperty deserializer) {
                this.deserializer = deserializer;
                return this;
            }

            public Builder deserializer(IResolvable deserializer) {
                this.deserializer = deserializer;
                return this;
            }

            public InputFormatConfigurationProperty build() {
                return new Jsii.Proxy(this.deserializer);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointRequestConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HttpEndpointRequestConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCommonAttributes() {
            return null;
        }

        @Nullable
        default public String getContentEncoding() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HttpEndpointRequestConfigurationProperty> {
            private Object commonAttributes;
            private String contentEncoding;

            public Builder commonAttributes(IResolvable commonAttributes) {
                this.commonAttributes = commonAttributes;
                return this;
            }

            public Builder commonAttributes(List<? extends Object> commonAttributes) {
                this.commonAttributes = commonAttributes;
                return this;
            }

            public Builder contentEncoding(String contentEncoding) {
                this.contentEncoding = contentEncoding;
                return this;
            }

            public HttpEndpointRequestConfigurationProperty build() {
                return new Jsii.Proxy(this.commonAttributes, this.contentEncoding);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HttpEndpointDestinationConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEndpointConfiguration();

        @NotNull
        public Object getS3Configuration();

        @Nullable
        default public Object getBufferingHints() {
            return null;
        }

        @Nullable
        default public Object getCloudWatchLoggingOptions() {
            return null;
        }

        @Nullable
        default public Object getProcessingConfiguration() {
            return null;
        }

        @Nullable
        default public Object getRequestConfiguration() {
            return null;
        }

        @Nullable
        default public Object getRetryOptions() {
            return null;
        }

        @Nullable
        default public String getRoleArn() {
            return null;
        }

        @Nullable
        default public String getS3BackupMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HttpEndpointDestinationConfigurationProperty> {
            private Object endpointConfiguration;
            private Object s3Configuration;
            private Object bufferingHints;
            private Object cloudWatchLoggingOptions;
            private Object processingConfiguration;
            private Object requestConfiguration;
            private Object retryOptions;
            private String roleArn;
            private String s3BackupMode;

            public Builder endpointConfiguration(HttpEndpointConfigurationProperty endpointConfiguration) {
                this.endpointConfiguration = endpointConfiguration;
                return this;
            }

            public Builder endpointConfiguration(IResolvable endpointConfiguration) {
                this.endpointConfiguration = endpointConfiguration;
                return this;
            }

            public Builder s3Configuration(S3DestinationConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            public Builder s3Configuration(IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            public Builder bufferingHints(BufferingHintsProperty bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            public Builder bufferingHints(IResolvable bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            public Builder cloudWatchLoggingOptions(IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            public Builder processingConfiguration(ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            public Builder processingConfiguration(IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            public Builder requestConfiguration(HttpEndpointRequestConfigurationProperty requestConfiguration) {
                this.requestConfiguration = requestConfiguration;
                return this;
            }

            public Builder requestConfiguration(IResolvable requestConfiguration) {
                this.requestConfiguration = requestConfiguration;
                return this;
            }

            public Builder retryOptions(RetryOptionsProperty retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            public Builder retryOptions(IResolvable retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder s3BackupMode(String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            public HttpEndpointDestinationConfigurationProperty build() {
                return new Jsii.Proxy(this.endpointConfiguration, this.s3Configuration, this.bufferingHints, this.cloudWatchLoggingOptions, this.processingConfiguration, this.requestConfiguration, this.retryOptions, this.roleArn, this.s3BackupMode);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HttpEndpointConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getUrl();

        @Nullable
        default public String getAccessKey() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HttpEndpointConfigurationProperty> {
            private String url;
            private String accessKey;
            private String name;

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public Builder accessKey(String accessKey) {
                this.accessKey = accessKey;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public HttpEndpointConfigurationProperty build() {
                return new Jsii.Proxy(this.url, this.accessKey, this.name);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointCommonAttributeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HttpEndpointCommonAttributeProperty
    extends JsiiSerializable {
        @NotNull
        public String getAttributeName();

        @NotNull
        public String getAttributeValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HttpEndpointCommonAttributeProperty> {
            private String attributeName;
            private String attributeValue;

            public Builder attributeName(String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            public Builder attributeValue(String attributeValue) {
                this.attributeValue = attributeValue;
                return this;
            }

            public HttpEndpointCommonAttributeProperty build() {
                return new Jsii.Proxy(this.attributeName, this.attributeValue);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HiveJsonSerDeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HiveJsonSerDeProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getTimestampFormats() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HiveJsonSerDeProperty> {
            private List<String> timestampFormats;

            public Builder timestampFormats(List<String> timestampFormats) {
                this.timestampFormats = timestampFormats;
                return this;
            }

            public HiveJsonSerDeProperty build() {
                return new Jsii.Proxy(this.timestampFormats);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ExtendedS3DestinationConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketArn();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public Object getBufferingHints() {
            return null;
        }

        @Nullable
        default public Object getCloudWatchLoggingOptions() {
            return null;
        }

        @Nullable
        default public String getCompressionFormat() {
            return null;
        }

        @Nullable
        default public Object getDataFormatConversionConfiguration() {
            return null;
        }

        @Nullable
        default public Object getEncryptionConfiguration() {
            return null;
        }

        @Nullable
        default public String getErrorOutputPrefix() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        @Nullable
        default public Object getProcessingConfiguration() {
            return null;
        }

        @Nullable
        default public Object getS3BackupConfiguration() {
            return null;
        }

        @Nullable
        default public String getS3BackupMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ExtendedS3DestinationConfigurationProperty> {
            private String bucketArn;
            private String roleArn;
            private Object bufferingHints;
            private Object cloudWatchLoggingOptions;
            private String compressionFormat;
            private Object dataFormatConversionConfiguration;
            private Object encryptionConfiguration;
            private String errorOutputPrefix;
            private String prefix;
            private Object processingConfiguration;
            private Object s3BackupConfiguration;
            private String s3BackupMode;

            public Builder bucketArn(String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder bufferingHints(BufferingHintsProperty bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            public Builder bufferingHints(IResolvable bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            public Builder cloudWatchLoggingOptions(IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            public Builder compressionFormat(String compressionFormat) {
                this.compressionFormat = compressionFormat;
                return this;
            }

            public Builder dataFormatConversionConfiguration(DataFormatConversionConfigurationProperty dataFormatConversionConfiguration) {
                this.dataFormatConversionConfiguration = dataFormatConversionConfiguration;
                return this;
            }

            public Builder dataFormatConversionConfiguration(IResolvable dataFormatConversionConfiguration) {
                this.dataFormatConversionConfiguration = dataFormatConversionConfiguration;
                return this;
            }

            public Builder encryptionConfiguration(EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            public Builder encryptionConfiguration(IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            public Builder errorOutputPrefix(String errorOutputPrefix) {
                this.errorOutputPrefix = errorOutputPrefix;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder processingConfiguration(ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            public Builder processingConfiguration(IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            public Builder s3BackupConfiguration(S3DestinationConfigurationProperty s3BackupConfiguration) {
                this.s3BackupConfiguration = s3BackupConfiguration;
                return this;
            }

            public Builder s3BackupConfiguration(IResolvable s3BackupConfiguration) {
                this.s3BackupConfiguration = s3BackupConfiguration;
                return this;
            }

            public Builder s3BackupMode(String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            public ExtendedS3DestinationConfigurationProperty build() {
                return new Jsii.Proxy(this.bucketArn, this.roleArn, this.bufferingHints, this.cloudWatchLoggingOptions, this.compressionFormat, this.dataFormatConversionConfiguration, this.encryptionConfiguration, this.errorOutputPrefix, this.prefix, this.processingConfiguration, this.s3BackupConfiguration, this.s3BackupMode);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getKmsEncryptionConfig() {
            return null;
        }

        @Nullable
        default public String getNoEncryptionConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncryptionConfigurationProperty> {
            private Object kmsEncryptionConfig;
            private String noEncryptionConfig;

            public Builder kmsEncryptionConfig(KMSEncryptionConfigProperty kmsEncryptionConfig) {
                this.kmsEncryptionConfig = kmsEncryptionConfig;
                return this;
            }

            public Builder kmsEncryptionConfig(IResolvable kmsEncryptionConfig) {
                this.kmsEncryptionConfig = kmsEncryptionConfig;
                return this;
            }

            public Builder noEncryptionConfig(String noEncryptionConfig) {
                this.noEncryptionConfig = noEncryptionConfig;
                return this;
            }

            public EncryptionConfigurationProperty build() {
                return new Jsii.Proxy(this.kmsEncryptionConfig, this.noEncryptionConfig);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ElasticsearchRetryOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ElasticsearchRetryOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getDurationInSeconds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ElasticsearchRetryOptionsProperty> {
            private Number durationInSeconds;

            public Builder durationInSeconds(Number durationInSeconds) {
                this.durationInSeconds = durationInSeconds;
                return this;
            }

            public ElasticsearchRetryOptionsProperty build() {
                return new Jsii.Proxy(this.durationInSeconds);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ElasticsearchDestinationConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getIndexName();

        @NotNull
        public String getRoleArn();

        @NotNull
        public Object getS3Configuration();

        @Nullable
        default public Object getBufferingHints() {
            return null;
        }

        @Nullable
        default public Object getCloudWatchLoggingOptions() {
            return null;
        }

        @Nullable
        default public String getClusterEndpoint() {
            return null;
        }

        @Nullable
        default public String getDomainArn() {
            return null;
        }

        @Nullable
        default public String getIndexRotationPeriod() {
            return null;
        }

        @Nullable
        default public Object getProcessingConfiguration() {
            return null;
        }

        @Nullable
        default public Object getRetryOptions() {
            return null;
        }

        @Nullable
        default public String getS3BackupMode() {
            return null;
        }

        @Nullable
        default public String getTypeName() {
            return null;
        }

        @Nullable
        default public Object getVpcConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ElasticsearchDestinationConfigurationProperty> {
            private String indexName;
            private String roleArn;
            private Object s3Configuration;
            private Object bufferingHints;
            private Object cloudWatchLoggingOptions;
            private String clusterEndpoint;
            private String domainArn;
            private String indexRotationPeriod;
            private Object processingConfiguration;
            private Object retryOptions;
            private String s3BackupMode;
            private String typeName;
            private Object vpcConfiguration;

            public Builder indexName(String indexName) {
                this.indexName = indexName;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder s3Configuration(S3DestinationConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            public Builder s3Configuration(IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            public Builder bufferingHints(ElasticsearchBufferingHintsProperty bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            public Builder bufferingHints(IResolvable bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            public Builder cloudWatchLoggingOptions(IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            public Builder clusterEndpoint(String clusterEndpoint) {
                this.clusterEndpoint = clusterEndpoint;
                return this;
            }

            public Builder domainArn(String domainArn) {
                this.domainArn = domainArn;
                return this;
            }

            public Builder indexRotationPeriod(String indexRotationPeriod) {
                this.indexRotationPeriod = indexRotationPeriod;
                return this;
            }

            public Builder processingConfiguration(ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            public Builder processingConfiguration(IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            public Builder retryOptions(ElasticsearchRetryOptionsProperty retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            public Builder retryOptions(IResolvable retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            public Builder s3BackupMode(String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            public Builder typeName(String typeName) {
                this.typeName = typeName;
                return this;
            }

            public Builder vpcConfiguration(VpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public Builder vpcConfiguration(IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public ElasticsearchDestinationConfigurationProperty build() {
                return new Jsii.Proxy(this.indexName, this.roleArn, this.s3Configuration, this.bufferingHints, this.cloudWatchLoggingOptions, this.clusterEndpoint, this.domainArn, this.indexRotationPeriod, this.processingConfiguration, this.retryOptions, this.s3BackupMode, this.typeName, this.vpcConfiguration);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ElasticsearchBufferingHintsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ElasticsearchBufferingHintsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getIntervalInSeconds() {
            return null;
        }

        @Nullable
        default public Number getSizeInMBs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ElasticsearchBufferingHintsProperty> {
            private Number intervalInSeconds;
            private Number sizeInMBs;

            public Builder intervalInSeconds(Number intervalInSeconds) {
                this.intervalInSeconds = intervalInSeconds;
                return this;
            }

            public Builder sizeInMBs(Number sizeInMBs) {
                this.sizeInMBs = sizeInMBs;
                return this;
            }

            public ElasticsearchBufferingHintsProperty build() {
                return new Jsii.Proxy(this.intervalInSeconds, this.sizeInMBs);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DeserializerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeserializerProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getHiveJsonSerDe() {
            return null;
        }

        @Nullable
        default public Object getOpenXJsonSerDe() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeserializerProperty> {
            private Object hiveJsonSerDe;
            private Object openXJsonSerDe;

            public Builder hiveJsonSerDe(HiveJsonSerDeProperty hiveJsonSerDe) {
                this.hiveJsonSerDe = hiveJsonSerDe;
                return this;
            }

            public Builder hiveJsonSerDe(IResolvable hiveJsonSerDe) {
                this.hiveJsonSerDe = hiveJsonSerDe;
                return this;
            }

            public Builder openXJsonSerDe(OpenXJsonSerDeProperty openXJsonSerDe) {
                this.openXJsonSerDe = openXJsonSerDe;
                return this;
            }

            public Builder openXJsonSerDe(IResolvable openXJsonSerDe) {
                this.openXJsonSerDe = openXJsonSerDe;
                return this;
            }

            public DeserializerProperty build() {
                return new Jsii.Proxy(this.hiveJsonSerDe, this.openXJsonSerDe);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeliveryStreamEncryptionConfigurationInputProperty
    extends JsiiSerializable {
        @NotNull
        public String getKeyType();

        @Nullable
        default public String getKeyArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeliveryStreamEncryptionConfigurationInputProperty> {
            private String keyType;
            private String keyArn;

            public Builder keyType(String keyType) {
                this.keyType = keyType;
                return this;
            }

            public Builder keyArn(String keyArn) {
                this.keyArn = keyArn;
                return this;
            }

            public DeliveryStreamEncryptionConfigurationInputProperty build() {
                return new Jsii.Proxy(this.keyType, this.keyArn);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DataFormatConversionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataFormatConversionConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public Object getInputFormatConfiguration() {
            return null;
        }

        @Nullable
        default public Object getOutputFormatConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSchemaConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataFormatConversionConfigurationProperty> {
            private Object enabled;
            private Object inputFormatConfiguration;
            private Object outputFormatConfiguration;
            private Object schemaConfiguration;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder inputFormatConfiguration(InputFormatConfigurationProperty inputFormatConfiguration) {
                this.inputFormatConfiguration = inputFormatConfiguration;
                return this;
            }

            public Builder inputFormatConfiguration(IResolvable inputFormatConfiguration) {
                this.inputFormatConfiguration = inputFormatConfiguration;
                return this;
            }

            public Builder outputFormatConfiguration(OutputFormatConfigurationProperty outputFormatConfiguration) {
                this.outputFormatConfiguration = outputFormatConfiguration;
                return this;
            }

            public Builder outputFormatConfiguration(IResolvable outputFormatConfiguration) {
                this.outputFormatConfiguration = outputFormatConfiguration;
                return this;
            }

            public Builder schemaConfiguration(SchemaConfigurationProperty schemaConfiguration) {
                this.schemaConfiguration = schemaConfiguration;
                return this;
            }

            public Builder schemaConfiguration(IResolvable schemaConfiguration) {
                this.schemaConfiguration = schemaConfiguration;
                return this;
            }

            public DataFormatConversionConfigurationProperty build() {
                return new Jsii.Proxy(this.enabled, this.inputFormatConfiguration, this.outputFormatConfiguration, this.schemaConfiguration);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.CopyCommandProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CopyCommandProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataTableName();

        @Nullable
        default public String getCopyOptions() {
            return null;
        }

        @Nullable
        default public String getDataTableColumns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CopyCommandProperty> {
            private String dataTableName;
            private String copyOptions;
            private String dataTableColumns;

            public Builder dataTableName(String dataTableName) {
                this.dataTableName = dataTableName;
                return this;
            }

            public Builder copyOptions(String copyOptions) {
                this.copyOptions = copyOptions;
                return this;
            }

            public Builder dataTableColumns(String dataTableColumns) {
                this.dataTableColumns = dataTableColumns;
                return this;
            }

            public CopyCommandProperty build() {
                return new Jsii.Proxy(this.dataTableName, this.copyOptions, this.dataTableColumns);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudWatchLoggingOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public String getLogGroupName() {
            return null;
        }

        @Nullable
        default public String getLogStreamName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudWatchLoggingOptionsProperty> {
            private Object enabled;
            private String logGroupName;
            private String logStreamName;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder logGroupName(String logGroupName) {
                this.logGroupName = logGroupName;
                return this;
            }

            public Builder logStreamName(String logStreamName) {
                this.logStreamName = logStreamName;
                return this;
            }

            public CloudWatchLoggingOptionsProperty build() {
                return new Jsii.Proxy(this.enabled, this.logGroupName, this.logStreamName);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.BufferingHintsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BufferingHintsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getIntervalInSeconds() {
            return null;
        }

        @Nullable
        default public Number getSizeInMBs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BufferingHintsProperty> {
            private Number intervalInSeconds;
            private Number sizeInMBs;

            public Builder intervalInSeconds(Number intervalInSeconds) {
                this.intervalInSeconds = intervalInSeconds;
                return this;
            }

            public Builder sizeInMBs(Number sizeInMBs) {
                this.sizeInMBs = sizeInMBs;
                return this;
            }

            public BufferingHintsProperty build() {
                return new Jsii.Proxy(this.intervalInSeconds, this.sizeInMBs);
            }
        }
    }
}

