/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.rds.CfnDBCluster;
import software.amazon.awscdk.services.rds.CfnDBClusterProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBCluster")
public class CfnDBCluster
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDBCluster.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDBCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDBCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDBCluster(@NotNull Construct scope, @NotNull String id, @NotNull CfnDBClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrEndpointAddress() {
        return (String)Kernel.get((Object)this, (String)"attrEndpointAddress", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrEndpointPort() {
        return (String)Kernel.get((Object)this, (String)"attrEndpointPort", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrReadEndpointAddress() {
        return (String)Kernel.get((Object)this, (String)"attrReadEndpointAddress", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getEngine() {
        return (String)Kernel.get((Object)this, (String)"engine", (NativeType)NativeType.forClass(String.class));
    }

    public void setEngine(@NotNull String value) {
        Kernel.set((Object)this, (String)"engine", (Object)Objects.requireNonNull(value, "engine is required"));
    }

    @Nullable
    public Object getAssociatedRoles() {
        return Kernel.get((Object)this, (String)"associatedRoles", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAssociatedRoles(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"associatedRoles", (Object)value);
    }

    public void setAssociatedRoles(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"associatedRoles", value);
    }

    @Nullable
    public List<String> getAvailabilityZones() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"availabilityZones", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setAvailabilityZones(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"availabilityZones", value);
    }

    @Nullable
    public Number getBacktrackWindow() {
        return (Number)Kernel.get((Object)this, (String)"backtrackWindow", (NativeType)NativeType.forClass(Number.class));
    }

    public void setBacktrackWindow(@Nullable Number value) {
        Kernel.set((Object)this, (String)"backtrackWindow", (Object)value);
    }

    @Nullable
    public Number getBackupRetentionPeriod() {
        return (Number)Kernel.get((Object)this, (String)"backupRetentionPeriod", (NativeType)NativeType.forClass(Number.class));
    }

    public void setBackupRetentionPeriod(@Nullable Number value) {
        Kernel.set((Object)this, (String)"backupRetentionPeriod", (Object)value);
    }

    @Nullable
    public String getDatabaseName() {
        return (String)Kernel.get((Object)this, (String)"databaseName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDatabaseName(@Nullable String value) {
        Kernel.set((Object)this, (String)"databaseName", (Object)value);
    }

    @Nullable
    public String getDbClusterIdentifier() {
        return (String)Kernel.get((Object)this, (String)"dbClusterIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbClusterIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"dbClusterIdentifier", (Object)value);
    }

    @Nullable
    public String getDbClusterParameterGroupName() {
        return (String)Kernel.get((Object)this, (String)"dbClusterParameterGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbClusterParameterGroupName(@Nullable String value) {
        Kernel.set((Object)this, (String)"dbClusterParameterGroupName", (Object)value);
    }

    @Nullable
    public String getDbSubnetGroupName() {
        return (String)Kernel.get((Object)this, (String)"dbSubnetGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbSubnetGroupName(@Nullable String value) {
        Kernel.set((Object)this, (String)"dbSubnetGroupName", (Object)value);
    }

    @Nullable
    public Object getDeletionProtection() {
        return Kernel.get((Object)this, (String)"deletionProtection", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDeletionProtection(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"deletionProtection", (Object)value);
    }

    public void setDeletionProtection(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"deletionProtection", (Object)value);
    }

    @Nullable
    public List<String> getEnableCloudwatchLogsExports() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"enableCloudwatchLogsExports", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setEnableCloudwatchLogsExports(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"enableCloudwatchLogsExports", value);
    }

    @Nullable
    public Object getEnableHttpEndpoint() {
        return Kernel.get((Object)this, (String)"enableHttpEndpoint", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnableHttpEndpoint(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"enableHttpEndpoint", (Object)value);
    }

    public void setEnableHttpEndpoint(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"enableHttpEndpoint", (Object)value);
    }

    @Nullable
    public Object getEnableIamDatabaseAuthentication() {
        return Kernel.get((Object)this, (String)"enableIamDatabaseAuthentication", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnableIamDatabaseAuthentication(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"enableIamDatabaseAuthentication", (Object)value);
    }

    public void setEnableIamDatabaseAuthentication(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"enableIamDatabaseAuthentication", (Object)value);
    }

    @Nullable
    public String getEngineMode() {
        return (String)Kernel.get((Object)this, (String)"engineMode", (NativeType)NativeType.forClass(String.class));
    }

    public void setEngineMode(@Nullable String value) {
        Kernel.set((Object)this, (String)"engineMode", (Object)value);
    }

    @Nullable
    public String getEngineVersion() {
        return (String)Kernel.get((Object)this, (String)"engineVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setEngineVersion(@Nullable String value) {
        Kernel.set((Object)this, (String)"engineVersion", (Object)value);
    }

    @Nullable
    public String getGlobalClusterIdentifier() {
        return (String)Kernel.get((Object)this, (String)"globalClusterIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setGlobalClusterIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"globalClusterIdentifier", (Object)value);
    }

    @Nullable
    public String getKmsKeyId() {
        return (String)Kernel.get((Object)this, (String)"kmsKeyId", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsKeyId(@Nullable String value) {
        Kernel.set((Object)this, (String)"kmsKeyId", (Object)value);
    }

    @Nullable
    public String getMasterUsername() {
        return (String)Kernel.get((Object)this, (String)"masterUsername", (NativeType)NativeType.forClass(String.class));
    }

    public void setMasterUsername(@Nullable String value) {
        Kernel.set((Object)this, (String)"masterUsername", (Object)value);
    }

    @Nullable
    public String getMasterUserPassword() {
        return (String)Kernel.get((Object)this, (String)"masterUserPassword", (NativeType)NativeType.forClass(String.class));
    }

    public void setMasterUserPassword(@Nullable String value) {
        Kernel.set((Object)this, (String)"masterUserPassword", (Object)value);
    }

    @Nullable
    public Number getPort() {
        return (Number)Kernel.get((Object)this, (String)"port", (NativeType)NativeType.forClass(Number.class));
    }

    public void setPort(@Nullable Number value) {
        Kernel.set((Object)this, (String)"port", (Object)value);
    }

    @Nullable
    public String getPreferredBackupWindow() {
        return (String)Kernel.get((Object)this, (String)"preferredBackupWindow", (NativeType)NativeType.forClass(String.class));
    }

    public void setPreferredBackupWindow(@Nullable String value) {
        Kernel.set((Object)this, (String)"preferredBackupWindow", (Object)value);
    }

    @Nullable
    public String getPreferredMaintenanceWindow() {
        return (String)Kernel.get((Object)this, (String)"preferredMaintenanceWindow", (NativeType)NativeType.forClass(String.class));
    }

    public void setPreferredMaintenanceWindow(@Nullable String value) {
        Kernel.set((Object)this, (String)"preferredMaintenanceWindow", (Object)value);
    }

    @Nullable
    public String getReplicationSourceIdentifier() {
        return (String)Kernel.get((Object)this, (String)"replicationSourceIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setReplicationSourceIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"replicationSourceIdentifier", (Object)value);
    }

    @Nullable
    public String getRestoreType() {
        return (String)Kernel.get((Object)this, (String)"restoreType", (NativeType)NativeType.forClass(String.class));
    }

    public void setRestoreType(@Nullable String value) {
        Kernel.set((Object)this, (String)"restoreType", (Object)value);
    }

    @Nullable
    public Object getScalingConfiguration() {
        return Kernel.get((Object)this, (String)"scalingConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setScalingConfiguration(@Nullable ScalingConfigurationProperty value) {
        Kernel.set((Object)this, (String)"scalingConfiguration", (Object)value);
    }

    public void setScalingConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"scalingConfiguration", (Object)value);
    }

    @Nullable
    public String getSnapshotIdentifier() {
        return (String)Kernel.get((Object)this, (String)"snapshotIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setSnapshotIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"snapshotIdentifier", (Object)value);
    }

    @Nullable
    public String getSourceDbClusterIdentifier() {
        return (String)Kernel.get((Object)this, (String)"sourceDbClusterIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setSourceDbClusterIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"sourceDbClusterIdentifier", (Object)value);
    }

    @Nullable
    public String getSourceRegion() {
        return (String)Kernel.get((Object)this, (String)"sourceRegion", (NativeType)NativeType.forClass(String.class));
    }

    public void setSourceRegion(@Nullable String value) {
        Kernel.set((Object)this, (String)"sourceRegion", (Object)value);
    }

    @Nullable
    public Object getStorageEncrypted() {
        return Kernel.get((Object)this, (String)"storageEncrypted", (NativeType)NativeType.forClass(Object.class));
    }

    public void setStorageEncrypted(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"storageEncrypted", (Object)value);
    }

    public void setStorageEncrypted(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"storageEncrypted", (Object)value);
    }

    @Nullable
    public Object getUseLatestRestorableTime() {
        return Kernel.get((Object)this, (String)"useLatestRestorableTime", (NativeType)NativeType.forClass(Object.class));
    }

    public void setUseLatestRestorableTime(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"useLatestRestorableTime", (Object)value);
    }

    public void setUseLatestRestorableTime(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"useLatestRestorableTime", (Object)value);
    }

    @Nullable
    public List<String> getVpcSecurityGroupIds() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"vpcSecurityGroupIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setVpcSecurityGroupIds(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"vpcSecurityGroupIds", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDBCluster> {
        private final Construct scope;
        private final String id;
        private final CfnDBClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDBClusterProps.Builder();
        }

        public Builder engine(String engine) {
            this.props.engine(engine);
            return this;
        }

        public Builder associatedRoles(IResolvable associatedRoles) {
            this.props.associatedRoles(associatedRoles);
            return this;
        }

        public Builder associatedRoles(List<? extends Object> associatedRoles) {
            this.props.associatedRoles(associatedRoles);
            return this;
        }

        public Builder availabilityZones(List<String> availabilityZones) {
            this.props.availabilityZones(availabilityZones);
            return this;
        }

        public Builder backtrackWindow(Number backtrackWindow) {
            this.props.backtrackWindow(backtrackWindow);
            return this;
        }

        public Builder backupRetentionPeriod(Number backupRetentionPeriod) {
            this.props.backupRetentionPeriod(backupRetentionPeriod);
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        public Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.props.dbClusterIdentifier(dbClusterIdentifier);
            return this;
        }

        public Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.props.dbClusterParameterGroupName(dbClusterParameterGroupName);
            return this;
        }

        public Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.props.dbSubnetGroupName(dbSubnetGroupName);
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        public Builder deletionProtection(IResolvable deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        public Builder enableCloudwatchLogsExports(List<String> enableCloudwatchLogsExports) {
            this.props.enableCloudwatchLogsExports(enableCloudwatchLogsExports);
            return this;
        }

        public Builder enableHttpEndpoint(Boolean enableHttpEndpoint) {
            this.props.enableHttpEndpoint(enableHttpEndpoint);
            return this;
        }

        public Builder enableHttpEndpoint(IResolvable enableHttpEndpoint) {
            this.props.enableHttpEndpoint(enableHttpEndpoint);
            return this;
        }

        public Builder enableIamDatabaseAuthentication(Boolean enableIamDatabaseAuthentication) {
            this.props.enableIamDatabaseAuthentication(enableIamDatabaseAuthentication);
            return this;
        }

        public Builder enableIamDatabaseAuthentication(IResolvable enableIamDatabaseAuthentication) {
            this.props.enableIamDatabaseAuthentication(enableIamDatabaseAuthentication);
            return this;
        }

        public Builder engineMode(String engineMode) {
            this.props.engineMode(engineMode);
            return this;
        }

        public Builder engineVersion(String engineVersion) {
            this.props.engineVersion(engineVersion);
            return this;
        }

        public Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.props.globalClusterIdentifier(globalClusterIdentifier);
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        public Builder masterUsername(String masterUsername) {
            this.props.masterUsername(masterUsername);
            return this;
        }

        public Builder masterUserPassword(String masterUserPassword) {
            this.props.masterUserPassword(masterUserPassword);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder preferredBackupWindow(String preferredBackupWindow) {
            this.props.preferredBackupWindow(preferredBackupWindow);
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        public Builder replicationSourceIdentifier(String replicationSourceIdentifier) {
            this.props.replicationSourceIdentifier(replicationSourceIdentifier);
            return this;
        }

        public Builder restoreType(String restoreType) {
            this.props.restoreType(restoreType);
            return this;
        }

        public Builder scalingConfiguration(ScalingConfigurationProperty scalingConfiguration) {
            this.props.scalingConfiguration(scalingConfiguration);
            return this;
        }

        public Builder scalingConfiguration(IResolvable scalingConfiguration) {
            this.props.scalingConfiguration(scalingConfiguration);
            return this;
        }

        public Builder snapshotIdentifier(String snapshotIdentifier) {
            this.props.snapshotIdentifier(snapshotIdentifier);
            return this;
        }

        public Builder sourceDbClusterIdentifier(String sourceDbClusterIdentifier) {
            this.props.sourceDbClusterIdentifier(sourceDbClusterIdentifier);
            return this;
        }

        public Builder sourceRegion(String sourceRegion) {
            this.props.sourceRegion(sourceRegion);
            return this;
        }

        public Builder storageEncrypted(Boolean storageEncrypted) {
            this.props.storageEncrypted(storageEncrypted);
            return this;
        }

        public Builder storageEncrypted(IResolvable storageEncrypted) {
            this.props.storageEncrypted(storageEncrypted);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder useLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.props.useLatestRestorableTime(useLatestRestorableTime);
            return this;
        }

        public Builder useLatestRestorableTime(IResolvable useLatestRestorableTime) {
            this.props.useLatestRestorableTime(useLatestRestorableTime);
            return this;
        }

        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            this.props.vpcSecurityGroupIds(vpcSecurityGroupIds);
            return this;
        }

        public CfnDBCluster build() {
            return new CfnDBCluster(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBCluster.ScalingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAutoPause() {
            return null;
        }

        @Nullable
        default public Number getMaxCapacity() {
            return null;
        }

        @Nullable
        default public Number getMinCapacity() {
            return null;
        }

        @Nullable
        default public Number getSecondsUntilAutoPause() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScalingConfigurationProperty> {
            private Object autoPause;
            private Number maxCapacity;
            private Number minCapacity;
            private Number secondsUntilAutoPause;

            public Builder autoPause(Boolean autoPause) {
                this.autoPause = autoPause;
                return this;
            }

            public Builder autoPause(IResolvable autoPause) {
                this.autoPause = autoPause;
                return this;
            }

            public Builder maxCapacity(Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            public Builder minCapacity(Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            public Builder secondsUntilAutoPause(Number secondsUntilAutoPause) {
                this.secondsUntilAutoPause = secondsUntilAutoPause;
                return this;
            }

            public ScalingConfigurationProperty build() {
                return new Jsii.Proxy(this.autoPause, this.maxCapacity, this.minCapacity, this.secondsUntilAutoPause);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBCluster.DBClusterRoleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DBClusterRoleProperty
    extends JsiiSerializable {
        @NotNull
        public String getRoleArn();

        @Nullable
        default public String getFeatureName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DBClusterRoleProperty> {
            private String roleArn;
            private String featureName;

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder featureName(String featureName) {
                this.featureName = featureName;
                return this;
            }

            public DBClusterRoleProperty build() {
                return new Jsii.Proxy(this.roleArn, this.featureName);
            }
        }
    }
}

